/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.File;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Properties;
import kafka.admin.ReassignPartitionsCommand;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReplicationQuotaUtils$;
import kafka.common.AdminCommandFailedException;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.ReassignPartitionsZNode$;
import kafka.zk.ZkVersion$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.DescribeReplicaLogDirsResult;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionReplica;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dh\u0001B\u0015+\u0001=BQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004I\u0001\u0001\u0006IA\u0011\u0005\b\u0013\u0002\u0001\r\u0011\"\u0001K\u0011\u001d9\u0006\u00011A\u0005\u0002aCaA\u0018\u0001!B\u0013Y\u0005bB0\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007S\u0002\u0001\u000b\u0011B1\t\u000f)\u0004!\u0019!C\u0001\u0003\"11\u000e\u0001Q\u0001\n\tCq\u0001\u001c\u0001A\u0002\u0013\u0005Q\u000eC\u0004{\u0001\u0001\u0007I\u0011A>\t\ru\u0004\u0001\u0015)\u0003o\u0011\u0015q\b\u0001\"\u0001\u0000\u0011\u0019\t\t\u0001\u0001C!\u007f\"9\u0011\u0011\u0003\u0001\u0005\u0002\u0005M\u0001bBA\u000e\u0001\u0011\u0005\u0011Q\u0004\u0005\b\u0003C\u0001A\u0011AA\u0012\u0011\u0019\ti\u0004\u0001C!\u007f\"1\u0011q\t\u0001\u0005\u0002}Da!!\u0015\u0001\t\u0003y\bBBA+\u0001\u0011\u0005q\u0010\u0003\u0004\u0002Z\u0001!\ta \u0005\u0007\u0003;\u0002A\u0011A@\t\r\u0005\u0005\u0004\u0001\"\u0001\u0000\u0011\u0019\t)\u0007\u0001C\u0001\u007f\"1\u0011\u0011\u000e\u0001\u0005\u0002}Da!!\u001c\u0001\t\u0003y\bBBA9\u0001\u0011\u0005q\u0010\u0003\u0004\u0002\u0006\u0002!\ta \u0005\u0007\u0003\u0013\u0003A\u0011A@\t\r\u00055\u0005\u0001\"\u0001\u0000\u0011\u0019\t\t\n\u0001C\u0001\u007f\"1\u0011Q\u0013\u0001\u0005\u0002}Da!!'\u0001\t\u0003y\bBBAO\u0001\u0011\u0005q\u0010C\u0004\u0002\"\u0002!\t!a)\t\u0013\u0005=\u0006!%A\u0005\u0002\u0005E\u0006bBAd\u0001\u0011\u0005\u0011\u0011\u001a\u0005\b\u0003+\u0004A\u0011BAl\u0005u\u0011V-Y:tS\u001et\u0007+\u0019:uSRLwN\\:DYV\u001cH/\u001a:UKN$(BA\u0016-\u0003\u0015\tG-\\5o\u0015\u0005i\u0013!B6bM.\f7\u0001A\n\u0004\u0001A2\u0004CA\u00195\u001b\u0005\u0011$BA\u001a-\u0003\tQ8.\u0003\u00026e\t!\"l\\8LK\u0016\u0004XM\u001d+fgRD\u0015M\u001d8fgN\u0004\"a\u000e\u001e\u000e\u0003aR!!\u000f\u0017\u0002\u000bU$\u0018\u000e\\:\n\u0005mB$a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003y\u0002\"a\u0010\u0001\u000e\u0003)\n1\u0002]1si&$\u0018n\u001c8JIV\t!\t\u0005\u0002D\r6\tAIC\u0001F\u0003\u0015\u00198-\u00197b\u0013\t9EIA\u0002J]R\fA\u0002]1si&$\u0018n\u001c8JI\u0002\nqa]3sm\u0016\u00148/F\u0001L!\rau*U\u0007\u0002\u001b*\u0011a\nR\u0001\u000bG>dG.Z2uS>t\u0017B\u0001)N\u0005\r\u0019V-\u001d\t\u0003%Vk\u0011a\u0015\u0006\u0003)2\naa]3sm\u0016\u0014\u0018B\u0001,T\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sg~#S-\u001d\u000b\u00033r\u0003\"a\u0011.\n\u0005m#%\u0001B+oSRDq!X\u0003\u0002\u0002\u0003\u00071*A\u0002yIE\n\u0001b]3sm\u0016\u00148\u000fI\u0001\ni>\u0004\u0018n\u0019(b[\u0016,\u0012!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u00015d\u0005\u0019\u0019FO]5oO\u0006QAo\u001c9jG:\u000bW.\u001a\u0011\u0002\u000f\u0011,G.Y=Ng\u0006AA-\u001a7bs6\u001b\b%A\u0006bI6Lgn\u00117jK:$X#\u00018\u0011\u0005=DX\"\u00019\u000b\u0005-\n(B\u0001:t\u0003\u001d\u0019G.[3oiNT!!\f;\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u0005\u0003sB\u00141\"\u00113nS:\u001cE.[3oi\u0006y\u0011\rZ7j]\u000ec\u0017.\u001a8u?\u0012*\u0017\u000f\u0006\u0002Zy\"9Q\fDA\u0001\u0002\u0004q\u0017\u0001D1e[&t7\t\\5f]R\u0004\u0013!\u0004>l+B$\u0017\r^3EK2\f\u0017\u0010F\u0001Z\u0003\u0015\u0019X\r^+qQ\ry\u0011Q\u0001\t\u0005\u0003\u000f\ti!\u0004\u0002\u0002\n)\u0019\u00111\u0002<\u0002\u000b),h.\u001b;\n\t\u0005=\u0011\u0011\u0002\u0002\u0007\u0005\u00164wN]3\u0002\u0019M$\u0018M\u001d;Ce>\\WM]:\u0015\u0007e\u000b)\u0002C\u0004\u0002\u0018A\u0001\r!!\u0007\u0002\u0013\t\u0014xn[3s\u0013\u0012\u001c\bc\u0001'P\u0005\u0006\t2M]3bi\u0016\fE-\\5o\u00072LWM\u001c;\u0015\u00079\fy\u0002C\u0003J#\u0001\u00071*A\rhKR\u0014\u0016M\u001c3p[2{w\rR5s\u0003N\u001c\u0018n\u001a8nK:$H\u0003BA\u0013\u0003s\u0001B!a\n\u000269!\u0011\u0011FA\u0019!\r\tY\u0003R\u0007\u0003\u0003[Q1!a\f/\u0003\u0019a$o\\8u}%\u0019\u00111\u0007#\u0002\rA\u0013X\rZ3g\u0013\rA\u0017q\u0007\u0006\u0004\u0003g!\u0005BBA\u001e%\u0001\u0007!)\u0001\u0005ce>\\WM]%e\u0003!!X-\u0019:E_^t\u0007fA\n\u0002BA!\u0011qAA\"\u0013\u0011\t)%!\u0003\u0003\u000b\u00053G/\u001a:\u0002AQ,7\u000f\u001e%x\u0003\u001a$XM\u001d)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0015\u0004)\u0005-\u0003\u0003BA\u0004\u0003\u001bJA!a\u0014\u0002\n\t!A+Z:u\u0003e\u0019\bn\\;mI6{g/Z*j]\u001edW\rU1si&$\u0018n\u001c8)\u0007U\tY%A\u0013tQ>,H\u000eZ'pm\u0016\u001c\u0016N\\4mKB\u000b'\u000f^5uS>tw+\u001b;iS:\u0014%o\\6fe\"\u001aa#a\u0013\u0002'MDw.\u001e7e\u000bb\u0004\u0018M\u001c3DYV\u001cH/\u001a:)\u0007]\tY%A\ntQ>,H\u000eZ*ie&t7n\u00117vgR,'\u000fK\u0002\u0019\u0003\u0017\nAd\u001d5pk2$Wj\u001c<f'V\u00147/\u001a;PMB\u000b'\u000f^5uS>t7\u000fK\u0002\u001a\u0003\u0017\n!e\u001d5pk2$W\t_3dkR,G\u000b\u001b:piRdW\r\u001a*fCN\u001c\u0018n\u001a8nK:$\bf\u0001\u000e\u0002L\u0005\u00013\u000f[8vY\u0012|e\u000e\\=UQJ|G\u000f\u001e7f\u001b>4\u0018N\\4SKBd\u0017nY1tQ\rY\u00121J\u0001-g\"|W\u000f\u001c3DQ\u0006tw-\u001a+ie>$H\u000f\\3P]J+'/\u001e8B]\u0012\u0014V-\\8wK>sg+\u001a:jMfD3\u0001HA&\u0003!\u001a\bn\\;mI\u001a\u000b\u0017\u000e\\%g!J|\u0007o\\:fI\u0012{Wm\u001d(pi6\u000bGo\u00195Fq&\u001cH/\u001b8hQ\u001di\u00121JA;\u0003o\n\u0001\"\u001a=qK\u000e$X\rZ\u0012\u0003\u0003s\u0002B!a\u001f\u0002\u00026\u0011\u0011Q\u0010\u0006\u0004\u0003\u007fb\u0013AB2p[6|g.\u0003\u0003\u0002\u0004\u0006u$aG!e[&t7i\\7nC:$g)Y5mK\u0012,\u0005pY3qi&|g.A\u0014tQ>,H\u000e\u001a$bS2Le\r\u0015:pa>\u001cX\r\u001a%bg\u0016k\u0007\u000f^=SKBd\u0017nY1MSN$\bf\u0002\u0010\u0002L\u0005U\u0014qO\u0001'g\"|W\u000f\u001c3GC&d\u0017J\u001a)s_B|7/\u001a3ICNLeN^1mS\u0012\u0014%o\\6fe&#\u0005fB\u0010\u0002L\u0005U\u0014qO\u0001%g\"|W\u000f\u001c3GC&d\u0017J\u001a)s_B|7/\u001a3ICNLeN^1mS\u0012dun\u001a#je\":\u0001%a\u0013\u0002v\u0005]\u0014!N:i_VdGMR1jY&3\u0007K]8q_N,G\rS1t\u0013:\u001cwN\\:jgR,g\u000e\u001e*fa2L7-Y:B]\u0012dun\u001a#jeNDs!IA&\u0003k\n9(A\u001atQ>,H\u000e\u001a)fe\u001a|'/\u001c+ie>$H\u000f\\3e%\u0016\f7o]5h]6,g\u000e^(wKJ4\u0016M]5pkN$v\u000e]5dg\"\u001a!%a\u0013\u0002yMDw.\u001e7e!\u0016\u0014hm\u001c:n\u001bVdG/\u001b9mKJ+\u0017m]:jO:lWM\u001c;Pa\u0016\u0014\u0018\r^5p]N|e/\u001a:WCJLw.^:U_BL7m\u001d\u0015\u0004G\u0005-\u0013\u0001L:i_VdG\r\u0016:jO\u001e,'OU3bgNLwM\\7f]R|enQ8oiJ|G\u000e\\3s'R\f'\u000f^;qQ\r!\u00131J\u0001\u001eo\u0006LGOR8s%\u0016\f7o]5h]6,g\u000e\u001e+p\u0007>l\u0007\u000f\\3uKR\u0019\u0011,!*\t\u0013\u0005\u001dV\u0005%AA\u0002\u0005%\u0016!\u00029bkN,\u0007cA\"\u0002,&\u0019\u0011Q\u0016#\u0003\t1{gnZ\u0001(o\u0006LGOR8s%\u0016\f7o]5h]6,g\u000e\u001e+p\u0007>l\u0007\u000f\\3uK\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u00024*\"\u0011\u0011VA[W\t\t9\f\u0005\u0003\u0002:\u0006\rWBAA^\u0015\u0011\ti,a0\u0002\u0013Ut7\r[3dW\u0016$'bAAa\t\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0015\u00171\u0018\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017\u0001\u00026t_:$B!!\n\u0002L\"9\u0011QZ\u0014A\u0002\u0005=\u0017!\u0002;pa&\u001c\u0007#B\"\u0002R\u0006\u0015\u0012bAAj\t\nQAH]3qK\u0006$X\r\u001a \u0002\u001fA\u0014x\u000eZ;dK6+7o]1hKN$\u0012\"WAm\u00037\fy.a9\t\u000f\u00055\u0007\u00061\u0001\u0002&!1\u0011Q\u001c\u0015A\u0002\t\u000b1B\\;n\u001b\u0016\u001c8/Y4fg\"1\u0011\u0011\u001d\u0015A\u0002\t\u000bA!Y2lg\"1\u0011Q\u001d\u0015A\u0002\t\u000b1B^1mk\u0016dUM\\4uQ\u0002")
public class ReassignPartitionsClusterTest
extends ZooKeeperTestHarness {
    private final int partitionId;
    private Seq<KafkaServer> servers = null;
    private final String topicName;
    private final int delayMs;
    private AdminClient adminClient = null;

    public int partitionId() {
        return this.partitionId;
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public String topicName() {
        return this.topicName;
    }

    public int delayMs() {
        return this.delayMs;
    }

    public AdminClient adminClient() {
        return this.adminClient;
    }

    public void adminClient_$eq(AdminClient x$1) {
        this.adminClient = x$1;
    }

    public void zkUpdateDelay() {
        Thread.sleep(this.delayMs());
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
    }

    public void startBrokers(Seq<Object> brokerIds) {
        this.servers_$eq((Seq<KafkaServer>)((Seq)((TraversableLike)brokerIds.map((Function1 & Serializable & scala.Serializable)i -> ReassignPartitionsClusterTest.$anonfun$startBrokers$1(this, BoxesRunTime.unboxToInt((Object)i)), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)c -> TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(c), TestUtils$.MODULE$.createServer$default$2()), Seq$.MODULE$.canBuildFrom())));
    }

    public AdminClient createAdminClient(Seq<KafkaServer> servers) {
        Properties props = new Properties();
        props.put("bootstrap.servers", TestUtils$.MODULE$.getBrokerListStrFromServers(servers, TestUtils$.MODULE$.getBrokerListStrFromServers$default$2()));
        props.put("request.timeout.ms", "10000");
        return AdminClient.create((Properties)props);
    }

    public String getRandomLogDirAssignment(int brokerId) {
        KafkaServer server = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$getRandomLogDirAssignment$1(brokerId, x$1))).get();
        Seq logDirs = server.config().logDirs();
        return new File((String)logDirs.apply(Random$.MODULE$.nextInt(logDirs.size()))).getAbsolutePath();
    }

    @Override
    @After
    public void tearDown() {
        if (this.adminClient() != null) {
            this.adminClient().close();
            this.adminClient_$eq(null);
        }
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testHwAfterPartitionReassignment() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        TopicPartition topicPartition = new TopicPartition(this.topicName(), 0);
        KafkaServer leaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$testHwAfterPartitionReassignment$1(x$2))).get();
        leaderServer.replicaManager().logManager().truncateFullyAndStartAt(topicPartition, 100L, false);
        String topicJson = new StringBuilder(77).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":0,\"replicas\":[101, 102]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        KafkaServer newLeaderServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$testHwAfterPartitionReassignment$2(x$3))).get();
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> newLeaderServer.replicaManager().getPartition(topicPartition).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.leaderReplicaIfLocal()).isDefined();
        Function0 & Serializable & scala.Serializable x$22 = (Function0 & Serializable & scala.Serializable)() -> "broker 101 should be the new leader";
        long x$32 = 1L;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        int x$52 = TestUtils$.MODULE$.waitUntilTrue$default$5();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$22, x$4, x$32, x$52);
        Assert.assertEquals((long)100L, (long)newLeaderServer.replicaManager().localReplicaOrException(topicPartition).highWatermark().messageOffset());
        KafkaServer newFollowerServer = (KafkaServer)this.servers().find((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$testHwAfterPartitionReassignment$6(x$5))).get();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> newFollowerServer.replicaManager().localReplicaOrException(topicPartition).highWatermark().messageOffset() == 100L, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "partition follower's highWatermark should be 100", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void shouldMoveSinglePartition() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        int partition = 0;
        String expectedLogDir = this.getRandomLogDirAssignment(101);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)partition)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringBuilder(88).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"").append(expectedLogDir).append("\"]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101})), (Object)((MapLike)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).get((Object)this.topicName()).get()).apply((Object)BoxesRunTime.boxToInteger((int)partition)));
        TopicPartitionReplica replica = new TopicPartitionReplica(this.topicName(), 0, 101);
        Assert.assertEquals((Object)expectedLogDir, (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica)).all().get()).get(replica)).getCurrentReplicaLogDir());
    }

    @Test
    public void shouldMoveSinglePartitionWithinBroker() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        String expectedLogDir = this.getRandomLogDirAssignment(100);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringBuilder(88).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":0,\"replicas\":[100],\"log_dirs\":[\"").append(expectedLogDir).append("\"]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        TopicPartitionReplica replica = new TopicPartitionReplica(this.topicName(), 0, 100);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = expectedLogDir;
            String string2 = ((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica)).all().get()).get(replica)).getCurrentReplicaLogDir();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition should have been moved to the expected log directory", 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void shouldExpandCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(brokers), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        int partition1 = ((TopicPartition)((Tuple2)newAssignment.find((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$shouldExpandCluster$1(x0$1))).get())._1()).partition();
        TopicPartitionReplica replica1 = new TopicPartitionReplica(this.topicName(), partition1, 102);
        String expectedLogDir1 = this.getRandomLogDirAssignment(102);
        int partition2 = ((TopicPartition)((Tuple2)newAssignment.find((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$shouldExpandCluster$2(x0$2))).get())._1()).partition();
        TopicPartitionReplica replica2 = new TopicPartitionReplica(this.topicName(), partition2, 100);
        String expectedLogDir2 = this.getRandomLogDirAssignment(100);
        Map newReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica1), (Object)expectedLogDir1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica2), (Object)expectedLogDir2)}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, newReplicaAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = expectedLogDir1;
            String string2 = ((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica1)).all().get()).get(replica1)).getCurrentReplicaLogDir();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition should have been moved to the expected log directory on broker 102", 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = expectedLogDir2;
            String string2 = ((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)((java.util.Map)this.adminClient().describeReplicaLogDirs(Collections.singleton(replica2)).all().get()).get(replica2)).getCurrentReplicaLogDir();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Partition should have been moved to the expected log directory on broker 100", 1000L, TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    @Test
    public void shouldShrinkCluster() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test
    public void shouldMoveSubsetOfPartitions() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{102, 100})))}))), this.servers());
        Map proposed = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})))}));
        TopicPartitionReplica replica1 = new TopicPartitionReplica("topic1", 0, 102);
        TopicPartitionReplica replica2 = new TopicPartitionReplica("topic2", 1, 100);
        Map proposedReplicaAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica1), (Object)this.getRandomLogDirAssignment(102)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)replica2), (Object)this.getRandomLogDirAssignment(100))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(proposed, proposedReplicaAssignment), ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        scala.collection.immutable.Map actual = this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic1", "topic2"})));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic1")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 100})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102})), (Object)((MapLike)actual.apply((Object)"topic2")).apply((Object)BoxesRunTime.boxToInteger((int)2)));
        java.util.Map replicaDirs = (java.util.Map)this.adminClient().describeReplicaLogDirs((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)new .colon.colon((Object)replica1, (List)new .colon.colon((Object)replica2, (List)Nil$.MODULE$))).asJava()).all().get();
        Assert.assertEquals((Object)proposedReplicaAssignment.apply((Object)replica1), (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirs.get(replica1)).getCurrentReplicaLogDir());
        Assert.assertEquals((Object)proposedReplicaAssignment.apply((Object)replica2), (Object)((DescribeReplicaLogDirsResult.ReplicaLogDirInfo)replicaDirs.get(replica2)).getCurrentReplicaLogDir());
    }

    @Test
    public void shouldExecuteThrottledReassignment() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        ReassignPartitionsCommand.Throttle initialThrottle = new ReassignPartitionsCommand.Throttle(10000000L, -1L, (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.zkUpdateDelay());
        int expectedDurationSecs = 5;
        int numMessages = 500;
        int msgSize = 100000;
        this.produceMessages(this.topicName(), numMessages, 0, msgSize);
        Assert.assertEquals((long)expectedDurationSecs, (long)((long)(numMessages * msgSize) / initialThrottle.interBrokerLimit()));
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        long start = System.currentTimeMillis();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), initialThrottle, ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), initialThrottle.interBrokerLimit(), this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        long took = System.currentTimeMillis() - start - (long)this.delayMs();
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
        Assert.assertTrue((String)new StringBuilder(38).append("Expected replication to be > ").append((double)expectedDurationSecs * 0.9 * (double)1000).append(" but was ").append(took).toString(), ((double)took > (double)expectedDurationSecs * 0.9 * (double)1000 ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringBuilder(38).append("Expected replication to be < ").append(expectedDurationSecs * 2 * 1000).append(" but was ").append(took).toString(), (took < (long)(expectedDurationSecs * 2 * 1000) ? 1 : 0) != 0);
    }

    @Test
    public void shouldOnlyThrottleMovingReplicas() {
        int[] brokers = new int[]{100, 101, 102, 103, 104, 105};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic1", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "topic2", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{104, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}))), this.servers());
        long throttle = 1000000L;
        this.produceMessages("topic1", 100, 0, 100000);
        this.produceMessages("topic2", 100, 0, 100000);
        Map newAssignment = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 102}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 105}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic1", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("topic2", 2)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{103, 104})))}));
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(throttle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), throttle, this.servers(), "topic1", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:100", "1:101", "0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:102", "0:102"}))));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), throttle, this.servers(), "topic2", (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:104", "1:105", "0:104", "0:105"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"1:103", "0:103"}))));
    }

    @Test
    public void shouldChangeThrottleOnRerunAndRemoveOnVerify() {
        int[] brokers = new int[]{100, 101, 102};
        this.startBrokers((Seq<Object>)Predef$.MODULE$.wrapIntArray(brokers));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101})))}))), this.servers());
        long initialThrottle = 1000000L;
        this.produceMessages(this.topicName(), 200, 0, 100000);
        Map newAssignment = (Map)ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102}), this.json((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()})), true)._1();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(initialThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), initialThrottle, this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), initialThrottle, this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        long newThrottle = initialThrottle * 1000L;
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()), new ReassignPartitionsCommand.Throttle(newThrottle, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3()), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigAddedToZK(this.adminZkClient(), newThrottle, this.servers(), this.topicName(), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:100", "0:101"}))), (Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"0:102"}))));
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        ReassignPartitionsCommand$.MODULE$.verifyAssignment(this.zkClient(), (Option)None$.MODULE$, ReassignPartitionsCommand$.MODULE$.formatAsReassignmentJson(newAssignment, (Map)Map$.MODULE$.empty()));
        ReplicationQuotaUtils$.MODULE$.checkThrottleConfigRemovedFromZK(this.adminZkClient(), this.topicName(), this.servers());
        scala.collection.immutable.Map actual = (scala.collection.immutable.Map)this.zkClient().getPartitionAssignmentForTopics((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topicName()}))).apply((Object)this.topicName());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{101, 102})), (Object)((SeqLike)((TraversableOnce)actual.values().flatten((Function1)Predef$.MODULE$.$conforms())).toSeq().distinct()).sorted((Ordering)Ordering.Int$.MODULE$));
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedDoesNotMatchExisting() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringBuilder(72).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":1,\"replicas\":[101]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasEmptyReplicaList() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringBuilder(69).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":0,\"replicas\":[]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInvalidBrokerID() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringBuilder(77).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":0,\"replicas\":[101, 102]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)None$.MODULE$, topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInvalidLogDir() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringBuilder(98).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"invalidDir\"]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test(expected=AdminCommandFailedException.class)
    public void shouldFailIfProposedHasInconsistentReplicasAndLogDirs() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100, 101}))));
        this.adminClient_$eq(this.createAdminClient(this.servers()));
        String logDir = this.getRandomLogDirAssignment(100);
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topicName(), (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{100})))}))), this.servers());
        String topicJson = new StringBuilder(92).append("{\"version\":1,\"partitions\":[{\"topic\":\"").append(this.topicName()).append("\",\"partition\":0,\"replicas\":[101],\"log_dirs\":[\"").append(logDir).append("\", \"").append(logDir).append("\"]}]}").toString();
        ReassignPartitionsCommand$.MODULE$.executeAssignment(this.zkClient(), (Option)new Some((Object)this.adminClient()), topicJson, ReassignPartitionsCommand$.MODULE$.NoThrottle(), ReassignPartitionsCommand$.MODULE$.executeAssignment$default$5());
    }

    @Test
    public void shouldPerformThrottledReassignmentOverVariousTopics() {
        ReassignPartitionsCommand.Throttle throttle = new ReassignPartitionsCommand.Throttle(1000L, ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$2(), ReassignPartitionsCommand.Throttle$.MODULE$.apply$default$3());
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "payments", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "deliveries", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "customers", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))}))), this.servers());
        Map move = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        KafkaZkClient x$1 = this.zkClient();
        None$ x$2 = None$.MODULE$;
        Map x$3 = move;
        AdminZkClient x$4 = this.adminZkClient();
        Map x$5 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$1 = new ReassignPartitionsCommand(x$1, (Option)x$2, x$3, x$5, x$4);
        ReassignPartitionsCommand.Throttle x$6 = throttle;
        long x$7 = qual$1.reassignPartitions$default$2();
        qual$1.reassignPartitions(x$6, x$7);
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
    }

    @Test
    public void shouldPerformMultipleReassignmentOperationsOverVariousTopics() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2, 3}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "payments", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "deliveries", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})))}))), this.servers());
        TestUtils$.MODULE$.createTopic(this.zkClient(), "customers", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)3)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})))}))), this.servers());
        Map firstMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        KafkaZkClient x$1 = this.zkClient();
        None$ x$2 = None$.MODULE$;
        Map x$3 = firstMove;
        AdminZkClient x$4 = this.adminZkClient();
        Map x$5 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$1 = new ReassignPartitionsCommand(x$1, (Option)x$2, x$3, x$5, x$4);
        ReassignPartitionsCommand.Throttle x$6 = qual$1.reassignPartitions$default$1();
        long x$7 = qual$1.reassignPartitions$default$2();
        qual$1.reassignPartitions(x$6, x$7);
        this.waitForReassignmentToComplete(1L);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
        Map secondMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("deliveries", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        KafkaZkClient x$8 = this.zkClient();
        None$ x$9 = None$.MODULE$;
        Map x$10 = secondMove;
        AdminZkClient x$11 = this.adminZkClient();
        Map x$12 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$2 = new ReassignPartitionsCommand(x$8, (Option)x$9, x$10, x$12, x$11);
        ReassignPartitionsCommand.Throttle x$13 = qual$2.reassignPartitions$default$1();
        long x$14 = qual$2.reassignPartitions$default$2();
        qual$2.reassignPartitions(x$13, x$14);
        this.waitForReassignmentToComplete(1L);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
        Map thirdMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})))}));
        KafkaZkClient x$15 = this.zkClient();
        None$ x$16 = None$.MODULE$;
        Map x$17 = thirdMove;
        AdminZkClient x$18 = this.adminZkClient();
        Map x$19 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
        ReassignPartitionsCommand qual$3 = new ReassignPartitionsCommand(x$15, (Option)x$16, x$17, x$19, x$18);
        ReassignPartitionsCommand.Throttle x$20 = qual$3.reassignPartitions$default$1();
        long x$21 = qual$3.reassignPartitions$default$2();
        qual$3.reassignPartitions(x$20, x$21);
        Map fourthMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("payments", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})))}));
        package$.MODULE$.Iterator().continually((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            boolean bl;
            try {
                KafkaZkClient x$22 = this.zkClient();
                None$ x$23 = None$.MODULE$;
                Map x$24 = fourthMove;
                AdminZkClient x$25 = this.adminZkClient();
                Map x$26 = ReassignPartitionsCommand$.MODULE$.$lessinit$greater$default$4();
                ReassignPartitionsCommand qual$4 = new ReassignPartitionsCommand(x$22, (Option)x$23, x$24, x$26, x$25);
                ReassignPartitionsCommand.Throttle x$27 = qual$4.reassignPartitions$default$1();
                long x$28 = qual$4.reassignPartitions$default$2();
                bl = qual$4.reassignPartitions(x$27, x$28);
            }
            catch (AdminCommandFailedException adminCommandFailedException) {
                bl = false;
            }
            return bl;
        }).exists((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean((boolean)ReassignPartitionsClusterTest.$anonfun$shouldPerformMultipleReassignmentOperationsOverVariousTopics$2(BoxesRunTime.unboxToBoolean((Object)x))));
        this.waitForReassignmentToComplete(1L);
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("deliveries", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("payments", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 2)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 3)));
    }

    @Test
    public void shouldTriggerReassignmentOnControllerStartup() {
        this.startBrokers((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        TestUtils$.MODULE$.createTopic(this.zkClient(), "orders", (Map<Object, Seq<Object>>)((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}))), this.servers());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            x$6.shutdown();
            return BoxedUnit.UNIT;
        });
        Map firstMove = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("orders", 1)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("customers", 0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})))}));
        this.zkClient().setOrCreatePartitionReassignment(firstMove, ZkVersion$.MODULE$.MatchAnyVersion());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$7 -> {
            x$7.startup();
            return BoxedUnit.UNIT;
        });
        this.waitForReassignmentToComplete(this.waitForReassignmentToComplete$default$1());
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 1})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 0)));
        Assert.assertEquals((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2})), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("orders", 1)));
        Assert.assertEquals((Object)Seq$.MODULE$.empty(), (Object)this.zkClient().getReplicasForPartition(new TopicPartition("customers", 0)));
    }

    public void waitForReassignmentToComplete(long pause) {
        JFunction0.mcZ.sp & Serializable & scala.Serializable x$1 = (JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> !this.zkClient().reassignPartitionsInProgress();
        Function0 & Serializable & scala.Serializable x$2 = (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(21).append("Znode ").append(ReassignPartitionsZNode$.MODULE$.path()).append(" wasn't deleted").toString();
        long x$3 = pause;
        long x$4 = TestUtils$.MODULE$.waitUntilTrue$default$3();
        int x$5 = TestUtils$.MODULE$.waitUntilTrue$default$5();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)x$1, (Function0<String>)x$2, x$4, x$3, x$5);
    }

    public long waitForReassignmentToComplete$default$1() {
        return 100L;
    }

    public String json(Seq<String> topic) {
        String topicStr = ((TraversableOnce)topic.map((Function1 & Serializable & scala.Serializable)t -> new StringBuilder(13).append("{\"topic\": \"").append((String)t).append("\"}").toString(), Seq$.MODULE$.canBuildFrom())).mkString(",");
        return new StringBuilder(26).append("{\"topics\": [").append(topicStr).append("],\"version\":1}").toString();
    }

    private void produceMessages(String topic, int numMessages, int acks, int valueLength) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$8 -> ReassignPartitionsClusterTest.$anonfun$produceMessages$1(topic, valueLength, BoxesRunTime.unboxToInt((Object)x$8)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages(this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, acks);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ Properties $anonfun$startBrokers$1(ReassignPartitionsClusterTest $this, int i) {
        void var2_20;
        int x$1 = i;
        String x$2 = $this.zkConnect();
        boolean x$3 = false;
        int x$4 = 3;
        boolean x$5 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$6 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<SecurityProtocol> x$7 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$8 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$10 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$11 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$12 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$17 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        boolean x$18 = TestUtils$.MODULE$.createBrokerConfig$default$18();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$1, x$2, x$3, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$4, x$18);
        props.put(KafkaConfig$.MODULE$.ReplicaFetchBackoffMsProp(), "100");
        return var2_20;
    }

    public static final /* synthetic */ boolean $anonfun$getRandomLogDirAssignment$1(int brokerId$1, KafkaServer x$1) {
        return x$1.config().brokerId() == brokerId$1;
    }

    public static final /* synthetic */ boolean $anonfun$testHwAfterPartitionReassignment$1(KafkaServer x$2) {
        return x$2.config().brokerId() == 100;
    }

    public static final /* synthetic */ boolean $anonfun$testHwAfterPartitionReassignment$2(KafkaServer x$3) {
        return x$3.config().brokerId() == 101;
    }

    public static final /* synthetic */ boolean $anonfun$testHwAfterPartitionReassignment$6(KafkaServer x$5) {
        return x$5.config().brokerId() == 102;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExpandCluster$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq brokerIds = (Seq)tuple2._2();
        boolean bl = brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)102));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$shouldExpandCluster$2(Tuple2 x0$2) {
        Tuple2 tuple2 = x0$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq brokerIds = (Seq)tuple2._2();
        boolean bl = brokerIds.contains((Object)BoxesRunTime.boxToInteger((int)100));
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$shouldPerformMultipleReassignmentOperationsOverVariousTopics$2(boolean x) {
        return BoxesRunTime.unboxToBoolean((Object)Predef$.MODULE$.identity((Object)BoxesRunTime.boxToBoolean((boolean)x)));
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$1, int valueLength$1, int x$8) {
        return new ProducerRecord(topic$1, (Object)new byte[valueLength$1]);
    }

    public ReassignPartitionsClusterTest() {
        this.partitionId = 0;
        this.topicName = "my-topic";
        this.delayMs = 1000;
    }
}

