/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Properties;
import joptsimple.OptionException;
import kafka.admin.ConsumerGroupCommand;
import kafka.admin.ConsumerGroupCommandTest;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.TopicPartition;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.MapLike;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\t}b\u0001\u0002\u0017.\u0001IBQa\u000e\u0001\u0005\u0002aBqA\u000f\u0001C\u0002\u0013\u00051\b\u0003\u0004E\u0001\u0001\u0006I\u0001\u0010\u0005\b\u000b\u0002\u0011\r\u0011\"\u0001G\u0011\u0019i\u0005\u0001)A\u0005\u000f\"9a\n\u0001b\u0001\n\u00031\u0005BB(\u0001A\u0003%q\tC\u0003Q\u0001\u0011\u0005\u0013\u000bC\u0003g\u0001\u0011\u0005q\rC\u0003v\u0001\u0011\u0005q\rC\u0003x\u0001\u0011\u0005q\rC\u0003z\u0001\u0011\u0005q\rC\u0003|\u0001\u0011\u0005q\rC\u0003~\u0001\u0011\u0005q\rC\u0003\u0000\u0001\u0011\u0005q\r\u0003\u0004\u0002\u0004\u0001!\ta\u001a\u0005\u0007\u0003\u000f\u0001A\u0011A4\t\r\u0005-\u0001\u0001\"\u0001h\u0011\u0019\ty\u0001\u0001C\u0001O\"1\u00111\u0003\u0001\u0005\u0002\u001dDa!a\u0006\u0001\t\u00039\u0007BBA\u000e\u0001\u0011\u0005q\r\u0003\u0004\u0002 \u0001!\ta\u001a\u0005\u0007\u0003G\u0001A\u0011A4\t\r\u0005\u001d\u0002\u0001\"\u0001h\u0011\u0019\tY\u0003\u0001C\u0001O\"1\u0011q\u0006\u0001\u0005\u0002\u001dDa!a\r\u0001\t\u00039\u0007BBA\u001c\u0001\u0011\u0005q\r\u0003\u0004\u0002<\u0001!\ta\u001a\u0005\u0007\u0003\u007f\u0001A\u0011A4\t\r\u0005\r\u0003\u0001\"\u0001h\u0011\u001d\t9\u0006\u0001C\u0005\u00033Bq!a\u001e\u0001\t\u0013\tI\bC\u0005\u0002\n\u0002\t\n\u0011\"\u0003\u0002\f\"9\u0011\u0011\u0015\u0001\u0005\n\u0005\r\u0006\"CAZ\u0001E\u0005I\u0011BA[\u0011%\tI\fAI\u0001\n\u0013\t)\fC\u0004\u0002<\u0002!I!!0\t\u0013\u0005u\u0007!%A\u0005\n\u0005}\u0007\"CAr\u0001E\u0005I\u0011BAs\u0011\u001d\tI\u000f\u0001C\u0005\u0003WDqA!\n\u0001\t\u0013\u00119C\u0001\u000fSKN,GoQ8ogVlWM]$s_V\u0004xJ\u001a4tKR$Vm\u001d;\u000b\u00059z\u0013!B1e[&t'\"\u0001\u0019\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\r\t\u0003iUj\u0011!L\u0005\u0003m5\u0012\u0001dQ8ogVlWM]$s_V\u00048i\\7nC:$G+Z:u\u0003\u0019a\u0014N\\5u}Q\t\u0011\b\u0005\u00025\u0001\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001=!\ti$)D\u0001?\u0015\ty\u0004)\u0001\u0003vi&d'\"A!\u0002\t)\fg/Y\u0005\u0003\u0007z\u0012!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%\u0001\u0004u_BL7-M\u000b\u0002\u000fB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nQ\u0001\u0005Y\u0006tw-\u0003\u0002M\u0013\n11\u000b\u001e:j]\u001e\fq\u0001^8qS\u000e\f\u0004%\u0001\u0004u_BL7MM\u0001\bi>\u0004\u0018n\u0019\u001a!\u0003=9WM\\3sCR,7i\u001c8gS\u001e\u001cX#\u0001*\u0011\u0007Mk\u0006M\u0004\u0002U5:\u0011Q\u000bW\u0007\u0002-*\u0011q+M\u0001\u0007yI|w\u000e\u001e \n\u0003e\u000bQa]2bY\u0006L!a\u0017/\u0002\u000fA\f7m[1hK*\t\u0011,\u0003\u0002_?\n\u00191+Z9\u000b\u0005mc\u0006CA1e\u001b\u0005\u0011'BA20\u0003\u0019\u0019XM\u001d<fe&\u0011QM\u0019\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0011uKN$(+Z:fi>3gm]3ug:{G/\u0012=jgRLgnZ$s_V\u0004H#\u00015\u0011\u0005%TW\"\u0001/\n\u0005-d&\u0001B+oSRD#!C7\u0011\u00059\u001cX\"A8\u000b\u0005A\f\u0018!\u00026v]&$(\"\u0001:\u0002\u0007=\u0014x-\u0003\u0002u_\n!A+Z:u\u0003u!Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=jgRLgn\u001a+pa&\u001c\u0007F\u0001\u0006n\u0003-\"Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=jgRLgn\u001a+pa&\u001c7+\u001a7fGR,Gm\u0012:pkB\u001c\bFA\u0006n\u0003\u0019\"Xm\u001d;SKN,Go\u00144gg\u0016$8/\u0012=jgRLgn\u001a+pa&\u001c\u0017\t\u001c7He>,\bo\u001d\u0015\u0003\u00195\f!\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:BY2$v\u000e]5dg\u0006cGn\u0012:pkB\u001c\bFA\u0007n\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8M_\u000e\fG\u000eR1uKRKW.\u001a\u0015\u0003\u001d5\fq\u0004^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_j{g.\u001a3ECR,G+[7fQ\tyQ.\u0001\u000euKN$(+Z:fi>3gm]3ug\nKH)\u001e:bi&|g\u000e\u000b\u0002\u0011[\u0006!C/Z:u%\u0016\u001cX\r^(gMN,Go\u001d\"z\tV\u0014\u0018\r^5p]R{W)\u0019:mS\u0016\u001cH\u000f\u000b\u0002\u0012[\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti\"\u0012!#\\\u0001\u0019i\u0016\u001cHOU3tKR|eMZ:fiN$v\u000eT1uKN$\bFA\nn\u0003}!Xm\u001d;SKN,Go\u00144gg\u0016$8\u000fV8DkJ\u0014XM\u001c;PM\u001a\u001cX\r\u001e\u0015\u0003)5\f\u0001\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:U_N\u0003XmY5gS\u000e|eMZ:fi\"\u0012Q#\\\u0001\u001ai\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u!2,8\u000f\u000b\u0002\u0017[\u0006QB/Z:u%\u0016\u001cX\r^(gMN,Go]*iS\u001a$X*\u001b8vg\"\u0012q#\\\u0001)i\u0016\u001cHOU3tKR|eMZ:fiN\u001c\u0006.\u001b4u\u0005fdun^3s)\"\fg.R1sY&,7\u000f\u001e\u0015\u000315\fq\u0005^3tiJ+7/\u001a;PM\u001a\u001cX\r^:TQ&4GOQ=IS\u001eDWM\u001d+iC:d\u0015\r^3ti\"\u0012\u0011$\\\u0001%i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\"\u0012!$\\\u00011i\u0016\u001cHOU3tKR|eMZ:fiN$v.R1sY&,7\u000f^(o\u001f:,Gk\u001c9jG\u0006sG\rU1si&$\u0018n\u001c8)\u0005mi\u0017A\t;fgR\u0014Vm]3u\u001f\u001a47/\u001a;t)>,\u0015M\u001d7jKN$xJ\u001c+pa&\u001c7\u000f\u000b\u0002\u001d[\u0006yC/Z:u%\u0016\u001cX\r^(gMN,Go\u001d+p\u000b\u0006\u0014H.[3ti>sGk\u001c9jGN\fe\u000e\u001a)beRLG/[8og\"\u0012Q$\\\u0001/i\u0016\u001cHOU3tKR|eMZ:fiN,\u0005\u0010]8si&k\u0007o\u001c:u!2\fgnU5oO2,wI]8va\u0006\u0013x\r\u000b\u0002\u001f[\u0006\u0001C/Z:u%\u0016\u001cX\r^(gMN,Go]#ya>\u0014H/S7q_J$\b\u000b\\1oQ\tyR.\u0001\u0016uKN$(+Z:fi^KG\u000f[+oe\u0016\u001cwn\u001a8ju\u0016$g*Z<D_:\u001cX/\\3s\u001fB$\u0018n\u001c8)\r\u0001j\u0017qIA%\u0003!)\u0007\u0010]3di\u0016$7EAA&!\u0011\ti%a\u0015\u000e\u0005\u0005=#BAA)\u0003)Qw\u000e\u001d;tS6\u0004H.Z\u0005\u0005\u0003+\nyEA\bPaRLwN\\#yG\u0016\u0004H/[8o\u0003=\u0001(o\u001c3vG\u0016lUm]:bO\u0016\u001cH#\u00025\u0002\\\u00055\u0004bBA/C\u0001\u0007\u0011qL\u0001\u0006i>\u0004\u0018n\u0019\t\u0005\u0003C\nIG\u0004\u0003\u0002d\u0005\u0015\u0004CA+]\u0013\r\t9\u0007X\u0001\u0007!J,G-\u001a4\n\u00071\u000bYGC\u0002\u0002hqCq!a\u001c\"\u0001\u0004\t\t(A\u0006ok6lUm]:bO\u0016\u001c\bcA5\u0002t%\u0019\u0011Q\u000f/\u0003\u0007%sG/A\rqe>$WoY3D_:\u001cX/\\3B]\u0012\u001c\u0006.\u001e;e_^tG#\u00035\u0002|\u0005u\u0014\u0011QAC\u0011\u001d\tiF\ta\u0001\u0003?Bq!a #\u0001\u0004\ty&A\u0003he>,\b\u000fC\u0004\u0002\u0004\n\u0002\r!!\u001d\u0002\u001bQ|G/\u00197NKN\u001c\u0018mZ3t\u0011%\t9I\tI\u0001\u0002\u0004\t\t(\u0001\u0007ok6\u001cuN\\:v[\u0016\u00148/A\u0012qe>$WoY3D_:\u001cX/\\3B]\u0012\u001c\u0006.\u001e;e_^tG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u00055%\u0006BA9\u0003\u001f[#!!%\u0011\t\u0005M\u0015QT\u0007\u0003\u0003+SA!a&\u0002\u001a\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u00037c\u0016AC1o]>$\u0018\r^5p]&!\u0011qTAK\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u0016C^\f\u0017\u000e^\"p]N,X.\u001a:Qe><'/Z:t)\u001dA\u0017QUAT\u0003SC\u0011\"!\u0018%!\u0003\u0005\r!a\u0018\t\u0013\u0005}D\u0005%AA\u0002\u0005}\u0003bBAVI\u0001\u0007\u0011QV\u0001\u0006G>,h\u000e\u001e\t\u0004S\u0006=\u0016bAAY9\n!Aj\u001c8h\u0003}\tw/Y5u\u0007>t7/^7feB\u0013xn\u001a:fgN$C-\u001a4bk2$H%M\u000b\u0003\u0003oSC!a\u0018\u0002\u0010\u0006y\u0012m^1ji\u000e{gn];nKJ\u0004&o\\4sKN\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0002+I,7/\u001a;B]\u0012\f5o]3si>3gm]3ugRI\u0001.a0\u0002J\u00065\u0017q\u001b\u0005\b\u0003\u0003<\u0003\u0019AAb\u0003\u0011\t'oZ:\u0011\u000b%\f)-a\u0018\n\u0007\u0005\u001dGLA\u0003BeJ\f\u0017\u0010C\u0004\u0002L\u001e\u0002\r!!,\u0002\u001d\u0015D\b/Z2uK\u0012|eMZ:fi\"I\u0011qZ\u0014\u0011\u0002\u0003\u0007\u0011\u0011[\u0001\u0007IJL(+\u001e8\u0011\u0007%\f\u0019.C\u0002\u0002Vr\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0002Z\u001e\u0002\n\u00111\u0001\u0002\\\u00061Ao\u001c9jGN\u0004BaU/\u0002`\u0005y\"/Z:fi\u0006sG-Q:tKJ$xJ\u001a4tKR\u001cH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005(\u0006BAi\u0003\u001f\u000bqD]3tKR\fe\u000eZ!tg\u0016\u0014Ho\u00144gg\u0016$8\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t9O\u000b\u0003\u0002\\\u0006=\u0015A\b:fg\u0016$\u0018I\u001c3BgN,'\u000f^(gMN,Go]\"p[6LG\u000f^3e)\u001dA\u0017Q\u001eB\u0004\u0005GAq!a<+\u0001\u0004\t\t0\u0001\u000bd_:\u001cX/\\3s\u000fJ|W\u000f]*feZL7-\u001a\t\u0005\u0003g\u0014\tA\u0004\u0003\u0002v\u0006uh\u0002BA|\u0003wt1!VA}\u0013\u0005\u0001\u0014B\u0001\u00180\u0013\r\ty0L\u0001\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9D_6l\u0017M\u001c3\n\t\t\r!Q\u0001\u0002\u0015\u0007>t7/^7fe\u001e\u0013x.\u001e9TKJ4\u0018nY3\u000b\u0007\u0005}X\u0006C\u0004\u0003\n)\u0002\rAa\u0003\u0002\u001f\u0015D\b/Z2uK\u0012|eMZ:fiN\u0004\u0002\"!\u0019\u0003\u000e\tE\u0011QV\u0005\u0005\u0005\u001f\tYGA\u0002NCB\u0004BAa\u0005\u0003 5\u0011!Q\u0003\u0006\u0005\u0005/\u0011I\"\u0001\u0004d_6lwN\u001c\u0006\u0004a\tm!b\u0001B\u000fc\u00061\u0011\r]1dQ\u0016LAA!\t\u0003\u0016\tqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007bBA/U\u0001\u0007\u0011qL\u0001\re\u0016\u001cX\r^(gMN,Go\u001d\u000b\u0005\u0005S\u0011i\u0004\u0005\u0005\u0002b\t5\u0011q\fB\u0016!!\t\tG!\u0004\u0003\u0012\t5\u0002\u0003\u0002B\u0018\u0005si!A!\r\u000b\t\tM\"QG\u0001\tG>t7/^7fe*!!q\u0007B\r\u0003\u001d\u0019G.[3oiNLAAa\u000f\u00032\t\trJ\u001a4tKR\fe\u000eZ'fi\u0006$\u0017\r^1\t\u000f\u0005=8\u00061\u0001\u0002r\u0002")
public class ResetConsumerGroupOffsetTest
extends ConsumerGroupCommandTest {
    private final Properties overridingProps = new Properties();
    private final String topic1;
    private final String topic2;

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public String topic1() {
        return this.topic1;
    }

    public String topic2() {
        return this.topic2;
    }

    @Override
    public Seq<KafkaConfig> generateConfigs() {
        return (Seq)TestUtils$.MODULE$.createBrokerConfigs(1, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
    }

    @Test
    public void testResetOffsetsNotExistingGroup() {
        String group = "missing.group";
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", group, "--all-topics", "--to-current", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            String string = consumerGroupCommand.collectGroupState(group).coordinator().host();
            String string2 = "localhost";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Can't find a coordinator", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        Map resetOffsets = (Map)consumerGroupCommand.resetOffsets().apply((Object)group);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().empty(), (Object)resetOffsets);
        String x$1 = group;
        String x$2 = this.committedOffsets$default$1();
        Assert.assertEquals((Object)resetOffsets, this.committedOffsets(x$2, x$1));
    }

    @Test
    public void testResetOffsetsExistingTopic() {
        String group = "new.group";
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", group, "--topic", this.topic(), "--to-offset", "50"});
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicSelectedGroups() {
        this.produceMessages(this.topic(), 100);
        String[] groups = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((TraversableOnce)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)id -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicSelectedGroups$1(this, BoxesRunTime.unboxToInt((Object)id)), IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).flatten((Function1 & Serializable & scala.Serializable)xs -> Predef$.MODULE$.wrapRefArray((Object[])xs), ClassTag$.MODULE$.apply(String.class));
        String[] args = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--topic", this.topic(), "--to-offset", "50"})).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])groups)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsExistingTopicAllGroups() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--all-groups", "--topic", this.topic(), "--to-offset", "50"});
        this.produceMessages(this.topic(), 100);
        ((IterableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$2 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)group -> {
            ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsExistingTopicAllGroups$2(this, group);
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, this.resetAndAssertOffsets$default$4());
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsAllTopicsAllGroups() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--all-groups", "--all-topics", "--to-offset", "50"});
        IndexedSeq topics = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$3 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$1(this, BoxesRunTime.unboxToInt((Object)x$3)), IndexedSeq$.MODULE$.canBuildFrom());
        IndexedSeq groups = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 3).map((Function1 & Serializable & scala.Serializable)x$4 -> ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$2(this, BoxesRunTime.unboxToInt((Object)x$4)), IndexedSeq$.MODULE$.canBuildFrom());
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            this.produceMessages(topic, 100);
            return BoxedUnit.UNIT;
        });
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            groups.foreach((Function1 & Serializable & scala.Serializable)group -> {
                ResetConsumerGroupOffsetTest.$anonfun$testResetOffsetsAllTopicsAllGroups$5($this, topic, group);
                return BoxedUnit.UNIT;
            });
            return BoxedUnit.UNIT;
        });
        this.resetAndAssertOffsets(args, 50L, true, (Seq<String>)topics);
        this.resetAndAssertOffsets((String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--dry-run"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))), 50L, true, (Seq<String>)topics);
        String[] x$42 = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])args)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{"--execute"})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        long x$5 = 50L;
        IndexedSeq x$6 = topics;
        boolean x$7 = this.resetAndAssertOffsets$default$3();
        this.resetAndAssertOffsets(x$42, x$5, x$7, (Seq<String>)x$6);
    }

    @Test
    public void testResetOffsetsToLocalDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1);
        this.produceMessages(this.topic(), 100);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(calendar.getTime()), "--execute"});
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToZonedDateTime() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX");
        this.produceMessages(this.topic(), 50);
        Date checkpoint = new Date();
        this.produceMessages(this.topic(), 50);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(1, this.topic(), this.addConsumerGroupExecutor$default$3(), this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        long x$1 = 100L;
        String x$2 = this.awaitConsumerProgress$default$1();
        String x$3 = this.awaitConsumerProgress$default$2();
        this.awaitConsumerProgress(x$2, x$3, x$1);
        executor.shutdown();
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-datetime", format.format(checkpoint), "--execute"});
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDuration() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT1M", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsByDurationToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--by-duration", "PT0.1S", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-latest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToCurrentOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-current", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 100L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToSpecificOffset() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "1", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 1L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftPlus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 150L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftMinus() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-50", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 50L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByLowerThanEarliest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "-150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsShiftByHigherThanLatest() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--shift-by", "150", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.produceMessages(this.topic(), 100);
        this.resetAndAssertOffsets(args, 200L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopic() {
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", this.topic(), "--to-earliest", "--execute"});
        this.produceConsumeAndShutdown(this.topic(), this.group(), 100, this.produceConsumeAndShutdown$default$4());
        this.resetAndAssertOffsets(args, 0L, this.resetAndAssertOffsets$default$3(), this.resetAndAssertOffsets$default$4());
    }

    @Test
    public void testResetOffsetsToEarliestOnOneTopicAndPartition() {
        String topic = "bar";
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringBuilder(2).append(topic).append(":1").toString(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets = this.committedOffsets(topic, this.committedOffsets$default$2());
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        Map expectedOffsets = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), priorCommittedOffsets.apply((Object)tp0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))}));
        this.resetAndAssertOffsetsCommitted(consumerGroupCommand, (Map<TopicPartition, Object>)expectedOffsets, topic);
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopics() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 1, 1, this.createTopic$default$4());
        this.createTopic(topic2, 1, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", topic1, "--topic", topic2, "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 1);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 1);
        TopicPartition tp1 = new TopicPartition(topic1, 0);
        TopicPartition tp2 = new TopicPartition(topic2, 0);
        Map allResetOffsets = ((MapLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.offset()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), (Object)allResetOffsets);
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))})), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsToEarliestOnTopicsAndPartitions() {
        String topic1 = "topic1";
        String topic2 = "topic2";
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] args = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--topic", new StringBuilder(2).append(topic1).append(":1").toString(), "--topic", new StringBuilder(2).append(topic2).append(":1").toString(), "--to-earliest", "--execute"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        this.produceConsumeAndShutdown(topic1, this.group(), 100, 2);
        this.produceConsumeAndShutdown(topic2, this.group(), 100, 2);
        Map<TopicPartition, Object> priorCommittedOffsets1 = this.committedOffsets(topic1, this.committedOffsets$default$2());
        Map<TopicPartition, Object> priorCommittedOffsets2 = this.committedOffsets(topic2, this.committedOffsets$default$2());
        TopicPartition tp1 = new TopicPartition(topic1, 1);
        TopicPartition tp2 = new TopicPartition(topic2, 1);
        Map allResetOffsets = ((MapLike)this.resetOffsets(consumerGroupCommand).apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToLong((long)x$6.offset()));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToInteger((int)0)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToInteger((int)0))})), (Object)allResetOffsets);
        Assert.assertEquals((Object)priorCommittedOffsets1.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic1, this.committedOffsets$default$2()));
        Assert.assertEquals((Object)priorCommittedOffsets2.$plus(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp2), (Object)BoxesRunTime.boxToLong((long)0L))), this.committedOffsets(topic2, this.committedOffsets$default$2()));
        this.adminZkClient().deleteTopic(topic1);
        this.adminZkClient().deleteTopic(topic2);
    }

    @Test
    public void testResetOffsetsExportImportPlanSingleGroupArg() {
        String topic = "bar";
        TopicPartition tp0 = new TopicPartition(topic, 0);
        TopicPartition tp1 = new TopicPartition(topic, 1);
        this.createTopic(topic, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic, this.group(), 100, 2);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToLong((long)x$7.offset())));
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)this.group())).mapValues((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToLong((long)x$8.offset())));
        this.adminZkClient().deleteTopic(topic);
    }

    @Test
    public void testResetOffsetsExportImportPlan() {
        String group1 = new StringBuilder(1).append(this.group()).append("1").toString();
        String group2 = new StringBuilder(1).append(this.group()).append("2").toString();
        String topic1 = "bar1";
        String topic2 = "bar2";
        TopicPartition t1p0 = new TopicPartition(topic1, 0);
        TopicPartition t1p1 = new TopicPartition(topic1, 1);
        TopicPartition t2p0 = new TopicPartition(topic2, 0);
        TopicPartition t2p1 = new TopicPartition(topic2, 1);
        this.createTopic(topic1, 2, 1, this.createTopic$default$4());
        this.createTopic(topic2, 2, 1, this.createTopic$default$4());
        String[] cgcArgs = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", group1, "--group", group2, "--all-topics", "--to-offset", "2", "--export"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(cgcArgs);
        this.produceConsumeAndShutdown(topic1, group1, 100, 2);
        this.produceConsumeAndShutdown(topic2, group2, 100, 5);
        File file = File.createTempFile("reset", ".csv");
        file.deleteOnExit();
        Map exportedOffsets = consumerGroupCommand.resetOffsets();
        BufferedWriter bw = new BufferedWriter(new FileWriter(file));
        bw.write(consumerGroupCommand.exportOffsetsToCsv(exportedOffsets));
        bw.close();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)group1)).mapValues((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToLong((long)x$9.offset())));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)exportedOffsets.apply((Object)group2)).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToLong((long)x$10.offset())));
        String[] cgcArgsExec = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", group1, "--group", group2, "--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec = this.getConsumerGroupService(cgcArgsExec);
        Map importedOffsets = consumerGroupCommandExec.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)group1)).mapValues((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.offset())));
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t2p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets.apply((Object)group2)).mapValues((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToLong((long)x$12.offset())));
        String[] cgcArgsExec2 = (String[])((Object[])new String[]{"--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", group1, "--all-topics", "--from-file", file.getCanonicalPath(), "--dry-run"});
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommandExec2 = this.getConsumerGroupService(cgcArgsExec2);
        Map importedOffsets2 = consumerGroupCommandExec2.resetOffsets();
        Assert.assertEquals((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p0), (Object)BoxesRunTime.boxToLong((long)2L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)t1p1), (Object)BoxesRunTime.boxToLong((long)2L))})), (Object)((MapLike)importedOffsets2.apply((Object)group1)).mapValues((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToLong((long)x$13.offset())));
        this.adminZkClient().deleteTopic(this.topic());
    }

    @Test(expected=OptionException.class)
    public void testResetWithUnrecognizedNewConsumerOption() {
        String[] cgcArgs = (String[])((Object[])new String[]{"--new-consumer", "--bootstrap-server", this.brokerList(), "--reset-offsets", "--group", this.group(), "--all-topics", "--to-offset", "2", "--export"});
        this.getConsumerGroupService(cgcArgs);
    }

    private void produceMessages(String topic, int numMessages) {
        IndexedSeq records = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).map((Function1 & Serializable & scala.Serializable)x$14 -> ResetConsumerGroupOffsetTest.$anonfun$produceMessages$1(topic, BoxesRunTime.unboxToInt((Object)x$14)), IndexedSeq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.produceMessages((Seq<KafkaServer>)this.servers(), (Seq<ProducerRecord<byte[], byte[]>>)records, 1);
    }

    private void produceConsumeAndShutdown(String topic, String group, int totalMessages, int numConsumers) {
        this.produceMessages(topic, totalMessages);
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = this.addConsumerGroupExecutor(numConsumers, topic, group, this.addConsumerGroupExecutor$default$4(), this.addConsumerGroupExecutor$default$5());
        this.awaitConsumerProgress(topic, group, totalMessages);
        executor.shutdown();
    }

    private int produceConsumeAndShutdown$default$4() {
        return 1;
    }

    private void awaitConsumerProgress(String topic, String group, long count) {
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> {
            Iterable offsets = this.committedOffsets(topic, group).values();
            return count == BoxesRunTime.unboxToLong((Object)offsets.sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        }, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Expected that consumer group has consumed all messages from topic/partition. ").append("Expected offset: ").append(count).append(". Actual offset: ").append(this.committedOffsets(topic, group).values().sum((Numeric)Numeric.LongIsIntegral$.MODULE$)).toString(), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
    }

    private String awaitConsumerProgress$default$1() {
        return this.topic();
    }

    private String awaitConsumerProgress$default$2() {
        return this.group();
    }

    private void resetAndAssertOffsets(String[] args, long expectedOffset, boolean dryRun, Seq<String> topics) {
        ConsumerGroupCommand.ConsumerGroupService consumerGroupCommand = this.getConsumerGroupService(args);
        Map expectedOffsets = ((TraversableOnce)topics.map((Function1 & Serializable & scala.Serializable)topic -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topic), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(topic, 0)), (Object)BoxesRunTime.boxToLong((long)expectedOffset))}))), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsetsResultByGroup = this.resetOffsets(consumerGroupCommand);
        try {
            topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
                ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$2(this, resetOffsetsResultByGroup, expectedOffsets, dryRun, topic);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            consumerGroupCommand.close();
        }
    }

    private boolean resetAndAssertOffsets$default$3() {
        return false;
    }

    private Seq<String> resetAndAssertOffsets$default$4() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{this.topic()}));
    }

    private void resetAndAssertOffsetsCommitted(ConsumerGroupCommand.ConsumerGroupService consumerGroupService, Map<TopicPartition, Object> expectedOffsets, String topic) {
        Map<String, Map<TopicPartition, OffsetAndMetadata>> allResetOffsets = this.resetOffsets(consumerGroupService);
        allResetOffsets.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$18 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$2(this, expectedOffsets, topic, x$18);
            return BoxedUnit.UNIT;
        });
    }

    private Map<String, Map<TopicPartition, OffsetAndMetadata>> resetOffsets(ConsumerGroupCommand.ConsumerGroupService consumerGroupService) {
        return consumerGroupService.resetOffsets();
    }

    public static final /* synthetic */ String[] $anonfun$testResetOffsetsExistingTopicSelectedGroups$1(ResetConsumerGroupOffsetTest $this, int id) {
        String group = new StringBuilder(0).append($this.group()).append(id).toString();
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5());
        long x$1 = 100L;
        String x$2 = group;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, x$2, x$1);
        executor.shutdown();
        return (String[])((Object[])new String[]{"--group", group});
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsExistingTopicAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$2) {
        return new StringBuilder(0).append($this.group()).append(x$2).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsExistingTopicAllGroups$2(ResetConsumerGroupOffsetTest $this, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(1, $this.topic(), group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5());
        long x$1 = 100L;
        String x$2 = group;
        String x$3 = $this.awaitConsumerProgress$default$1();
        $this.awaitConsumerProgress(x$3, x$2, x$1);
        executor.shutdown();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$1(ResetConsumerGroupOffsetTest $this, int x$3) {
        return new StringBuilder(0).append($this.topic()).append(x$3).toString();
    }

    public static final /* synthetic */ String $anonfun$testResetOffsetsAllTopicsAllGroups$2(ResetConsumerGroupOffsetTest $this, int x$4) {
        return new StringBuilder(0).append($this.group()).append(x$4).toString();
    }

    public static final /* synthetic */ void $anonfun$testResetOffsetsAllTopicsAllGroups$5(ResetConsumerGroupOffsetTest $this, String topic$1, String group) {
        ConsumerGroupCommandTest.ConsumerGroupExecutor executor = $this.addConsumerGroupExecutor(3, topic$1, group, $this.addConsumerGroupExecutor$default$4(), $this.addConsumerGroupExecutor$default$5());
        String x$1 = topic$1;
        long x$2 = 100L;
        String x$3 = group;
        $this.awaitConsumerProgress(x$1, x$3, x$2);
        executor.shutdown();
    }

    public static final /* synthetic */ ProducerRecord $anonfun$produceMessages$1(String topic$2, int x$14) {
        return new ProducerRecord(topic$2, (Object)new byte[100000]);
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsets$3(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsets$5(String topic$4, Tuple2 partitionInfo) {
        String string = ((TopicPartition)partitionInfo._1()).topic();
        String string2 = topic$4;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$4(ResetConsumerGroupOffsetTest $this, String topic$4, Map expectedOffsets$1, boolean dryRun$1, Tuple2 x$16) {
        Tuple2 tuple2 = x$16;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String group = (String)tuple2._1();
        Map partitionInfo2 = (Map)tuple2._2();
        Map<TopicPartition, Object> priorOffsets = $this.committedOffsets(topic$4, group);
        Assert.assertEquals((Object)expectedOffsets$1.apply((Object)topic$4), (Object)((MapLike)partitionInfo2.filter((Function1 & Serializable & scala.Serializable)partitionInfo -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$5(topic$4, partitionInfo)))).mapValues((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToLong((long)x$15.offset())));
        Assert.assertEquals(dryRun$1 ? priorOffsets : expectedOffsets$1.apply((Object)topic$4), $this.committedOffsets(topic$4, group));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsets$2(ResetConsumerGroupOffsetTest $this, Map resetOffsetsResultByGroup$1, Map expectedOffsets$1, boolean dryRun$1, String topic) {
        resetOffsetsResultByGroup$1.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$3(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$16 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsets$4($this, topic, expectedOffsets$1, dryRun$1, x$16);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsetsCommitted$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$resetAndAssertOffsetsCommitted$3(Tuple2 check$ifrefutable$3) {
        Tuple2 tuple2 = check$ifrefutable$3;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$4(ResetConsumerGroupOffsetTest $this, Map expectedOffsets$2, String topic$5, String group$3, Tuple2 x$17) {
        Tuple2 tuple2 = x$17;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition tp = (TopicPartition)tuple2._1();
        OffsetAndMetadata offsetMetadata = (OffsetAndMetadata)tuple2._2();
        Assert.assertEquals((long)offsetMetadata.offset(), (long)BoxesRunTime.unboxToLong((Object)expectedOffsets$2.apply((Object)tp)));
        Assert.assertEquals((Object)expectedOffsets$2, $this.committedOffsets(topic$5, group$3));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$resetAndAssertOffsetsCommitted$2(ResetConsumerGroupOffsetTest $this, Map expectedOffsets$2, String topic$5, Tuple2 x$18) {
        Tuple2 tuple2 = x$18;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String group = (String)tuple2._1();
        Map offsetsInfo = (Map)tuple2._2();
        offsetsInfo.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$3(check$ifrefutable$3))).foreach((Function1 & Serializable & scala.Serializable)x$17 -> {
            ResetConsumerGroupOffsetTest.$anonfun$resetAndAssertOffsetsCommitted$4($this, expectedOffsets$2, topic$5, group, x$17);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public ResetConsumerGroupOffsetTest() {
        this.topic1 = "foo1";
        this.topic2 = "foo2";
    }
}

