/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import java.io.Serializable;
import java.nio.ByteBuffer;
import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.CoordinatorEpochAndTxnMetadata;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.TransactionConfig;
import kafka.coordinator.transaction.TransactionConfig$;
import kafka.coordinator.transaction.TransactionLog$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TransactionStateManager;
import kafka.coordinator.transaction.TransactionalIdAndProducerIdEpoch;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.log.Log;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.ReplicaManager;
import kafka.utils.MockScheduler;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.zk.KafkaZkClient;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileRecords;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.requests.TransactionResult;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.easymock.Capture;
import org.easymock.EasyMock;
import org.easymock.IAnswer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.Function5;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

@ScalaSignature(bytes="\u0006\u0001\r\ra\u0001B(Q\u0001]CQA\u0018\u0001\u0005\u0002}CqA\u0019\u0001C\u0002\u0013\u00051\r\u0003\u0004h\u0001\u0001\u0006I\u0001\u001a\u0005\bQ\u0002\u0011\r\u0011\"\u0001d\u0011\u0019I\u0007\u0001)A\u0005I\"9!\u000e\u0001b\u0001\n\u0003\u0019\u0007BB6\u0001A\u0003%A\rC\u0004m\u0001\t\u0007I\u0011A7\t\re\u0004\u0001\u0015!\u0003o\u0011\u001dQ\bA1A\u0005\u0002\rDaa\u001f\u0001!\u0002\u0013!\u0007b\u0002?\u0001\u0005\u0004%\t! \u0005\b\u00033\u0001\u0001\u0015!\u0003\u007f\u0011%\tY\u0002\u0001b\u0001\n\u0003\ti\u0002\u0003\u0005\u0002,\u0001\u0001\u000b\u0011BA\u0010\u0011%\ti\u0003\u0001b\u0001\n\u0003\ty\u0003\u0003\u0005\u0002<\u0001\u0001\u000b\u0011BA\u0019\u0011%\ti\u0004\u0001b\u0001\n\u0003\ty\u0004\u0003\u0005\u0002N\u0001\u0001\u000b\u0011BA!\u0011%\ty\u0005\u0001b\u0001\n\u0003\t\t\u0006\u0003\u0005\u0002`\u0001\u0001\u000b\u0011BA*\u0011%\t\t\u0007\u0001b\u0001\n\u0003\t\u0019\u0007\u0003\u0005\u0002l\u0001\u0001\u000b\u0011BA3\u0011%\ti\u0007\u0001b\u0001\n\u0003\ty\u0007\u0003\u0005\u0002x\u0001\u0001\u000b\u0011BA9\u0011%\tI\b\u0001b\u0001\n\u0003\tY\b\u0003\u0005\u0002\u0014\u0002\u0001\u000b\u0011BA?\u0011%\t)\n\u0001b\u0001\n\u0003\tY\b\u0003\u0005\u0002\u0018\u0002\u0001\u000b\u0011BA?\u0011%\tI\n\u0001b\u0001\n\u0003\tY\n\u0003\u0005\u0002*\u0002\u0001\u000b\u0011BAO\u0011%\tY\u000b\u0001b\u0001\n\u0003\tY\n\u0003\u0005\u0002.\u0002\u0001\u000b\u0011BAO\u0011%\ty\u000b\u0001b\u0001\n\u0003\t\t\f\u0003\u0005\u0002B\u0002\u0001\u000b\u0011BAZ\u0011%\t\u0019\r\u0001a\u0001\n\u0003\t)\rC\u0005\u0002N\u0002\u0001\r\u0011\"\u0001\u0002P\"A\u00111\u001c\u0001!B\u0013\t9\rC\u0005\u0002^\u0002\u0001\r\u0011\"\u0001\u0002F\"I\u0011q\u001c\u0001A\u0002\u0013\u0005\u0011\u0011\u001d\u0005\t\u0003K\u0004\u0001\u0015)\u0003\u0002H\"I\u0011q\u001d\u0001A\u0002\u0013\u0005\u0011\u0011\u001e\u0005\n\u0003o\u0004\u0001\u0019!C\u0001\u0003sD\u0001\"!@\u0001A\u0003&\u00111\u001e\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011\t\u0002\u0001C\u0001\u0005\u0003AqAa\u0007\u0001\t\u0003\u0011\t\u0001C\u0004\u0003&\u0001!\tA!\u0001\t\u000f\t%\u0002\u0001\"\u0001\u0003\u0002!9!Q\u0006\u0001\u0005\u0002\t\u0005\u0001b\u0002B\u0019\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005k\u0001A\u0011\u0001B\u0001\u0011\u001d\u0011I\u0004\u0001C\u0001\u0005\u0003AqA!\u0010\u0001\t\u0003\u0011\t\u0001C\u0004\u0003B\u0001!\tA!\u0001\t\u000f\t\u0015\u0003\u0001\"\u0001\u0003\u0002!9!\u0011\n\u0001\u0005\u0002\t\u0005\u0001b\u0002B1\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005K\u0002A\u0011\u0001B\u0001\u0011\u001d\u0011I\u0007\u0001C\u0001\u0005\u0003AqA!\u001c\u0001\t\u0003\u0011\t\u0001C\u0004\u0003r\u0001!\tA!\u0001\t\u000f\tU\u0004\u0001\"\u0001\u0003\u0002!9!\u0011\u0010\u0001\u0005\u0002\t\u0005\u0001b\u0002B?\u0001\u0011\u0005!\u0011\u0001\u0005\b\u0005\u0003\u0003A\u0011\u0001B\u0001\u0011\u001d\u0011)\t\u0001C\u0001\u0005\u0003AqA!#\u0001\t\u0003\u0011\t\u0001C\u0004\u0003\u000e\u0002!IAa$\t\u000f\tU\u0005\u0001\"\u0003\u0003\u0018\"9!1\u0014\u0001\u0005\n\tu\u0005b\u0002BW\u0001\u0011%!q\u0016\u0005\b\u0005k\u0003A\u0011\u0002B\\\u0011\u001d\u0011Y\f\u0001C\u0005\u0005{C\u0011Ba3\u0001#\u0003%IA!4\t\u0013\t\r\b!%A\u0005\n\t\u0015\bb\u0002Bu\u0001\u0011%!1\u001e\u0005\b\u0005{\u0004A\u0011\u0002B\u0000\u0005m!&/\u00198tC\u000e$\u0018n\u001c8Ti\u0006$X-T1oC\u001e,'\u000fV3ti*\u0011\u0011KU\u0001\fiJ\fgn]1di&|gN\u0003\u0002T)\u0006Y1m\\8sI&t\u0017\r^8s\u0015\u0005)\u0016!B6bM.\f7\u0001A\n\u0003\u0001a\u0003\"!\u0017/\u000e\u0003iS\u0011aW\u0001\u0006g\u000e\fG.Y\u0005\u0003;j\u0013a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001a!\t\t\u0007!D\u0001Q\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0016\u0003\u0011\u0004\"!W3\n\u0005\u0019T&aA%oi\u0006a\u0001/\u0019:uSRLwN\\%eA\u0005ia.^7QCJ$\u0018\u000e^5p]N\faB\\;n!\u0006\u0014H/\u001b;j_:\u001c\b%\u0001\u000bue\u0006t7/Y2uS>tG+[7f_V$Xj]\u0001\u0016iJ\fgn]1di&|g\u000eV5nK>,H/T:!\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:,\u0012A\u001c\t\u0003_^l\u0011\u0001\u001d\u0006\u0003cJ\faaY8n[>t'BA+t\u0015\t!X/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002m\u0006\u0019qN]4\n\u0005a\u0004(A\u0004+pa&\u001c\u0007+\u0019:uSRLwN\\\u0001\u0010i>\u0004\u0018n\u0019)beRLG/[8oA\u0005\u00012m\\8sI&t\u0017\r^8s\u000bB|7\r[\u0001\u0012G>|'\u000fZ5oCR|'/\u00129pG\"\u0004\u0013A\u0003;y]J+7m\u001c:egV\ta\u0010E\u0003\u0000\u0003\u0013\ti!\u0004\u0002\u0002\u0002)!\u00111AA\u0003\u0003\u001diW\u000f^1cY\u0016T1!a\u0002[\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003\u0017\t\tAA\u0006BeJ\f\u0017PQ;gM\u0016\u0014\b\u0003BA\b\u0003+i!!!\u0005\u000b\u0007\u0005M\u0001/\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003/\t\tB\u0001\u0007TS6\u0004H.\u001a*fG>\u0014H-A\u0006uq:\u0014VmY8sIN\u0004\u0013\u0001\u0002;j[\u0016,\"!a\b\u0011\t\u0005\u0005\u0012qE\u0007\u0003\u0003GQ1!!\nq\u0003\u0015)H/\u001b7t\u0013\u0011\tI#a\t\u0003\u00115{7m\u001b+j[\u0016\fQ\u0001^5nK\u0002\n\u0011b]2iK\u0012,H.\u001a:\u0016\u0005\u0005E\u0002\u0003BA\u001a\u0003oi!!!\u000e\u000b\u0007\u0005\u0015B+\u0003\u0003\u0002:\u0005U\"!D'pG.\u001c6\r[3ek2,'/\u0001\u0006tG\",G-\u001e7fe\u0002\n\u0001B_6DY&,g\u000e^\u000b\u0003\u0003\u0003\u0002B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000f\"\u0016A\u0001>l\u0013\u0011\tY%!\u0012\u0003\u001b-\u000bgm[1[W\u000ec\u0017.\u001a8u\u0003%Q8n\u00117jK:$\b%\u0001\bsKBd\u0017nY1NC:\fw-\u001a:\u0016\u0005\u0005M\u0003\u0003BA+\u00037j!!a\u0016\u000b\u0007\u0005eC+\u0001\u0004tKJ4XM]\u0005\u0005\u0003;\n9F\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0002\u001fI,\u0007\u000f\\5dC6\u000bg.Y4fe\u0002\n\u0011\u0002\u001e=o\u0007>tg-[4\u0016\u0005\u0005\u0015\u0004cA1\u0002h%\u0019\u0011\u0011\u000e)\u0003#Q\u0013\u0018M\\:bGRLwN\\\"p]\u001aLw-\u0001\u0006uq:\u001cuN\u001c4jO\u0002\n!\u0003\u001e:b]N\f7\r^5p]6\u000bg.Y4feV\u0011\u0011\u0011\u000f\t\u0004C\u0006M\u0014bAA;!\n9BK]1og\u0006\u001cG/[8o'R\fG/Z'b]\u0006<WM]\u0001\u0014iJ\fgn]1di&|g.T1oC\u001e,'\u000fI\u0001\u0011iJ\fgn]1di&|g.\u00197JIF*\"!! \u0011\t\u0005}\u0014Q\u0012\b\u0005\u0003\u0003\u000bI\tE\u0002\u0002\u0004jk!!!\"\u000b\u0007\u0005\u001de+\u0001\u0004=e>|GOP\u0005\u0004\u0003\u0017S\u0016A\u0002)sK\u0012,g-\u0003\u0003\u0002\u0010\u0006E%AB*ue&twMC\u0002\u0002\fj\u000b\u0011\u0003\u001e:b]N\f7\r^5p]\u0006d\u0017\nZ\u0019!\u0003A!(/\u00198tC\u000e$\u0018n\u001c8bY&#''A\tue\u0006t7/Y2uS>t\u0017\r\\%ee\u0001\n1\u0003\u001e=o\u001b\u0016\u001c8/Y4f\u0017\u0016L()\u001f;fgF*\"!!(\u0011\u000be\u000by*a)\n\u0007\u0005\u0005&LA\u0003BeJ\f\u0017\u0010E\u0002Z\u0003KK1!a*[\u0005\u0011\u0011\u0015\u0010^3\u0002)QDh.T3tg\u0006<WmS3z\u0005f$Xm]\u0019!\u0003M!\bP\\'fgN\fw-Z&fs\nKH/Z:3\u0003Q!\bP\\'fgN\fw-Z&fs\nKH/Z:3A\u0005Y\u0001O]8ek\u000e,'/\u00133t+\t\t\u0019\f\u0005\u0005\u00026\u0006]\u0016QPA^\u001b\t\t)!\u0003\u0003\u0002:\u0006\u0015!aA'baB\u0019\u0011,!0\n\u0007\u0005}&L\u0001\u0003M_:<\u0017\u0001\u00049s_\u0012,8-\u001a:JIN\u0004\u0013\u0001\u0004;y]6+G/\u00193bi\u0006\fTCAAd!\r\t\u0017\u0011Z\u0005\u0004\u0003\u0017\u0004&a\u0005+sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\f\u0017\u0001\u0005;y]6+G/\u00193bi\u0006\ft\fJ3r)\u0011\t\t.a6\u0011\u0007e\u000b\u0019.C\u0002\u0002Vj\u0013A!\u00168ji\"I\u0011\u0011\\\u0013\u0002\u0002\u0003\u0007\u0011qY\u0001\u0004q\u0012\n\u0014!\u0004;y]6+G/\u00193bi\u0006\f\u0004%\u0001\u0007uq:lU\r^1eCR\f''\u0001\tuq:lU\r^1eCR\f'g\u0018\u0013fcR!\u0011\u0011[Ar\u0011%\tI\u000eKA\u0001\u0002\u0004\t9-A\u0007uq:lU\r^1eCR\f'\u0007I\u0001\u000eKb\u0004Xm\u0019;fI\u0016\u0013(o\u001c:\u0016\u0005\u0005-\b\u0003BAw\u0003gl!!a<\u000b\u0007\u0005E\b/\u0001\u0005qe>$xnY8m\u0013\u0011\t)0a<\u0003\r\u0015\u0013(o\u001c:t\u0003E)\u0007\u0010]3di\u0016$WI\u001d:pe~#S-\u001d\u000b\u0005\u0003#\fY\u0010C\u0005\u0002Z.\n\t\u00111\u0001\u0002l\u0006qQ\r\u001f9fGR,G-\u0012:s_J\u0004\u0013!B:fiV\u0003HCAAiQ\ri#Q\u0001\t\u0005\u0005\u000f\u0011i!\u0004\u0002\u0003\n)\u0019!1B;\u0002\u000b),h.\u001b;\n\t\t=!\u0011\u0002\u0002\u0007\u0005\u00164wN]3\u0002\u0011Q,\u0017M\u001d#po:D3A\fB\u000b!\u0011\u00119Aa\u0006\n\t\te!\u0011\u0002\u0002\u0006\u0003\u001a$XM]\u0001\u001fi\u0016\u001cHOV1mS\u0012\fG/\u001a+sC:\u001c\u0018m\u0019;j_:$\u0016.\\3pkRD3a\fB\u0010!\u0011\u00119A!\t\n\t\t\r\"\u0011\u0002\u0002\u0005)\u0016\u001cH/\u0001\buKN$\u0018\t\u001a3HKR\u0004\u0016\u000eZ:)\u0007A\u0012y\"A\u0015uKN$Hj\\1e\u0003:$'+Z7pm\u0016$&/\u00198tC\u000e$\u0018n\u001c8t\r>\u0014\b+\u0019:uSRLwN\u001c\u0015\u0004c\t}\u0011!\u000b;fgR\u001cu.\u001c9mKR,GK]1og&$\u0018n\u001c8XQ\u0016t\u0017\t\u001d9f]\u0012\u001cVoY2fK\u0012,G\rK\u00023\u0005?\tA\u0006^3ti\u0006\u0003\b/\u001a8e\r\u0006LG\u000eV8D_>\u0014H-\u001b8bi>\u0014hj\u001c;Bm\u0006LG.\u00192mK\u0016\u0013(o\u001c:)\u0007M\u0012y\"A\u0012uKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_:{GoQ8pe\u0012Lg.\u0019;pe\u0016\u0013(o\u001c:)\u0007Q\u0012y\"A\u0014uKN$\u0018\t\u001d9f]\u00124\u0015-\u001b7U_\u000e{wN\u001d3j]\u0006$xN\u001d'pC\u0012LgnZ#se>\u0014\bfA\u001b\u0003 \u0005aB/Z:u\u0003B\u0004XM\u001c3GC&dGk\\+oW:|wO\\#se>\u0014\bf\u0001\u001c\u0003 \u0005)C/Z:u!\u0016tG-\u001b8h'R\fG/\u001a(piJ+7/\u001a;P]J+GO]=BaB,g\u000e\u001a\u0015\u0004o\t}\u0011!\f;fgR\f\u0005\u000f]3oIR\u0013\u0018M\\:bGRLwN\u001c+p\u0019><w\u000b[5mKB\u0013x\u000eZ;dKJ4UM\\2fI\"\u001a\u0001Ha\b\u0002eQ,7\u000f^!qa\u0016tG\r\u0016:b]N\f7\r^5p]R{Gj\\4XQ&dW\rU3oI&twm\u0015;bi\u0016\u001c\u0005.\u00198hK\u0012Ds!\u000fB\u0010\u0005\u001b\u0012y%\u0001\u0005fqB,7\r^3eG\t\u0011\t\u0006\u0005\u0003\u0003T\tuSB\u0001B+\u0015\u0011\u00119F!\u0017\u0002\t1\fgn\u001a\u0006\u0003\u00057\nAA[1wC&!!q\fB+\u0005UIE\u000e\\3hC2\u001cF/\u0019;f\u000bb\u001cW\r\u001d;j_:\fqh\u001d5pk2$'+\u001a;ve:tu\u000e^\"p_JLGM\\1u_J,%O]8s\u0013\u001a$&/\u00198tC\u000e$\u0018n\u001c8JIB\u000b'\u000f^5uS>tgj\u001c;Po:,G\rK\u0002;\u0005?\tag\u001d5pk2$wJ\u001c7z\u0007>t7/\u001b3feR\u0013\u0018M\\:bGRLwN\\:J]RCWm\u00148h_&twm\u0015;bi\u0016$v.\u00112peRD3a\u000fB\u0010\u0003a\u001a\bn\\;mI^\u0013\u0018\u000e^3Uq:l\u0015M]6feN4uN\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000e\u0015:fa\u0006\u0014X\rZ\"p[6LGo\u0015;bi\u0016D3\u0001\u0010B\u0010\u0003]\u001a\bn\\;mI^\u0013\u0018\u000e^3Uq:l\u0015M]6feN4uN\u001d+sC:\u001c\u0018m\u0019;j_:Le\u000e\u0015:fa\u0006\u0014X\rZ!c_J$8\u000b^1uK\"\u001aQHa\b\u0002eMDw.\u001e7e%\u0016lwN^3D_6\u0004H.\u001a;f\u0007>lW.\\5u\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JIND3A\u0010B\u0010\u0003A\u001a\bn\\;mIJ+Wn\u001c<f\u0007>l\u0007\u000f\\3uK\u0006\u0013wN\u001d;FqBL'/\u001a3Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001aqHa\b\u0002QMDw.\u001e7e%\u0016lwN^3F[B$\u00180\u0012=qSJ,G\r\u0016:b]N\f7\r^5p]\u0006d\u0017\nZ:)\u0007\u0001\u0013y\"\u0001\u001ctQ>,H\u000e\u001a(piJ+Wn\u001c<f\u000bb\u0004\u0018N]3e)J\fgn]1di&|g.\u00197JINLe\rT8h\u0003B\u0004XM\u001c3GC&d7\u000fK\u0002B\u0005?\tae\u001d5pk2$gj\u001c;SK6|g/Z(oO>Lgn\u001a+sC:\u001c\u0018m\u0019;j_:\fG.\u00133tQ\r\u0011%qD\u0001,g\"|W\u000f\u001c3O_R\u0014V-\\8wKB\u0013X\r]1sK\u0006\u0013wN\u001d;Ue\u0006t7/Y2uS>t\u0017\r\\%eg\"\u001a1Ia\b\u0002YMDw.\u001e7e\u001d>$(+Z7pm\u0016\u0004&/\u001a9be\u0016\u001cu.\\7jiR\u0013\u0018M\\:bGRLwN\\1m\u0013\u0012\u001c\bf\u0001#\u0003 \u0005\u0011c/\u001a:jMflU\r^1eCR\fGi\\3t\u000bbL7\u000f^!oI&\u001bXk]1cY\u0016$B!!5\u0003\u0012\"9!1S#A\u0002\u0005u\u0014a\u0004;sC:\u001c\u0018m\u0019;j_:\fG.\u00133\u00023Y,'/\u001b4z\u001b\u0016$\u0018\rZ1uC\u0012{Wm\u001d8u\u000bbL7\u000f\u001e\u000b\u0005\u0003#\u0014I\nC\u0004\u0003\u0014\u001a\u0003\r!! \u0002IM,G/\u001e9B]\u0012\u0014VO\u001c+sC:\u001c\u0018m\u0019;j_:\fG.\u00133FqBL'/\u0019;j_:$b!!5\u0003 \n\r\u0006b\u0002BQ\u000f\u0002\u0007\u00111^\u0001\u0006KJ\u0014xN\u001d\u0005\b\u0005K;\u0005\u0019\u0001BT\u0003!!\bP\\*uCR,\u0007cA1\u0003*&\u0019!1\u0016)\u0003!Q\u0013\u0018M\\:bGRLwN\\*uCR,\u0017\u0001\n<fe&4\u0017p\u0016:ji\u0016\u001cH\u000b\u001f8NCJ\\WM]:J]B\u0013X\r]1sKN#\u0018\r^3\u0015\t\u0005E'\u0011\u0017\u0005\b\u0005gC\u0005\u0019\u0001BT\u0003\u0015\u0019H/\u0019;f\u00039\t7o]3si\u000e\u000bG\u000e\u001c2bG.$B!!5\u0003:\"9!\u0011U%A\u0002\u0005-\u0018a\u0005;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fGCCAd\u0005\u007f\u0013\tM!2\u0003H\"9!1\u0013&A\u0002\u0005u\u0004b\u0002Bb\u0015\u0002\u0007\u00111X\u0001\u000baJ|G-^2fe&#\u0007\"\u0003BZ\u0015B\u0005\t\u0019\u0001BT\u0011!\u0011IM\u0013I\u0001\u0002\u0004!\u0017A\u0003;y]RKW.Z8vi\u0006iBO]1og\u0006\u001cG/[8o\u001b\u0016$\u0018\rZ1uC\u0012\"WMZ1vYR$3'\u0006\u0002\u0003P*\"!q\u0015BiW\t\u0011\u0019\u000e\u0005\u0003\u0003V\n}WB\u0001Bl\u0015\u0011\u0011INa7\u0002\u0013Ut7\r[3dW\u0016$'b\u0001Bo5\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\u0005(q\u001b\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017!\b;sC:\u001c\u0018m\u0019;j_:lU\r^1eCR\fG\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t\u001d(f\u00013\u0003R\u0006i\u0001O]3qCJ,G\u000b\u001f8M_\u001e$\u0002\"!5\u0003n\n=(1\u001f\u0005\u0006Y6\u0003\rA\u001c\u0005\b\u0005cl\u0005\u0019AA^\u0003-\u0019H/\u0019:u\u001f\u001a47/\u001a;\t\u000f\tUX\n1\u0001\u0003x\u00069!/Z2pe\u0012\u001c\b\u0003BA\b\u0005sLAAa?\u0002\u0012\tiQ*Z7pef\u0014VmY8sIN\f!\u0004\u001d:fa\u0006\u0014XMR8s)btW*Z:tC\u001e,\u0017\t\u001d9f]\u0012$B!!5\u0004\u0002!9!\u0011\u0015(A\u0002\u0005-\b")
public class TransactionStateManagerTest {
    private final int partitionId;
    private final int numPartitions;
    private final int transactionTimeoutMs;
    private final TopicPartition topicPartition = new TopicPartition("__transaction_state", this.partitionId());
    private final int coordinatorEpoch;
    private final ArrayBuffer<SimpleRecord> txnRecords = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    private final MockTime time = new MockTime();
    private final MockScheduler scheduler = new MockScheduler((Time)this.time());
    private final KafkaZkClient zkClient = (KafkaZkClient)EasyMock.createNiceMock(KafkaZkClient.class);
    private final ReplicaManager replicaManager = (ReplicaManager)EasyMock.createNiceMock(ReplicaManager.class);
    private final TransactionConfig txnConfig;
    private final TransactionStateManager transactionManager;
    private final String transactionalId1;
    private final String transactionalId2;
    private final byte[] txnMessageKeyBytes1;
    private final byte[] txnMessageKeyBytes2;
    private final Map<String, Object> producerIds;
    private TransactionMetadata txnMetadata1;
    private TransactionMetadata txnMetadata2;
    private Errors expectedError;

    public int partitionId() {
        return this.partitionId;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public int coordinatorEpoch() {
        return this.coordinatorEpoch;
    }

    public ArrayBuffer<SimpleRecord> txnRecords() {
        return this.txnRecords;
    }

    public MockTime time() {
        return this.time;
    }

    public MockScheduler scheduler() {
        return this.scheduler;
    }

    public KafkaZkClient zkClient() {
        return this.zkClient;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public TransactionConfig txnConfig() {
        return this.txnConfig;
    }

    public TransactionStateManager transactionManager() {
        return this.transactionManager;
    }

    public String transactionalId1() {
        return this.transactionalId1;
    }

    public String transactionalId2() {
        return this.transactionalId2;
    }

    public byte[] txnMessageKeyBytes1() {
        return this.txnMessageKeyBytes1;
    }

    public byte[] txnMessageKeyBytes2() {
        return this.txnMessageKeyBytes2;
    }

    public Map<String, Object> producerIds() {
        return this.producerIds;
    }

    public TransactionMetadata txnMetadata1() {
        return this.txnMetadata1;
    }

    public void txnMetadata1_$eq(TransactionMetadata x$1) {
        this.txnMetadata1 = x$1;
    }

    public TransactionMetadata txnMetadata2() {
        return this.txnMetadata2;
    }

    public void txnMetadata2_$eq(TransactionMetadata x$1) {
        this.txnMetadata2 = x$1;
    }

    public Errors expectedError() {
        return this.expectedError;
    }

    public void expectedError_$eq(Errors x$1) {
        this.expectedError = x$1;
    }

    @Before
    public void setUp() {
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId1()));
        Assert.assertEquals((long)this.partitionId(), (long)this.transactionManager().partitionFor(this.transactionalId2()));
    }

    @After
    public void tearDown() {
        EasyMock.reset((Object[])new Object[]{this.zkClient(), this.replicaManager()});
        this.transactionManager().shutdown();
    }

    @Test
    public void testValidateTransactionTimeout() {
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(-1));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(0));
        Assert.assertTrue((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs()));
        Assert.assertFalse((boolean)this.transactionManager().validateTransactionTimeoutMs(this.txnConfig().transactionMaxTimeoutMs() + 1));
    }

    @Test
    public void testAddGetPids() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)None$.MODULE$), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1())), (Object)this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata2()));
    }

    @Test
    public void testLoadAndRemoveTransactionsForPartition() {
        this.txnMetadata1().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0), new TopicPartition("topic2", 1), new TopicPartition("topic2", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata1().state_$eq((TransactionState)PrepareCommit$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Ongoing$.MODULE$);
        this.txnMetadata2().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic3", 0), new TopicPartition("topic3", 1), new TopicPartition("topic3", 2)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)PrepareAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)CompleteAbort$.MODULE$);
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        this.txnMetadata2().state_$eq((TransactionState)Empty$.MODULE$);
        this.txnMetadata2().topicPartitions().clear();
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes2(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata2().prepareNoTransit())));
        long startOffset = 15L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), startOffset, records);
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$1 -> Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 166)));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$3(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$2 -> Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId2()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 170)));
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(x$3, x$4, x$5, x$6, x$7) -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$5(x$3, BoxesRunTime.unboxToInt((Object)x$4), x$5, x$6, x$7);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 179)), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 180))));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata1 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state access returns error ").append(err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 184)), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId1()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 185))));
        CoordinatorEpochAndTxnMetadata cachedPidMetadata2 = (CoordinatorEpochAndTxnMetadata)this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state access returns error ").append(err).toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 188)), (Function1 & Serializable & scala.Serializable)entry -> (CoordinatorEpochAndTxnMetadata)entry.getOrElse((Function0 & Serializable & scala.Serializable)() -> Assertions$.MODULE$.fail(new StringBuilder(50).append(this.transactionalId2()).append("'s transaction state was not loaded into the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 189))));
        Assert.assertEquals((Object)this.txnMetadata1(), (Object)cachedPidMetadata1.transactionMetadata());
        Assert.assertEquals((Object)this.txnMetadata2(), (Object)cachedPidMetadata2.transactionMetadata());
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.scheduler().tick();
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$15(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$8 -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId1()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 203)));
        this.transactionManager().getTransactionState(this.transactionalId2()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$testLoadAndRemoveTransactionsForPartition$17(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$9 -> Assertions$.MODULE$.fail(new StringBuilder(42).append(this.transactionalId2()).append("'s transaction state is still in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 207)));
    }

    @Test
    public void testCompleteTransitionWhenAppendSucceeded() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NONE);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), this.coordinatorEpoch(), newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToCoordinatorNotAvailableError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_ENOUGH_REPLICAS_AFTER_APPEND);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.REQUEST_TIMED_OUT);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testAppendFailToNotCoordinatorError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NOT_LEADER_FOR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch() + 1, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToCoordinatorLoadingError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_LOAD_IN_PROGRESS);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.transactionManager().removeTransactionsForTxnTopicPartition(this.partitionId(), this.coordinatorEpoch());
        this.transactionManager().addLoadingPartition(this.partitionId(), this.coordinatorEpoch() + 1);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void testAppendFailToUnknownError() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.UNKNOWN_SERVER_ERROR);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.MESSAGE_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
        failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.RECORD_LIST_TOO_LARGE);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertTrue((boolean)this.txnMetadata1().pendingState().isEmpty());
    }

    @Test
    public void testPendingStateNotResetOnRetryAppend() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.expectedError_$eq(Errors.COORDINATOR_NOT_AVAILABLE);
        TxnTransitMetadata failedMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds());
        this.prepareForTxnMessageAppend(Errors.UNKNOWN_TOPIC_OR_PARTITION);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, failedMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)TransactionStateManagerTest.$anonfun$testPendingStateNotResetOnRetryAppend$2(x$10)));
        Assert.assertEquals((Object)package$.MODULE$.Right().apply((Object)new Some((Object)new CoordinatorEpochAndTxnMetadata(this.coordinatorEpoch(), this.txnMetadata1()))), (Object)this.transactionManager().getTransactionState(this.transactionalId1()));
        Assert.assertEquals((Object)new Some((Object)Ongoing$.MODULE$), (Object)this.txnMetadata1().pendingState());
    }

    @Test
    public void testAppendTransactionToLogWhileProducerFenced() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.NOT_COORDINATOR);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().producerEpoch_$eq((short)(this.txnMetadata1().producerEpoch() + 1));
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test(expected=IllegalStateException.class)
    public void testAppendTransactionToLogWhilePendingStateChanged() {
        this.transactionManager().addLoadedTransactionsToCache(this.partitionId(), this.coordinatorEpoch(), new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1()));
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.prepareForTxnMessageAppend(Errors.NONE);
        this.expectedError_$eq(Errors.INVALID_PRODUCER_EPOCH);
        TxnTransitMetadata newMetadata = this.txnMetadata1().prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})), this.time().milliseconds());
        this.txnMetadata1().pendingState_$eq((Option)None$.MODULE$);
        this.transactionManager().appendTransactionToLog(this.transactionalId1(), 10, newMetadata, (Function1 & Serializable & scala.Serializable)error -> {
            this.assertCallback(error);
            return BoxedUnit.UNIT;
        }, this.transactionManager().appendTransactionToLog$default$5());
    }

    @Test
    public void shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned() {
        this.transactionManager().getTransactionState(this.transactionalId1()).fold((Function1 & Serializable & scala.Serializable)err -> {
            TransactionStateManagerTest.$anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(err);
            return BoxedUnit.UNIT;
        }, (Function1 & Serializable & scala.Serializable)x$11 -> Assertions$.MODULE$.fail(new StringBuilder(44).append(this.transactionalId1()).append("'s transaction state is already in the cache").toString(), new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 385)));
    }

    @Test
    public void shouldOnlyConsiderTransactionsInTheOngoingStateToAbort() {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        this.transactionManager().putTransactionStateIfNotExists("ongoing", this.transactionMetadata("ongoing", 0L, (TransactionState)Ongoing$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("not-expiring", this.transactionMetadata("not-expiring", 1L, (TransactionState)Ongoing$.MODULE$, 10000));
        this.transactionManager().putTransactionStateIfNotExists("prepare-commit", this.transactionMetadata("prepare-commit", 2L, (TransactionState)PrepareCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("prepare-abort", this.transactionMetadata("prepare-abort", 3L, (TransactionState)PrepareAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-commit", this.transactionMetadata("complete-commit", 4L, (TransactionState)CompleteCommit$.MODULE$, this.transactionMetadata$default$4()));
        this.transactionManager().putTransactionStateIfNotExists("complete-abort", this.transactionMetadata("complete-abort", 5L, (TransactionState)CompleteAbort$.MODULE$, this.transactionMetadata$default$4()));
        this.time().sleep(2000L);
        Iterable expiring = this.transactionManager().timedOutTransactions();
        Assert.assertEquals((Object)new .colon.colon((Object)new TransactionalIdAndProducerIdEpoch("ongoing", 0L, 0), (List)Nil$.MODULE$), (Object)expiring);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedCommitState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void shouldWriteTxnMarkersForTransactionInPreparedAbortState() {
        this.verifyWritesTxnMarkersInPrepareState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test
    public void shouldRemoveCompleteCommmitExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteCommit$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveCompleteAbortExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldRemoveEmptyExpiredTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Empty$.MODULE$);
        this.verifyMetadataDoesntExist(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveExpiredTransactionalIdsIfLogAppendFails() {
        this.setupAndRunTransactionalIdExpiration(Errors.NOT_ENOUGH_REPLICAS, (TransactionState)CompleteAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemoveOngoingTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)Ongoing$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareAbortTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareAbort$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    @Test
    public void shouldNotRemovePrepareCommitTransactionalIds() {
        this.setupAndRunTransactionalIdExpiration(Errors.NONE, (TransactionState)PrepareCommit$.MODULE$);
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId1());
        this.verifyMetadataDoesExistAndIsUsable(this.transactionalId2());
    }

    private void verifyMetadataDoesExistAndIsUsable(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 468));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (None$.MODULE$.equals(option2)) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 469));
            }
        }
        if (!bl || !((option = (Option)right.value()) instanceof Some)) {
            throw new MatchError((Object)either);
        }
        Some some = (Some)option;
        CoordinatorEpochAndTxnMetadata metadata = (CoordinatorEpochAndTxnMetadata)some.value();
        Assert.assertTrue((String)"metadata shouldn't be in a pending state", (boolean)metadata.transactionMetadata().pendingState().isEmpty());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void verifyMetadataDoesntExist(String transactionalId) {
        Option option;
        boolean bl = false;
        Right right = null;
        Either either = this.transactionManager().getTransactionState(transactionalId);
        if (either instanceof Left) {
            throw Assertions$.MODULE$.fail("shouldn't have been any errors", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 477));
        }
        if (either instanceof Right) {
            bl = true;
            right = (Right)either;
            Option option2 = (Option)right.value();
            if (option2 instanceof Some) {
                throw Assertions$.MODULE$.fail("metadata should have been removed", new Position("TransactionStateManagerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 478));
            }
        }
        if (!bl || !None$.MODULE$.equals(option = (Option)right.value())) {
            throw new MatchError((Object)either);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void setupAndRunTransactionalIdExpiration(Errors error, TransactionState txnState) {
        BoxedUnit boxedUnit;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partitionId -> this.transactionManager().addLoadedTransactionsToCache(partitionId, 0, new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1())));
        Capture capturedArgument = EasyMock.newCapture();
        TopicPartition partition = new TopicPartition("__transaction_state", this.transactionManager().partitionFor(this.transactionalId1()));
        Map recordsByPartition = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)MemoryRecords.withRecords((CompressionType)TransactionLog$.MODULE$.EnforcedCompressionType(), (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(this.time().milliseconds() + (long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs(), TransactionLog$.MODULE$.keyToBytes(this.transactionalId1()), null)}))}));
        TransactionState transactionState = txnState;
        boolean bl = Empty$.MODULE$.equals(transactionState) ? true : (CompleteCommit$.MODULE$.equals(transactionState) ? true : CompleteAbort$.MODULE$.equals(transactionState));
        if (bl) {
            this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.eq((short)((short)-1)), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.eq((Object)recordsByPartition), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, capturedArgument, partition, error){
                private final Capture capturedArgument$1;
                private final TopicPartition partition$1;
                private final Errors error$1;

                public void answer() {
                    ((Function1)this.capturedArgument$1.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.partition$1), (Object)new ProduceResponse.PartitionResponse(this.error$1, 0L, -1L, 0L))})));
                }
                {
                    this.capturedArgument$1 = capturedArgument$1;
                    this.partition$1 = partition$1;
                    this.error$1 = error$1;
                }
            });
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
        this.txnMetadata1().txnLastUpdateTimestamp_$eq(this.time().milliseconds() - (long)this.txnConfig().transactionalIdExpirationMs());
        this.txnMetadata1().state_$eq(txnState);
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId1(), this.txnMetadata1());
        this.txnMetadata2().txnLastUpdateTimestamp_$eq(this.time().milliseconds());
        this.transactionManager().putTransactionStateIfNotExists(this.transactionalId2(), this.txnMetadata2());
        this.transactionManager().enableTransactionalIdExpiration();
        this.time().sleep((long)this.txnConfig().removeExpiredTransactionalIdsIntervalMs());
        this.scheduler().tick();
        EasyMock.verify((Object[])new Object[]{this.replicaManager()});
    }

    private void verifyWritesTxnMarkersInPrepareState(TransactionState state) {
        this.txnMetadata1().state_$eq(state);
        this.txnMetadata1().addPartitions((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic1", 1)})));
        this.txnRecords().$plus$eq((Object)new SimpleRecord(this.txnMessageKeyBytes1(), TransactionLog$.MODULE$.valueToBytes(this.txnMetadata1().prepareNoTransit())));
        long startOffset = 0L;
        MemoryRecords records = MemoryRecords.withRecords((long)startOffset, (CompressionType)CompressionType.NONE, (SimpleRecord[])((SimpleRecord[])this.txnRecords().toArray(ClassTag$.MODULE$.apply(SimpleRecord.class))));
        this.prepareTxnLog(this.topicPartition(), 0L, records);
        ObjectRef txnId = ObjectRef.create(null);
        this.transactionManager().loadTransactionsForTxnTopicPartition(this.partitionId(), 0, (Function5 & Serializable & scala.Serializable)(transactionalId, coordinatorEpoch, command, metadata, newMetadata) -> {
            TransactionStateManagerTest.rememberTxnMarkers$1(transactionalId, BoxesRunTime.unboxToInt((Object)coordinatorEpoch), command, metadata, newMetadata, txnId);
            return BoxedUnit.UNIT;
        });
        this.scheduler().tick();
        Assert.assertEquals((Object)this.transactionalId1(), (Object)((String)txnId.elem));
    }

    private void assertCallback(Errors error) {
        Assert.assertEquals((Object)this.expectedError(), (Object)error);
    }

    private TransactionMetadata transactionMetadata(String transactionalId, long producerId, TransactionState state, int txnTimeout) {
        return TransactionMetadata$.MODULE$.apply(transactionalId, producerId, (short)0, txnTimeout, state, this.time().milliseconds());
    }

    private TransactionState transactionMetadata$default$3() {
        return Empty$.MODULE$;
    }

    private int transactionMetadata$default$4() {
        return this.transactionTimeoutMs();
    }

    private void prepareTxnLog(TopicPartition topicPartition, long startOffset, MemoryRecords records) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Log logMock = (Log)EasyMock.mock(Log.class);
        FileRecords fileRecordsMock = (FileRecords)EasyMock.mock(FileRecords.class);
        long endOffset = startOffset + (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records.records()).asScala()).size();
        EasyMock.expect((Object)this.replicaManager().getLog(topicPartition)).andStubReturn((Object)new Some((Object)logMock));
        EasyMock.expect((Object)this.replicaManager().getLogEndOffset(topicPartition)).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToLong((long)endOffset)));
        EasyMock.expect((Object)BoxesRunTime.boxToLong((long)logMock.logStartOffset())).andStubReturn((Object)BoxesRunTime.boxToLong((long)startOffset));
        EasyMock.expect((Object)logMock.read(EasyMock.eq((long)startOffset), EasyMock.anyInt(), (Option)EasyMock.eq((Object)None$.MODULE$), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false))).andReturn((Object)new FetchDataInfo(new LogOffsetMetadata(startOffset, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3()), (Records)fileRecordsMock, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()));
        EasyMock.expect((Object)BoxesRunTime.boxToInteger((int)fileRecordsMock.sizeInBytes())).andStubReturn((Object)BoxesRunTime.boxToInteger((int)records.sizeInBytes()));
        Capture bufferCapture = EasyMock.newCapture();
        fileRecordsMock.readInto((ByteBuffer)EasyMock.capture((Capture)bufferCapture), EasyMock.anyInt());
        EasyMock.expectLastCall().andAnswer((IAnswer)new IAnswer<BoxedUnit>(null, bufferCapture, records){
            private final Capture bufferCapture$1;
            private final MemoryRecords records$1;

            public void answer() {
                ByteBuffer buffer = (ByteBuffer)this.bufferCapture$1.getValue();
                buffer.put(this.records$1.buffer().duplicate());
                buffer.flip();
            }
            {
                this.bufferCapture$1 = bufferCapture$1;
                this.records$1 = records$1;
            }
        });
        EasyMock.replay((Object[])new Object[]{logMock, fileRecordsMock, this.replicaManager()});
    }

    private void prepareForTxnMessageAppend(Errors error) {
        EasyMock.reset((Object[])new Object[]{this.replicaManager()});
        Capture capturedArgument = EasyMock.newCapture();
        this.replicaManager().appendRecords(EasyMock.anyLong(), EasyMock.anyShort(), EasyMock.eq((boolean)true), EasyMock.eq((boolean)false), (Map)EasyMock.anyObject(), (Function1)EasyMock.capture((Capture)capturedArgument), (Option)EasyMock.anyObject(), (Function1)EasyMock.anyObject());
        EasyMock.expect((Object)BoxedUnit.UNIT).andAnswer((IAnswer)new IAnswer<BoxedUnit>(this, capturedArgument, error){
            private final /* synthetic */ TransactionStateManagerTest $outer;
            private final Capture capturedArgument$2;
            private final Errors error$2;

            public void answer() {
                ((Function1)this.capturedArgument$2.getValue()).apply((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("__transaction_state", this.$outer.partitionId())), (Object)new ProduceResponse.PartitionResponse(this.error$2, 0L, -1L, 0L))})));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.capturedArgument$2 = capturedArgument$2;
                this.error$2 = error$2;
            }
        });
        EasyMock.expect((Object)this.replicaManager().getMagic((TopicPartition)EasyMock.anyObject())).andStubReturn((Object)new Some((Object)BoxesRunTime.boxToByte((byte)1)));
        EasyMock.replay((Object[])new Object[]{this.replicaManager()});
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$3(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$5(String x$3, int x$4, TransactionResult x$5, TransactionMetadata x$6, TxnTransitMetadata x$7) {
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$15(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ void $anonfun$testLoadAndRemoveTransactionsForPartition$17(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    public static final /* synthetic */ boolean $anonfun$testPendingStateNotResetOnRetryAppend$2(Errors x$10) {
        return true;
    }

    public static final /* synthetic */ void $anonfun$shouldReturnNotCooridnatorErrorIfTransactionIdPartitionNotOwned$1(Errors err) {
        Assert.assertEquals((Object)Errors.NOT_COORDINATOR, (Object)err);
    }

    private static final void rememberTxnMarkers$1(String transactionalId, int coordinatorEpoch, TransactionResult command, TransactionMetadata metadata, TxnTransitMetadata newMetadata, ObjectRef txnId$1) {
        txnId$1.elem = transactionalId;
    }

    public TransactionStateManagerTest() {
        this.partitionId = 0;
        this.numPartitions = 2;
        this.transactionTimeoutMs = 1000;
        this.coordinatorEpoch = 10;
        EasyMock.expect((Object)this.zkClient().getTopicPartitionCount("__transaction_state")).andReturn((Object)new Some((Object)BoxesRunTime.boxToInteger((int)this.numPartitions()))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
        this.txnConfig = new TransactionConfig(TransactionConfig$.MODULE$.apply$default$1(), TransactionConfig$.MODULE$.apply$default$2(), TransactionConfig$.MODULE$.apply$default$3(), TransactionConfig$.MODULE$.apply$default$4(), TransactionConfig$.MODULE$.apply$default$5(), TransactionConfig$.MODULE$.apply$default$6(), TransactionConfig$.MODULE$.apply$default$7(), TransactionConfig$.MODULE$.apply$default$8(), TransactionConfig$.MODULE$.apply$default$9(), TransactionConfig$.MODULE$.apply$default$10());
        this.transactionManager = new TransactionStateManager(0, this.zkClient(), (Scheduler)this.scheduler(), this.replicaManager(), this.txnConfig(), (Time)this.time());
        this.transactionalId1 = "one";
        this.transactionalId2 = "two";
        this.txnMessageKeyBytes1 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId1());
        this.txnMessageKeyBytes2 = TransactionLog$.MODULE$.keyToBytes(this.transactionalId2());
        this.producerIds = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId1()), (Object)BoxesRunTime.boxToLong((long)1L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.transactionalId2()), (Object)BoxesRunTime.boxToLong((long)2L))}));
        this.txnMetadata1 = this.transactionMetadata(this.transactionalId1(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId1())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.txnMetadata2 = this.transactionMetadata(this.transactionalId2(), BoxesRunTime.unboxToLong((Object)this.producerIds().apply((Object)this.transactionalId2())), this.transactionMetadata$default$3(), this.transactionMetadata$default$4());
        this.expectedError = Errors.NONE;
    }
}

