/*
 * Decompiled with CFR 0.152.
 */
package kafka.security.auth;

import java.nio.charset.StandardCharsets;
import kafka.security.auth.Acl;
import kafka.security.auth.Acl$;
import kafka.security.auth.Allow$;
import kafka.security.auth.Deny$;
import kafka.security.auth.Operation;
import kafka.security.auth.PermissionType;
import kafka.security.auth.Read$;
import kafka.utils.Json$;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001U2A!\u0002\u0004\u0001\u001b!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0003i\u0002B\u0002\u0014\u0001A\u0003%a\u0004C\u0003(\u0001\u0011\u0005\u0001FA\u0004BG2$Vm\u001d;\u000b\u0005\u001dA\u0011\u0001B1vi\"T!!\u0003\u0006\u0002\u0011M,7-\u001e:jifT\u0011aC\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0002\u0005\u0002\u0010-5\t\u0001C\u0003\u0002\u0012%\u0005)!.\u001e8ji*\u00111\u0003F\u0001\ng\u000e\fG.\u0019;fgRT\u0011!F\u0001\u0004_J<\u0017BA\f\u0011\u0005)QUK\\5u'VLG/Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003i\u0001\"a\u0007\u0001\u000e\u0003\u0019\tq!Q2m\u0015N|g.F\u0001\u001f!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003mC:<'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012aa\u0015;sS:<\u0017\u0001C!dY*\u001bxN\u001c\u0011\u0002+Q,7\u000f^!dY*\u001bxN\\\"p]Z,'o]5p]R\t\u0011\u0006\u0005\u0002+[5\t1FC\u0001-\u0003\u0015\u00198-\u00197b\u0013\tq3F\u0001\u0003V]&$\bF\u0001\u00031!\t\t4'D\u00013\u0015\t\tB#\u0003\u00025e\t!A+Z:u\u0001")
public class AclTest
extends JUnitSuite {
    private final String AclJson;

    public String AclJson() {
        return this.AclJson;
    }

    @Test
    public void testAclJsonConversion() {
        Acl acl1 = new Acl(new KafkaPrincipal("User", "alice"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Acl acl2 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Allow$.MODULE$, "*", (Operation)Read$.MODULE$);
        Acl acl3 = new Acl(new KafkaPrincipal("User", "bob"), (PermissionType)Deny$.MODULE$, "host1", (Operation)Read$.MODULE$);
        Set acls = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Acl[]{acl1, acl2, acl3}));
        byte[] jsonAcls = Json$.MODULE$.encodeAsBytes(JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Acl$.MODULE$.toJsonCompatibleMap(acls)).asJava());
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromBytes(jsonAcls));
        Assert.assertEquals((Object)acls, (Object)Acl$.MODULE$.fromBytes(this.AclJson().getBytes(StandardCharsets.UTF_8)));
    }

    public AclTest() {
        this.AclJson = "{\"version\": 1, \"acls\": [{\"host\": \"host1\",\"permissionType\": \"Deny\",\"operation\": \"READ\", \"principal\": \"User:alice\"  },  {  \"host\":  \"*\" ,  \"permissionType\": \"Allow\",  \"operation\":  \"Read\", \"principal\": \"User:bob\"  },  {  \"host\": \"host1\",  \"permissionType\": \"Deny\",  \"operation\":   \"Read\" ,  \"principal\": \"User:bob\"}  ]}";
    }
}

