/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.cluster.Replica$;
import kafka.log.Log;
import kafka.log.LogManager;
import kafka.server.BrokerTopicStats;
import kafka.server.FetchDataInfo;
import kafka.server.FetchDataInfo$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.LogReadResult;
import kafka.server.LogReadResult$;
import kafka.server.MetadataCache;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.utils.MockTime;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.common.utils.Time;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=g\u0001B\u0011#\u0001\u001dBQA\f\u0001\u0005\u0002=BqA\r\u0001A\u0002\u0013\u00051\u0007C\u0004W\u0001\u0001\u0007I\u0011A,\t\ru\u0003\u0001\u0015)\u00035\u0011\u001dq\u0006A1A\u0005\u0002}Caa\u0019\u0001!\u0002\u0013\u0001\u0007b\u00023\u0001\u0005\u0004%\t!\u001a\u0005\u0007M\u0002\u0001\u000b\u0011\u0002&\t\u000f\u001d\u0004!\u0019!C\u0001K\"1\u0001\u000e\u0001Q\u0001\n)Cq!\u001b\u0001C\u0002\u0013\u0005!\u000e\u0003\u0004t\u0001\u0001\u0006Ia\u001b\u0005\bi\u0002\u0011\r\u0011\"\u0001v\u0011\u0019a\b\u0001)A\u0005m\"9Q\u0010\u0001b\u0001\n\u0003q\bbBA\u0005\u0001\u0001\u0006Ia \u0005\n\u0003\u0017\u0001!\u0019!C\u0001\u0003\u001bA\u0001\"a\u0007\u0001A\u0003%\u0011q\u0002\u0005\n\u0003;\u0001!\u0019!C\u0001\u0003?A\u0001\"!\u000f\u0001A\u0003%\u0011\u0011\u0005\u0005\n\u0003w\u0001\u0001\u0019!C\u0001\u0003{A\u0011\"!\u0012\u0001\u0001\u0004%\t!a\u0012\t\u0011\u0005-\u0003\u0001)Q\u0005\u0003\u007fAq!!\u0014\u0001\t\u0003\ty\u0005C\u0004\u0002`\u0001!\t!a\u0014\t\u000f\u0005%\u0004\u0001\"\u0001\u0002P!9\u00111\u000f\u0001\u0005\u0002\u0005=\u0003bBA<\u0001\u0011\u0005\u0011q\n\u0005\b\u0003w\u0002A\u0011AA(\u0011\u001d\ty\b\u0001C\u0005\u0003\u0003Cq!!.\u0001\t\u0013\t9\fC\u0004\u0002:\u0002!I!a/\u0003#%\u001b(/\u0012=qSJ\fG/[8o)\u0016\u001cHO\u0003\u0002$I\u000511/\u001a:wKJT\u0011!J\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001\u0001\u0006\u0005\u0002*Y5\t!FC\u0001,\u0003\u0015\u00198-\u00197b\u0013\ti#F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003A\u0002\"!\r\u0001\u000e\u0003\t\n\u0011\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|g.S:s+\u0005!\u0004\u0003B\u001b;y5k\u0011A\u000e\u0006\u0003oa\nq!\\;uC\ndWM\u0003\u0002:U\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005m2$aA'baB!\u0011&P K\u0013\tq$F\u0001\u0004UkBdWM\r\t\u0003\u0001\u001es!!Q#\u0011\u0005\tSS\"A\"\u000b\u0005\u00113\u0013A\u0002\u001fs_>$h(\u0003\u0002GU\u00051\u0001K]3eK\u001aL!\u0001S%\u0003\rM#(/\u001b8h\u0015\t1%\u0006\u0005\u0002*\u0017&\u0011AJ\u000b\u0002\u0004\u0013:$\bc\u0001(T\u0015:\u0011q*\u0015\b\u0003\u0005BK\u0011aK\u0005\u0003%*\nq\u0001]1dW\u0006<W-\u0003\u0002U+\n\u00191+Z9\u000b\u0005IS\u0013!\u0006;pa&\u001c\u0007+\u0019:uSRLwN\\%te~#S-\u001d\u000b\u00031n\u0003\"!K-\n\u0005iS#\u0001B+oSRDq\u0001X\u0002\u0002\u0002\u0003\u0007A'A\u0002yIE\n!\u0003^8qS\u000e\u0004\u0016M\u001d;ji&|g.S:sA\u0005\u0019\"/\u001a9mS\u000e\fG*Y4US6,W*\u0019=NgV\t\u0001\r\u0005\u0002*C&\u0011!M\u000b\u0002\u0005\u0019>tw-\u0001\u000bsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5\u000fI\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005Q\u0015A\u0006:fa2L7-\u0019$fi\u000eDw+Y5u\u001b\u0006DXj\u001d\u0011\u0002%1,\u0017\rZ3s\u0019><WI\u001c3PM\u001a\u001cX\r^\u0001\u0014Y\u0016\fG-\u001a:M_\u001e,e\u000eZ(gMN,G\u000fI\u0001\u0010_Z,'O]5eS:<\u0007K]8qgV\t1\u000e\u0005\u0002mc6\tQN\u0003\u0002o_\u0006!Q\u000f^5m\u0015\u0005\u0001\u0018\u0001\u00026bm\u0006L!A]7\u0003\u0015A\u0013x\u000e]3si&,7/\u0001\tpm\u0016\u0014(/\u001b3j]\u001e\u0004&o\u001c9tA\u000591m\u001c8gS\u001e\u001cX#\u0001<\u0011\u0007]D\u00180D\u00019\u0013\t!\u0006\b\u0005\u00022u&\u00111P\t\u0002\f\u0017\u000647.Y\"p]\u001aLw-\u0001\u0005d_:4\u0017nZ:!\u0003\u0015!x\u000e]5d+\u0005y\b\u0003BA\u0001\u0003\u000fi!!a\u0001\u000b\u0007\u0005\u0015q.\u0001\u0003mC:<\u0017b\u0001%\u0002\u0004\u00051Ao\u001c9jG\u0002\nA\u0001^5nKV\u0011\u0011q\u0002\t\u0005\u0003#\t9\"\u0004\u0002\u0002\u0014)\u0019\u0011Q\u0003\u0013\u0002\u000bU$\u0018\u000e\\:\n\t\u0005e\u00111\u0003\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u00059Q.\u001a;sS\u000e\u001cXCAA\u0011!\u0011\t\u0019#!\u000e\u000e\u0005\u0005\u0015\"\u0002BA\u000f\u0003OQA!!\u000b\u0002,\u000511m\\7n_:T1!JA\u0017\u0015\u0011\ty#!\r\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\t\u0019$A\u0002pe\u001eLA!a\u000e\u0002&\t9Q*\u001a;sS\u000e\u001c\u0018\u0001C7fiJL7m\u001d\u0011\u0002\u001dI,\u0007\u000f\\5dC6\u000bg.Y4feV\u0011\u0011q\b\t\u0004c\u0005\u0005\u0013bAA\"E\tq!+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\u0018A\u0005:fa2L7-Y'b]\u0006<WM]0%KF$2\u0001WA%\u0011!af#!AA\u0002\u0005}\u0012a\u0004:fa2L7-Y'b]\u0006<WM\u001d\u0011\u0002\u000bM,G/\u00169\u0015\u0003aC3\u0001GA*!\u0011\t)&a\u0017\u000e\u0005\u0005]#\u0002BA-\u0003c\tQA[;oSRLA!!\u0018\u0002X\t1!)\u001a4pe\u0016\f\u0001\u0002^3be\u0012{wO\u001c\u0015\u00043\u0005\r\u0004\u0003BA+\u0003KJA!a\u001a\u0002X\t)\u0011I\u001a;fe\u0006\u0011C/Z:u\u0013N\u0014X\t\u001f9je\u0006$\u0018n\u001c8G_J\u001cF/^2l\r>dGn\\<feND3AGA7!\u0011\t)&a\u001c\n\t\u0005E\u0014q\u000b\u0002\u0005)\u0016\u001cH/A\u0013uKN$\u0018j\u001d:FqBL'/\u0019;j_:LeMT8GKR\u001c\u0007NU3rk\u0016\u001cH/T1eK\"\u001a1$!\u001c\u0002CQ,7\u000f^%te\u0016C\b/\u001b:bi&|gNR8s'2|wOR8mY><XM]:)\u0007q\ti'A\u0013uKN$\u0018j\u001d:FqBL'/\u0019;j_:4uN]\"bk\u001eDG/\u00169G_2dwn^3sg\"\u001aQ$!\u001c\u0002A\u001d,G\u000fU1si&$\u0018n\u001c8XSRD\u0017\t\u001c7SKBd\u0017nY1t\u0013:L5O\u001d\u000b\r\u0003\u0007\u000by)!%\u0002\u0016\u0006\u0005\u0016Q\u0015\t\u0005\u0003\u000b\u000bY)\u0004\u0002\u0002\b*\u0019\u0011\u0011\u0012\u0013\u0002\u000f\rdWo\u001d;fe&!\u0011QRAD\u0005%\u0001\u0016M\u001d;ji&|g\u000eC\u0003~=\u0001\u0007q\b\u0003\u0004\u0002\u0014z\u0001\rAS\u0001\fa\u0006\u0014H/\u001b;j_:LE\rC\u0004\u0002\fy\u0001\r!a&\u0011\t\u0005e\u0015QT\u0007\u0003\u00037SA!!\u0006\u0002(%!\u0011qTAN\u0005\u0011!\u0016.\\3\t\r\u0005\rf\u00041\u0001z\u0003\u0019\u0019wN\u001c4jO\"9\u0011q\u0015\u0010A\u0002\u0005%\u0016\u0001\u00037pG\u0006dGj\\4\u0011\t\u0005-\u0016\u0011W\u0007\u0003\u0003[S1!a,%\u0003\rawnZ\u0005\u0005\u0003g\u000biKA\u0002M_\u001e\fq\u0001\\8h\u001b>\u001c7.\u0006\u0002\u0002*\u0006\u0019r-\u001a;G_2dwn^3s%\u0016\u0004H.[2bgRA\u0011QXAc\u0003\u0013\fi\r\u0005\u0003O'\u0006}\u0006\u0003BAC\u0003\u0003LA!a1\u0002\b\n9!+\u001a9mS\u000e\f\u0007bBAdA\u0001\u0007\u00111Q\u0001\na\u0006\u0014H/\u001b;j_:Da!a3!\u0001\u0004Q\u0015\u0001\u00037fC\u0012,'/\u00133\t\u000f\u0005-\u0001\u00051\u0001\u0002\u0018\u0002")
public class IsrExpirationTest {
    private Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr = new HashMap();
    private final long replicaLagTimeMaxMs;
    private final int replicaFetchWaitMaxMs;
    private final int leaderLogEndOffset;
    private final Properties overridingProps = new Properties();
    private final Seq<KafkaConfig> configs;
    private final String topic;
    private final MockTime time;
    private final Metrics metrics;
    private ReplicaManager replicaManager;

    public Map<Tuple2<String, Object>, Seq<Object>> topicPartitionIsr() {
        return this.topicPartitionIsr;
    }

    public void topicPartitionIsr_$eq(Map<Tuple2<String, Object>, Seq<Object>> x$1) {
        this.topicPartitionIsr = x$1;
    }

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int leaderLogEndOffset() {
        return this.leaderLogEndOffset;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ReplicaManager replicaManager() {
        return this.replicaManager;
    }

    public void replicaManager_$eq(ReplicaManager x$1) {
        this.replicaManager = x$1;
    }

    @Before
    public void setUp() {
        LogManager logManager = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)logManager.liveLogDirs()).andReturn((Object)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(File.class)))).anyTimes();
        EasyMock.replay((Object[])new Object[]{logManager});
        this.replicaManager_$eq(new ReplicaManager((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), null, null, logManager, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate((KafkaConfig)this.configs().head(), this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(((KafkaConfig)this.configs().head()).brokerId()), new LogDirFailureChannel(((KafkaConfig)this.configs().head()).logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12()));
    }

    @After
    public void tearDown() {
        this.replicaManager().shutdown(false);
        this.metrics().close();
    }

    @Test
    public void testIsrExpirationForStuckFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)x$2.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.leaderLogEndOffset() - 1), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationIfNoFetchRequestMade() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)x$6.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        this.time().sleep(150L);
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger((int)x$8.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForSlowFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger((int)x$9.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 2), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.leaderLogEndOffset() - 2), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToInteger((int)x$11.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)r -> {
            r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)(this.leaderLogEndOffset() - 1), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)(this.leaderLogEndOffset() - 1), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)x$12.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(75L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"Replica 1 should be out of sync", (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{((KafkaConfig)this.configs().last()).brokerId()})), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)x$13.brokerId()), Set$.MODULE$.canBuildFrom()));
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)r -> {
            r.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)this.leaderLogEndOffset(), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)x$14.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    @Test
    public void testIsrExpirationForCaughtUpFollowers() {
        Log log = this.logMock();
        Partition partition0 = this.getPartitionWithAllReplicasInIsr(this.topic(), 0, (Time)this.time(), (KafkaConfig)this.configs().head(), log);
        Assert.assertEquals((String)"All replicas should be in ISR", (Object)((TraversableOnce)this.configs().map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)x$15.brokerId()), Seq$.MODULE$.canBuildFrom())).toSet(), (Object)partition0.inSyncReplicas().map((Function1 & Serializable & scala.Serializable)x$16 -> BoxesRunTime.boxToInteger((int)x$16.brokerId()), Set$.MODULE$.canBuildFrom()));
        Replica leaderReplica = (Replica)partition0.getReplica(((KafkaConfig)this.configs().head()).brokerId()).get();
        partition0.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), (long)this.leaderLogEndOffset(), 0L, (long)this.leaderLogEndOffset(), 0L, this.time().milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        Set partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToInteger((int)x$17.brokerId()), Set$.MODULE$.canBuildFrom()));
        this.time().sleep(150L);
        partition0OSR = partition0.getOutOfSyncReplicas(leaderReplica, Predef$.MODULE$.Long2long(((KafkaConfig)this.configs().head()).replicaLagTimeMaxMs()));
        Assert.assertEquals((String)"No replica should be out of sync", (Object)Predef$.MODULE$.Set().empty(), (Object)partition0OSR.map((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger((int)x$18.brokerId()), Set$.MODULE$.canBuildFrom()));
        EasyMock.verify((Object[])new Object[]{log});
    }

    private Partition getPartitionWithAllReplicasInIsr(String topic, int partitionId, Time time, KafkaConfig config, Log localLog) {
        int leaderId = config.brokerId();
        TopicPartition tp = new TopicPartition(topic, partitionId);
        Partition partition = this.replicaManager().getOrCreatePartition(tp);
        Replica leaderReplica = new Replica(leaderId, tp, time, 0L, (Option)new Some((Object)localLog));
        Seq allReplicas = (Seq)this.getFollowerReplicas(partition, leaderId, time).$colon$plus((Object)leaderReplica, Seq$.MODULE$.canBuildFrom());
        allReplicas.foreach((Function1 & Serializable & scala.Serializable)r -> partition.addReplicaIfNotExists(r));
        partition.inSyncReplicas_$eq(allReplicas.toSet());
        partition.assignedReplicas().$minus((Object)leaderReplica).foreach((Function1 & Serializable & scala.Serializable)replica -> {
            replica.updateLogReadResult(new LogReadResult(new FetchDataInfo(new LogOffsetMetadata(0L, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3()), (Records)MemoryRecords.EMPTY, FetchDataInfo$.MODULE$.apply$default$3(), FetchDataInfo$.MODULE$.apply$default$4()), 0L, 0L, 0L, 0L, time.milliseconds(), -1, (Option)None$.MODULE$, LogReadResult$.MODULE$.$lessinit$greater$default$9()));
            return BoxedUnit.UNIT;
        });
        partition.leaderReplicaIdOpt_$eq((Option)new Some((Object)BoxesRunTime.boxToInteger((int)leaderId)));
        return partition;
    }

    /*
     * WARNING - void declaration
     */
    private Log logMock() {
        void var1_1;
        Log log = (Log)EasyMock.createMock(Log.class);
        EasyMock.expect((Object)log.dir()).andReturn((Object)TestUtils$.MODULE$.tempDir()).anyTimes();
        log.onHighWatermarkIncremented(0L);
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.expect((Object)log.logEndOffsetMetadata()).andReturn((Object)new LogOffsetMetadata((long)this.leaderLogEndOffset(), LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3())).anyTimes();
        EasyMock.replay((Object[])new Object[]{log});
        return var1_1;
    }

    private Seq<Replica> getFollowerReplicas(Partition partition, int leaderId, Time time) {
        return (Seq)((TraversableLike)this.configs().filter((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)IsrExpirationTest.$anonfun$getFollowerReplicas$1(leaderId, x$19)))).map((Function1 & Serializable & scala.Serializable)config -> new Replica(config.brokerId(), partition.topicPartition(), time, Replica$.MODULE$.$lessinit$greater$default$4(), Replica$.MODULE$.$lessinit$greater$default$5()), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ boolean $anonfun$getFollowerReplicas$1(int leaderId$1, KafkaConfig x$19) {
        return x$19.brokerId() != leaderId$1;
    }

    public IsrExpirationTest() {
        this.replicaLagTimeMaxMs = 100L;
        this.replicaFetchWaitMaxMs = 100;
        this.leaderLogEndOffset = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.configs = (Seq)TestUtils$.MODULE$.createBrokerConfigs(2, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfigs$default$3(), TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom());
        this.topic = "foo";
        this.time = new MockTime();
        this.metrics = new Metrics();
        this.replicaManager = null;
    }
}

