/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.server.ReplicaManager$;
import kafka.server.checkpoints.OffsetCheckpointFile;
import kafka.server.checkpoints.OffsetCheckpointFile$;
import kafka.utils.TestUtils$;
import kafka.zk.KafkaZkClient;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.apache.kafka.common.serialization.IntegerSerializer;
import org.apache.kafka.common.serialization.StringSerializer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005eg\u0001B\u00181\u0001UBQ\u0001\u0010\u0001\u0005\u0002uBq\u0001\u0011\u0001C\u0002\u0013\u0005\u0011\t\u0003\u0004I\u0001\u0001\u0006IA\u0011\u0005\b\u0013\u0002\u0011\r\u0011\"\u0001B\u0011\u0019Q\u0005\u0001)A\u0005\u0005\"91\n\u0001b\u0001\n\u0003a\u0005B\u0002)\u0001A\u0003%Q\nC\u0004R\u0001\t\u0007I\u0011\u0001'\t\rI\u0003\u0001\u0015!\u0003N\u0011\u001d\u0019\u0006A1A\u0005\u0002QCa!\u0018\u0001!\u0002\u0013)\u0006b\u00020\u0001\u0001\u0004%\ta\u0018\u0005\b_\u0002\u0001\r\u0011\"\u0001q\u0011\u00191\b\u0001)Q\u0005A\"9q\u000f\u0001b\u0001\n\u0003A\bBB@\u0001A\u0003%\u0011\u0010\u0003\u0005\u0002\u0002\u0001\u0011\r\u0011\"\u0001M\u0011\u001d\t\u0019\u0001\u0001Q\u0001\n5C\u0011\"!\u0002\u0001\u0005\u0004%\t!a\u0002\t\u0011\u0005}\u0001\u0001)A\u0005\u0003\u0013A\u0011\"!\t\u0001\u0001\u0004%\t!a\t\t\u0013\u0005-\u0002\u00011A\u0005\u0002\u00055\u0002\u0002CA\u0019\u0001\u0001\u0006K!!\n\t\u0013\u0005M\u0002\u00011A\u0005\u0002\u0005\r\u0002\"CA\u001b\u0001\u0001\u0007I\u0011AA\u001c\u0011!\tY\u0004\u0001Q!\n\u0005\u0015\u0002bBA\u001f\u0001\u0011\u0005\u0011q\b\u0005\b\u0003\u0003\u0002A\u0011AA \u0011!\t\u0019\u0005\u0001b\u0001\n\u0003A\bbBA#\u0001\u0001\u0006I!\u001f\u0005\n\u0003\u000f\u0002\u0001\u0019!C\u0001\u0003\u0013B\u0011\"!\u001c\u0001\u0001\u0004%\t!a\u001c\t\u0011\u0005M\u0004\u0001)Q\u0005\u0003\u0017Bq!!\u001e\u0001\t\u0003\t9\bC\u0004\u0002\u0006\u0002!\t!a\u001e\t\u0013\u0005\u001d\u0005\u00011A\u0005\u0002\u0005%\u0005\"CAK\u0001\u0001\u0007I\u0011AAL\u0011!\tY\n\u0001Q!\n\u0005-\u0005bBAO\u0001\u0011\u0005\u0011q\u0014\u0005\b\u0003C\u0003A\u0011IAP\u0011\u001d\t\t\f\u0001C!\u0003?Cq!a/\u0001\t\u0003\ty\nC\u0004\u0002F\u0002!\t!a(\t\u000f\u0005%\u0007\u0001\"\u0001\u0002 \"9\u0011Q\u001a\u0001\u0005\u0002\u0005}\u0005bBAi\u0001\u0011%\u00111\u001b\u0002\u0010\u0019><'+Z2pm\u0016\u0014\u0018\u0010V3ti*\u0011\u0011GM\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003M\nQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001mA\u0011qGO\u0007\u0002q)\u0011\u0011HM\u0001\u0003u.L!a\u000f\u001d\u0003)i{wnS3fa\u0016\u0014H+Z:u\u0011\u0006\u0014h.Z:t\u0003\u0019a\u0014N\\5u}Q\ta\b\u0005\u0002@\u00015\t\u0001'A\nsKBd\u0017nY1MC\u001e$\u0016.\\3NCbl5/F\u0001C!\t\u0019e)D\u0001E\u0015\u0005)\u0015!B:dC2\f\u0017BA$E\u0005\u0011auN\\4\u0002)I,\u0007\u000f\\5dC2\u000bw\rV5nK6\u000b\u00070T:!\u0003U\u0011X\r\u001d7jG\u0006d\u0015mZ'bq6+7o]1hKN\faC]3qY&\u001c\u0017\rT1h\u001b\u0006DX*Z:tC\u001e,7\u000fI\u0001\u0016e\u0016\u0004H.[2b\r\u0016$8\r[,bSRl\u0015\r_'t+\u0005i\u0005CA\"O\u0013\tyEIA\u0002J]R\faC]3qY&\u001c\u0017MR3uG\"<\u0016-\u001b;NCbl5\u000fI\u0001\u0015e\u0016\u0004H.[2b\r\u0016$8\r['j]\nKH/Z:\u0002+I,\u0007\u000f\\5dC\u001a+Go\u00195NS:\u0014\u0015\u0010^3tA\u0005yqN^3se&$\u0017N\\4Qe>\u00048/F\u0001V!\t16,D\u0001X\u0015\tA\u0016,\u0001\u0003vi&d'\"\u0001.\u0002\t)\fg/Y\u0005\u00039^\u0013!\u0002\u0015:pa\u0016\u0014H/[3t\u0003Ayg/\u001a:sS\u0012Lgn\u001a)s_B\u001c\b%A\u0004d_:4\u0017nZ:\u0016\u0003\u0001\u00042!Y5m\u001d\t\u0011wM\u0004\u0002dM6\tAM\u0003\u0002fi\u00051AH]8pizJ\u0011!R\u0005\u0003Q\u0012\u000bq\u0001]1dW\u0006<W-\u0003\u0002kW\n\u00191+Z9\u000b\u0005!$\u0005CA n\u0013\tq\u0007GA\u0006LC\u001a\\\u0017mQ8oM&<\u0017aC2p]\u001aLwm]0%KF$\"!\u001d;\u0011\u0005\r\u0013\u0018BA:E\u0005\u0011)f.\u001b;\t\u000fUl\u0011\u0011!a\u0001A\u0006\u0019\u0001\u0010J\u0019\u0002\u0011\r|gNZ5hg\u0002\nQ\u0001^8qS\u000e,\u0012!\u001f\t\u0003uvl\u0011a\u001f\u0006\u0003yf\u000bA\u0001\\1oO&\u0011ap\u001f\u0002\u0007'R\u0014\u0018N\\4\u0002\rQ|\u0007/[2!\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0002\u0019A\f'\u000f^5uS>t\u0017\n\u001a\u0011\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]V\u0011\u0011\u0011\u0002\t\u0005\u0003\u0017\tY\"\u0004\u0002\u0002\u000e)!\u0011qBA\t\u0003\u0019\u0019w.\\7p]*\u00191'a\u0005\u000b\t\u0005U\u0011qC\u0001\u0007CB\f7\r[3\u000b\u0005\u0005e\u0011aA8sO&!\u0011QDA\u0007\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\u0002^8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eI\u0001\bg\u0016\u0014h/\u001a:2+\t\t)\u0003E\u0002@\u0003OI1!!\u000b1\u0005-Y\u0015MZ6b'\u0016\u0014h/\u001a:\u0002\u0017M,'O^3sc}#S-\u001d\u000b\u0004c\u0006=\u0002\u0002C;\u0017\u0003\u0003\u0005\r!!\n\u0002\u0011M,'O^3sc\u0001\nqa]3sm\u0016\u0014('A\u0006tKJ4XM\u001d\u001a`I\u0015\fHcA9\u0002:!AQ/GA\u0001\u0002\u0004\t)#\u0001\u0005tKJ4XM\u001d\u001a!\u00031\u0019wN\u001c4jOB\u0013x\u000e]:2+\u0005a\u0017\u0001D2p]\u001aLw\r\u0015:paN\u0014\u0014aB7fgN\fw-Z\u0001\t[\u0016\u001c8/Y4fA\u0005A\u0001O]8ek\u000e,'/\u0006\u0002\u0002LAA\u0011QJA+\u00033\ny&\u0004\u0002\u0002P)!\u0011qIA)\u0015\u0011\t\u0019&!\u0005\u0002\u000f\rd\u0017.\u001a8ug&!\u0011qKA(\u00055Y\u0015MZ6b!J|G-^2feB\u0019!0a\u0017\n\u0007\u0005u3PA\u0004J]R,w-\u001a:\u0011\t\u0005\u0005\u0014\u0011\u000e\b\u0005\u0003G\n)\u0007\u0005\u0002d\t&\u0019\u0011q\r#\u0002\rA\u0013X\rZ3g\u0013\rq\u00181\u000e\u0006\u0004\u0003O\"\u0015\u0001\u00049s_\u0012,8-\u001a:`I\u0015\fHcA9\u0002r!AQ\u000fIA\u0001\u0002\u0004\tY%A\u0005qe>$WoY3sA\u00059\u0001n\u001e$jY\u0016\fTCAA=!\u0011\tY(!!\u000e\u0005\u0005u$bAA@a\u0005Y1\r[3dWB|\u0017N\u001c;t\u0013\u0011\t\u0019)! \u0003)=3gm]3u\u0007\",7m\u001b9pS:$h)\u001b7f\u0003\u001dAwOR5mKJ\nqa]3sm\u0016\u00148/\u0006\u0002\u0002\fB1\u0011QRAJ\u0003Ki!!a$\u000b\u0007\u0005EE)\u0001\u0006d_2dWm\u0019;j_:L1A[AH\u0003-\u0019XM\u001d<feN|F%Z9\u0015\u0007E\fI\n\u0003\u0005vK\u0005\u0005\t\u0019AAF\u0003!\u0019XM\u001d<feN\u0004\u0013AD;qI\u0006$X\r\u0015:pIV\u001cWM\u001d\u000b\u0002c\u0006)1/\u001a;Va\"\u001a\u0001&!*\u0011\t\u0005\u001d\u0016QV\u0007\u0003\u0003SSA!a+\u0002\u0018\u0005)!.\u001e8ji&!\u0011qVAU\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002*\u0003k\u0003B!a*\u00028&!\u0011\u0011XAU\u0005\u0015\te\r^3s\u0003)\"Xm\u001d;I/\u000eCWmY6q_&tGOT8GC&dWO]3t'&tw\r\\3M_\u001e\u001cVmZ7f]RD3AKA`!\u0011\t9+!1\n\t\u0005\r\u0017\u0011\u0016\u0002\u0005)\u0016\u001cH/\u0001\u0017uKN$\bjV\"iK\u000e\\\u0007o\\5oi^KG\u000f\u001b$bS2,(/Z:TS:<G.\u001a'pON+w-\\3oi\"\u001a1&a0\u0002[Q,7\u000f\u001e%X\u0007\",7m\u001b9pS:$hj\u001c$bS2,(/Z:Nk2$\u0018\u000e\u001d7f\u0019><7+Z4nK:$8\u000fK\u0002-\u0003\u007f\u000bq\u0006^3ti\";6\t[3dWB|\u0017N\u001c;XSRDg)Y5mkJ,7/T;mi&\u0004H.\u001a'pON+w-\\3oiND3!LA`\u00031\u0019XM\u001c3NKN\u001c\u0018mZ3t)\r\t\u0018Q\u001b\u0005\u0007\u0003/t\u0003\u0019A'\u0002\u00039\u0004")
public class LogRecoveryTest
extends ZooKeeperTestHarness {
    private final long replicaLagTimeMaxMs;
    private final long replicaLagMaxMessages;
    private final int replicaFetchWaitMaxMs;
    private final int replicaFetchMinBytes;
    private final Properties overridingProps = new Properties();
    private Seq<KafkaConfig> configs;
    private final String topic;
    private final int partitionId;
    private final TopicPartition topicPartition;
    private KafkaServer server1;
    private KafkaServer server2;
    private final String message;
    private KafkaProducer<Integer, String> producer;
    private Seq<KafkaServer> servers;

    public long replicaLagTimeMaxMs() {
        return this.replicaLagTimeMaxMs;
    }

    public long replicaLagMaxMessages() {
        return this.replicaLagMaxMessages;
    }

    public int replicaFetchWaitMaxMs() {
        return this.replicaFetchWaitMaxMs;
    }

    public int replicaFetchMinBytes() {
        return this.replicaFetchMinBytes;
    }

    public Properties overridingProps() {
        return this.overridingProps;
    }

    public Seq<KafkaConfig> configs() {
        return this.configs;
    }

    public void configs_$eq(Seq<KafkaConfig> x$1) {
        this.configs = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public TopicPartition topicPartition() {
        return this.topicPartition;
    }

    public KafkaServer server1() {
        return this.server1;
    }

    public void server1_$eq(KafkaServer x$1) {
        this.server1 = x$1;
    }

    public KafkaServer server2() {
        return this.server2;
    }

    public void server2_$eq(KafkaServer x$1) {
        this.server2 = x$1;
    }

    public KafkaConfig configProps1() {
        return (KafkaConfig)this.configs().head();
    }

    public KafkaConfig configProps2() {
        return (KafkaConfig)this.configs().last();
    }

    public String message() {
        return this.message;
    }

    public KafkaProducer<Integer, String> producer() {
        return this.producer;
    }

    public void producer_$eq(KafkaProducer<Integer, String> x$1) {
        this.producer = x$1;
    }

    public OffsetCheckpointFile hwFile1() {
        return new OffsetCheckpointFile(new File((String)this.configProps1().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public OffsetCheckpointFile hwFile2() {
        return new OffsetCheckpointFile(new File((String)this.configProps2().logDirs().head(), ReplicaManager$.MODULE$.HighWatermarkFilename()), OffsetCheckpointFile$.MODULE$.$lessinit$greater$default$2());
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public void updateProducer() {
        if (this.producer() != null) {
            this.producer().close();
        }
        String x$1 = TestUtils$.MODULE$.getBrokerListStrFromServers(this.servers(), TestUtils$.MODULE$.getBrokerListStrFromServers$default$2());
        IntegerSerializer x$2 = new IntegerSerializer();
        StringSerializer x$3 = new StringSerializer();
        int x$4 = TestUtils$.MODULE$.createProducer$default$2();
        long x$5 = TestUtils$.MODULE$.createProducer$default$3();
        long x$6 = TestUtils$.MODULE$.createProducer$default$4();
        int x$7 = TestUtils$.MODULE$.createProducer$default$5();
        int x$8 = TestUtils$.MODULE$.createProducer$default$6();
        int x$9 = TestUtils$.MODULE$.createProducer$default$7();
        int x$10 = TestUtils$.MODULE$.createProducer$default$8();
        String x$11 = TestUtils$.MODULE$.createProducer$default$9();
        int x$12 = TestUtils$.MODULE$.createProducer$default$10();
        SecurityProtocol x$13 = TestUtils$.MODULE$.createProducer$default$11();
        Option<File> x$14 = TestUtils$.MODULE$.createProducer$default$12();
        Option<Properties> x$15 = TestUtils$.MODULE$.createProducer$default$13();
        this.producer_$eq(TestUtils$.MODULE$.createProducer(x$1, x$4, x$5, x$6, x$7, x$8, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$2, x$3));
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.configs_$eq((Seq<KafkaConfig>)((Seq)TestUtils$.MODULE$.createBrokerConfigs(2, this.zkConnect(), false, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14()).map((Function1 & Serializable & scala.Serializable)x$1 -> KafkaConfig$.MODULE$.fromProps(x$1, this.overridingProps()), Seq$.MODULE$.canBuildFrom())));
        this.server1_$eq(TestUtils$.MODULE$.createServer(this.configProps1(), TestUtils$.MODULE$.createServer$default$2()));
        this.server2_$eq(TestUtils$.MODULE$.createServer(this.configProps2(), TestUtils$.MODULE$.createServer$default$2()));
        this.servers_$eq((Seq<KafkaServer>)new .colon.colon((Object)this.server1(), (List)new .colon.colon((Object)this.server2(), (List)Nil$.MODULE$)));
        TestUtils$.MODULE$.createTopic(this.zkClient(), this.topic(), (Map<Object, Seq<Object>>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1})))}))), this.servers());
        this.updateProducer();
    }

    @Override
    @After
    public void tearDown() {
        this.producer().close();
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    @Test
    public void testHWCheckpointNoFailuresSingleLogSegment() {
        long numMessages = 2L;
        this.sendMessages((int)numMessages);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == numMessages, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            LogRecoveryTest.$anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(x$2);
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)numMessages, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)numMessages, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresSingleLogSegment() {
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertEquals((long)0L, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.sendMessages(1);
        Thread.sleep(1000L);
        LongRef hw = LongRef.create((long)1L);
        this.server1().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$32 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$5 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$32, x$5, (Option<Object>)x$4, x$6);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader);
        this.server1().startup();
        this.updateProducer();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        Assert.assertTrue((String)"Leader must remain on broker 1, in case of ZooKeeper session expiration it can move to broker 0", (leader == 0 || leader == 1 ? 1 : 0) != 0);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Partition)this.server2().replicaManager().getPartition(this.topicPartition()).get()).inSyncReplicas().size() == 2, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Server 1 is not able to join the ISR after restart", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$7 = this.zkClient();
        String x$8 = this.topic();
        int x$9 = this.partitionId();
        Some x$10 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$11 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$12 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$7, x$8, x$9, x$11, (Option<Object>)x$10, x$12);
        Assert.assertTrue((String)"Leader must remain on broker 0, in case of ZooKeeper session expiration it can move to broker 1", (leader == 0 || leader == 1 ? 1 : 0) != 0);
        this.sendMessages(1);
        ++hw.elem;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw$1.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            x$3.shutdown();
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    @Test
    public void testHWCheckpointNoFailuresMultipleLogSegments() {
        this.sendMessages(20);
        long hw = 20L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        long leaderHW = BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)hw, (long)leaderHW);
        long followerHW = BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L));
        Assert.assertEquals((long)hw, (long)followerHW);
    }

    @Test
    public void testHWCheckpointWithFailuresMultipleLogSegments() {
        int leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), this.partitionId(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5(), TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6());
        this.sendMessages(2);
        LongRef hw = LongRef.create((long)2L);
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server2().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw$3.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.server1().shutdown();
        this.server2().shutdown();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server2().startup();
        this.updateProducer();
        KafkaZkClient x$1 = this.zkClient();
        String x$2 = this.topic();
        int x$3 = this.partitionId();
        Some x$4 = new Some((Object)BoxesRunTime.boxToInteger((int)leader));
        long x$52 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$4();
        Option<Object> x$6 = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$6();
        leader = TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(x$1, x$2, x$3, x$52, (Option<Object>)x$4, x$6);
        Assert.assertEquals((String)"Leader must move to broker 1", (long)1L, (long)leader);
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.server1().startup();
        this.updateProducer();
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        this.sendMessages(2);
        hw.elem += 2L;
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> this.server1().replicaManager().localReplica(this.topicPartition()).nonEmpty(), (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to create replica in follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> ((Replica)this.server1().replicaManager().localReplica(this.topicPartition()).get()).highWatermark().messageOffset() == hw$3.elem, (Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Failed to update high watermark for follower after timeout", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4(), TestUtils$.MODULE$.waitUntilTrue$default$5());
        this.servers().foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile1().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
        Assert.assertEquals((long)hw.elem, (long)BoxesRunTime.unboxToLong((Object)this.hwFile2().read().getOrElse((Object)this.topicPartition(), (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
    }

    private void sendMessages(int n) {
        ((IterableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1 & Serializable & scala.Serializable)x$6 -> LogRecoveryTest.$anonfun$sendMessages$1(this, BoxesRunTime.unboxToInt((Object)x$6)), IndexedSeq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x$7 -> (RecordMetadata)x$7.get());
    }

    public static final /* synthetic */ void $anonfun$testHWCheckpointNoFailuresSingleLogSegment$3(KafkaServer x$2) {
        x$2.replicaManager().checkpointHighWatermarks();
    }

    public static final /* synthetic */ Future $anonfun$sendMessages$1(LogRecoveryTest $this, int x$6) {
        return $this.producer().send(new ProducerRecord($this.topic(), (Object)Predef$.MODULE$.int2Integer(0), (Object)$this.message()));
    }

    public LogRecoveryTest() {
        this.replicaLagTimeMaxMs = 5000L;
        this.replicaLagMaxMessages = 10L;
        this.replicaFetchWaitMaxMs = 1000;
        this.replicaFetchMinBytes = 20;
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), ((Object)BoxesRunTime.boxToLong((long)this.replicaLagTimeMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchWaitMaxMsProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchWaitMaxMs())).toString());
        this.overridingProps().put(KafkaConfig$.MODULE$.ReplicaFetchMinBytesProp(), ((Object)BoxesRunTime.boxToInteger((int)this.replicaFetchMinBytes())).toString());
        this.configs = null;
        this.topic = "new-topic";
        this.partitionId = 0;
        this.topicPartition = new TopicPartition(this.topic(), this.partitionId());
        this.server1 = null;
        this.server2 = null;
        this.message = "hello";
        this.producer = null;
        this.servers = (Seq)Seq$.MODULE$.empty();
    }
}

