/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.Partition;
import kafka.cluster.Replica;
import kafka.log.Log;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogManager;
import kafka.log.ProducerStateManager;
import kafka.server.BrokerTopicStats;
import kafka.server.DelayedOperationPurgatory;
import kafka.server.DelayedOperationPurgatory$;
import kafka.server.FetchPartitionData;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.LogDirFailureChannel;
import kafka.server.LogOffsetMetadata;
import kafka.server.LogOffsetMetadata$;
import kafka.server.MetadataCache;
import kafka.server.OffsetAndEpoch;
import kafka.server.QuotaFactory;
import kafka.server.QuotaFactory$;
import kafka.server.ReplicaFetcherManager;
import kafka.server.ReplicaFetcherThread;
import kafka.server.ReplicaManager;
import kafka.server.ReplicaManager$;
import kafka.server.ReplicaManagerTest$;
import kafka.server.ReplicaManagerTest$$anon$2$;
import kafka.server.ReplicaQuota;
import kafka.server.ReplicationQuotaManager;
import kafka.server.epoch.util.ReplicaFetcherMockBlockingSend;
import kafka.utils.MockScheduler;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.timer.MockTimer;
import kafka.utils.timer.Timer;
import kafka.zk.KafkaZkClient;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.ControlRecordType;
import org.apache.kafka.common.record.EndTransactionMarker;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.SimpleRecord;
import org.apache.kafka.common.requests.EpochEndOffset;
import org.apache.kafka.common.requests.FetchRequest;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.requests.IsolationLevel;
import org.apache.kafka.common.requests.LeaderAndIsrRequest;
import org.apache.kafka.common.requests.ProduceResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.zookeeper.data.Stat;
import org.easymock.EasyMock;
import org.easymock.IExpectationSetters;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\r\u0015d\u0001B\u001f?\u0001\rCQA\u0013\u0001\u0005\u0002-CqA\u0014\u0001C\u0002\u0013\u0005q\n\u0003\u0004Y\u0001\u0001\u0006I\u0001\u0015\u0005\b3\u0002\u0011\r\u0011\"\u0001[\u0011\u0019\t\u0007\u0001)A\u00057\"9!\r\u0001b\u0001\n\u0003\u0019\u0007B\u00029\u0001A\u0003%A\rC\u0005r\u0001\u0001\u0007\t\u0019!C\u0001e\"I1\u0010\u0001a\u0001\u0002\u0004%\t\u0001 \u0005\u000b\u0003\u000b\u0001\u0001\u0019!A!B\u0013\u0019\bbCA\u0004\u0001\u0001\u0007\t\u0019!C\u0001\u0003\u0013A1\"a\u0006\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002\u001a!Y\u0011Q\u0004\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0006\u0011%\ty\u0002\u0001b\u0001\n\u0003\t\t\u0003\u0003\u0005\u0002*\u0001\u0001\u000b\u0011BA\u0012\u0011%\tY\u0003\u0001b\u0001\n\u0003\t\t\u0003\u0003\u0005\u0002.\u0001\u0001\u000b\u0011BA\u0012\u0011%\ty\u0003\u0001a\u0001\n\u0003\t\t\u0003C\u0005\u00022\u0001\u0001\r\u0011\"\u0001\u00024!A\u0011q\u0007\u0001!B\u0013\t\u0019\u0003C\u0005\u0002:\u0001\u0011\r\u0011\"\u0001\u0002<!A\u00111\t\u0001!\u0002\u0013\ti\u0004C\u0004\u0002F\u0001!\t!a\u0012\t\u000f\u0005]\u0003\u0001\"\u0001\u0002H!9\u0011\u0011\r\u0001\u0005\u0002\u0005\u001d\u0003bBA6\u0001\u0011\u0005\u0011q\t\u0005\b\u0003_\u0002A\u0011AA$\u0011\u001d\t\u0019\b\u0001C\u0001\u0003\u000fBq!a\u001e\u0001\t\u0003\t9\u0005C\u0004\u0002|\u0001!\t!a\u0012\t\u000f\u0005}\u0004\u0001\"\u0001\u0002H!9\u00111\u0011\u0001\u0005\u0002\u0005\u001d\u0003bBAD\u0001\u0011\u0005\u0011q\t\u0005\b\u0003\u0017\u0003A\u0011AA$\u0011\u001d\ty\t\u0001C\u0005\u0003#Cq!!7\u0001\t\u0013\tYN\u0002\u0004\u0003\u001a\u0001!!1\u0004\u0005\u0007\u0015\u0016\"\tAa\b\t\u0013\tmR\u00051A\u0005\n\tu\u0002\"\u0003B#K\u0001\u0007I\u0011\u0002B$\u0011!\u0011Y%\nQ!\n\t}\u0002\"\u0003B'K\u0001\u0007I\u0011\u0002B(\u0011%\u0011I&\na\u0001\n\u0013\u0011Y\u0006\u0003\u0005\u0003`\u0015\u0002\u000b\u0015\u0002B)\u0011\u001d\u0011\t'\nC\u0001\u0005GBqA!\u001a&\t\u0003\u00119\u0007C\u0004\u0003j\u0015\"\tAa\u001b\t\u000f\t=T\u0005\"\u0001\u0003r!9!Q\u000f\u0001\u0005\n\t]\u0004\"\u0003Bf\u0001E\u0005I\u0011\u0002Bg\u0011%\u0011\u0019\u000fAI\u0001\n\u0013\u0011)\u000fC\u0004\u0003j\u0002!IAa;\t\u0013\re\u0001!%A\u0005\n\rm\u0001\"CB\u0010\u0001E\u0005I\u0011BB\u0011\u0011\u001d\u0019)\u0003\u0001C\u0005\u0007OA\u0011ba\r\u0001#\u0003%Iaa\u0007\t\u0013\rU\u0002!%A\u0005\n\r\u0005\u0002bBB\u001c\u0001\u0011%1\u0011\b\u0005\b\u0007\u0013\u0002A\u0011BB&\u0011%\u0019y\u0006AI\u0001\n\u0013\u0019\tG\u0001\nSKBd\u0017nY1NC:\fw-\u001a:UKN$(BA A\u0003\u0019\u0019XM\u001d<fe*\t\u0011)A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001!\u0005CA#I\u001b\u00051%\"A$\u0002\u000bM\u001c\u0017\r\\1\n\u0005%3%AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002\u0019B\u0011Q\nA\u0007\u0002}\u0005)Ao\u001c9jGV\t\u0001\u000b\u0005\u0002R-6\t!K\u0003\u0002T)\u0006!A.\u00198h\u0015\u0005)\u0016\u0001\u00026bm\u0006L!a\u0016*\u0003\rM#(/\u001b8h\u0003\u0019!x\u000e]5dA\u0005!A/[7f+\u0005Y\u0006C\u0001/`\u001b\u0005i&B\u00010A\u0003\u0015)H/\u001b7t\u0013\t\u0001WL\u0001\u0005N_\u000e\\G+[7f\u0003\u0015!\u0018.\\3!\u0003\u001diW\r\u001e:jGN,\u0012\u0001\u001a\t\u0003K:l\u0011A\u001a\u0006\u0003E\u001eT!\u0001[5\u0002\r\r|W.\\8o\u0015\t\t%N\u0003\u0002lY\u00061\u0011\r]1dQ\u0016T\u0011!\\\u0001\u0004_J<\u0017BA8g\u0005\u001diU\r\u001e:jGN\f\u0001\"\\3ue&\u001c7\u000fI\u0001\tu.\u001cE.[3oiV\t1\u000f\u0005\u0002us6\tQO\u0003\u0002wo\u0006A!p[2mS\u0016tGO\u0003\u0002yY\u00061\u0011\nM%uK\u000eL!A_;\u0003\u0011i[7\t\\5f]R\fAB_6DY&,g\u000e^0%KF$2!`A\u0001!\t)e0\u0003\u0002\u0000\r\n!QK\\5u\u0011!\t\u0019!CA\u0001\u0002\u0004\u0019\u0018a\u0001=%c\u0005I!p[\"mS\u0016tG\u000fI\u0001\u000eW\u000647.\u0019.l\u00072LWM\u001c;\u0016\u0005\u0005-\u0001\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001)\u0001\u0002{W&!\u0011QCA\b\u00055Y\u0015MZ6b5.\u001cE.[3oi\u0006\t2.\u00194lCj[7\t\\5f]R|F%Z9\u0015\u0007u\fY\u0002C\u0005\u0002\u00041\t\t\u00111\u0001\u0002\f\u0005q1.\u00194lCj[7\t\\5f]R\u0004\u0013!\u0003>l-\u0016\u00148/[8o+\t\t\u0019\u0003E\u0002F\u0003KI1!a\nG\u0005\rIe\u000e^\u0001\u000bu.4VM]:j_:\u0004\u0013!D2peJ,G.\u0019;j_:LE-\u0001\bd_J\u0014X\r\\1uS>t\u0017\n\u001a\u0011\u0002\u001f\r|g\u000e\u001e:pY2,'/\u00129pG\"\f1cY8oiJ|G\u000e\\3s\u000bB|7\r[0%KF$2!`A\u001b\u0011%\t\u0019aEA\u0001\u0002\u0004\t\u0019#\u0001\td_:$(o\u001c7mKJ,\u0005o\\2iA\u0005Y!M]8lKJ,\u0005o\\2i+\t\ti\u0004E\u0002F\u0003\u007fI1!!\u0011G\u0005\u0011auN\\4\u0002\u0019\t\u0014xn[3s\u000bB|7\r\u001b\u0011\u0002\u000bM,G/\u00169\u0015\u0003uD3aFA&!\u0011\ti%a\u0015\u000e\u0005\u0005=#bAA)Y\u0006)!.\u001e8ji&!\u0011QKA(\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000eK\u0002\u0019\u00037\u0002B!!\u0014\u0002^%!\u0011qLA(\u0005\u0015\te\r^3s\u0003\u0005\"Xm\u001d;IS\u001eDw+\u0019;fe6\u000b'o\u001b#je\u0016\u001cGo\u001c:z\u001b\u0006\u0004\b/\u001b8hQ\rI\u0012Q\r\t\u0005\u0003\u001b\n9'\u0003\u0003\u0002j\u0005=#\u0001\u0002+fgR\f\u0011\u0006^3ti\"Kw\r[<bi\u0016\u0014X*\u0019:l%\u0016d\u0017\r^5wK\u0012K'/Z2u_JLX*\u00199qS:<\u0007f\u0001\u000e\u0002f\u00059B/Z:u\u00132dWmZ1m%\u0016\fX/\u001b:fI\u0006\u001b7n\u001d\u0015\u00047\u0005\u0015\u0014\u0001\n;fgR\u001cE.Z1s!V\u0014x-\u0019;pef|eNQ3d_6Lgn\u001a$pY2|w/\u001a:)\u0007q\t)'\u0001\u001duKN$(+Z2fSZ,w*\u001e;PM>\u0013H-\u001a:TKF,XM\\2f\u000bb\u001cW\r\u001d;j_:<\u0016\u000e\u001e5M_\u001e\u001cF/\u0019:u\u001f\u001a47/\u001a;)\u0007u\t)'\u0001\u0012uKN$(+Z1e\u0007>lW.\u001b;uK\u00124U\r^2i\u0019&l\u0017\u000e^3e\u0003Rd5k\u0014\u0015\u0004=\u0005\u0015\u0014a\u000b;fgR$U\r\\1zK\u00124U\r^2i\u0013:\u001cG.\u001e3fg\u0006\u0013wN\u001d;fIR\u0013\u0018M\\:bGRLwN\\:)\u0007}\t)'A\u0018uKN$h)\u001a;dQ\n+\u0017p\u001c8e\u0011&<\u0007nV1uKJl\u0017M]6SKR,(O\\#naRL(+Z:q_:\u001cX\rK\u0002!\u0003K\nq\u0006^3ti\u001a+Go\u00195NKN\u001c\u0018mZ3t/\",gNT8u\r>dGn\\<fe\u001a{'o\u00148f!\u0006\u0014H/\u001b;j_:D3!IA3\u0003q\"Xm\u001d;CK\u000e|W.\u001a$pY2|w/\u001a:XQ\u0016tG*Z1eKJL5/\u00168dQ\u0006tw-\u001a3CkRl\u0015n]:fI2+\u0017\rZ3s+B$\u0017\r^3)\u0007\t\n)'\u0001\u0012qe\u0016\u0004\u0018M]3SKBd\u0017nY1NC:\fw-\u001a:B]\u0012dunZ'b]\u0006<WM\u001d\u000b\u000f\u0003'\u000bY+a,\u00024\u0006]\u00161XAh!\u001d)\u0015QSAM\u0003?K1!a&G\u0005\u0019!V\u000f\u001d7feA\u0019Q*a'\n\u0007\u0005ueH\u0001\bSKBd\u0017nY1NC:\fw-\u001a:\u0011\t\u0005\u0005\u0016qU\u0007\u0003\u0003GS1!!*A\u0003\rawnZ\u0005\u0005\u0003S\u000b\u0019K\u0001\u0006M_\u001el\u0015M\\1hKJDq!!,$\u0001\u0004\t\u0019#\u0001\bu_BL7\rU1si&$\u0018n\u001c8\t\u000f\u0005E6\u00051\u0001\u0002$\u0005IB.Z1eKJ,\u0005o\\2i\u0013:dU-\u00193fe\u0006sG-S:s\u0011\u001d\t)l\ta\u0001\u0003G\t\u0001CZ8mY><XM\u001d\"s_.,'/\u00133\t\u000f\u0005e6\u00051\u0001\u0002$\u0005qA.Z1eKJ\u0014%o\\6fe&#\u0007bBA_G\u0001\u0007\u0011qX\u0001\u000fG>,h\u000e\u001e#po:d\u0015\r^2i!\u0011\t\t-a3\u000e\u0005\u0005\r'\u0002BAc\u0003\u000f\f!bY8oGV\u0014(/\u001a8u\u0015\r\tI\rV\u0001\u0005kRLG.\u0003\u0003\u0002N\u0006\r'AD\"pk:$Hi\\<o\u0019\u0006$8\r\u001b\u0005\b\u0003#\u001c\u0003\u0019AAj\u0003A)\u0007\u0010]3diR\u0013XO\\2bi&|g\u000eE\u0002F\u0003+L1!a6G\u0005\u001d\u0011un\u001c7fC:\f!\u0004\\3bI\u0016\u0014\u0018I\u001c3JgJ\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016$\u0002\"!8\u0002r\u0006U\u0018q\u001f\t\u0005\u0003?\fYO\u0004\u0003\u0002b\u0006\u001dXBAAr\u0015\r\t)oZ\u0001\te\u0016\fX/Z:ug&!\u0011\u0011^Ar\u0003MaU-\u00193fe\u0006sG-S:s%\u0016\fX/Z:u\u0013\u0011\ti/a<\u0003\u001dA\u000b'\u000f^5uS>t7\u000b^1uK*!\u0011\u0011^Ar\u0011\u001d\t\u0019\u0010\na\u0001\u0003G\t1\u0002\\3bI\u0016\u0014X\t]8dQ\"9\u0011\u0011\u0018\u0013A\u0002\u0005\r\u0002bBA}I\u0001\u0007\u00111`\u0001\u000fC2Lg/\u001a\"s_.,'/\u00133t!\u0019\tiP!\u0004\u0003\u00149!\u0011q B\u0005\u001d\u0011\u0011\tAa\u0002\u000e\u0005\t\r!b\u0001B\u0003\u0005\u00061AH]8pizJ\u0011aR\u0005\u0004\u0005\u00171\u0015a\u00029bG.\fw-Z\u0005\u0005\u0005\u001f\u0011\tBA\u0002TKFT1Aa\u0003G!\r\t&QC\u0005\u0004\u0005/\u0011&aB%oi\u0016<WM\u001d\u0002\u000f\u0007\u0006dGNY1dWJ+7/\u001e7u+\u0011\u0011iB!\u000b\u0014\u0005\u0015\"EC\u0001B\u0011!\u0015\u0011\u0019#\nB\u0013\u001b\u0005\u0001\u0001\u0003\u0002B\u0014\u0005Sa\u0001\u0001B\u0004\u0003,\u0015\u0012\rA!\f\u0003\u0003Q\u000bBAa\f\u00036A\u0019QI!\r\n\u0007\tMbIA\u0004O_RD\u0017N\\4\u0011\u0007\u0015\u00139$C\u0002\u0003:\u0019\u00131!\u00118z\u0003\u00151\u0018\r\\;f+\t\u0011y\u0004E\u0003F\u0005\u0003\u0012)#C\u0002\u0003D\u0019\u0013aa\u00149uS>t\u0017!\u0003<bYV,w\fJ3r)\ri(\u0011\n\u0005\n\u0003\u0007A\u0013\u0011!a\u0001\u0005\u007f\taA^1mk\u0016\u0004\u0013a\u00014v]V\u0011!\u0011\u000b\t\u0006\u000b\n\u0005#1\u000b\t\u0007\u000b\nU#QE?\n\u0007\t]cIA\u0005Gk:\u001cG/[8oc\u00059a-\u001e8`I\u0015\fHcA?\u0003^!I\u00111A\u0016\u0002\u0002\u0003\u0007!\u0011K\u0001\u0005MVt\u0007%A\u0006bgN,'\u000f\u001e$je\u0016$WC\u0001B\u0013\u0003\u001dI7OR5sK\u0012,\"!a5\u0002\t\u0019L'/\u001a\u000b\u0004{\n5\u0004b\u0002B\u001e_\u0001\u0007!QE\u0001\u0007_:4\u0015N]3\u0015\t\t\u0005\"1\u000f\u0005\b\u0005\u001b\u0002\u0004\u0019\u0001B*\u00035\t\u0007\u000f]3oIJ+7m\u001c:egRa!\u0011\u0010BO\u0005C\u0013iK!0\u0003BB)!1E\u0013\u0003|A!!Q\u0010BL\u001d\u0011\u0011yHa%\u000f\t\t\u0005%\u0011\u0013\b\u0005\u0005\u0007\u0013yI\u0004\u0003\u0003\u0006\n5e\u0002\u0002BD\u0005\u0017sAA!\u0001\u0003\n&\tQ.\u0003\u0002lY&\u0011\u0011I[\u0005\u0003Q&L1!!:h\u0013\u0011\u0011)*a9\u0002\u001fA\u0013x\u000eZ;dKJ+7\u000f]8og\u0016LAA!'\u0003\u001c\n\t\u0002+\u0019:uSRLwN\u001c*fgB|gn]3\u000b\t\tU\u00151\u001d\u0005\b\u0005?\u000b\u0004\u0019AAM\u00039\u0011X\r\u001d7jG\u0006l\u0015M\\1hKJDqAa)2\u0001\u0004\u0011)+A\u0005qCJ$\u0018\u000e^5p]B!!q\u0015BU\u001b\u00059\u0017b\u0001BVO\nqAk\u001c9jGB\u000b'\u000f^5uS>t\u0007b\u0002BXc\u0001\u0007!\u0011W\u0001\be\u0016\u001cwN\u001d3t!\u0011\u0011\u0019L!/\u000e\u0005\tU&b\u0001B\\O\u00061!/Z2pe\u0012LAAa/\u00036\niQ*Z7pef\u0014VmY8sIND\u0011Ba02!\u0003\u0005\r!a5\u0002\u0019%\u001chI]8n\u00072LWM\u001c;\t\u0013\t\r\u0017\u0007%AA\u0002\t\u0015\u0017\u0001\u0004:fcVL'/\u001a3BG.\u001c\bcA#\u0003H&\u0019!\u0011\u001a$\u0003\u000bMCwN\u001d;\u0002/\u0005\u0004\b/\u001a8e%\u0016\u001cwN\u001d3tI\u0011,g-Y;mi\u0012\"TC\u0001BhU\u0011\t\u0019N!5,\u0005\tM\u0007\u0003\u0002Bk\u0005?l!Aa6\u000b\t\te'1\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1A!8G\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005C\u00149NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq#\u00199qK:$'+Z2pe\u0012\u001cH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\u001d(\u0006\u0002Bc\u0005#\fqBZ3uG\"\f5oQ8ogVlWM\u001d\u000b\r\u0005[\u0014)Pa>\u0003z\u000e-1q\u0002\t\u0006\u0005G)#q\u001e\t\u0004\u001b\nE\u0018b\u0001Bz}\t\u0011b)\u001a;dQB\u000b'\u000f^5uS>tG)\u0019;b\u0011\u001d\u0011y\n\u000ea\u0001\u00033CqAa)5\u0001\u0004\u0011)\u000bC\u0004\u0003|R\u0002\rA!@\u0002\u001bA\f'\u000f^5uS>tG)\u0019;b!\u0011\u0011yp!\u0002\u000f\t\t}4\u0011A\u0005\u0005\u0007\u0007\t\u0019/\u0001\u0007GKR\u001c\u0007NU3rk\u0016\u001cH/\u0003\u0003\u0004\b\r%!!\u0004)beRLG/[8o\t\u0006$\u0018M\u0003\u0003\u0004\u0004\u0005\r\b\"CB\u0007iA\u0005\t\u0019AA\u0012\u0003!i\u0017N\u001c\"zi\u0016\u001c\b\"CB\tiA\u0005\t\u0019AB\n\u00039I7o\u001c7bi&|g\u000eT3wK2\u0004B!!9\u0004\u0016%!1qCAr\u00059I5o\u001c7bi&|g\u000eT3wK2\f\u0011DZ3uG\"\f5oQ8ogVlWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u00111Q\u0004\u0016\u0005\u0003G\u0011\t.A\rgKR\u001c\u0007.Q:D_:\u001cX/\\3sI\u0011,g-Y;mi\u0012*TCAB\u0012U\u0011\u0019\u0019B!5\u0002\u001f\u0019,Go\u00195Bg\u001a{G\u000e\\8xKJ$BB!<\u0004*\r-2QFB\u0018\u0007cAqAa(8\u0001\u0004\tI\nC\u0004\u0003$^\u0002\rA!*\t\u000f\tmx\u00071\u0001\u0003~\"I1QB\u001c\u0011\u0002\u0003\u0007\u00111\u0005\u0005\n\u0007#9\u0004\u0013!a\u0001\u0007'\t\u0011DZ3uG\"\f5OR8mY><XM\u001d\u0013eK\u001a\fW\u000f\u001c;%i\u0005Ib-\u001a;dQ\u0006\u001bhi\u001c7m_^,'\u000f\n3fM\u0006,H\u000e\u001e\u00136\u000351W\r^2i\u001b\u0016\u001c8/Y4fgRq!Q^B\u001e\u0007{\u0019\tea\u0011\u0004F\r\u001d\u0003b\u0002BPu\u0001\u0007\u0011\u0011\u0014\u0005\b\u0007\u007fQ\u0004\u0019AA\u0012\u0003%\u0011X\r\u001d7jG\u0006LE\rC\u0004\u0003$j\u0002\rA!*\t\u000f\tm(\b1\u0001\u0003~\"91Q\u0002\u001eA\u0002\u0005\r\u0002bBB\tu\u0001\u000711C\u0001)g\u0016$X\u000f\u001d*fa2L7-Y'b]\u0006<WM],ji\"lunY6fIB+(oZ1u_JLWm\u001d\u000b\u0007\u00033\u001biea\u0017\t\u000f\r=3\b1\u0001\u0004R\u0005)A/[7feB!11KB,\u001b\t\u0019)FC\u0002\u0004PuKAa!\u0017\u0004V\tIQj\\2l)&lWM\u001d\u0005\n\u0003s\\\u0004\u0013!a\u0001\u0007;\u0002b!!@\u0003\u000e\u0005\r\u0012AM:fiV\u0004(+\u001a9mS\u000e\fW*\u00198bO\u0016\u0014x+\u001b;i\u001b>\u001c7.\u001a3QkJ<\u0017\r^8sS\u0016\u001cH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\r\r$\u0006BB/\u0005#\u0004")
public class ReplicaManagerTest {
    private final String topic;
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics();
    private ZkClient zkClient;
    private KafkaZkClient kafkaZkClient;
    private final int zkVersion;
    private final int correlationId;
    private int controllerEpoch = 0;
    private final long brokerEpoch;

    public String topic() {
        return this.topic;
    }

    public MockTime time() {
        return this.time;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public ZkClient zkClient() {
        return this.zkClient;
    }

    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    public KafkaZkClient kafkaZkClient() {
        return this.kafkaZkClient;
    }

    public void kafkaZkClient_$eq(KafkaZkClient x$1) {
        this.kafkaZkClient = x$1;
    }

    public int zkVersion() {
        return this.zkVersion;
    }

    public int correlationId() {
        return this.correlationId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public void controllerEpoch_$eq(int x$1) {
        this.controllerEpoch = x$1;
    }

    public long brokerEpoch() {
        return this.brokerEpoch;
    }

    @Before
    public void setUp() {
        this.zkClient_$eq((ZkClient)EasyMock.createMock(ZkClient.class));
        this.kafkaZkClient_$eq((KafkaZkClient)EasyMock.createMock(KafkaZkClient.class));
        EasyMock.expect((Object)this.kafkaZkClient().getEntityConfigs(EasyMock.anyString(), EasyMock.anyString())).andReturn((Object)new Properties()).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.kafkaZkClient()});
        EasyMock.expect((Object)this.zkClient().readData(EasyMock.anyString(), (Stat)EasyMock.anyObject())).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.zkClient()});
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void testHighWaterMarkDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$1 -> new File((String)x$1), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testHighwaterMarkRelativeDirectoryMapping() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$2 -> new File((String)x$2), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 1));
            partition.getOrCreateReplica(1, partition.getOrCreateReplica$default$2());
            rm.checkpointHighWatermarks();
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testIllegalRequiredAcks() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(1, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$3 -> new File((String)x$3), Seq$.MODULE$.canBuildFrom())), TestUtils$.MODULE$.createLogManager$default$2(), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), new MetadataCache(config.brokerId()), new LogDirFailureChannel(config.logDirs().size()), Option$.MODULE$.apply((Object)this.getClass().getName()));
        try {
            rm.appendRecords(0L, (short)3, false, true, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition("test1", 0)), (Object)MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())}))})), (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.callback$1(responseStatus);
                return BoxedUnit.UNIT;
            }, rm.appendRecords$default$7(), rm.appendRecords$default$8());
        }
        finally {
            rm.shutdown(false);
        }
        TestUtils$.MODULE$.verifyNonDaemonThreadsStatus(this.getClass().getName());
    }

    @Test
    public void testClearPurgatoryOnBecomingFollower() {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$4 -> new File((String)x$4), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{TestUtils$.MODULE$.createBroker(0, "host0", 0, TestUtils$.MODULE$.createBroker$default$4()), TestUtils$.MODULE$.createBroker(1, "host1", 1, TestUtils$.MODULE$.createBroker$default$4())}));
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        EasyMock.replay((Object[])new Object[]{metadataCache});
        ReplicaManager rm = new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), ReplicaManager$.MODULE$.$lessinit$greater$default$12());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$5, x$6) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$2(x$5, x$6);
                return BoxedUnit.UNIT;
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            MemoryRecords records = MemoryRecords.withRecords((CompressionType)CompressionType.NONE, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord("first message".getBytes())});
            CallbackResult<ProduceResponse.PartitionResponse> appendResult = this.appendRecords(rm, new TopicPartition(this.topic(), 0), records, this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$3(response);
                return BoxedUnit.UNIT;
            });
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty()), 100000, this.fetchAsConsumer$default$5());
            Assert.assertFalse((boolean)fetchResult.isFired());
            LeaderAndIsrRequest leaderAndIsrRequest2 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 1, 1, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            rm.becomeLeaderOrFollower(1, leaderAndIsrRequest2, (Function2 & Serializable & scala.Serializable)(x$7, x$8) -> {
                ReplicaManagerTest.$anonfun$testClearPurgatoryOnBecomingFollower$4(x$7, x$8);
                return BoxedUnit.UNIT;
            });
            Assert.assertTrue((boolean)appendResult.isFired());
            Assert.assertTrue((boolean)fetchResult.isFired());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testReceiveOutOfOrderSequenceExceptionWithLogStartOffset() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$9, x$10) -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(x$9, x$10);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(this, producerId, epoch, replicaManager, BoxesRunTime.unboxToInt((Object)sequence)));
            Assert.assertEquals((long)0L, (long)partition.logStartOffset());
            int outOfRangeSequence = numRecords + 10;
            MemoryRecords record = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId, (short)epoch, (int)outOfRangeSequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(9).append("message: ").append(outOfRangeSequence).toString().getBytes())});
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), record, this.appendRecords$default$4(), this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(response);
                return BoxedUnit.UNIT;
            });
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testReadCommittedFetchLimitedAtLSO() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$11, x$12) -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$1(x$11, x$12);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$2(this, producerId, epoch, replicaManager, BoxesRunTime.unboxToInt((Object)sequence)));
            ReplicaManager x$1 = replicaManager;
            TopicPartition x$2 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData((long)numRecords, 0L, 100000, Optional.empty());
            IsolationLevel x$4 = IsolationLevel.READ_UNCOMMITTED;
            int x$5 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$1, x$2, x$3, x$5, x$4);
            ReplicaManager x$6 = replicaManager;
            TopicPartition x$7 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$8 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$9 = IsolationLevel.READ_COMMITTED;
            int x$10 = this.fetchAsConsumer$default$4();
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(x$6, x$7, x$8, x$10, x$9);
            FetchPartitionData fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            ReplicaManager x$112 = replicaManager;
            TopicPartition x$122 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$13 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$14 = IsolationLevel.READ_COMMITTED;
            int x$15 = 1000;
            consumerFetchResult = this.fetchAsConsumer(x$112, x$122, x$13, x$15, x$14);
            Assert.assertFalse((boolean)consumerFetchResult.isFired());
            timer.advanceClock(1001L);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.COMMIT, 0);
            MemoryRecords commitRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), commitRecordBatch, false, this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$16 = replicaManager;
            TopicPartition x$17 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$18 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$19 = IsolationLevel.READ_COMMITTED;
            int x$20 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$16, x$17, x$18, x$20, x$19);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertTrue((boolean)((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).isEmpty());
            ReplicaManager x$21 = replicaManager;
            TopicPartition x$22 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$23 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$24 = IsolationLevel.READ_UNCOMMITTED;
            int x$25 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$21, x$22, x$23, x$25, x$24);
            ReplicaManager x$26 = replicaManager;
            TopicPartition x$27 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$28 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$29 = IsolationLevel.READ_COMMITTED;
            int x$30 = this.fetchAsConsumer$default$4();
            consumerFetchResult = this.fetchAsConsumer(x$26, x$27, x$28, x$30, x$29);
            fetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((Object)new Some((Object)List$.MODULE$.empty()), (Object)fetchData.abortedTransactions());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().batches()).asScala()).size());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testDelayedFetchIncludesAbortedTransactions() {
        MockTimer timer = new MockTimer();
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(timer, this.setupReplicaManagerWithMockedPurgatories$default$2());
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            Partition partition = replicaManager.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$13, x$14) -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$1(x$13, x$14);
                return BoxedUnit.UNIT;
            });
            replicaManager.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            long producerId = 234L;
            short epoch = (short)5;
            int numRecords = 3;
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRecords).foreach((Function1 & Serializable & scala.Serializable)sequence -> ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$2(this, producerId, epoch, replicaManager, BoxesRunTime.unboxToInt((Object)sequence)));
            EndTransactionMarker endTxnMarker = new EndTransactionMarker(ControlRecordType.ABORT, 0);
            MemoryRecords abortRecordBatch = MemoryRecords.withEndTransactionMarker((long)producerId, (short)epoch, (EndTransactionMarker)endTxnMarker);
            this.appendRecords(replicaManager, new TopicPartition(this.topic(), 0), abortRecordBatch, false, this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
                ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$4(response);
                return BoxedUnit.UNIT;
            });
            ReplicaManager x$1 = replicaManager;
            TopicPartition x$2 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$3 = new FetchRequest.PartitionData((long)(numRecords + 1), 0L, 100000, Optional.empty());
            IsolationLevel x$4 = IsolationLevel.READ_UNCOMMITTED;
            int x$5 = this.fetchAsFollower$default$4();
            this.fetchAsFollower(x$1, x$2, x$3, x$5, x$4);
            ReplicaManager x$6 = replicaManager;
            TopicPartition x$7 = new TopicPartition(this.topic(), 0);
            FetchRequest.PartitionData x$8 = new FetchRequest.PartitionData(0L, 0L, 100000, Optional.empty());
            IsolationLevel x$9 = IsolationLevel.READ_COMMITTED;
            int x$10 = 10000;
            CallbackResult<FetchPartitionData> fetchResult = this.fetchAsConsumer(x$6, x$7, x$8, x$10, x$9);
            Assert.assertFalse((boolean)fetchResult.isFired());
            timer.advanceClock(1001L);
            FetchPartitionData fetchData = fetchResult.assertFired();
            Assert.assertEquals((Object)Errors.NONE, (Object)fetchData.error());
            Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)(numRecords + 1))), (Object)fetchData.lastStableOffset());
            Assert.assertEquals((long)(numRecords + 1), (long)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fetchData.records().records()).asScala()).size());
            Assert.assertTrue((boolean)fetchData.abortedTransactions().isDefined());
            Assert.assertEquals((long)1L, (long)((SeqLike)fetchData.abortedTransactions().get()).size());
            FetchResponse.AbortedTransaction abortedTransaction = (FetchResponse.AbortedTransaction)((IterableLike)fetchData.abortedTransactions().get()).head();
            Assert.assertEquals((long)0L, (long)abortedTransaction.firstOffset);
            Assert.assertEquals((long)producerId, (long)abortedTransaction.producerId);
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testFetchBeyondHighWatermarkReturnEmptyResponse() {
        ReplicaManager rm = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            List brokerList = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1), Predef$.MODULE$.int2Integer(2)}))).asJava();
            Partition partition = rm.getOrCreatePartition(new TopicPartition(this.topic(), 0));
            partition.getOrCreateReplica(0, partition.getOrCreateReplica$default$2());
            LeaderAndIsrRequest leaderAndIsrRequest1 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), 0)), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, brokerList, 0, brokerList, false))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1), new Node(2, "host2", 2)}))).asJava()).build();
            rm.becomeLeaderOrFollower(0, leaderAndIsrRequest1, (Function2 & Serializable & scala.Serializable)(x$15, x$16) -> {
                ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(x$15, x$16);
                return BoxedUnit.UNIT;
            });
            rm.getPartitionOrException(new TopicPartition(this.topic(), 0), true).localReplicaOrException();
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(this, rm, BoxesRunTime.unboxToInt((Object)i)));
            CallbackResult<FetchPartitionData> followerFetchResult = this.fetchAsFollower(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsFollower$default$4(), this.fetchAsFollower$default$5());
            FetchPartitionData followerFetchData = followerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)followerFetchData.error());
            Assert.assertTrue((String)"Should return some data", (boolean)followerFetchData.records().batches().iterator().hasNext());
            CallbackResult<FetchPartitionData> consumerFetchResult = this.fetchAsConsumer(rm, new TopicPartition(this.topic(), 0), new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()), this.fetchAsConsumer$default$4(), this.fetchAsConsumer$default$5());
            FetchPartitionData consumerFetchData = consumerFetchResult.assertFired();
            Assert.assertEquals((String)"Should not give an exception", (Object)Errors.NONE, (Object)consumerFetchData.error());
            Assert.assertEquals((String)"Should return empty response", (Object)MemoryRecords.EMPTY, (Object)consumerFetchData.records());
        }
        finally {
            rm.shutdown(false);
        }
    }

    @Test
    public void testFetchMessagesWhenNotFollowerForOnePartition() {
        ReplicaManager replicaManager = this.setupReplicaManagerWithMockedPurgatories(new MockTimer(), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 2}))));
        try {
            TopicPartition tp0 = new TopicPartition(this.topic(), 0);
            TopicPartition tp1 = new TopicPartition(this.topic(), 1);
            Partition qual$1 = replicaManager.getOrCreatePartition(tp0);
            int x$1 = 0;
            boolean x$2 = qual$1.getOrCreateReplica$default$2();
            qual$1.getOrCreateReplica(x$1, x$2);
            Partition qual$2 = replicaManager.getOrCreatePartition(tp1);
            int x$3 = 0;
            boolean x$4 = qual$2.getOrCreateReplica$default$2();
            qual$2.getOrCreateReplica(x$3, x$4);
            List partition0Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(1)}))).asJava();
            List partition1Replicas = (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(0), Predef$.MODULE$.int2Integer(2)}))).asJava();
            LeaderAndIsrRequest leaderAndIsrRequest = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), 0, 0, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition0Replicas, 0, partition0Replicas, true)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new LeaderAndIsrRequest.PartitionState(0, 0, 0, partition1Replicas, 0, partition1Replicas, true))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(0, "host1", 0), new Node(1, "host2", 1)}))).asJava()).build();
            replicaManager.becomeLeaderOrFollower(0, leaderAndIsrRequest, (Function2 & Serializable & scala.Serializable)(x$17, x$18) -> {
                ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(x$17, x$18);
                return BoxedUnit.UNIT;
            });
            RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), 2).foreach((Function1 & Serializable & scala.Serializable)i -> ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(this, replicaManager, tp0, tp1, BoxesRunTime.unboxToInt((Object)i)));
            long x$5 = 1000L;
            int x$6 = 1;
            int x$7 = 0;
            int x$8 = Integer.MAX_VALUE;
            boolean x$9 = false;
            Seq x$10 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp0), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)tp1), (Object)new FetchRequest.PartitionData(1L, 0L, 100000, Optional.empty()))}));
            Function1 & Serializable & scala.Serializable x$11 = (Function1 & Serializable & scala.Serializable)responseStatus -> {
                ReplicaManagerTest.fetchCallback$1(responseStatus, tp0, tp1);
                return BoxedUnit.UNIT;
            };
            IsolationLevel x$12 = IsolationLevel.READ_UNCOMMITTED;
            ReplicaQuota x$13 = replicaManager.fetchMessages$default$7();
            replicaManager.fetchMessages(x$5, x$6, x$7, x$8, x$9, x$10, x$13, (Function1)x$11, x$12);
            Option tp0Replica = replicaManager.localReplica(tp0);
            Assert.assertTrue((boolean)tp0Replica.isDefined());
            Assert.assertEquals((String)"hw should be incremented", (long)1L, (long)((Replica)tp0Replica.get()).highWatermark().messageOffset());
            replicaManager.localReplica(tp1);
            Option tp1Replica = replicaManager.localReplica(tp1);
            Assert.assertTrue((boolean)tp1Replica.isDefined());
            Assert.assertEquals((String)"hw should not be incremented", (long)0L, (long)((Replica)tp1Replica.get()).highWatermark().messageOffset());
        }
        finally {
            replicaManager.shutdown(false);
        }
    }

    @Test
    public void testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate() {
        int topicPartition = 0;
        int followerBrokerId = 0;
        int leaderBrokerId = 1;
        int controllerId = 0;
        int controllerEpoch = 0;
        int leaderEpoch = 1;
        int leaderEpochIncrement = 2;
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        CountDownLatch countDownLatch = new CountDownLatch(1);
        Tuple2<ReplicaManager, LogManager> tuple2 = this.prepareReplicaManagerAndLogManager(topicPartition, leaderEpoch + leaderEpochIncrement, followerBrokerId, leaderBrokerId, countDownLatch, true);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        ReplicaManager replicaManager = (ReplicaManager)tuple2._1();
        LogManager mockLogMgr = (LogManager)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)replicaManager, (Object)mockLogMgr);
        Tuple2 tuple23 = tuple22;
        ReplicaManager replicaManager2 = (ReplicaManager)tuple23._1();
        LogManager mockLogMgr2 = (LogManager)tuple23._2();
        Partition partition = replicaManager2.getOrCreatePartition(new TopicPartition(this.topic(), topicPartition));
        partition.getOrCreateReplica(followerBrokerId, partition.getOrCreateReplica$default$2());
        partition.makeFollower(controllerId, this.leaderAndIsrPartitionState(leaderEpoch, leaderBrokerId, (Seq<Integer>)aliveBrokerIds), this.correlationId());
        LeaderAndIsrRequest leaderAndIsrRequest0 = (LeaderAndIsrRequest)new LeaderAndIsrRequest.Builder(ApiKeys.LEADER_AND_ISR.latestVersion(), controllerId, controllerEpoch, this.brokerEpoch(), (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)scala.collection.immutable.Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)this.leaderAndIsrPartitionState(leaderEpoch += leaderEpochIncrement, leaderBrokerId, (Seq<Integer>)aliveBrokerIds))}))).asJava(), (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Node[]{new Node(followerBrokerId, "host1", 0), new Node(leaderBrokerId, "host2", 1)}))).asJava()).build();
        replicaManager2.becomeLeaderOrFollower(this.correlationId(), leaderAndIsrRequest0, (Function2 & Serializable & scala.Serializable)(x$20, followers) -> {
            ReplicaManagerTest.$anonfun$testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate$1(followerBrokerId, x$20, followers);
            return BoxedUnit.UNIT;
        });
        Assert.assertTrue((boolean)countDownLatch.await(1000L, TimeUnit.MILLISECONDS));
        EasyMock.verify((Object[])new Object[]{mockLogMgr2});
    }

    private Tuple2<ReplicaManager, LogManager> prepareReplicaManagerAndLogManager(int topicPartition, int leaderEpochInLeaderAndIsr, int followerBrokerId, int leaderBrokerId, CountDownLatch countDownLatch, boolean expectTruncation) {
        BoxedUnit boxedUnit;
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        int localLogOffset = 10;
        int offsetFromLeader = 5;
        int leaderEpochFromLeader = 3;
        MockScheduler mockScheduler = new MockScheduler((Time)this.time());
        BrokerTopicStats mockBrokerTopicStats = new BrokerTopicStats();
        LogDirFailureChannel mockLogDirFailureChannel = new LogDirFailureChannel(config.logDirs().size());
        Log mockLog = new Log(this, config, mockScheduler, mockBrokerTopicStats, topicPartition, mockLogDirFailureChannel, leaderEpochFromLeader, localLogOffset){
            private final int leaderEpochFromLeader$1;
            private final int localLogOffset$1;

            public Option<OffsetAndEpoch> endOffsetForEpoch(int leaderEpoch) {
                Assert.assertEquals((long)leaderEpoch, (long)this.leaderEpochFromLeader$1);
                return new Some((Object)new OffsetAndEpoch((long)this.localLogOffset$1, this.leaderEpochFromLeader$1));
            }

            public Option<Object> latestEpoch() {
                return new Some((Object)BoxesRunTime.boxToInteger((int)this.leaderEpochFromLeader$1));
            }

            public LogOffsetMetadata logEndOffsetMetadata() {
                return new LogOffsetMetadata((long)this.localLogOffset$1, LogOffsetMetadata$.MODULE$.apply$default$2(), LogOffsetMetadata$.MODULE$.apply$default$3());
            }
            {
                this.leaderEpochFromLeader$1 = leaderEpochFromLeader$1;
                this.localLogOffset$1 = localLogOffset$1;
                super(new File(new File((String)config$1.logDirs().head()), new StringBuilder(2).append($outer.topic()).append("-0").toString()), LogConfig$.MODULE$.apply(), 0L, 0L, (Scheduler)mockScheduler$1, mockBrokerTopicStats$1, (Time)$outer.time(), 30000, 30000, new TopicPartition($outer.topic(), topicPartition$1), new ProducerStateManager(new TopicPartition($outer.topic(), topicPartition$1), new File(new File((String)config$1.logDirs().head()), new StringBuilder(1).append($outer.topic()).append("-").append(topicPartition$1).toString()), 30000), mockLogDirFailureChannel$1);
            }
        };
        LogManager mockLogMgr = (LogManager)EasyMock.createMock(LogManager.class);
        EasyMock.expect((Object)mockLogMgr.liveLogDirs()).andReturn(config.logDirs().map((Function1 & Serializable & scala.Serializable)x$21 -> new File((String)x$21).getAbsoluteFile(), Seq$.MODULE$.canBuildFrom())).anyTimes();
        EasyMock.expect((Object)mockLogMgr.currentDefaultConfig()).andReturn((Object)LogConfig$.MODULE$.apply());
        EasyMock.expect((Object)mockLogMgr.getOrCreateLog(new TopicPartition(this.topic(), topicPartition), LogConfig$.MODULE$.apply(), false, false)).andReturn((Object)mockLog).anyTimes();
        if (expectTruncation) {
            mockLogMgr.truncateTo((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)BoxesRunTime.boxToLong((long)offsetFromLeader))})), false);
            boxedUnit = EasyMock.expect((Object)BoxedUnit.UNIT).once();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        EasyMock.replay((Object[])new Object[]{mockLogMgr});
        Seq aliveBrokerIds = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer(followerBrokerId), Predef$.MODULE$.int2Integer(leaderBrokerId)}));
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(Predef$.MODULE$.Integer2int(brokerId), new StringBuilder(4).append("host").append(brokerId).toString(), Predef$.MODULE$.Integer2int(brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache.isBrokerAlive(BoxesRunTime.unboxToInt((Object)EasyMock.eq((Object)BoxesRunTime.boxToInteger((int)Predef$.MODULE$.Integer2int(brokerId))))))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes());
        EasyMock.replay((Object[])new Object[]{metadataCache});
        MockTimer timer = new MockTimer();
        String x$1 = "Produce";
        MockTimer x$2 = timer;
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$1, (Timer)x$2, x$4, x$5, x$3, x$6);
        String x$7 = "Fetch";
        MockTimer x$8 = timer;
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$7, (Timer)x$8, x$10, x$11, x$9, x$12);
        String x$13 = "DeleteRecords";
        MockTimer x$14 = timer;
        boolean x$15 = false;
        int x$16 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$17 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$18 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$13, (Timer)x$14, x$16, x$17, x$15, x$18);
        String x$19 = "ElectPreferredLeader";
        MockTimer x$20 = timer;
        boolean x$212 = false;
        int x$22 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$23 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$24 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockElectPreferredLeaderPurgatory = new DelayedOperationPurgatory(x$19, (Timer)x$20, x$22, x$23, x$212, x$24);
        QuotaFactory.QuotaManagers quota = QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), "");
        ReplicaFetcherMockBlockingSend blockingSend = new ReplicaFetcherMockBlockingSend((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.topic(), topicPartition)), (Object)new EpochEndOffset(leaderEpochFromLeader, (long)offsetFromLeader))}))).asJava(), new BrokerEndPoint(1, "host1", 1), (Time)this.time());
        ReplicaManager replicaManager = new ReplicaManager(this, config, mockScheduler, mockLogMgr, quota, mockBrokerTopicStats, metadataCache, mockLogDirFailureChannel, mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockElectPreferredLeaderPurgatory, blockingSend, leaderEpochInLeaderAndIsr, topicPartition, countDownLatch){
            private final /* synthetic */ ReplicaManagerTest $outer;
            public final QuotaFactory.QuotaManagers quota$1;
            public final ReplicaFetcherMockBlockingSend blockingSend$1;
            public final int leaderEpochInLeaderAndIsr$1;
            public final int topicPartition$1;
            public final CountDownLatch countDownLatch$1;

            public ReplicaFetcherManager createReplicaFetcherManager(Metrics metrics, Time time, Option<String> threadNamePrefix, ReplicationQuotaManager quotaManager) {
                return new ReplicaFetcherManager(this, metrics, time, threadNamePrefix, quotaManager){
                    private final /* synthetic */ $anon$2 $outer;
                    public final Metrics metrics$1;
                    public final Time time$1;

                    public ReplicaFetcherThread createFetcherThread(int fetcherId, BrokerEndPoint sourceBroker) {
                        return new ReplicaFetcherThread(this, fetcherId, sourceBroker){
                            private final /* synthetic */ $anon$2$$anon$3 $outer;

                            public void doWork() {
                                OffsetAndEpoch initialOffset = new OffsetAndEpoch(0L, this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().leaderEpochInLeaderAndIsr$1);
                                this.addPartitions((Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new TopicPartition(this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().kafka$server$ReplicaManagerTest$$anon$$$outer().topic(), this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().topicPartition$1)), (Object)initialOffset)})));
                                super.doWork();
                                this.initiateShutdown();
                                this.$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().countDownLatch$1.countDown();
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                                super(new StringBuilder(21).append("ReplicaFetcherThread-").append(fetcherId$1).toString(), fetcherId$1, sourceBroker$1, $outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().config(), $outer.failedPartitions(), $outer.replicaManager(), $outer.metrics$1, $outer.time$1, (ReplicaQuota)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().quota$1.follower(), (Option)new Some((Object)$outer.kafka$server$ReplicaManagerTest$$anon$$anon$$$outer().blockingSend$1));
                            }
                        };
                    }

                    public /* synthetic */ $anon$2 kafka$server$ReplicaManagerTest$$anon$$anon$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                        this.metrics$1 = metrics$1;
                        this.time$1 = time$1;
                        super($outer.config(), (ReplicaManager)$outer, metrics$1, time$1, threadNamePrefix$1, quotaManager$1);
                    }
                };
            }

            public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$$anon$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.quota$1 = quota$1;
                this.blockingSend$1 = blockingSend$1;
                this.leaderEpochInLeaderAndIsr$1 = leaderEpochInLeaderAndIsr$1;
                this.topicPartition$1 = topicPartition$1;
                this.countDownLatch$1 = countDownLatch$1;
                super(config$1, $outer.metrics(), (Time)$outer.time(), $outer.kafkaZkClient(), (Scheduler)mockScheduler$1, mockLogMgr$1, new AtomicBoolean(false), quota$1, mockBrokerTopicStats$1, metadataCache$1, mockLogDirFailureChannel$1, mockProducePurgatory$1, mockFetchPurgatory$1, mockDeleteRecordsPurgatory$1, mockElectPreferredLeaderPurgatory$1, Option$.MODULE$.apply((Object)$outer.getClass().getName()));
            }
        };
        return new Tuple2((Object)replicaManager, (Object)mockLogMgr);
    }

    private LeaderAndIsrRequest.PartitionState leaderAndIsrPartitionState(int leaderEpoch, int leaderBrokerId, Seq<Integer> aliveBrokerIds) {
        return new LeaderAndIsrRequest.PartitionState(this.controllerEpoch(), leaderBrokerId, leaderEpoch, (List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava(), this.zkVersion(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(aliveBrokerIds).asJava(), false);
    }

    private CallbackResult<ProduceResponse.PartitionResponse> appendRecords(ReplicaManager replicaManager, TopicPartition partition, MemoryRecords records, boolean isFromClient, short requiredAcks) {
        CallbackResult<ProduceResponse.PartitionResponse> result = new CallbackResult<ProduceResponse.PartitionResponse>();
        replicaManager.appendRecords(1000L, requiredAcks, false, isFromClient, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)records)})), (Function1 & Serializable & scala.Serializable)responses -> {
            ReplicaManagerTest.appendCallback$1(responses, partition, result);
            return BoxedUnit.UNIT;
        }, replicaManager.appendRecords$default$7(), replicaManager.appendRecords$default$8());
        return result;
    }

    private boolean appendRecords$default$4() {
        return true;
    }

    private short appendRecords$default$5() {
        return -1;
    }

    private CallbackResult<FetchPartitionData> fetchAsConsumer(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, -1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsConsumer$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsConsumer$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchAsFollower(ReplicaManager replicaManager, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        return this.fetchMessages(replicaManager, 1, partition, partitionData, minBytes, isolationLevel);
    }

    private int fetchAsFollower$default$4() {
        return 0;
    }

    private IsolationLevel fetchAsFollower$default$5() {
        return IsolationLevel.READ_UNCOMMITTED;
    }

    private CallbackResult<FetchPartitionData> fetchMessages(ReplicaManager replicaManager, int replicaId, TopicPartition partition, FetchRequest.PartitionData partitionData, int minBytes, IsolationLevel isolationLevel) {
        CallbackResult<FetchPartitionData> result = new CallbackResult<FetchPartitionData>();
        long x$1 = 1000L;
        int x$2 = replicaId;
        int x$3 = minBytes;
        int x$4 = Integer.MAX_VALUE;
        boolean x$5 = false;
        Seq x$6 = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)partition), (Object)partitionData)}));
        Function1 & Serializable & scala.Serializable x$7 = (Function1 & Serializable & scala.Serializable)responseStatus -> {
            ReplicaManagerTest.fetchCallback$2(responseStatus, partition, result);
            return BoxedUnit.UNIT;
        };
        IsolationLevel x$8 = isolationLevel;
        ReplicaQuota x$9 = replicaManager.fetchMessages$default$7();
        replicaManager.fetchMessages(x$1, x$2, x$3, x$4, x$5, x$6, x$9, (Function1)x$7, x$8);
        return result;
    }

    private ReplicaManager setupReplicaManagerWithMockedPurgatories(MockTimer timer, Seq<Object> aliveBrokerIds) {
        Properties props = TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.MockZkConnect(), TestUtils$.MODULE$.createBrokerConfig$default$3(), TestUtils$.MODULE$.createBrokerConfig$default$4(), TestUtils$.MODULE$.createBrokerConfig$default$5(), TestUtils$.MODULE$.createBrokerConfig$default$6(), TestUtils$.MODULE$.createBrokerConfig$default$7(), TestUtils$.MODULE$.createBrokerConfig$default$8(), TestUtils$.MODULE$.createBrokerConfig$default$9(), TestUtils$.MODULE$.createBrokerConfig$default$10(), TestUtils$.MODULE$.createBrokerConfig$default$11(), TestUtils$.MODULE$.createBrokerConfig$default$12(), TestUtils$.MODULE$.createBrokerConfig$default$13(), TestUtils$.MODULE$.createBrokerConfig$default$14(), TestUtils$.MODULE$.createBrokerConfig$default$15(), TestUtils$.MODULE$.createBrokerConfig$default$16(), TestUtils$.MODULE$.createBrokerConfig$default$17(), TestUtils$.MODULE$.createBrokerConfig$default$18());
        props.put("log.dir", TestUtils$.MODULE$.tempRelativeDir("data").getAbsolutePath());
        KafkaConfig config = KafkaConfig$.MODULE$.fromProps(props);
        Properties logProps = new Properties();
        LogManager mockLogMgr = TestUtils$.MODULE$.createLogManager((Seq<File>)((Seq)config.logDirs().map((Function1 & Serializable & scala.Serializable)x$23 -> new File((String)x$23), Seq$.MODULE$.canBuildFrom())), new LogConfig((java.util.Map)logProps, LogConfig$.MODULE$.apply$default$2()), TestUtils$.MODULE$.createLogManager$default$3(), TestUtils$.MODULE$.createLogManager$default$4());
        Seq aliveBrokers = (Seq)aliveBrokerIds.map((Function1 & Serializable & scala.Serializable)brokerId -> TestUtils$.MODULE$.createBroker(BoxesRunTime.unboxToInt((Object)brokerId), new StringBuilder(4).append("host").append(BoxesRunTime.unboxToInt((Object)brokerId)).toString(), BoxesRunTime.unboxToInt((Object)brokerId), TestUtils$.MODULE$.createBroker$default$4()), Seq$.MODULE$.canBuildFrom());
        MetadataCache metadataCache = (MetadataCache)EasyMock.createMock(MetadataCache.class);
        EasyMock.expect((Object)metadataCache.getAliveBrokers()).andReturn((Object)aliveBrokers).anyTimes();
        aliveBrokerIds.foreach((Function1 & Serializable & scala.Serializable)brokerId -> ReplicaManagerTest.$anonfun$setupReplicaManagerWithMockedPurgatories$3(metadataCache, BoxesRunTime.unboxToInt((Object)brokerId)));
        EasyMock.replay((Object[])new Object[]{metadataCache});
        String x$1 = "Produce";
        MockTimer x$2 = timer;
        boolean x$3 = false;
        int x$4 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$5 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$6 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockProducePurgatory = new DelayedOperationPurgatory(x$1, (Timer)x$2, x$4, x$5, x$3, x$6);
        String x$7 = "Fetch";
        MockTimer x$8 = timer;
        boolean x$9 = false;
        int x$10 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$11 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$12 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockFetchPurgatory = new DelayedOperationPurgatory(x$7, (Timer)x$8, x$10, x$11, x$9, x$12);
        String x$13 = "DeleteRecords";
        MockTimer x$14 = timer;
        boolean x$15 = false;
        int x$16 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$17 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$18 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDeleteRecordsPurgatory = new DelayedOperationPurgatory(x$13, (Timer)x$14, x$16, x$17, x$15, x$18);
        String x$19 = "DelayedElectPreferredLeader";
        MockTimer x$20 = timer;
        boolean x$21 = false;
        int x$22 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$3();
        int x$232 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$4();
        boolean x$24 = DelayedOperationPurgatory$.MODULE$.$lessinit$greater$default$6();
        DelayedOperationPurgatory mockDelayedElectPreferredLeaderPurgatory = new DelayedOperationPurgatory(x$19, (Timer)x$20, x$22, x$232, x$21, x$24);
        return new ReplicaManager(config, this.metrics(), (Time)this.time(), this.kafkaZkClient(), (Scheduler)new MockScheduler((Time)this.time()), mockLogMgr, new AtomicBoolean(false), QuotaFactory$.MODULE$.instantiate(config, this.metrics(), (Time)this.time(), ""), new BrokerTopicStats(), metadataCache, new LogDirFailureChannel(config.logDirs().size()), mockProducePurgatory, mockFetchPurgatory, mockDeleteRecordsPurgatory, mockDelayedElectPreferredLeaderPurgatory, Option$.MODULE$.apply((Object)this.getClass().getName()));
    }

    private Seq<Object> setupReplicaManagerWithMockedPurgatories$default$2() {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
    }

    private static final void callback$1(Map responseStatus) {
        Errors errors = ((ProduceResponse.PartitionResponse)responseStatus.values().head()).error;
        Errors errors2 = Errors.INVALID_REQUIRED_ACKS;
        Predef$.MODULE$.assert(!(errors != null ? !errors.equals(errors2) : errors2 != null));
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$2(Iterable x$5, Iterable x$6) {
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NOT_LEADER_FOR_PARTITION, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testClearPurgatoryOnBecomingFollower$4(Iterable x$7, Iterable x$8) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$1(Iterable x$9, Iterable x$10) {
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$2(ReplicaManagerTest $this, long producerId$1, short epoch$1, ReplicaManager replicaManager$1, int sequence) {
        MemoryRecords records = MemoryRecords.withIdempotentRecords((CompressionType)CompressionType.NONE, (long)producerId$1, (short)epoch$1, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReceiveOutOfOrderSequenceExceptionWithLogStartOffset$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.OUT_OF_ORDER_SEQUENCE_NUMBER, (Object)response.error);
        Assert.assertEquals((long)0L, (long)response.logStartOffset);
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$1(Iterable x$11, Iterable x$12) {
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testReadCommittedFetchLimitedAtLSO$2(ReplicaManagerTest $this, long producerId$2, short epoch$2, ReplicaManager replicaManager$2, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$2, (short)epoch$2, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$2, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testReadCommittedFetchLimitedAtLSO$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testReadCommittedFetchLimitedAtLSO$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$1(Iterable x$13, Iterable x$14) {
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testDelayedFetchIncludesAbortedTransactions$2(ReplicaManagerTest $this, long producerId$3, short epoch$3, ReplicaManager replicaManager$3, int sequence) {
        MemoryRecords records = MemoryRecords.withTransactionalRecords((CompressionType)CompressionType.NONE, (long)producerId$3, (short)epoch$3, (int)sequence, (SimpleRecord[])new SimpleRecord[]{new SimpleRecord(new StringBuilder(8).append("message ").append(sequence).toString().getBytes())});
        return $this.appendRecords(replicaManager$3, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testDelayedFetchIncludesAbortedTransactions$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testDelayedFetchIncludesAbortedTransactions$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$1(Iterable x$15, Iterable x$16) {
    }

    public static final /* synthetic */ void $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$2(ReplicaManagerTest $this, ReplicaManager rm$1, int i) {
        MemoryRecords records = TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        return $this.appendRecords(rm$1, new TopicPartition($this.topic(), 0), records, $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchBeyondHighWatermarkReturnEmptyResponse$3(response);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$1(Iterable x$17, Iterable x$18) {
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ void $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(ProduceResponse.PartitionResponse response) {
        Assert.assertEquals((Object)Errors.NONE, (Object)response.error);
    }

    public static final /* synthetic */ CallbackResult $anonfun$testFetchMessagesWhenNotFollowerForOnePartition$2(ReplicaManagerTest $this, ReplicaManager replicaManager$4, TopicPartition tp0$1, TopicPartition tp1$1, int i) {
        $this.appendRecords(replicaManager$4, tp0$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$3(response);
            return BoxedUnit.UNIT;
        });
        return $this.appendRecords(replicaManager$4, tp1$1, TestUtils$.MODULE$.singletonRecords(new StringBuilder(8).append("message ").append(i).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), $this.appendRecords$default$4(), $this.appendRecords$default$5()).onFire((Function1<ProduceResponse.PartitionResponse, BoxedUnit>)(Function1 & Serializable & scala.Serializable)response -> {
            ReplicaManagerTest.$anonfun$testFetchMessagesWhenNotFollowerForOnePartition$4(response);
            return BoxedUnit.UNIT;
        });
    }

    private static final void fetchCallback$1(Seq responseStatus, TopicPartition tp0$1, TopicPartition tp1$1) {
        scala.collection.immutable.Map responseStatusMap = responseStatus.toMap(Predef$.MODULE$.$conforms());
        Assert.assertEquals((long)2L, (long)responseStatus.size());
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{tp0$1, tp1$1})), (Object)responseStatusMap.keySet());
        Option tp0Status = responseStatusMap.get((Object)tp0$1);
        Assert.assertTrue((boolean)tp0Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp0Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp0Status.get()).error());
        Assert.assertTrue((boolean)((FetchPartitionData)tp0Status.get()).records().batches().iterator().hasNext());
        Option tp1Status = responseStatusMap.get((Object)tp1$1);
        Assert.assertTrue((boolean)tp1Status.isDefined());
        Assert.assertEquals((long)0L, (long)((FetchPartitionData)tp1Status.get()).highWatermark());
        Assert.assertEquals((Object)new Some((Object)BoxesRunTime.boxToInteger((int)0)), (Object)((FetchPartitionData)tp0Status.get()).lastStableOffset());
        Assert.assertEquals((Object)Errors.NONE, (Object)((FetchPartitionData)tp1Status.get()).error());
        Assert.assertFalse((boolean)((FetchPartitionData)tp1Status.get()).records().batches().iterator().hasNext());
    }

    public static final /* synthetic */ void $anonfun$testBecomeFollowerWhenLeaderIsUnchangedButMissedLeaderUpdate$1(int followerBrokerId$1, Iterable x$20, Iterable followers) {
        Assert.assertEquals((long)followerBrokerId$1, (long)((Partition)followers.head()).partitionId());
    }

    private static final void appendCallback$1(Map responses, TopicPartition partition$1, CallbackResult result$1) {
        Option response = responses.get((Object)partition$1);
        Assert.assertTrue((boolean)response.isDefined());
        result$1.fire(response.get());
    }

    private static final void fetchCallback$2(Seq responseStatus, TopicPartition partition$2, CallbackResult result$2) {
        Assert.assertEquals((long)1L, (long)responseStatus.size());
        Tuple2 tuple2 = (Tuple2)responseStatus.head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        TopicPartition topicPartition = (TopicPartition)tuple2._1();
        FetchPartitionData fetchData = (FetchPartitionData)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)topicPartition, (Object)fetchData);
        Tuple2 tuple23 = tuple22;
        TopicPartition topicPartition2 = (TopicPartition)tuple23._1();
        FetchPartitionData fetchData2 = (FetchPartitionData)tuple23._2();
        Assert.assertEquals((Object)partition$2, (Object)topicPartition2);
        result$2.fire(fetchData2);
    }

    public static final /* synthetic */ IExpectationSetters $anonfun$setupReplicaManagerWithMockedPurgatories$3(MetadataCache metadataCache$2, int brokerId) {
        return EasyMock.expect((Object)BoxesRunTime.boxToBoolean((boolean)metadataCache$2.isBrokerAlive(EasyMock.eq((int)brokerId)))).andReturn((Object)BoxesRunTime.boxToBoolean((boolean)true)).anyTimes();
    }

    public ReplicaManagerTest() {
        this.topic = "test-topic";
        this.zkVersion = 0;
        this.correlationId = 0;
        this.brokerEpoch = 0L;
    }

    public class CallbackResult<T> {
        private Option<T> value;
        private Option<Function1<T, BoxedUnit>> fun;

        private Option<T> value() {
            return this.value;
        }

        private void value_$eq(Option<T> x$1) {
            this.value = x$1;
        }

        private Option<Function1<T, BoxedUnit>> fun() {
            return this.fun;
        }

        private void fun_$eq(Option<Function1<T, BoxedUnit>> x$1) {
            this.fun = x$1;
        }

        public T assertFired() {
            Assert.assertTrue((String)"Callback has not been fired", (boolean)this.isFired());
            return (T)this.value().get();
        }

        public boolean isFired() {
            return this.value().isDefined();
        }

        public void fire(T value) {
            this.value_$eq((Option<T>)new Some(value));
            this.fun().foreach((Function1 & Serializable & scala.Serializable)f -> {
                f.apply(value);
                return BoxedUnit.UNIT;
            });
        }

        public CallbackResult<T> onFire(Function1<T, BoxedUnit> fun) {
            block0: {
                this.fun_$eq((Option<Function1<T, BoxedUnit>>)new Some(fun));
                if (!this.isFired()) break block0;
                this.fire(this.value().get());
            }
            return this;
        }

        public /* synthetic */ ReplicaManagerTest kafka$server$ReplicaManagerTest$CallbackResult$$$outer() {
            return ReplicaManagerTest.this;
        }

        public CallbackResult() {
            if (ReplicaManagerTest.this == null) {
                throw null;
            }
            this.value = None$.MODULE$;
            this.fun = None$.MODULE$;
        }
    }
}

