/*
 * Decompiled with CFR 0.152.
 */
package kafka.controller;

import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.controller.AutoPreferredReplicaLeaderElection$;
import kafka.controller.BrokerChange$;
import kafka.controller.ControllerEvent;
import kafka.controller.ControllerEventManager;
import kafka.controller.ControllerEventProcessor;
import kafka.controller.ControllerState;
import kafka.controller.ControllerStats;
import kafka.controller.TopicChange$;
import kafka.controller.UpdateMetadataResponseReceived;
import kafka.metrics.KafkaYammerMetrics;
import org.apache.kafka.common.message.UpdateMetadataResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataResponse;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.MapOps;
import scala.collection.convert.AsScalaExtensions;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u000594AAD\b\u0001)!)1\u0004\u0001C\u00019!Iq\u0004\u0001a\u0001\u0002\u0004%I\u0001\t\u0005\nI\u0001\u0001\r\u00111A\u0005\n\u0015B\u0011b\u000b\u0001A\u0002\u0003\u0005\u000b\u0015B\u0011\t\u000b1\u0002A\u0011A\u0017\t\u000b]\u0002A\u0011A\u0017\t\u000bq\u0002A\u0011A\u0017\t\u000by\u0002A\u0011A\u0017\t\u000b\u0001\u0003A\u0011A\u0017\t\u000b\t\u0003A\u0011A\u0017\t\u000b\u0011\u0003A\u0011A\u0017\t\u000b\u0019\u0003A\u0011B$\t\u000b}\u0003A\u0011\u00021\u00035\r{g\u000e\u001e:pY2,'/\u0012<f]Rl\u0015M\\1hKJ$Vm\u001d;\u000b\u0005A\t\u0012AC2p]R\u0014x\u000e\u001c7fe*\t!#A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001)\u0002C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u001f\u000512m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/F\u0001\"!\tq\"%\u0003\u0002$\u001f\t12i\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'/\u0001\u000ed_:$(o\u001c7mKJ,e/\u001a8u\u001b\u0006t\u0017mZ3s?\u0012*\u0017\u000f\u0006\u0002'SA\u0011acJ\u0005\u0003Q]\u0011A!\u00168ji\"9!fAA\u0001\u0002\u0004\t\u0013a\u0001=%c\u000592m\u001c8ue>dG.\u001a:Fm\u0016tG/T1oC\u001e,'\u000fI\u0001\ti\u0016\f'\u000fR8x]R\ta\u0005\u000b\u0002\u0006_A\u0011\u0001'N\u0007\u0002c)\u0011!gM\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0002i\u0005\u0019qN]4\n\u0005Y\n$!B!gi\u0016\u0014\u0018!\u0007;fgRlU\r\u001e:jGN\u001cE.Z1oK\u0012|en\u00117pg\u0016D#AB\u001d\u0011\u0005AR\u0014BA\u001e2\u0005\u0011!Vm\u001d;\u00027Q,7\u000f^#wK:$x+\u001b;i_V$(+\u0019;f\u001b\u0016$(/[2tQ\t9\u0011(\u0001\nuKN$XI^3oiF+X-^3US6,\u0007F\u0001\u0005:\u0003\u0001\"Xm\u001d;Fm\u0016tG/U;fk\u0016$\u0016.\\3SKN,Go\u00148US6,w.\u001e;)\u0005%I\u0014a\u0005;fgR\u001cVoY2fgN4W\u000f\\#wK:$\bF\u0001\u0006:\u0003q!Xm\u001d;Fm\u0016tG\u000f\u00165biRC'o\\<t\u000bb\u001cW\r\u001d;j_:D#aC\u001d\u0002\u000b\rDWmY6\u0015\t\u0019BUK\u0017\u0005\u0006\u00132\u0001\rAS\u0001\u000b[\u0016$(/[2OC6,\u0007CA&S\u001d\ta\u0005\u000b\u0005\u0002N/5\taJ\u0003\u0002P'\u00051AH]8pizJ!!U\f\u0002\rA\u0013X\rZ3g\u0013\t\u0019FK\u0001\u0004TiJLgn\u001a\u0006\u0003#^AQA\u0016\u0007A\u0002]\u000bQ!\u001a<f]R\u0004\"A\b-\n\u0005e{!aD\"p]R\u0014x\u000e\u001c7fe\u00163XM\u001c;\t\u000bmc\u0001\u0019\u0001/\u0002\t\u0019,hn\u0019\t\u0004-u3\u0013B\u00010\u0018\u0005%1UO\\2uS>t\u0007'A\u0003uS6,'\u000f\u0006\u0002b[B\u0011!m[\u0007\u0002G*\u0011A-Z\u0001\u0005G>\u0014XM\u0003\u0002gO\u00069Q.\u001a;sS\u000e\u001c(B\u00015j\u0003\u0019I\u0018-\\7fe*\t!.A\u0002d_6L!\u0001\\2\u0003\u000bQKW.\u001a:\t\u000b%k\u0001\u0019\u0001&")
public class ControllerEventManagerTest {
    private ControllerEventManager controllerEventManager;

    private ControllerEventManager controllerEventManager() {
        return this.controllerEventManager;
    }

    private void controllerEventManager_$eq(ControllerEventManager x$1) {
        this.controllerEventManager = x$1;
    }

    @After
    public void tearDown() {
        if (this.controllerEventManager() != null) {
            this.controllerEventManager().close();
        }
    }

    @Test
    public void testMetricsCleanedOnClose() {
        MockTime time = new MockTime();
        ControllerStats controllerStats = new ControllerStats();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null){

            public void process(ControllerEvent event) {
            }

            public void preempt(ControllerEvent event) {
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics(), 300000L));
        this.controllerEventManager().start();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().nonEmpty());
        this.controllerEventManager().close();
        Assert.assertTrue((boolean)ControllerEventManagerTest.allEventManagerMetrics$1().isEmpty());
    }

    @Test
    public void testEventWithoutRateMetrics() {
        MockTime time = new MockTime();
        ControllerStats controllerStats = new ControllerStats();
        Set processedEvents = (Set)Set$.MODULE$.empty();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, processedEvents){
            private final Set processedEvents$1;

            public void process(ControllerEvent event) {
                Set set = this.processedEvents$1;
                if (set == null) {
                    throw null;
                }
                set.addOne((Object)event);
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.processedEvents$1 = processedEvents$1;
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics(), 300000L));
        this.controllerEventManager().start();
        UpdateMetadataResponse updateMetadataResponse = new UpdateMetadataResponse(new UpdateMetadataResponseData().setErrorCode(Errors.NONE.code()));
        UpdateMetadataResponseReceived updateMetadataResponseEvent = new UpdateMetadataResponseReceived(updateMetadataResponse, 1);
        this.controllerEventManager().put((ControllerEvent)updateMetadataResponseEvent);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$testEventWithoutRateMetrics$1(processedEvents)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Failed to process expected event before timing out", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Assert.assertEquals((Object)updateMetadataResponseEvent, (Object)processedEvents.head());
    }

    @Test
    public void testEventQueueTime() {
        Object object;
        String metricName = "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs";
        ControllerStats controllerStats = new ControllerStats();
        MockTime time = new MockTime();
        CountDownLatch latch = new CountDownLatch(1);
        AtomicInteger processedEvents = new AtomicInteger();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, latch, time, processedEvents){
            private final CountDownLatch latch$1;
            private final MockTime time$1;
            private final AtomicInteger processedEvents$2;

            public void process(ControllerEvent event) {
                this.latch$1.await();
                this.time$1.sleep(500L);
                this.processedEvents$2.incrementAndGet();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$1 = latch$1;
                this.time$1 = time$1;
                this.processedEvents$2 = processedEvents$2;
            }
        };
        Assert.assertTrue((boolean)((MapOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$1(metricName, x0$1)))).values().isEmpty());
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics(), 300000L));
        this.controllerEventManager().start();
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        latch.countDown();
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$testEventQueueTime$2(processedEvents)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Timed out waiting for processing of all events", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Option option = ((MapOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTime$4(metricName, x0$2)))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ControllerEventManagerTest.$anonfun$testEventQueueTime$5(metricName);
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var8_10 = null;
        object = null;
        Histogram queueTimeHistogram = (Histogram)object2;
        Assert.assertEquals((long)2L, (long)queueTimeHistogram.count());
        Assert.assertEquals((double)0.0, (double)queueTimeHistogram.min(), (double)0.01);
        Assert.assertEquals((double)500.0, (double)queueTimeHistogram.max(), (double)0.01);
    }

    @Test
    public void testEventQueueTimeResetOnTimeout() {
        Object object;
        String metricName = "kafka.controller:type=ControllerEventManager,name=EventQueueTimeMs";
        ControllerStats controllerStats = new ControllerStats();
        MockTime time = new MockTime();
        AtomicInteger processedEvents = new AtomicInteger();
        ControllerEventProcessor eventProcessor = new ControllerEventProcessor(null, processedEvents){
            private final AtomicInteger processedEvents$3;

            public void process(ControllerEvent event) {
                this.processedEvents$3.incrementAndGet();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.processedEvents$3 = processedEvents$3;
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)time, controllerStats.rateAndTimeMetrics(), 1L));
        this.controllerEventManager().start();
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        this.controllerEventManager().put((ControllerEvent)TopicChange$.MODULE$);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$testEventQueueTimeResetOnTimeout$1(processedEvents)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail("Timed out waiting for processing of all events", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        Option option = ((MapOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testEventQueueTimeResetOnTimeout$3(metricName, x0$1)))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ControllerEventManagerTest.$anonfun$testEventQueueTimeResetOnTimeout$4(metricName);
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        Object object2 = object;
        Object var7_9 = null;
        object = null;
        Histogram queueTimeHistogram = (Histogram)object2;
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$testEventQueueTimeResetOnTimeout$5(queueTimeHistogram)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Timed out on resetting queueTimeHistogram", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertEquals((double)0.0, (double)queueTimeHistogram.min(), (double)0.1);
        Assert.assertEquals((double)0.0, (double)queueTimeHistogram.max(), (double)0.1);
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testSuccessfulEvent() {
        void check_func;
        JFunction0.mcV.sp & Serializable intersect = (JFunction0.mcV.sp & Serializable)() -> {};
        AutoPreferredReplicaLeaderElection$ check_event = AutoPreferredReplicaLeaderElection$.MODULE$;
        String check_metricName = "kafka.controller:type=ControllerStats,name=AutoLeaderBalanceRateAndTimeMs";
        ControllerStats check_controllerStats = new ControllerStats();
        AtomicInteger check_eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch check_latch = new CountDownLatch(1);
        ControllerEventProcessor check_eventProcessor = new ControllerEventProcessor(null, check_latch, check_eventProcessedListenerCount, (Function0)check_func){
            private final CountDownLatch latch$2;
            private final AtomicInteger eventProcessedListenerCount$1;
            private final Function0 func$1;

            public void process(ControllerEvent event) {
                this.latch$2.await();
                this.eventProcessedListenerCount$1.incrementAndGet();
                this.func$1.apply$mcV$sp();
            }

            public void preempt(ControllerEvent event) {
            }
            {
                this.latch$2 = latch$2;
                this.eventProcessedListenerCount$1 = eventProcessedListenerCount$1;
                this.func$1 = func$1;
            }
        };
        this.controllerEventManager_$eq(new ControllerEventManager(0, check_eventProcessor, (Time)new MockTime(), check_controllerStats.rateAndTimeMetrics(), 300000L));
        this.controllerEventManager().start();
        long check_initialTimerCount = this.timer(check_metricName).count();
        this.controllerEventManager().put((ControllerEvent)check_event);
        long l = 15000L;
        long l2 = 100L;
        long check_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, (ControllerEvent)check_event)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2((ControllerEvent)check_event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        check_latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long check_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Controller state has not changed back to Idle", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertEquals((long)1L, (long)check_eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(check_initialTimerCount + 1L), (long)this.timer(check_metricName).count());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testEventThatThrowsException() {
        void check_func;
        Function0 & Serializable intersect = (Function0 & Serializable)() -> {
            throw new NullPointerException();
        };
        BrokerChange$ check_event = BrokerChange$.MODULE$;
        String check_metricName = "kafka.controller:type=ControllerStats,name=LeaderElectionRateAndTimeMs";
        ControllerStats check_controllerStats = new ControllerStats();
        AtomicInteger check_eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch check_latch = new CountDownLatch(1);
        ControllerEventProcessor check_eventProcessor = new /* invalid duplicate definition of identical inner class */;
        this.controllerEventManager_$eq(new ControllerEventManager(0, check_eventProcessor, (Time)new MockTime(), check_controllerStats.rateAndTimeMetrics(), 300000L));
        this.controllerEventManager().start();
        long check_initialTimerCount = this.timer(check_metricName).count();
        this.controllerEventManager().put((ControllerEvent)check_event);
        long l = 15000L;
        long l2 = 100L;
        long check_waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, (ControllerEvent)check_event)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2((ControllerEvent)check_event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        check_latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long check_waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            if (System.currentTimeMillis() > check_waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Controller state has not changed back to Idle", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertEquals((long)1L, (long)check_eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(check_initialTimerCount + 1L), (long)this.timer(check_metricName).count());
    }

    private void check(String metricName, ControllerEvent event, Function0<BoxedUnit> func) {
        ControllerStats controllerStats = new ControllerStats();
        AtomicInteger eventProcessedListenerCount = new AtomicInteger();
        CountDownLatch latch = new CountDownLatch(1);
        ControllerEventProcessor eventProcessor = new /* invalid duplicate definition of identical inner class */;
        this.controllerEventManager_$eq(new ControllerEventManager(0, eventProcessor, (Time)new MockTime(), controllerStats.rateAndTimeMetrics(), 300000L));
        this.controllerEventManager().start();
        long initialTimerCount = this.timer(metricName).count();
        this.controllerEventManager().put(event);
        long l = 15000L;
        long l2 = 100L;
        long waitUntilTrue_startTime = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$1(this, event)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime + l) {
                throw Assertions$.MODULE$.fail(ControllerEventManagerTest.$anonfun$check$2(event), new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l, l2));
        }
        latch.countDown();
        long l3 = 15000L;
        long l4 = 100L;
        long waitUntilTrue_startTime2 = System.currentTimeMillis();
        while (!ControllerEventManagerTest.$anonfun$check$3(this)) {
            if (System.currentTimeMillis() > waitUntilTrue_startTime2 + l3) {
                throw Assertions$.MODULE$.fail("Controller state has not changed back to Idle", new Position("TestUtils.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 847));
            }
            Thread.sleep(Math.min(l3, l4));
        }
        Assert.assertEquals((long)1L, (long)eventProcessedListenerCount.get());
        Assert.assertEquals((String)"Timer has not been updated", (long)(initialTimerCount + 1L), (long)this.timer(metricName).count());
    }

    private Timer timer(String metricName) {
        Object object;
        Option option = ((MapOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$timer$1(metricName, x0$1)))).values().headOption();
        if (option == null) {
            throw null;
        }
        Option getOrElse_this = option;
        if (getOrElse_this.isEmpty()) {
            ControllerEventManagerTest.$anonfun$timer$2(metricName);
            object = BoxedUnit.UNIT;
        } else {
            object = getOrElse_this.get();
        }
        return (Timer)object;
    }

    public static final /* synthetic */ boolean $anonfun$testMetricsCleanedOnClose$1(MetricName x$2) {
        return x$2.getMBeanName().startsWith("kafka.controller:type=ControllerEventManager");
    }

    private static final scala.collection.immutable.Set allEventManagerMetrics$1() {
        return ((IterableOnceOps)AsScalaExtensions.MapHasAsScala$((AsScalaExtensions)CollectionConverters$.MODULE$, (Map)KafkaYammerMetrics.defaultRegistry().allMetrics()).asScala().keySet().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ControllerEventManagerTest.$anonfun$testMetricsCleanedOnClose$1(x$2)))).toSet();
    }

    public static final /* synthetic */ boolean $anonfun$testEventWithoutRateMetrics$1(Set processedEvents$1) {
        return processedEvents$1.size() == 1;
    }

    public static final /* synthetic */ String $anonfun$testEventWithoutRateMetrics$2() {
        return "Failed to process expected event before timing out";
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$1(String metricName$1, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$2(AtomicInteger processedEvents$2) {
        return processedEvents$2.get() == 2;
    }

    public static final /* synthetic */ String $anonfun$testEventQueueTime$3() {
        return "Timed out waiting for processing of all events";
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTime$4(String metricName$1, Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$2._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$1) : metricName$1 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testEventQueueTime$5(String metricName$1) {
        Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName$1).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTimeResetOnTimeout$1(AtomicInteger processedEvents$3) {
        return processedEvents$3.get() == 2;
    }

    public static final /* synthetic */ String $anonfun$testEventQueueTimeResetOnTimeout$2() {
        return "Timed out waiting for processing of all events";
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTimeResetOnTimeout$3(String metricName$2, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$2) : metricName$2 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$testEventQueueTimeResetOnTimeout$4(String metricName$2) {
        Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName$2).toString());
    }

    public static final /* synthetic */ boolean $anonfun$testEventQueueTimeResetOnTimeout$5(Histogram queueTimeHistogram$1) {
        return queueTimeHistogram$1.count() == 0L;
    }

    public static final /* synthetic */ String $anonfun$testEventQueueTimeResetOnTimeout$6() {
        return "Timed out on resetting queueTimeHistogram";
    }

    public static final /* synthetic */ boolean $anonfun$check$1(ControllerEventManagerTest $this, ControllerEvent event$1) {
        ControllerState controllerState = $this.controllerEventManager().state();
        ControllerState controllerState2 = event$1.state();
        return !(controllerState != null ? !controllerState.equals(controllerState2) : controllerState2 != null);
    }

    public static final /* synthetic */ String $anonfun$check$2(ControllerEvent event$1) {
        return new StringBuilder(24).append("Controller state is not ").append(event$1.state()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$check$3(ControllerEventManagerTest $this) {
        ControllerState controllerState = $this.controllerEventManager().state();
        ControllerState.Idle$ idle$ = ControllerState.Idle$.MODULE$;
        return controllerState != null && controllerState.equals(idle$);
    }

    public static final /* synthetic */ String $anonfun$check$4() {
        return "Controller state has not changed back to Idle";
    }

    public static final /* synthetic */ boolean $anonfun$timer$1(String metricName$3, Tuple2 x0$1) {
        if (x0$1 == null) {
            throw new MatchError(null);
        }
        String string = ((MetricName)x0$1._1()).getMBeanName();
        boolean bl = !(string != null ? !string.equals(metricName$3) : metricName$3 != null);
        return bl;
    }

    public static final /* synthetic */ void $anonfun$timer$2(String metricName$3) {
        Assert.fail((String)new StringBuilder(22).append("Unable to find metric ").append(metricName$3).toString());
    }
}

