/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.utils.MockTime;
import kafka.utils.QuotaUtils$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.metrics.QuotaViolationException;
import org.apache.kafka.common.metrics.stats.Rate;
import org.apache.kafka.common.metrics.stats.Value;
import org.apache.kafka.common.utils.Time;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.Assertions$;
import scala.Function0;
import scala.Predef$;
import scala.collection.Map;
import scala.collection.convert.AsJavaExtensions;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\r\u001a\u0001yAQ!\n\u0001\u0005\u0002\u0019Bq!\u000b\u0001C\u0002\u0013%!\u0006\u0003\u0004/\u0001\u0001\u0006Ia\u000b\u0005\b_\u0001\u0011\r\u0011\"\u00031\u0011\u0019!\u0004\u0001)A\u0005c!9Q\u0007\u0001b\u0001\n\u0013\u0001\u0004B\u0002\u001c\u0001A\u0003%\u0011\u0007C\u00048\u0001\t\u0007I\u0011\u0002\u0019\t\ra\u0002\u0001\u0015!\u00032\u0011\u001dI\u0004A1A\u0005\niBaA\u0012\u0001!\u0002\u0013Y\u0004\"B$\u0001\t\u0003A\u0005\"B*\u0001\t\u0003A\u0005\"B+\u0001\t\u0003A\u0005\"B,\u0001\t\u0003A\u0005\"B-\u0001\t\u0003A\u0005\"B.\u0001\t\u0003A\u0005\"B/\u0001\t\u0003A\u0005\"B0\u0001\t\u0003A\u0005\"B1\u0001\t\u0003A\u0005\"B2\u0001\t\u0013!\u0007\"B:\u0001\t\u0013!\b\"B>\u0001\t\u0013a(AD)v_R\fW\u000b^5mgR+7\u000f\u001e\u0006\u00035m\tQ!\u001e;jYNT\u0011\u0001H\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0004\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u001d\u0002\"\u0001\u000b\u0001\u000e\u0003e\tA\u0001^5nKV\t1\u0006\u0005\u0002)Y%\u0011Q&\u0007\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Qa.^7TC6\u0004H.Z:\u0016\u0003E\u0002\"\u0001\t\u001a\n\u0005M\n#aA%oi\u0006Ya.^7TC6\u0004H.Z:!\u0003=\u0019\u0018-\u001c9mK^Kg\u000eZ8x'\u0016\u001c\u0017\u0001E:b[BdWmV5oI><8+Z2!\u0003Ei\u0017\r\u001f+ie>$H\u000f\\3US6,Wj]\u0001\u0013[\u0006DH\u000b\u001b:piRdW\rV5nK6\u001b\b%\u0001\u0006nKR\u0014\u0018n\u0019(b[\u0016,\u0012a\u000f\t\u0003y\u0011k\u0011!\u0010\u0006\u0003}}\naaY8n[>t'B\u0001\u000fA\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015k$AC'fiJL7MT1nK\u0006YQ.\u001a;sS\u000et\u0015-\\3!\u0003\u001d\"Xm\u001d;UQJ|G\u000f\u001e7f)&lWm\u00142tKJ4X\r\u001a*bi\u0016,\u0015/^1mgF+x\u000e^1\u0015\u0003%\u0003\"\u0001\t&\n\u0005-\u000b#\u0001B+oSRD#\u0001D'\u0011\u00059\u000bV\"A(\u000b\u0005A\u0013\u0015!\u00026v]&$\u0018B\u0001*P\u0005\u0011!Vm\u001d;\u0002MQ,7\u000f\u001e+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\n+Gn\\<Rk>$\u0018\r\u000b\u0002\u000e\u001b\u00061C/Z:u)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,\u0017IY8wKF+x\u000e^1)\u00059i\u0015A\f;fgR\u0014u.\u001e8eK\u0012$\u0006N]8ui2,G+[7f\u001f\n\u001cXM\u001d<fIJ\u000bG/Z#rk\u0006d7/U;pi\u0006D#aD'\u0002[Q,7\u000f\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\n+Gn\\<Rk>$\u0018\r\u000b\u0002\u0011\u001b\u00069D/Z:u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.Z(cg\u0016\u0014h/\u001a3SCR,\u0017IY8wKF+x\u000e^1CK2|w\u000fT5nSRD#!E'\u0002oQ,7\u000f\u001e\"pk:$W\r\u001a+ie>$H\u000f\\3US6,wJY:feZ,GMU1uK\u0006\u0013wN^3Rk>$\u0018-\u00112pm\u0016d\u0015.\\5uQ\t\u0011R*\u0001\u001cuKN$H\u000b\u001b:piRdW\rV5nKRC'o\\<t\u000bb\u001cW\r\u001d;j_:Le\r\u0015:pm&$W\r\u001a(p]J\u000bG/Z'fiJL7\r\u000b\u0002\u0014\u001b\u0006iD/Z:u\u0005>,h\u000eZ3e)\"\u0014x\u000e\u001e;mKRKW.\u001a+ie><8/\u0012=dKB$\u0018n\u001c8JMB\u0013xN^5eK\u0012tuN\u001c*bi\u0016lU\r\u001e:jG\"\u0012A#T\u0001\u0018cV|G/\u0019,j_2\fG/[8o\u000bb\u001cW\r\u001d;j_:$B!Z6qeB\u0011a-[\u0007\u0002O*\u0011\u0001.P\u0001\b[\u0016$(/[2t\u0013\tQwMA\fRk>$\u0018MV5pY\u0006$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]\")A.\u0006a\u0001[\u0006iqNY:feZ,GMV1mk\u0016\u0004\"\u0001\t8\n\u0005=\f#A\u0002#pk\ndW\rC\u0003r+\u0001\u0007Q.A\u0003rk>$\u0018\rC\u00030+\u0001\u0007\u0011'\u0001\u0007uQJ|G\u000f\u001e7f)&lW\r\u0006\u0003vqfT\bC\u0001\u0011w\u0013\t9\u0018E\u0001\u0003M_:<\u0007\"\u00027\u0017\u0001\u0004i\u0007\"B9\u0017\u0001\u0004i\u0007\"B\u0018\u0017\u0001\u0004\t\u0014a\u00052pk:$W\r\u001a+ie>$H\u000f\\3US6,GCB;~}~\f\t\u0001C\u0003m/\u0001\u0007Q\u000eC\u0003r/\u0001\u0007Q\u000eC\u00030/\u0001\u0007\u0011\u0007\u0003\u0004\u0002\u0004]\u0001\r!^\u0001\u0010[\u0006DH\u000b\u001b:piRdW\rV5nK\u0002")
public class QuotaUtilsTest {
    private final MockTime time = new MockTime();
    private final int numSamples;
    private final int sampleWindowSec;
    private final int maxThrottleTimeMs;
    private final MetricName metricName;

    private MockTime time() {
        return this.time;
    }

    private int numSamples() {
        return this.numSamples;
    }

    private int sampleWindowSec() {
        return this.sampleWindowSec;
    }

    private int maxThrottleTimeMs() {
        return this.maxThrottleTimeMs;
    }

    private MetricName metricName() {
        return this.metricName;
    }

    @Test
    public void testThrottleTimeObservedRateEqualsQuota() {
        int numSamples = 10;
        double observedValue = 16.5;
        Assert.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples));
        Assert.assertEquals((long)0L, (long)this.throttleTime(observedValue, observedValue, numSamples + 1));
    }

    @Test
    public void testThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 20.4;
        Assert.assertTrue((this.throttleTime(observedValue, quota, this.numSamples()) < 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.throttleTime(observedValue, quota, this.numSamples() + 1) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testThrottleTimeObservedRateAboveQuota() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assert.assertEquals((long)2000L, (long)this.throttleTime(observedValue, quota, 3));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateEqualsQuota() {
        double observedValue = 18.2;
        Assert.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples(), this.maxThrottleTimeMs()));
        Assert.assertEquals((long)0L, (long)this.boundedThrottleTime(observedValue, observedValue, this.numSamples() + 1, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateBelowQuota() {
        double observedValue = 16.5;
        double quota = 22.4;
        Assert.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
        Assert.assertTrue((this.boundedThrottleTime(observedValue, quota, this.numSamples() + 1, this.maxThrottleTimeMs()) < 0L ? 1 : 0) != 0);
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaBelowLimit() {
        double quota = 50.0;
        double observedValue = 55.0;
        Assert.assertEquals((long)100L, (long)this.boundedThrottleTime(observedValue, quota, 2, this.maxThrottleTimeMs()));
    }

    @Test
    public void testBoundedThrottleTimeObservedRateAboveQuotaAboveLimit() {
        double quota = 50.0;
        double observedValue = 100.0;
        Assert.assertEquals((long)this.maxThrottleTimeMs(), (long)this.boundedThrottleTime(observedValue, quota, this.numSamples(), this.maxThrottleTimeMs()));
    }

    @Test
    public void testThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> QuotaUtils$.MODULE$.throttleTime(new QuotaViolationException(testMetric, 10.0, 20.0), this.time().milliseconds()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("QuotaUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 105));
    }

    @Test
    public void testBoundedThrottleTimeThrowsExceptionIfProvidedNonRateMetric() {
        KafkaMetric testMetric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Value(), new MetricConfig(), (Time)this.time());
        Assertions$.MODULE$.assertThrows((Function0)(JFunction0.mcJ.sp & Serializable)() -> QuotaUtils$.MODULE$.boundedThrottleTime(new QuotaViolationException(testMetric, 10.0, 20.0), (long)this.maxThrottleTimeMs(), this.time().milliseconds()), ClassTag$.MODULE$.apply(IllegalArgumentException.class), new Position("QuotaUtilsTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 114));
    }

    private QuotaViolationException quotaViolationException(double observedValue, double quota, int numSamples) {
        MetricConfig metricConfig = new MetricConfig().timeWindow((long)this.sampleWindowSec(), TimeUnit.SECONDS).samples(numSamples).quota(new Quota(quota, true));
        KafkaMetric metric = new KafkaMetric(new Object(), this.metricName(), (MetricValueProvider)new Rate(), metricConfig, (Time)this.time());
        return new QuotaViolationException(metric, observedValue, quota);
    }

    private long throttleTime(double observedValue, double quota, int numSamples) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.throttleTime(e, this.time().milliseconds());
    }

    private long boundedThrottleTime(double observedValue, double quota, int numSamples, long maxThrottleTime) {
        QuotaViolationException e = this.quotaViolationException(observedValue, quota, numSamples);
        return QuotaUtils$.MODULE$.boundedThrottleTime(e, maxThrottleTime, this.time().milliseconds());
    }

    public QuotaUtilsTest() {
        this.numSamples = 10;
        this.sampleWindowSec = 1;
        this.maxThrottleTimeMs = 500;
        if (Predef$.MODULE$.Map() == null) {
            throw null;
        }
        this.metricName = new MetricName("test-metric", "groupA", "testA", AsJavaExtensions.MapHasAsJava$((AsJavaExtensions)CollectionConverters$.MODULE$, (Map)Map.EmptyMap$.MODULE$).asJava());
    }
}

