/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.model.jdbc;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.concurrent.Callable;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.RefreshHelper;
import org.apache.mahout.cf.taste.impl.model.GenericBooleanPrefDataModel;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.JDBCDataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReloadFromJDBCDataModel
implements DataModel {
    private static final Logger log = LoggerFactory.getLogger(ReloadFromJDBCDataModel.class);
    private DataModel delegateInMemory;
    private final JDBCDataModel delegate;
    private final RefreshHelper refreshHelper;

    public ReloadFromJDBCDataModel(JDBCDataModel delegate) throws TasteException {
        this.delegate = (JDBCDataModel)Preconditions.checkNotNull((Object)delegate);
        this.refreshHelper = new RefreshHelper((Callable)new Callable<Void>(){

            @Override
            public Void call() {
                ReloadFromJDBCDataModel.this.reload();
                return null;
            }
        });
        this.refreshHelper.addDependency((Refreshable)delegate);
        this.reload();
        if (this.delegateInMemory == null) {
            throw new TasteException("Failed to load data into memory");
        }
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.refreshHelper.refresh(alreadyRefreshed);
    }

    private void reload() {
        try {
            log.info("Loading new JDBC delegate data...");
            GenericDataModel newDelegateInMemory = this.delegate.hasPreferenceValues() ? new GenericDataModel(this.delegate.exportWithPrefs()) : new GenericBooleanPrefDataModel(this.delegate.exportWithIDsOnly());
            log.info("New data loaded.");
            this.delegateInMemory = newDelegateInMemory;
        }
        catch (TasteException te) {
            log.warn("Error while reloading JDBC delegate data", (Throwable)te);
        }
    }

    public JDBCDataModel getDelegate() {
        return this.delegate;
    }

    public DataModel getDelegateInMemory() {
        return this.delegateInMemory;
    }

    public LongPrimitiveIterator getUserIDs() throws TasteException {
        return this.delegateInMemory.getUserIDs();
    }

    public PreferenceArray getPreferencesFromUser(long id) throws TasteException {
        return this.delegateInMemory.getPreferencesFromUser(id);
    }

    public FastIDSet getItemIDsFromUser(long id) throws TasteException {
        return this.delegateInMemory.getItemIDsFromUser(id);
    }

    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        return this.delegateInMemory.getPreferenceValue(userID, itemID);
    }

    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        return this.delegateInMemory.getPreferenceTime(userID, itemID);
    }

    public LongPrimitiveIterator getItemIDs() throws TasteException {
        return this.delegateInMemory.getItemIDs();
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        return this.delegateInMemory.getPreferencesForItem(itemID);
    }

    public int getNumItems() throws TasteException {
        return this.delegateInMemory.getNumItems();
    }

    public int getNumUsers() throws TasteException {
        return this.delegateInMemory.getNumUsers();
    }

    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        return this.delegateInMemory.getNumUsersWithPreferenceFor(itemID);
    }

    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        return this.delegateInMemory.getNumUsersWithPreferenceFor(itemID1, itemID2);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.delegateInMemory.setPreference(userID, itemID, value);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.delegateInMemory.removePreference(userID, itemID);
    }

    public boolean hasPreferenceValues() {
        return this.delegateInMemory.hasPreferenceValues();
    }

    public float getMaxPreference() {
        return this.delegateInMemory.getMaxPreference();
    }

    public float getMinPreference() {
        return this.delegateInMemory.getMinPreference();
    }
}

