/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.clustering;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.mahout.clustering.Cluster;
import org.apache.mahout.clustering.WeightedVectorWritable;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.distance.DistanceMeasure;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.clustering.ClusterWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractClusterWriter
implements ClusterWriter {
    private static final Logger log = LoggerFactory.getLogger(AbstractClusterWriter.class);
    protected final Writer writer;
    protected final Map<Integer, List<WeightedVectorWritable>> clusterIdToPoints;
    protected final DistanceMeasure measure;

    protected AbstractClusterWriter(Writer writer, Map<Integer, List<WeightedVectorWritable>> clusterIdToPoints, DistanceMeasure measure) {
        this.writer = writer;
        this.clusterIdToPoints = clusterIdToPoints;
        this.measure = measure;
    }

    protected Writer getWriter() {
        return this.writer;
    }

    protected Map<Integer, List<WeightedVectorWritable>> getClusterIdToPoints() {
        return this.clusterIdToPoints;
    }

    public static String getTopFeatures(Vector vector, String[] dictionary, int numTerms) {
        ArrayList vectorTerms = Lists.newArrayList();
        Iterator iter = vector.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element elt = (Vector.Element)iter.next();
            vectorTerms.add(new TermIndexWeight(elt.index(), elt.get()));
        }
        Collections.sort(vectorTerms, new Comparator<TermIndexWeight>(){

            @Override
            public int compare(TermIndexWeight one, TermIndexWeight two) {
                return Double.compare(two.weight, one.weight);
            }
        });
        LinkedList<Pair> topTerms = new LinkedList<Pair>();
        for (int i = 0; i < vectorTerms.size() && i < numTerms; ++i) {
            int index = ((TermIndexWeight)vectorTerms.get(i)).index;
            String dictTerm = dictionary[index];
            if (dictTerm == null) {
                log.error("Dictionary entry missing for {}", (Object)index);
                continue;
            }
            topTerms.add(new Pair((Object)dictTerm, (Object)((TermIndexWeight)vectorTerms.get(i)).weight));
        }
        StringBuilder sb = new StringBuilder(100);
        for (Pair item : topTerms) {
            String term = (String)item.getFirst();
            sb.append("\n\t\t");
            sb.append(StringUtils.rightPad((String)term, (int)40));
            sb.append("=>");
            sb.append(StringUtils.leftPad((String)((Double)item.getSecond()).toString(), (int)20));
        }
        return sb.toString();
    }

    public static String getTopTerms(Vector vector, String[] dictionary, int numTerms) {
        ArrayList vectorTerms = Lists.newArrayList();
        Iterator iter = vector.iterateNonZero();
        while (iter.hasNext()) {
            Vector.Element elt = (Vector.Element)iter.next();
            vectorTerms.add(new TermIndexWeight(elt.index(), elt.get()));
        }
        Collections.sort(vectorTerms, new Comparator<TermIndexWeight>(){

            @Override
            public int compare(TermIndexWeight one, TermIndexWeight two) {
                return Double.compare(two.weight, one.weight);
            }
        });
        LinkedList<Pair> topTerms = new LinkedList<Pair>();
        for (int i = 0; i < vectorTerms.size() && i < numTerms; ++i) {
            int index = ((TermIndexWeight)vectorTerms.get(i)).index;
            String dictTerm = dictionary[index];
            if (dictTerm == null) {
                log.error("Dictionary entry missing for {}", (Object)index);
                continue;
            }
            topTerms.add(new Pair((Object)dictTerm, (Object)((TermIndexWeight)vectorTerms.get(i)).weight));
        }
        StringBuilder sb = new StringBuilder(100);
        for (Pair item : topTerms) {
            String term = (String)item.getFirst();
            sb.append(term).append("_");
        }
        sb.deleteCharAt(sb.length() - 1);
        return sb.toString();
    }

    @Override
    public long write(Iterable<Cluster> iterable) throws IOException {
        return this.write(iterable, Long.MAX_VALUE);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public long write(Iterable<Cluster> iterable, long maxDocs) throws IOException {
        long result;
        Iterator<Cluster> iterator = iterable.iterator();
        for (result = 0L; result < maxDocs && iterator.hasNext(); ++result) {
            this.write(iterator.next());
        }
        return result;
    }

    private static class TermIndexWeight {
        private final int index;
        private final double weight;

        TermIndexWeight(int index, double weight) {
            this.index = index;
            this.weight = weight;
        }
    }
}

