/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.io;

import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import org.apache.mahout.utils.vectors.TermEntry;
import org.apache.mahout.utils.vectors.TermInfo;
import org.apache.mahout.utils.vectors.io.TermInfoWriter;

public class DelimitedTermInfoWriter
implements TermInfoWriter {
    private final Writer writer;
    private final String delimiter;
    private final String field;

    public DelimitedTermInfoWriter(Writer writer, String delimiter, String field) {
        this.writer = writer;
        this.delimiter = delimiter;
        this.field = field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(TermInfo ti) throws IOException {
        Iterator<TermEntry> entIter = ti.getAllEntries();
        try {
            this.writer.write(String.valueOf(ti.totalTerms(this.field)));
            this.writer.write(10);
            this.writer.write("#term" + this.delimiter + "doc freq" + this.delimiter + "idx");
            this.writer.write(10);
            while (entIter.hasNext()) {
                TermEntry entry = entIter.next();
                this.writer.write(entry.getTerm());
                this.writer.write(this.delimiter);
                this.writer.write(String.valueOf(entry.getDocFreq()));
                this.writer.write(this.delimiter);
                this.writer.write(String.valueOf(entry.getTermIdx()));
                this.writer.write(10);
            }
        }
        finally {
            Closeables.closeQuietly((Closeable)this.writer);
        }
    }

    @Override
    public void close() {
    }
}

