/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors.lucene;

import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.mahout.math.RandomAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.utils.vectors.TermEntry;
import org.apache.mahout.utils.vectors.TermInfo;
import org.apache.mahout.utils.vectors.lucene.VectorMapper;
import org.apache.mahout.vectorizer.Weight;

public class TFDFMapper
extends VectorMapper {
    private Vector vector;
    private final Weight weight;
    private int numTerms;
    private final TermInfo termInfo;
    private String field;
    private final int numDocs;

    public TFDFMapper(IndexReader reader, Weight weight, TermInfo termInfo) {
        this.weight = weight;
        this.termInfo = termInfo;
        this.numDocs = reader.numDocs();
    }

    @Override
    public Vector getVector() {
        return this.vector;
    }

    public void setExpectations(String field, int numTerms, boolean storeOffsets, boolean storePositions) {
        this.field = field;
        this.vector = new RandomAccessSparseVector(this.termInfo.totalTerms(field));
        this.numTerms = numTerms;
    }

    public void map(String term, int frequency, TermVectorOffsetInfo[] offsets, int[] positions) {
        TermEntry entry = this.termInfo.getTermEntry(this.field, term);
        if (entry != null) {
            this.vector.setQuick(entry.getTermIdx(), this.weight.calculate(frequency, entry.getDocFreq(), this.numTerms, this.numDocs));
        }
    }

    public boolean isIgnoringPositions() {
        return true;
    }

    public boolean isIgnoringOffsets() {
        return true;
    }
}

