/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.utils;

import java.io.File;
import java.util.Locale;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;

public final class AssemblyFileUtils {
    private AssemblyFileUtils() {
    }

    public static String makePathRelativeTo(String path, File basedir) {
        String base;
        if (basedir == null) {
            return path;
        }
        if (path == null) {
            return null;
        }
        if ((path = path.trim()).startsWith(base = basedir.getAbsolutePath())) {
            if ((path = path.substring(base.length())).length() > 0 && (path.startsWith("/") || path.startsWith("\\"))) {
                path = path.substring(1);
            }
            if (path.length() == 0) {
                path = ".";
            }
        }
        if (!new File(path).isAbsolute()) {
            path = path.replace('\\', '/');
        }
        return path;
    }

    public static void verifyTempDirectoryAvailability(File tempDir) {
        if (!tempDir.exists()) {
            tempDir.mkdirs();
        }
    }

    private static String normalizePath(String path) {
        return path.replace('\\', '/');
    }

    public static String normalizeFileInfo(FileInfo fileInfo) {
        String name = fileInfo.getName();
        name = AssemblyFileUtils.normalizePath(name);
        return name.replace(File.separatorChar, '/');
    }

    public static boolean isPropertyFile(String sourceName) {
        return sourceName.toLowerCase(Locale.ENGLISH).endsWith(".properties");
    }

    public static boolean isPropertyFile(File file) {
        return AssemblyFileUtils.isPropertyFile(file.getName());
    }

    public static boolean isAbsolutePath(File dir) {
        return dir != null && (dir.isAbsolute() || dir.getPath().startsWith("\\"));
    }
}

