/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.help;

import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.collections.PropertiesConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.commons.lang3.ClassUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.lifecycle.internal.MojoDescriptorCreator;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.PluginParameterExpressionEvaluator;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.help.AbstractHelpMojo;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.shared.artifact.ArtifactCoordinate;
import org.apache.maven.shared.artifact.resolve.ArtifactResolverException;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.components.interactivity.InputHandler;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

@Mojo(name="evaluate", requiresProject=false)
public class EvaluateMojo
extends AbstractHelpMojo {
    @Component
    private InputHandler inputHandler;
    @Component
    private MojoDescriptorCreator mojoDescriptorCreator;
    @Parameter(property="output")
    private File output;
    @Parameter(property="forceStdout", defaultValue="false")
    private boolean forceStdout;
    @Parameter(property="artifact")
    private String artifact;
    @Parameter(property="expression")
    private String expression;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    private MavenProject project;
    @Parameter(defaultValue="${settings}", readonly=true, required=true)
    private Settings settings;
    private PluginParameterExpressionEvaluator evaluator;
    private XStream xstream;

    public void execute() throws MojoExecutionException, MojoFailureException {
        block8: {
            if (this.expression == null && !this.settings.isInteractiveMode()) {
                this.getLog().error((CharSequence)"Maven is configured to NOT interact with the user for input. This Mojo requires that 'interactiveMode' in your settings file is flag to 'true'.");
                return;
            }
            this.validateParameters();
            if (StringUtils.isNotEmpty((String)this.artifact)) {
                this.project = this.getMavenProject(this.artifact);
            }
            if (this.expression == null) {
                if (this.output != null) {
                    this.getLog().warn((CharSequence)"When prompting for input, the result will be written to the console, ignoring 'output'.");
                }
                while (true) {
                    this.getLog().info((CharSequence)"Enter the Maven expression i.e. ${project.groupId} or 0 to exit?:");
                    try {
                        String userExpression = this.inputHandler.readLine();
                        if (userExpression != null && !userExpression.toLowerCase(Locale.ENGLISH).equals("0")) {
                            this.handleResponse(userExpression, null);
                            continue;
                        }
                        break block8;
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Unable to read from standard input.", (Exception)e);
                    }
                }
            }
            this.handleResponse("${" + this.expression + "}", this.output);
        }
    }

    private void validateParameters() {
        if (this.artifact == null) {
            this.getLog().info((CharSequence)("No artifact parameter specified, using '" + this.project.getId() + "' as project."));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PluginParameterExpressionEvaluator getEvaluator() throws MojoExecutionException, MojoFailureException {
        if (this.evaluator == null) {
            MojoDescriptor mojoDescriptor;
            try {
                mojoDescriptor = this.mojoDescriptorCreator.getMojoDescriptor("help:evaluate", this.session, this.project);
            }
            catch (Exception e) {
                throw new MojoFailureException("Failure while evaluating.", (Throwable)e);
            }
            MojoExecution mojoExecution = new MojoExecution(mojoDescriptor);
            MavenProject currentProject = this.session.getCurrentProject();
            MavenSession mavenSession = this.session;
            synchronized (mavenSession) {
                this.session.setCurrentProject(this.project);
                this.evaluator = new PluginParameterExpressionEvaluator(this.session, mojoExecution);
                this.session.setCurrentProject(currentProject);
            }
        }
        return this.evaluator;
    }

    private void handleResponse(String expr, File output) throws MojoExecutionException, MojoFailureException {
        Object obj;
        StringBuilder response = new StringBuilder();
        try {
            obj = this.getEvaluator().evaluate(expr);
        }
        catch (ExpressionEvaluationException e) {
            throw new MojoExecutionException("Error when evaluating the Maven expression", (Exception)((Object)e));
        }
        if (obj != null && expr.equals(obj.toString())) {
            this.getLog().warn((CharSequence)"The Maven expression was invalid. Please use a valid expression.");
            return;
        }
        if (obj == null) {
            response.append("null object or invalid expression");
        } else if (obj instanceof String) {
            response.append(obj.toString());
        } else if (obj instanceof Boolean) {
            response.append(obj.toString());
        } else if (obj instanceof Byte) {
            response.append(obj.toString());
        } else if (obj instanceof Character) {
            response.append(obj.toString());
        } else if (obj instanceof Double) {
            response.append(obj.toString());
        } else if (obj instanceof Float) {
            response.append(obj.toString());
        } else if (obj instanceof Integer) {
            response.append(obj.toString());
        } else if (obj instanceof Long) {
            response.append(obj.toString());
        } else if (obj instanceof Short) {
            response.append(obj.toString());
        } else if (obj instanceof File) {
            File f = (File)obj;
            response.append(f.getAbsolutePath());
        } else if (obj instanceof MavenProject) {
            MavenProject projectAsked = (MavenProject)obj;
            StringWriter sWriter = new StringWriter();
            MavenXpp3Writer pomWriter = new MavenXpp3Writer();
            try {
                pomWriter.write((Writer)sWriter, projectAsked.getModel());
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error when writing pom", (Exception)e);
            }
            response.append(sWriter.toString());
        } else if (obj instanceof Settings) {
            Settings settingsAsked = (Settings)obj;
            StringWriter sWriter = new StringWriter();
            SettingsXpp3Writer settingsWriter = new SettingsXpp3Writer();
            try {
                settingsWriter.write((Writer)sWriter, settingsAsked);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Error when writing settings", (Exception)e);
            }
            response.append(sWriter.toString());
        } else {
            response.append(this.toXML(expr, obj));
        }
        if (output != null) {
            try {
                EvaluateMojo.writeFile(output, response);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Cannot write evaluation of expression to output: " + output, (Exception)e);
            }
            this.getLog().info((CharSequence)("Result of evaluation written to: " + output));
        } else if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)(LS + response.toString()));
        } else if (this.forceStdout) {
            System.out.print(response.toString());
        }
    }

    private String toXML(String expr, Object obj) {
        XStream currentXStream = this.getXStream();
        if (obj instanceof List) {
            List list = (List)obj;
            if (list.size() > 0) {
                Object elt = list.iterator().next();
                String name = StringUtils.lowercaseFirstLetter((String)elt.getClass().getSimpleName());
                currentXStream.alias(EvaluateMojo.pluralize(name), List.class);
            } else if (expr.indexOf(46) != -1) {
                String name = expr.substring(expr.indexOf(46) + 1, expr.indexOf(125));
                currentXStream.alias(name, List.class);
            }
        }
        return currentXStream.toXML(obj);
    }

    private XStream getXStream() {
        if (this.xstream == null) {
            this.xstream = new XStream();
            this.addAlias(this.xstream);
            this.xstream.registerConverter((Converter)new PropertiesConverter(){

                public boolean canConvert(Class type) {
                    return Properties.class == type;
                }

                public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
                    Properties properties = (Properties)source;
                    TreeMap<Object, Object> map = new TreeMap<Object, Object>(properties);
                    for (Map.Entry entry : map.entrySet()) {
                        writer.startNode(entry.getKey().toString());
                        writer.setValue(entry.getValue().toString());
                        writer.endNode();
                    }
                }
            });
        }
        return this.xstream;
    }

    private void addAlias(XStream xstreamObject) {
        block6: {
            try {
                this.addAlias(xstreamObject, this.getMavenModelJarFile(), "org.apache.maven.model");
                this.addAlias(xstreamObject, this.getMavenSettingsJarFile(), "org.apache.maven.settings");
            }
            catch (MojoExecutionException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("MojoExecutionException: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (ArtifactResolverException e) {
                if (this.getLog().isDebugEnabled()) {
                    this.getLog().debug((CharSequence)("ArtifactResolverException: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (ProjectBuildingException e) {
                if (!this.getLog().isDebugEnabled()) break block6;
                this.getLog().debug((CharSequence)("ProjectBuildingException: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAlias(XStream xstreamObject, File jarFile, String packageFilter) {
        JarInputStream jarStream = null;
        try {
            jarStream = new JarInputStream(new FileInputStream(jarFile));
            JarEntry jarEntry = jarStream.getNextJarEntry();
            while (jarEntry != null) {
                if (jarEntry.getName().toLowerCase(Locale.ENGLISH).endsWith(".class")) {
                    String name = jarEntry.getName().substring(0, jarEntry.getName().indexOf("."));
                    if ((name = name.replaceAll("/", "\\.")).contains(packageFilter)) {
                        try {
                            Class clazz = ClassUtils.getClass((String)name);
                            String alias = StringUtils.lowercaseFirstLetter((String)clazz.getSimpleName());
                            xstreamObject.alias(alias, clazz);
                            if (!clazz.equals(Model.class)) {
                                xstreamObject.omitField(clazz, "modelEncoding");
                            }
                        }
                        catch (ClassNotFoundException e) {
                            this.getLog().error((Throwable)e);
                        }
                    }
                }
                jarStream.closeEntry();
                jarEntry = jarStream.getNextJarEntry();
            }
            jarStream.close();
            jarStream = null;
        }
        catch (IOException e) {
            block10: {
                try {
                    if (!this.getLog().isDebugEnabled()) break block10;
                    this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtil.close(jarStream);
                    throw throwable;
                }
            }
            IOUtil.close((InputStream)jarStream);
        }
        IOUtil.close((InputStream)jarStream);
    }

    private File getMavenModelJarFile() throws MojoExecutionException, ProjectBuildingException, ArtifactResolverException {
        return this.getArtifactFile(true);
    }

    private File getMavenSettingsJarFile() throws MojoExecutionException, ProjectBuildingException, ArtifactResolverException {
        return this.getArtifactFile(false);
    }

    private File getArtifactFile(boolean isPom) throws MojoExecutionException, ProjectBuildingException, ArtifactResolverException {
        List dependencies = this.getHelpPluginPom().getDependencies();
        for (Dependency depependency : dependencies) {
            if (!depependency.getGroupId().equals("org.apache.maven") || (isPom ? !depependency.getArtifactId().equals("maven-model") : !depependency.getArtifactId().equals("maven-settings"))) continue;
            ArtifactCoordinate coordinate = this.getArtifactCoordinate(depependency.getGroupId(), depependency.getArtifactId(), depependency.getVersion(), "jar");
            DefaultProjectBuildingRequest pbr = new DefaultProjectBuildingRequest(this.session.getProjectBuildingRequest());
            pbr.setRemoteRepositories(this.remoteRepositories);
            return this.artifactResolver.resolveArtifact((ProjectBuildingRequest)pbr, coordinate).getArtifact().getFile();
        }
        throw new MojoExecutionException("Unable to find the 'org.apache.maven:" + (isPom ? "maven-model" : "maven-settings") + "' artifact");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MavenProject getHelpPluginPom() throws MojoExecutionException, ProjectBuildingException {
        String resource = "META-INF/maven/org.apache.maven.plugins/maven-help-plugin/pom.properties";
        InputStream resourceAsStream = EvaluateMojo.class.getClassLoader().getResourceAsStream(resource);
        if (resourceAsStream == null) {
            throw new MojoExecutionException("The help plugin artifact was not found.");
        }
        Properties properties = new Properties();
        try {
            properties.load(resourceAsStream);
        }
        catch (IOException e) {
            if (this.getLog().isDebugEnabled()) {
                this.getLog().debug((CharSequence)("IOException: " + e.getMessage()), (Throwable)e);
            }
        }
        finally {
            IOUtil.close((InputStream)resourceAsStream);
        }
        String artifactString = properties.getProperty("groupId", "unknown") + ":" + properties.getProperty("artifactId", "unknown") + ":" + properties.getProperty("version", "unknown");
        return this.getMavenProject(artifactString);
    }

    private static String pluralize(String name) {
        if (StringUtils.isEmpty((String)name)) {
            throw new IllegalArgumentException("name is required");
        }
        if (name.endsWith("y")) {
            return name.substring(0, name.length() - 1) + "ies";
        }
        if (name.endsWith("s")) {
            return name;
        }
        return name + "s";
    }
}

