/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ScmTckTestCase
extends ScmTestCase {
    private ScmRepository scmRepository;
    private List<String> scmFileNames;

    public abstract String getScmUrl() throws Exception;

    protected List<String> getScmFileNames() {
        return this.scmFileNames;
    }

    public abstract void initRepo() throws Exception;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.scmRepository = null;
        this.initRepo();
        this.checkOut(this.getWorkingCopy(), this.getScmRepository());
        this.scmFileNames = new ArrayList<String>(4);
        this.scmFileNames.add("/pom.xml");
        this.scmFileNames.add("/readme.txt");
        this.scmFileNames.add("/src/main/java/Application.java");
        this.scmFileNames.add("/src/test/java/Test.java");
        Iterator<String> it = this.getScmFileNames().iterator();
        while (it.hasNext()) {
            this.assertFile(this.getWorkingCopy(), it.next());
        }
    }

    protected ScmRepository getScmRepository() throws Exception {
        if (this.scmRepository == null) {
            this.scmRepository = this.getScmManager().makeScmRepository(this.getScmUrl());
        }
        return this.scmRepository;
    }

    protected CheckOutScmResult checkOut(File workingDirectory, ScmRepository repository) throws Exception {
        CheckOutScmResult result = this.getScmManager().getProviderByUrl(this.getScmUrl()).checkOut(repository, new ScmFileSet(workingDirectory), (ScmVersion)null);
        ScmTckTestCase.assertTrue((String)("Check result was successful, output: " + result.getCommandOutput()), (boolean)result.isSuccess());
        return result;
    }

    protected void addToWorkingTree(File workingDirectory, File file, ScmRepository repository) throws Exception {
        ScmProvider provider = this.getScmManager().getProviderByUrl(this.getScmUrl());
        AddScmResult result = provider.add(repository, new ScmFileSet(workingDirectory, file));
        ScmTckTestCase.assertTrue((String)("Check result was successful, output: " + result.getCommandOutput()), (boolean)result.isSuccess());
        List addedFiles = result.getAddedFiles();
        if (new File(workingDirectory, file.getPath()).isFile()) {
            ScmTckTestCase.assertEquals((String)("Expected 1 file in the added files list " + addedFiles), (int)1, (int)addedFiles.size());
        }
    }

    protected Map<String, ScmFile> mapFilesByPath(List<ScmFile> files) {
        if (files == null) {
            return null;
        }
        TreeMap<String, ScmFile> mappedFiles = new TreeMap<String, ScmFile>();
        for (ScmFile scmFile : files) {
            String path = StringUtils.replace((String)scmFile.getPath(), (String)"\\", (String)"/");
            mappedFiles.put(path, scmFile);
        }
        return mappedFiles;
    }
}

