/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.repository.ScmRepository;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public abstract class ScmTestCase
extends PlexusTestCase {
    protected static final TimeZone GMT_TIME_ZONE = TimeZone.getTimeZone("GMT");
    private static boolean debugExecute;
    private ScmManager scmManager;

    protected void setUp() throws Exception {
        super.setUp();
        FileUtils.deleteDirectory((File)this.getRepositoryRoot());
        ScmTestCase.assertFalse((boolean)this.getRepositoryRoot().exists());
        FileUtils.deleteDirectory((File)this.getWorkingCopy());
        ScmTestCase.assertFalse((boolean)this.getWorkingCopy().exists());
        FileUtils.deleteDirectory((File)this.getWorkingDirectory());
        ScmTestCase.assertFalse((boolean)this.getWorkingDirectory().exists());
        FileUtils.deleteDirectory((File)this.getAssertionCopy());
        ScmTestCase.assertFalse((boolean)this.getAssertionCopy().exists());
        FileUtils.deleteDirectory((File)this.getUpdatingCopy());
        ScmTestCase.assertFalse((boolean)this.getUpdatingCopy().exists());
        this.scmManager = null;
    }

    protected String getModule() {
        ScmTestCase.fail((String)"getModule() must be overridden.");
        return null;
    }

    protected File getRepositoryRoot() {
        return PlexusTestCase.getTestFile((String)"target/scm-test/repository");
    }

    protected File getRepository() {
        return PlexusTestCase.getTestFile((String)"/src/test/repository");
    }

    protected File getWorkingCopy() {
        return PlexusTestCase.getTestFile((String)"target/scm-test/working-copy");
    }

    protected File getWorkingDirectory() {
        return this.getWorkingCopy();
    }

    protected File getAssertionCopy() {
        return PlexusTestCase.getTestFile((String)"target/scm-test/assertion-copy");
    }

    protected File getUpdatingCopy() {
        return PlexusTestCase.getTestFile((String)"target/scm-test/updating-copy");
    }

    protected ScmManager getScmManager() throws Exception {
        if (this.scmManager == null) {
            this.scmManager = (ScmManager)this.lookup(ScmManager.ROLE);
        }
        return this.scmManager;
    }

    protected ScmRepository makeScmRepository(String scmUrl) throws Exception {
        return this.getScmManager().makeScmRepository(scmUrl);
    }

    public void assertPath(String expectedPath, String actualPath) throws Exception {
        ScmTestCase.assertEquals((String)StringUtils.replace((String)expectedPath, (String)"\\", (String)"/"), (String)StringUtils.replace((String)expectedPath, (String)"\\", (String)"/"));
    }

    protected void assertFile(File root, String fileName) throws Exception {
        File file = new File(root, fileName);
        ScmTestCase.assertTrue((String)("Missing file: '" + file.getAbsolutePath() + "'."), (boolean)file.exists());
        ScmTestCase.assertTrue((String)("File isn't a file: '" + file.getAbsolutePath() + "'."), (boolean)file.isFile());
        String expected = fileName;
        String actual = FileUtils.fileRead((File)file);
        ScmTestCase.assertEquals((String)("The file doesn't contain the expected contents. File: " + file.getAbsolutePath()), (String)expected, (String)actual);
    }

    protected void assertResultIsSuccess(ScmResult result) {
        if (result.isSuccess()) {
            return;
        }
        this.printOutputError(result);
        ScmTestCase.fail((String)"The check out result success flag was false.");
    }

    protected void printOutputError(ScmResult result) {
        System.err.println("----------------------------------------------------------------------");
        System.err.println("Provider message");
        System.err.println("----------------------------------------------------------------------");
        System.err.println(result.getProviderMessage());
        System.err.println("----------------------------------------------------------------------");
        System.err.println("----------------------------------------------------------------------");
        System.err.println("Command output");
        System.err.println("----------------------------------------------------------------------");
        System.err.println(result.getCommandOutput());
        System.err.println("----------------------------------------------------------------------");
    }

    protected ScmFileSet getScmFileSet() {
        return new ScmFileSet(this.getWorkingCopy());
    }

    protected static void setDebugExecute(boolean debugExecute) {
        ScmTestCase.debugExecute = debugExecute;
    }

    public static void execute(File workingDirectory, String executable, String arguments) throws Exception {
        Commandline cl = new Commandline();
        cl.setExecutable(executable);
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cl.addArguments(CommandLineUtils.translateCommandline((String)arguments));
        CommandLineUtils.StringStreamConsumer stdout = new CommandLineUtils.StringStreamConsumer();
        CommandLineUtils.StringStreamConsumer stderr = new CommandLineUtils.StringStreamConsumer();
        System.out.println("Test command line: " + cl);
        int exitValue = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)stdout, (StreamConsumer)stderr);
        if (debugExecute || exitValue != 0) {
            System.err.println("-----------------------------------------");
            System.err.println("Command line: " + cl);
            System.err.println("Working directory: " + cl.getWorkingDirectory());
            System.err.println("-----------------------------------------");
            System.err.println("Standard output: ");
            System.err.println("-----------------------------------------");
            System.err.println(stdout.getOutput());
            System.err.println("-----------------------------------------");
            System.err.println("Standard error: ");
            System.err.println("-----------------------------------------");
            System.err.println(stderr.getOutput());
            System.err.println("-----------------------------------------");
        }
        if (exitValue != 0) {
            ScmTestCase.fail((String)("Exit value wasn't 0, was:" + exitValue));
        }
    }

    protected static void makeDirectory(File basedir, String fileName) {
        File dir = new File(basedir, fileName);
        if (!dir.exists()) {
            ScmTestCase.assertTrue((boolean)dir.mkdirs());
        }
    }

    protected static void makeFile(File basedir, String fileName) throws IOException {
        ScmTestCase.makeFile(basedir, fileName, fileName);
    }

    public static void makeFile(File basedir, String fileName, String contents) throws IOException {
        File file = new File(basedir, fileName);
        File parent = file.getParentFile();
        if (!parent.exists()) {
            ScmTestCase.assertTrue((boolean)parent.mkdirs());
        }
        FileWriter writer = new FileWriter(file);
        writer.write(contents);
        writer.close();
    }

    public static Date getDate(int year, int month, int day) {
        return ScmTestCase.getDate(year, month, day, 0, 0, 0, null);
    }

    protected static Date getDate(int year, int month, int day, TimeZone tz) {
        return ScmTestCase.getDate(year, month, day, 0, 0, 0, tz);
    }

    protected static Date getDate(int year, int month, int day, int hourOfDay, int minute, int second, TimeZone tz) {
        Calendar cal = Calendar.getInstance();
        if (tz != null) {
            cal.setTimeZone(tz);
        }
        cal.set(year, month, day, hourOfDay, minute, second);
        cal.set(14, 0);
        return cal.getTime();
    }

    public void assertCommandLine(String expectedCommand, File expectedWorkingDirectory, Commandline actualCommand) throws IOException {
        Commandline cl = new Commandline(expectedCommand);
        if (expectedWorkingDirectory != null) {
            cl.setWorkingDirectory(expectedWorkingDirectory.getAbsolutePath());
        }
        ScmTestCase.assertEquals((String)cl.toString(), (String)actualCommand.toString());
    }

    public static boolean isSystemCmd(String cmd) {
        try {
            Runtime.getRuntime().exec(cmd);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }
}

