/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.blame;

import java.util.Date;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.command.blame.BlameLine;
import org.apache.maven.scm.command.blame.BlameScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

public abstract class BlameCommandTckTest
extends ScmTckTestCase {
    private static final String COMMIT_MSG = "Second changelog";

    public void testBlameCommand() throws Exception {
        ScmRepository repository = this.getScmRepository();
        ScmManager manager = this.getScmManager();
        ScmProvider provider = manager.getProviderByRepository(this.getScmRepository());
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        BlameScmResult result = manager.blame(repository, fileSet, "readme.txt");
        BlameCommandTckTest.assertNotNull((String)"The command returned a null result.", (Object)result);
        this.assertResultIsSuccess((ScmResult)result);
        BlameCommandTckTest.assertEquals((String)"Expected 1 line in blame", (int)1, (int)result.getLines().size());
        BlameLine line = (BlameLine)result.getLines().get(0);
        String initialRevision = line.getRevision();
        Date timeBeforeSecond = new Date();
        Thread.sleep(2000L);
        ScmTestCase.makeFile(this.getWorkingCopy(), "/readme.txt", "changed readme.txt");
        CheckInScmResult checkInResult = provider.checkIn(this.getScmRepository(), fileSet, COMMIT_MSG);
        BlameCommandTckTest.assertTrue((String)"Unable to checkin changes to the repository", (boolean)checkInResult.isSuccess());
        result = manager.blame(repository, fileSet, "readme.txt");
        Thread.sleep(2000L);
        Date timeAfterSecond = new Date();
        BlameCommandTckTest.assertNotNull((String)"The command returned a null result.", (Object)result);
        this.assertResultIsSuccess((ScmResult)result);
        BlameCommandTckTest.assertEquals((String)"Expected 1 line in blame", (int)1, (int)result.getLines().size());
        line = (BlameLine)result.getLines().get(0);
        BlameCommandTckTest.assertNotNull((String)"Expected not null author", (Object)line.getAuthor());
        BlameCommandTckTest.assertNotNull((String)"Expected not null revision", (Object)line.getRevision());
        BlameCommandTckTest.assertNotNull((String)"Expected not null date", (Object)line.getDate());
        BlameCommandTckTest.assertTrue((String)"Expected another revision", (!initialRevision.equals(line.getRevision()) ? 1 : 0) != 0);
        if (this.isTestDateTime()) {
            this.assertDateBetween(timeBeforeSecond, timeAfterSecond, line.getDate());
        }
        result = manager.blame(repository, fileSet, "pom.xml");
        BlameCommandTckTest.assertNotNull((String)"The command returned a null result.", (Object)result);
        this.assertResultIsSuccess((ScmResult)result);
        this.verifyResult(result);
    }

    protected boolean isTestDateTime() {
        return true;
    }

    protected void assertDateBetween(Date start, Date end, Date actual) {
        BlameCommandTckTest.assertTrue((String)("Expected date between " + start + " and " + end + ", but was " + actual), (start.before(actual) && actual.before(end) ? 1 : 0) != 0);
    }

    protected abstract void verifyResult(BlameScmResult var1);
}

