/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.changelog;

import java.util.Date;
import org.apache.maven.scm.ChangeSet;
import org.apache.maven.scm.ScmBranch;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmTestCase;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.provider.ScmProvider;

public abstract class ChangeLogCommandTckTest
extends ScmTckTestCase {
    private static final String COMMIT_MSG = "Second changelog";

    public void testChangeLogCommand() throws Exception {
        Thread.sleep(1000L);
        ScmProvider provider = this.getScmManager().getProviderByRepository(this.getScmRepository());
        ScmFileSet fileSet = new ScmFileSet(this.getWorkingCopy());
        ChangeLogScmResult result = provider.changeLog(this.getScmRepository(), fileSet, null, null, 0, (ScmBranch)null, null);
        ChangeLogCommandTckTest.assertTrue((boolean)result.isSuccess());
        ChangeLogCommandTckTest.assertEquals((int)1, (int)result.getChangeLog().getChangeSets().size());
        Date timeBeforeSecond = new Date();
        Thread.sleep(2000L);
        ScmTestCase.makeFile(this.getWorkingCopy(), "/readme.txt", "changed readme.txt");
        CheckInScmResult checkInResult = provider.checkIn(this.getScmRepository(), fileSet, COMMIT_MSG);
        ChangeLogCommandTckTest.assertTrue((String)"Unable to checkin changes to the repository", (boolean)checkInResult.isSuccess());
        result = provider.changeLog(this.getScmRepository(), fileSet, (ScmVersion)null, null);
        ChangeLogCommandTckTest.assertTrue((boolean)result.isSuccess());
        ChangeLogCommandTckTest.assertEquals((int)2, (int)result.getChangeLog().getChangeSets().size());
        Date currentTime = new Date();
        result = provider.changeLog(this.getScmRepository(), fileSet, timeBeforeSecond, currentTime, 0, new ScmBranch(""));
        ChangeLogCommandTckTest.assertTrue((boolean)result.isSuccess());
        ChangeLogCommandTckTest.assertEquals((int)1, (int)result.getChangeLog().getChangeSets().size());
        ChangeSet changeset = (ChangeSet)result.getChangeLog().getChangeSets().get(0);
        ChangeLogCommandTckTest.assertTrue((boolean)changeset.getDate().after(timeBeforeSecond));
        ChangeLogCommandTckTest.assertEquals((String)COMMIT_MSG, (String)changeset.getComment());
    }
}

