/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.tck.command.tag;

import java.io.File;
import java.io.FileWriter;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.ScmTag;
import org.apache.maven.scm.ScmTckTestCase;
import org.apache.maven.scm.ScmVersion;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.codehaus.plexus.util.FileUtils;

public abstract class TagCommandTckTest
extends ScmTckTestCase {
    public void testTagCommandTest() throws Exception {
        String tag = "test-tag";
        TagScmResult tagResult = this.getScmManager().getProviderByUrl(this.getScmUrl()).tag(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy()), tag);
        this.assertResultIsSuccess((ScmResult)tagResult);
        TagCommandTckTest.assertEquals((String)"check all 4 files tagged", (int)4, (int)tagResult.getTaggedFiles().size());
        File readmeTxt = new File(this.getWorkingCopy(), "readme.txt");
        TagCommandTckTest.assertEquals((String)"check readme.txt contents", (String)"/readme.txt", (String)FileUtils.fileRead((File)readmeTxt));
        this.changeReadmeTxt(readmeTxt);
        CheckInScmResult checkinResult = this.getScmManager().checkIn(this.getScmRepository(), new ScmFileSet(this.getWorkingCopy()), "commit message");
        this.assertResultIsSuccess((ScmResult)checkinResult);
        CheckOutScmResult checkoutResult = this.getScmManager().checkOut(this.getScmRepository(), new ScmFileSet(this.getAssertionCopy()));
        this.assertResultIsSuccess((ScmResult)checkoutResult);
        readmeTxt = new File(this.getAssertionCopy(), "readme.txt");
        TagCommandTckTest.assertEquals((String)"check readme.txt contents", (String)"changed file", (String)FileUtils.fileRead((File)readmeTxt));
        FileUtils.deleteDirectory((File)this.getAssertionCopy());
        TagCommandTckTest.assertFalse((String)"check previous assertion copy deleted", (boolean)this.getAssertionCopy().exists());
        checkoutResult = this.getScmManager().getProviderByUrl(this.getScmUrl()).checkOut(this.getScmRepository(), new ScmFileSet(this.getAssertionCopy()), (ScmVersion)new ScmTag(tag));
        this.assertResultIsSuccess((ScmResult)checkoutResult);
        TagCommandTckTest.assertEquals((String)"check readme.txt contents is from tagged version", (String)"/readme.txt", (String)FileUtils.fileRead((File)readmeTxt));
    }

    private void changeReadmeTxt(File readmeTxt) throws Exception {
        FileWriter output = new FileWriter(readmeTxt);
        output.write("changed file");
        output.close();
    }
}

