/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.http;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.maven.wagon.ConnectionException;
import org.apache.maven.wagon.FileTestUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.StreamingWagon;
import org.apache.maven.wagon.StreamingWagonTestCase;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.authentication.AuthenticationException;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.apache.maven.wagon.resource.Resource;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringOutputStream;
import org.mortbay.jetty.Handler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.HttpConnection;
import org.mortbay.jetty.Request;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.handler.AbstractHandler;
import org.mortbay.jetty.handler.HandlerCollection;
import org.mortbay.jetty.security.Constraint;
import org.mortbay.jetty.security.ConstraintMapping;
import org.mortbay.jetty.security.HashUserRealm;
import org.mortbay.jetty.security.SecurityHandler;
import org.mortbay.jetty.security.UserRealm;
import org.mortbay.jetty.servlet.Context;
import org.mortbay.jetty.servlet.DefaultServlet;
import org.mortbay.jetty.servlet.ServletHolder;

public abstract class HttpWagonTestCase
extends StreamingWagonTestCase {
    private Server server;

    protected void setupWagonTestingFixtures() throws Exception {
        File file = FileTestUtils.createUniqueFile("local-repository", "test-resource");
        file.delete();
        file.getParentFile().mkdirs();
        File repositoryDirectory = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)repositoryDirectory);
        repositoryDirectory.mkdirs();
        this.server = new Server(10007);
        PutHandler putHandler = new PutHandler(repositoryDirectory);
        this.server.addHandler((Handler)putHandler);
        this.createContext(this.server, repositoryDirectory);
        this.addConnectors(this.server);
        this.server.start();
    }

    protected void createContext(Server server, File repositoryDirectory) throws IOException {
        Context root = new Context((HandlerContainer)server, "/", 1);
        root.setResourceBase(repositoryDirectory.getAbsolutePath());
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(servletHolder, "/*");
    }

    protected void tearDownWagonTestingFixtures() throws Exception {
        this.server.stop();
    }

    public void testWagonGetFileList() throws Exception {
        File dir = this.getRepositoryDirectory();
        FileUtils.deleteDirectory((File)dir);
        File f = new File(dir, "file-list");
        f.mkdirs();
        super.testWagonGetFileList();
    }

    public void testHttpHeaders() throws Exception {
        Properties properties = new Properties();
        properties.setProperty("User-Agent", "Maven-Wagon/1.0");
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        this.setHttpHeaders(wagon, properties);
        Server server = new Server(0);
        TestHeaderHandler handler = new TestHeaderHandler();
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getProtocol() + "://localhost:" + server.getConnectors()[0].getLocalPort()));
        wagon.getToStream("resource", (OutputStream)new StringOutputStream());
        wagon.disconnect();
        server.stop();
        HttpWagonTestCase.assertEquals((Object)"Maven-Wagon/1.0", handler.headers.get("User-Agent"));
    }

    protected abstract void setHttpHeaders(StreamingWagon var1, Properties var2);

    protected void addConnectors(Server server) {
    }

    protected String getRepositoryUrl(Server server) {
        int localPort = server.getConnectors()[0].getLocalPort();
        return this.getProtocol() + "://localhost:" + localPort;
    }

    public void testGetForbidden() throws Exception {
        try {
            this.runTestGet(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testGet404() throws Exception {
        try {
            this.runTestGet(404);
            HttpWagonTestCase.fail();
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testGet500() throws Exception {
        try {
            this.runTestGet(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestGet(int status) throws Exception, ConnectionException, AuthenticationException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        StatusHandler handler = new StatusHandler();
        handler.setStatusToReturn(status);
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        try {
            wagon.getToStream("resource", (OutputStream)new StringOutputStream());
            HttpWagonTestCase.fail();
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
    }

    public void testResourceExistsForbidden() throws Exception {
        try {
            this.runTestResourceExists(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testResourceExists404() throws Exception {
        try {
            HttpWagonTestCase.assertFalse((boolean)this.runTestResourceExists(404));
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testResourceExists500() throws Exception {
        try {
            this.runTestResourceExists(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runTestResourceExists(int status) throws Exception, ConnectionException, AuthenticationException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        StatusHandler handler = new StatusHandler();
        handler.setStatusToReturn(status);
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        try {
            boolean bl = wagon.resourceExists("resource");
            return bl;
        }
        finally {
            wagon.disconnect();
            server.stop();
        }
    }

    protected long getExpectedLastModifiedOnGet(Repository repository, Resource resource) {
        File file = new File(this.getRepositoryDirectory(), resource.getName());
        return file.lastModified() / 1000L * 1000L;
    }

    protected File getRepositoryDirectory() {
        return HttpWagonTestCase.getTestFile((String)"target/test-output/http-repository");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGzipGet() throws Exception {
        Server server = new Server(10008);
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Context root = new Context((HandlerContainer)server, "/", 1);
        root.setResourceBase(localRepositoryPath);
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        servletHolder.setInitParameter("gzip", "true");
        root.addServlet(servletHolder, "/*");
        this.addConnectors(server);
        server.start();
        try {
            Wagon wagon = this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath + "/gzip");
            sourceFile.deleteOnExit();
            String resName = "gzip-res.txt";
            String sourceContent = this.writeTestFileGzip(sourceFile, resName);
            wagon.connect(testRepository);
            File destFile = FileTestUtils.createUniqueFile(this.getName(), this.getName());
            destFile.deleteOnExit();
            wagon.get("gzip/" + resName, destFile);
            wagon.disconnect();
            String destContent = FileUtils.fileRead((File)destFile);
            HttpWagonTestCase.assertEquals((String)sourceContent, (String)destContent);
        }
        finally {
            server.stop();
        }
    }

    public void testProxiedRequest() throws Exception {
        ProxyInfo proxyInfo = this.createProxyInfo();
        TestHeaderHandler handler = new TestHeaderHandler();
        this.runTestProxiedRequest(proxyInfo, handler);
    }

    public void testProxiedRequestWithAuthentication() throws Exception {
        ProxyInfo proxyInfo = this.createProxyInfo();
        proxyInfo.setUserName("user");
        proxyInfo.setPassword("secret");
        AuthorizingProxyHandler handler = new AuthorizingProxyHandler();
        this.runTestProxiedRequest(proxyInfo, handler);
        HttpWagonTestCase.assertTrue((boolean)((TestHeaderHandler)handler).headers.containsKey("Proxy-Authorization"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestProxiedRequest(ProxyInfo proxyInfo, TestHeaderHandler handler) throws Exception, IOException, ConnectionException, AuthenticationException, ResourceDoesNotExistException, TransferFailedException, AuthorizationException {
        Server proxyServer = new Server(10007);
        proxyServer.setHandler((Handler)handler);
        proxyServer.start();
        proxyInfo.setPort(10007);
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", "http://www.example.com/");
            String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
            File sourceFile = new File(localRepositoryPath, "test-proxied-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"content");
            wagon.connect(testRepository, proxyInfo);
            StringOutputStream out = new StringOutputStream();
            try {
                wagon.getToStream("test-proxied-resource", (OutputStream)out);
                HttpWagonTestCase.assertTrue((boolean)handler.headers.containsKey("Proxy-Connection"));
            }
            finally {
                wagon.disconnect();
            }
        }
        finally {
            proxyServer.stop();
        }
    }

    private ProxyInfo createProxyInfo() {
        ProxyInfo proxyInfo = new ProxyInfo();
        proxyInfo.setHost("localhost");
        proxyInfo.setNonProxyHosts(null);
        proxyInfo.setType("http");
        return proxyInfo;
    }

    public void testSecuredGetUnauthorized() throws Exception {
        try {
            this.runTestSecuredGet(null);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredGetWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredGet(authInfo);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredGet() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredGet(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredGet(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            StringOutputStream out = new StringOutputStream();
            try {
                wagon.getToStream("test-secured-resource", (OutputStream)out);
            }
            finally {
                wagon.disconnect();
            }
            HttpWagonTestCase.assertEquals((String)"top secret", (String)out.toString());
        }
        finally {
            server.stop();
        }
    }

    public void testSecuredResourceExistsUnauthorized() throws Exception {
        try {
            this.runTestSecuredResourceExists(null);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredResourceExistsWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredResourceExists(authInfo);
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredResourceExists() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredResourceExists(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredResourceExists(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = this.createSecurityServer(localRepositoryPath);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            File sourceFile = new File(localRepositoryPath, "test-secured-resource-exists");
            FileUtils.fileWrite((String)sourceFile.getAbsolutePath(), (String)"top secret");
            wagon.connect(testRepository, authInfo);
            try {
                HttpWagonTestCase.assertTrue((boolean)wagon.resourceExists("test-secured-resource-exists"));
                HttpWagonTestCase.assertFalse((boolean)wagon.resourceExists("test-secured-resource-not-exists"));
            }
            finally {
                wagon.disconnect();
            }
        }
        finally {
            server.stop();
        }
    }

    private Server createSecurityServer(String localRepositoryPath) {
        Server server = new Server(0);
        SecurityHandler sh = this.createSecurityHandler();
        Context root = new Context(1);
        root.setContextPath("/");
        root.addHandler((Handler)sh);
        root.setResourceBase(localRepositoryPath);
        ServletHolder servletHolder = new ServletHolder((Servlet)new DefaultServlet());
        root.addServlet(servletHolder, "/*");
        server.setHandler((Handler)root);
        this.addConnectors(server);
        return server;
    }

    protected SecurityHandler createSecurityHandler() {
        Constraint constraint = new Constraint();
        constraint.setName("BASIC");
        constraint.setRoles(new String[]{"admin"});
        constraint.setAuthenticate(true);
        ConstraintMapping cm = new ConstraintMapping();
        cm.setConstraint(constraint);
        cm.setPathSpec("/*");
        SecurityHandler sh = new SecurityHandler();
        HashUserRealm hashUserRealm = new HashUserRealm("MyRealm");
        hashUserRealm.put((Object)"user", (Object)"secret");
        hashUserRealm.addUserToRole("user", "admin");
        sh.setUserRealm((UserRealm)hashUserRealm);
        sh.setConstraintMappings(new ConstraintMapping[]{cm});
        return sh;
    }

    private String writeTestFileGzip(File parent, String child) throws IOException {
        File file = new File(parent, child);
        file.getParentFile().mkdirs();
        file.deleteOnExit();
        OutputStream out = new FileOutputStream(file);
        out.write(child.getBytes());
        out.close();
        file = new File(parent, child + ".gz");
        file.deleteOnExit();
        out = new FileOutputStream(file);
        out = new GZIPOutputStream(out);
        String content = file.getAbsolutePath();
        out.write(content.getBytes());
        out.close();
        return content;
    }

    public void testPutForbidden() throws Exception {
        try {
            this.runTestPut(403);
            HttpWagonTestCase.fail();
        }
        catch (AuthorizationException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testPut404() throws Exception {
        try {
            this.runTestPut(404);
            HttpWagonTestCase.fail();
        }
        catch (ResourceDoesNotExistException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testPut500() throws Exception {
        try {
            this.runTestPut(500);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTestPut(int status) throws Exception, ConnectionException, AuthenticationException, TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        StreamingWagon wagon = (StreamingWagon)this.getWagon();
        Server server = new Server(0);
        StatusHandler handler = new StatusHandler();
        handler.setStatusToReturn(status);
        server.setHandler((Handler)handler);
        this.addConnectors(server);
        server.start();
        wagon.connect(new Repository("id", this.getRepositoryUrl(server)));
        File tempFile = File.createTempFile("wagon", "tmp");
        tempFile.deleteOnExit();
        FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"content");
        try {
            wagon.put(tempFile, "resource");
            HttpWagonTestCase.fail();
        }
        finally {
            wagon.disconnect();
            server.stop();
            tempFile.delete();
        }
    }

    public void testSecuredPutUnauthorized() throws Exception {
        try {
            this.runTestSecuredPut(null);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredPutWrongPassword() throws Exception {
        try {
            AuthenticationInfo authInfo = new AuthenticationInfo();
            authInfo.setUserName("user");
            authInfo.setPassword("admin");
            this.runTestSecuredPut(authInfo);
            HttpWagonTestCase.fail();
        }
        catch (TransferFailedException e) {
            HttpWagonTestCase.assertTrue((boolean)true);
        }
    }

    public void testSecuredPut() throws Exception {
        AuthenticationInfo authInfo = new AuthenticationInfo();
        authInfo.setUserName("user");
        authInfo.setPassword("secret");
        this.runTestSecuredPut(authInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runTestSecuredPut(AuthenticationInfo authInfo) throws Exception {
        String localRepositoryPath = FileTestUtils.getTestOutputDir().toString();
        Server server = new Server(0);
        SecurityHandler sh = this.createSecurityHandler();
        PutHandler handler = new PutHandler(new File(localRepositoryPath));
        HandlerCollection handlers = new HandlerCollection();
        handlers.setHandlers(new Handler[]{sh, handler});
        server.setHandler((Handler)handlers);
        this.addConnectors(server);
        server.start();
        try {
            StreamingWagon wagon = (StreamingWagon)this.getWagon();
            Repository testRepository = new Repository("id", this.getRepositoryUrl(server));
            wagon.connect(testRepository, authInfo);
            File sourceFile = new File(localRepositoryPath, "test-secured-put-resource");
            sourceFile.delete();
            HttpWagonTestCase.assertFalse((boolean)sourceFile.exists());
            File tempFile = File.createTempFile("wagon", "tmp");
            tempFile.deleteOnExit();
            FileUtils.fileWrite((String)tempFile.getAbsolutePath(), (String)"put top secret");
            try {
                wagon.put(tempFile, "test-secured-put-resource");
            }
            finally {
                wagon.disconnect();
                tempFile.delete();
            }
            HttpWagonTestCase.assertEquals((String)"put top secret", (String)FileUtils.fileRead((String)sourceFile.getAbsolutePath()));
        }
        finally {
            server.stop();
        }
    }

    private static class TestHeaderHandler
    extends AbstractHandler {
        private Map headers;

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            this.headers = new HashMap();
            Enumeration e = request.getHeaderNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                this.headers.put(name, request.getHeader(name));
            }
            response.setContentType("text/plain");
            response.setStatus(200);
            response.getWriter().println("Hello, World!");
            ((Request)request).setHandled(true);
        }
    }

    private static class AuthorizingProxyHandler
    extends TestHeaderHandler {
        private AuthorizingProxyHandler() {
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            if (request.getHeader("Proxy-Authorization") == null) {
                response.setStatus(407);
                response.addHeader("Proxy-Authenticate", "Basic realm=\"Squid proxy-caching web server\"");
                ((Request)request).setHandled(true);
                return;
            }
            super.handle(target, request, response, dispatch);
        }
    }

    static class PutHandler
    extends AbstractHandler {
        private final File resourceBase;

        public PutHandler(File repositoryDirectory) {
            this.resourceBase = repositoryDirectory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            Request base_request;
            Request request2 = base_request = request instanceof Request ? (Request)request : HttpConnection.getCurrentConnection().getRequest();
            if (base_request.isHandled() || !"PUT".equals(base_request.getMethod())) {
                return;
            }
            base_request.setHandled(true);
            File file = new File(this.resourceBase, URLDecoder.decode(request.getPathInfo()));
            file.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            ServletInputStream in = request.getInputStream();
            try {
                IOUtil.copy((InputStream)in, (OutputStream)out);
            }
            finally {
                in.close();
                out.close();
            }
            response.setStatus(201);
        }
    }

    static class StatusHandler
    extends AbstractHandler {
        private int status;

        StatusHandler() {
        }

        public void setStatusToReturn(int status) {
            this.status = status;
        }

        public void handle(String target, HttpServletRequest request, HttpServletResponse response, int dispatch) throws IOException, ServletException {
            if (this.status != 0) {
                response.setStatus(this.status);
                ((Request)request).setHandled(true);
            }
        }
    }
}

