/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.ssh;

import java.io.File;
import java.io.IOException;
import org.codehaus.plexus.util.FileUtils;

public class TestData {
    public static String getTempDirectory() {
        return System.getProperty("java.io.tmpdir", "/tmp");
    }

    public static String getTestRepositoryUrl() {
        return "scp://" + TestData.getHostname() + TestData.getTempDirectory() + "/wagon-ssh-test/" + TestData.getUserName();
    }

    public static String getUserName() {
        return System.getProperty("test.user", System.getProperty("user.name"));
    }

    public static File getPrivateKey() {
        return new File(System.getProperty("user.home"), "/.ssh/id_dsa");
    }

    public static String getHostname() {
        return System.getProperty("test.host", "localhost");
    }

    public static String getHostKey() {
        try {
            return FileUtils.fileRead((String)"/etc/ssh_host_rsa_key.pub").substring("ssh-rsa".length()).trim();
        }
        catch (IOException e) {
            return null;
        }
    }
}

