/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.transport.serial;

import java.net.SocketAddress;
import java.security.InvalidParameterException;

public class SerialAddress
extends SocketAddress {
    private static final long serialVersionUID = 1735370510442384505L;
    private final String name;
    private final int bauds;
    private final DataBits dataBits;
    private final StopBits stopBits;
    private final Parity parity;
    private final FlowControl flowControl;

    public SerialAddress(String name, int bauds, DataBits dataBits, StopBits stopBits, Parity parity, FlowControl flowControl) {
        if (name == null) {
            throw new NullPointerException("name");
        }
        if ((name = name.trim()).length() == 0) {
            throw new IllegalArgumentException("Empty name.");
        }
        if (bauds <= 0) {
            throw new IllegalArgumentException("bauds: " + bauds);
        }
        if (dataBits == null) {
            throw new NullPointerException("dataBits");
        }
        if (stopBits == null) {
            throw new NullPointerException("stopBits");
        }
        if (parity == null) {
            throw new NullPointerException("parity");
        }
        if (flowControl == null) {
            throw new NullPointerException("flowControl");
        }
        this.name = name;
        this.bauds = bauds;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        this.parity = parity;
        this.flowControl = flowControl;
    }

    public int getBauds() {
        return this.bauds;
    }

    public DataBits getDataBits() {
        return this.dataBits;
    }

    public FlowControl getFlowControl() {
        return this.flowControl;
    }

    public String getName() {
        return this.name;
    }

    public Parity getParity() {
        return this.parity;
    }

    public StopBits getStopBits() {
        return this.stopBits;
    }

    public String toString() {
        return this.name + " (bauds: " + this.bauds + ", dataBits: " + (Object)((Object)this.dataBits) + ", stopBits: " + (Object)((Object)this.stopBits) + ", parity: " + (Object)((Object)this.parity) + ", flowControl: " + (Object)((Object)this.flowControl) + ")";
    }

    int getDataBitsForRXTX() {
        switch (this.dataBits) {
            case DATABITS_5: {
                return 5;
            }
            case DATABITS_6: {
                return 6;
            }
            case DATABITS_7: {
                return 7;
            }
            case DATABITS_8: {
                return 8;
            }
        }
        throw new InvalidParameterException("broken databits");
    }

    int getStopBitsForRXTX() {
        switch (this.stopBits) {
            case BITS_1: {
                return 1;
            }
            case BITS_1_5: {
                return 3;
            }
            case BITS_2: {
                return 2;
            }
        }
        throw new InvalidParameterException("broken stopbits");
    }

    int getParityForRXTX() {
        switch (this.parity) {
            case EVEN: {
                return 2;
            }
            case MARK: {
                return 3;
            }
            case NONE: {
                return 0;
            }
            case ODD: {
                return 1;
            }
            case SPACE: {
                return 4;
            }
        }
        throw new InvalidParameterException("broken parity");
    }

    int getFLowControlForRXTX() {
        switch (this.flowControl) {
            case NONE: {
                return 0;
            }
            case RTSCTS_IN: {
                return 1;
            }
            case RTSCTS_OUT: {
                return 2;
            }
            case XONXOFF_IN: {
                return 4;
            }
            case XONXOFF_OUT: {
                return 8;
            }
        }
        throw new InvalidParameterException("broken stopbits");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FlowControl {
        NONE,
        RTSCTS_IN,
        RTSCTS_OUT,
        XONXOFF_IN,
        XONXOFF_OUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum StopBits {
        BITS_1,
        BITS_2,
        BITS_1_5;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parity {
        NONE,
        ODD,
        EVEN,
        MARK,
        SPACE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DataBits {
        DATABITS_5,
        DATABITS_6,
        DATABITS_7,
        DATABITS_8;

    }
}

