/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.processor;

import java.io.IOException;
import java.util.Set;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.rt.RuntimeDelegate;

public abstract class ODataResponse {
    protected ODataResponse() {
    }

    public abstract HttpStatusCodes getStatus();

    public abstract Object getEntity();

    public abstract void close() throws IOException;

    public abstract String getHeader(String var1);

    public abstract String getContentHeader();

    public abstract String getIdLiteral();

    public abstract String getETag();

    public abstract Set<String> getHeaderNames();

    public abstract boolean containsHeader(String var1);

    public static ODataResponseBuilder status(HttpStatusCodes status) {
        return ODataResponse.newBuilder().status(status);
    }

    public static ODataResponseBuilder fromResponse(ODataResponse response) {
        return ODataResponse.newBuilder().fromResponse(response);
    }

    public static ODataResponseBuilder entity(Object entity) {
        return ODataResponse.newBuilder().entity(entity);
    }

    public static ODataResponseBuilder header(String name, String value) {
        return ODataResponse.newBuilder().header(name, value);
    }

    public static ODataResponseBuilder contentHeader(String value) {
        return ODataResponse.newBuilder().contentHeader(value);
    }

    public static ODataResponseBuilder newBuilder() {
        return ODataResponseBuilder.newInstance();
    }

    public static abstract class ODataResponseBuilder {
        protected ODataResponseBuilder() {
        }

        private static ODataResponseBuilder newInstance() {
            return RuntimeDelegate.createODataResponseBuilder();
        }

        public abstract ODataResponse build();

        public abstract ODataResponseBuilder status(HttpStatusCodes var1);

        public abstract ODataResponseBuilder entity(Object var1);

        public abstract ODataResponseBuilder header(String var1, String var2);

        public abstract ODataResponseBuilder idLiteral(String var1);

        public abstract ODataResponseBuilder eTag(String var1);

        public abstract ODataResponseBuilder contentHeader(String var1);

        protected abstract ODataResponseBuilder fromResponse(ODataResponse var1);
    }
}

