/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.api.rt;

import java.io.InputStream;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSet;
import org.apache.olingo.odata2.api.client.batch.BatchChangeSetPart;
import org.apache.olingo.odata2.api.client.batch.BatchQueryPart;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeFacade;
import org.apache.olingo.odata2.api.edm.EdmSimpleTypeKind;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.UriParser;

public abstract class RuntimeDelegate {
    private static final String IMPLEMENTATION = "org.apache.olingo.odata2.core.rt.RuntimeDelegateImpl";

    private static RuntimeDelegateInstance getInstance() {
        RuntimeDelegateInstance delegate;
        try {
            Class<?> clazz = Class.forName(IMPLEMENTATION);
            Object object = clazz.newInstance();
            delegate = (RuntimeDelegateInstance)object;
        }
        catch (Exception e) {
            throw new RuntimeDelegateException(e);
        }
        return delegate;
    }

    public static EdmSimpleType getEdmSimpleType(EdmSimpleTypeKind edmSimpleTypeKind) {
        return RuntimeDelegate.getInstance().getEdmSimpleType(edmSimpleTypeKind);
    }

    public static EdmSimpleTypeFacade getSimpleTypeFacade() {
        return RuntimeDelegate.getInstance().getSimpleTypeFacade();
    }

    public static ODataResponse.ODataResponseBuilder createODataResponseBuilder() {
        return RuntimeDelegate.getInstance().createODataResponseBuilder();
    }

    public static Edm createEdm(EdmProvider provider) {
        return RuntimeDelegate.getInstance().createEdm(provider);
    }

    public static UriParser getUriParser(Edm edm) {
        return RuntimeDelegate.getInstance().getUriParser(edm);
    }

    public static EntityProvider.EntityProviderInterface createEntityProvider() {
        return RuntimeDelegate.getInstance().createEntityProvider();
    }

    public static ODataService createODataSingleProcessorService(EdmProvider provider, ODataSingleProcessor processor) {
        return RuntimeDelegate.getInstance().createODataSingleProcessorService(provider, processor);
    }

    public static EdmProvider createEdmProvider(InputStream metadataXml, boolean validate) throws EntityProviderException {
        return RuntimeDelegate.getInstance().createEdmProvider(metadataXml, validate);
    }

    public static BatchResponsePart.BatchResponsePartBuilder createBatchResponsePartBuilder() {
        return RuntimeDelegate.getInstance().createBatchResponsePartBuilder();
    }

    public static ODataRequest.ODataRequestBuilder createODataRequestBuilder() {
        return RuntimeDelegate.getInstance().createODataRequestBuilder();
    }

    public static BatchChangeSet.BatchChangeSetBuilder createBatchChangeSetBuilder() {
        return RuntimeDelegate.getInstance().createBatchChangeSetBuilder();
    }

    public static BatchQueryPart.BatchQueryPartBuilder createBatchQueryPartBuilder() {
        return RuntimeDelegate.getInstance().createBatchQueryRequestBuilder();
    }

    public static BatchChangeSetPart.BatchChangeSetPartBuilder createBatchChangeSetPartBuilder() {
        return RuntimeDelegate.getInstance().createBatchChangeSetRequest();
    }

    public static ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder createExpandSelectTreeNodeBuilder() {
        return RuntimeDelegate.getInstance().createExpandSelectTreeNodeBuilder();
    }

    private static class RuntimeDelegateException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RuntimeDelegateException(Exception e) {
            super(e);
        }
    }

    public static abstract class RuntimeDelegateInstance {
        protected abstract ODataResponse.ODataResponseBuilder createODataResponseBuilder();

        protected abstract EdmSimpleType getEdmSimpleType(EdmSimpleTypeKind var1);

        protected abstract UriParser getUriParser(Edm var1);

        protected abstract EdmSimpleTypeFacade getSimpleTypeFacade();

        protected abstract Edm createEdm(EdmProvider var1);

        protected abstract EntityProvider.EntityProviderInterface createEntityProvider();

        protected abstract ODataService createODataSingleProcessorService(EdmProvider var1, ODataSingleProcessor var2);

        protected abstract EdmProvider createEdmProvider(InputStream var1, boolean var2) throws EntityProviderException;

        protected abstract BatchResponsePart.BatchResponsePartBuilder createBatchResponsePartBuilder();

        protected abstract ODataRequest.ODataRequestBuilder createODataRequestBuilder();

        protected abstract BatchChangeSet.BatchChangeSetBuilder createBatchChangeSetBuilder();

        protected abstract BatchQueryPart.BatchQueryPartBuilder createBatchQueryRequestBuilder();

        protected abstract BatchChangeSetPart.BatchChangeSetPartBuilder createBatchChangeSetRequest();

        public abstract ExpandSelectTreeNode.ExpandSelectTreeNodeBuilder createExpandSelectTreeNodeBuilder();
    }
}

