/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.collect.Multimap;
import com.google.common.eventbus.AnnotatedSubscriberFinder;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.EventSubscriber;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import org.apache.servicecomb.foundation.common.concurrent.ConcurrentHashMapEx;

public class SimpleEventBus
extends EventBus {
    private AnnotatedSubscriberFinder finder = new AnnotatedSubscriberFinder();
    private Map<Class<?>, List<EventSubscriber>> subscribersByType = new ConcurrentHashMapEx();

    public void register(Object listener) {
        Multimap methodsInListener = this.finder.findAllSubscribers(listener);
        for (Map.Entry entry : methodsInListener.asMap().entrySet()) {
            List exists = this.subscribersByType.computeIfAbsent((Class<?>)entry.getKey(), (Function<Class<?>, List<EventSubscriber>>)((Function<Class, List>)cls -> new CopyOnWriteArrayList()));
            exists.addAll((Collection)entry.getValue());
        }
    }

    public void unregister(Object listener) {
        Multimap methodsInListener = this.finder.findAllSubscribers(listener);
        for (Map.Entry entry : methodsInListener.asMap().entrySet()) {
            List<EventSubscriber> exists = this.subscribersByType.get(entry.getKey());
            if (exists == null) continue;
            exists.removeAll((Collection)entry.getValue());
        }
    }

    public void post(Object event) {
        Set dispatchTypes = this.flattenHierarchy(event.getClass());
        for (Class dispatchType : dispatchTypes) {
            List subscribers = this.subscribersByType.getOrDefault(dispatchType, Collections.emptyList());
            for (EventSubscriber subscriber : subscribers) {
                this.dispatch(event, subscriber);
            }
        }
    }
}

