/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.common.utils;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class JsonUtils {
    public static final ObjectMapper OBJ_MAPPER = new ObjectMapper();

    private JsonUtils() {
    }

    public static <T> T readValue(byte[] src, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)OBJ_MAPPER.readValue(src, valueType);
    }

    public static <T> T readValue(InputStream is, Class<T> valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)OBJ_MAPPER.readValue(is, valueType);
    }

    public static <T> T readValue(InputStream is, JavaType valueType) throws JsonParseException, JsonMappingException, IOException {
        return (T)OBJ_MAPPER.readValue(is, valueType);
    }

    public static byte[] writeValueAsBytes(Object value) throws JsonProcessingException {
        return OBJ_MAPPER.writeValueAsBytes(value);
    }

    public static String writeValueAsString(Object value) throws JsonProcessingException {
        return OBJ_MAPPER.writeValueAsString(value);
    }

    public static <T> T convertValue(Object fromValue, Class<T> toValueType) {
        return (T)OBJ_MAPPER.convertValue(fromValue, toValueType);
    }

    public static void writeValue(OutputStream out, Object value) throws JsonGenerationException, JsonMappingException, IOException {
        OBJ_MAPPER.writeValue(out, value);
    }

    static {
        OBJ_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        OBJ_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }
}

