/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.dbdiscovery.mgr;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.shardingsphere.dbdiscovery.mgr.MGRHeartbeatJob;
import org.apache.shardingsphere.dbdiscovery.spi.DatabaseDiscoveryType;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.ScheduleJobBootstrap;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperConfiguration;
import org.apache.shardingsphere.elasticjob.reg.zookeeper.ZookeeperRegistryCenter;
import org.apache.shardingsphere.infra.config.exception.ShardingSphereConfigurationException;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.rule.event.impl.DataSourceDisabledEvent;
import org.apache.shardingsphere.infra.rule.event.impl.PrimaryDataSourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MGRDatabaseDiscoveryType
implements DatabaseDiscoveryType {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MGRDatabaseDiscoveryType.class);
    private static final String PLUGIN_STATUS = "SELECT * FROM information_schema.PLUGINS WHERE PLUGIN_NAME='group_replication'";
    private static final String MEMBER_COUNT = "SELECT count(*) FROM performance_schema.replication_group_members";
    private static final String GROUP_NAME = "SELECT * FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_group_name'";
    private static final String SINGLE_PRIMARY = "SELECT * FROM performance_schema.global_variables WHERE VARIABLE_NAME='group_replication_single_primary_mode'";
    private static final String MEMBER_LIST = "SELECT MEMBER_HOST, MEMBER_PORT, MEMBER_STATE FROM performance_schema.replication_group_members";
    private static CoordinatorRegistryCenter coordinatorRegistryCenter;
    private static final Map<String, ScheduleJobBootstrap> SCHEDULE_JOB_BOOTSTRAP_MAP;
    private String oldPrimaryDataSource;
    private Properties props = new Properties();

    public void checkDatabaseDiscoveryConfig(Map<String, DataSource> dataSourceMap, String schemaName) throws SQLException {
        try (Connection connection = dataSourceMap.get(this.oldPrimaryDataSource).getConnection();
             Statement statement = connection.createStatement();){
            this.checkPluginIsActive(statement);
            this.checkMemberCount(statement);
            this.checkServerGroupName(statement);
            this.checkIsSinglePrimaryMode(statement);
        }
    }

    private void checkPluginIsActive(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(PLUGIN_STATUS);){
            while (resultSet.next()) {
                if ("ACTIVE".equals(resultSet.getString("PLUGIN_STATUS"))) continue;
                throw new ShardingSphereConfigurationException("MGR plugin is not active.", new Object[0]);
            }
        }
    }

    private void checkMemberCount(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(MEMBER_COUNT);){
            while (resultSet.next()) {
                if (resultSet.getInt(1) >= 1) continue;
                throw new ShardingSphereConfigurationException("MGR member count < 1", new Object[0]);
            }
        }
    }

    private void checkServerGroupName(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(GROUP_NAME);){
            while (resultSet.next()) {
                String ruleGroupName;
                String serverGroupName = resultSet.getString("VARIABLE_VALUE");
                if (serverGroupName.equals(ruleGroupName = this.props.getProperty("groupName"))) continue;
                throw new ShardingSphereConfigurationException("MGR group name is not consistent\nserverGroupName: %s\nruleGroupName: %s", new Object[]{serverGroupName, ruleGroupName});
            }
        }
    }

    private void checkIsSinglePrimaryMode(Statement statement) throws SQLException {
        try (ResultSet resultSet = statement.executeQuery(SINGLE_PRIMARY);){
            while (resultSet.next()) {
                if ("ON".equals(resultSet.getString("VARIABLE_VALUE"))) continue;
                throw new ShardingSphereConfigurationException("MGR is not in single primary mode", new Object[0]);
            }
        }
    }

    public void updatePrimaryDataSource(Map<String, DataSource> dataSourceMap, String schemaName, Collection<String> disabledDataSourceNames, String groupName, String primaryDataSourceName) {
        HashMap<String, DataSource> activeDataSourceMap = new HashMap<String, DataSource>(dataSourceMap);
        if (!disabledDataSourceNames.isEmpty()) {
            activeDataSourceMap.entrySet().removeIf(each -> disabledDataSourceNames.contains(each.getKey()));
        }
        if (null == primaryDataSourceName || primaryDataSourceName.equals(this.oldPrimaryDataSource)) {
            String newPrimaryDataSource = this.determinePrimaryDataSource(activeDataSourceMap);
            if (newPrimaryDataSource.isEmpty()) {
                return;
            }
            if (!newPrimaryDataSource.equals(this.oldPrimaryDataSource)) {
                this.oldPrimaryDataSource = newPrimaryDataSource;
                ShardingSphereEventBus.getInstance().post((Object)new PrimaryDataSourceEvent(schemaName, groupName, newPrimaryDataSource));
            }
        } else {
            this.oldPrimaryDataSource = primaryDataSourceName;
        }
    }

    private String determinePrimaryDataSource(Map<String, DataSource> dataSourceMap) {
        String primaryDataSourceURL = this.findPrimaryDataSourceURL(dataSourceMap);
        return this.findPrimaryDataSourceName(primaryDataSourceURL, dataSourceMap);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findPrimaryDataSourceURL(Map<String, DataSource> dataSourceMap) {
        String result = "";
        String sql = "SELECT MEMBER_HOST, MEMBER_PORT FROM performance_schema.replication_group_members WHERE MEMBER_ID = (SELECT VARIABLE_VALUE FROM performance_schema.global_status WHERE VARIABLE_NAME = 'group_replication_primary_member')";
        Iterator<DataSource> iterator = dataSourceMap.values().iterator();
        while (iterator.hasNext()) {
            DataSource each = iterator.next();
            try {
                Connection connection = each.getConnection();
                Throwable throwable = null;
                try {
                    Statement statement = connection.createStatement();
                    Throwable throwable2 = null;
                    try {
                        ResultSet resultSet = statement.executeQuery(sql);
                        Throwable throwable3 = null;
                        try {
                            if (!resultSet.next()) continue;
                            String string = String.format("%s:%s", resultSet.getString("MEMBER_HOST"), resultSet.getString("MEMBER_PORT"));
                            return string;
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (resultSet == null) continue;
                            if (throwable3 != null) {
                                try {
                                    resultSet.close();
                                }
                                catch (Throwable throwable5) {
                                    throwable3.addSuppressed(throwable5);
                                }
                                continue;
                            }
                            resultSet.close();
                        }
                    }
                    catch (Throwable throwable6) {
                        throwable2 = throwable6;
                        throw throwable6;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable7) {
                                throwable2.addSuppressed(throwable7);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable8) {
                    throwable = throwable8;
                    throw throwable8;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable9) {
                            throwable.addSuppressed(throwable9);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find primary data source url", (Throwable)ex);
            }
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findPrimaryDataSourceName(String primaryDataSourceURL, Map<String, DataSource> dataSourceMap) {
        String result = "";
        Iterator<Map.Entry<String, DataSource>> iterator = dataSourceMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, DataSource> entry = iterator.next();
            try {
                Connection connection = entry.getValue().getConnection();
                Throwable throwable = null;
                try {
                    String url = connection.getMetaData().getURL();
                    if (null == url || !url.contains(primaryDataSourceURL)) continue;
                    String string = entry.getKey();
                    return string;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find primary data source name", (Throwable)ex);
            }
        }
        return result;
    }

    public void updateMemberState(Map<String, DataSource> dataSourceMap, String schemaName, Collection<String> disabledDataSourceNames) {
        List<String> memberDataSourceURLs;
        HashMap<String, DataSource> activeDataSourceMap = new HashMap<String, DataSource>(dataSourceMap);
        if (!disabledDataSourceNames.isEmpty()) {
            activeDataSourceMap.entrySet().removeIf(each -> disabledDataSourceNames.contains(each.getKey()));
        }
        if ((memberDataSourceURLs = this.findMemberDataSourceURLs(activeDataSourceMap)).isEmpty()) {
            return;
        }
        HashMap<String, String> dataSourceURLs = new HashMap<String, String>(16, 1.0f);
        this.determineDisabledDataSource(schemaName, activeDataSourceMap, memberDataSourceURLs, dataSourceURLs);
        this.determineEnabledDataSource(dataSourceMap, schemaName, memberDataSourceURLs, dataSourceURLs);
    }

    private List<String> findMemberDataSourceURLs(Map<String, DataSource> activeDataSourceMap) {
        LinkedList<String> result = new LinkedList<String>();
        try (Connection connection = activeDataSourceMap.get(this.oldPrimaryDataSource).getConnection();
             Statement statement = connection.createStatement();){
            ResultSet resultSet = statement.executeQuery(MEMBER_LIST);
            while (resultSet.next()) {
                if (!"ONLINE".equals(resultSet.getString("MEMBER_STATE"))) continue;
                result.add(String.format("%s:%s", resultSet.getString("MEMBER_HOST"), resultSet.getString("MEMBER_PORT")));
            }
        }
        catch (SQLException ex) {
            log.error("An exception occurred while find member data source urls", (Throwable)ex);
        }
        return result;
    }

    private void determineDisabledDataSource(String schemaName, Map<String, DataSource> activeDataSourceMap, List<String> memberDataSourceURLs, Map<String, String> dataSourceURLs) {
        for (Map.Entry<String, DataSource> entry : activeDataSourceMap.entrySet()) {
            boolean disable = true;
            String url = null;
            try (Connection connection = entry.getValue().getConnection();){
                url = connection.getMetaData().getURL();
                for (String each : memberDataSourceURLs) {
                    if (null == url || !url.contains(each)) continue;
                    disable = false;
                    break;
                }
            }
            catch (SQLException ex) {
                log.error("An exception occurred while find data source urls", (Throwable)ex);
            }
            if (disable) {
                ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(schemaName, entry.getKey(), true));
                continue;
            }
            if (url.isEmpty()) continue;
            dataSourceURLs.put(entry.getKey(), url);
        }
    }

    private void determineEnabledDataSource(Map<String, DataSource> dataSourceMap, String schemaName, List<String> memberDataSourceURLs, Map<String, String> dataSourceURLs) {
        block13: for (String each : memberDataSourceURLs) {
            boolean enable = true;
            for (Map.Entry<String, String> entry : dataSourceURLs.entrySet()) {
                if (!entry.getValue().contains(each)) continue;
                enable = false;
                break;
            }
            if (!enable) continue;
            for (Map.Entry<String, Object> entry : dataSourceMap.entrySet()) {
                try {
                    Connection connection = ((DataSource)entry.getValue()).getConnection();
                    Throwable throwable = null;
                    try {
                        String url = connection.getMetaData().getURL();
                        if (null == url || !url.contains(each)) continue;
                        ShardingSphereEventBus.getInstance().post((Object)new DataSourceDisabledEvent(schemaName, entry.getKey(), false));
                        continue block13;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (connection == null) continue block13;
                        if (throwable != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            continue block13;
                        }
                        connection.close();
                        continue block13;
                    }
                }
                catch (SQLException ex) {
                    log.error("An exception occurred while find enable data source urls", (Throwable)ex);
                }
            }
        }
    }

    public void startPeriodicalUpdate(Map<String, DataSource> dataSourceMap, String schemaName, Collection<String> disabledDataSourceNames, String groupName, String primaryDataSourceName) {
        if (null == coordinatorRegistryCenter) {
            ZookeeperConfiguration zkConfig = new ZookeeperConfiguration(this.props.getProperty("zkServerLists"), "mgr-elasticjob");
            coordinatorRegistryCenter = new ZookeeperRegistryCenter(zkConfig);
            coordinatorRegistryCenter.init();
        }
        if (null != SCHEDULE_JOB_BOOTSTRAP_MAP.get(groupName)) {
            SCHEDULE_JOB_BOOTSTRAP_MAP.get(groupName).shutdown();
        }
        SCHEDULE_JOB_BOOTSTRAP_MAP.put(groupName, new ScheduleJobBootstrap(coordinatorRegistryCenter, (ElasticJob)new MGRHeartbeatJob(this, dataSourceMap, schemaName, disabledDataSourceNames, groupName, primaryDataSourceName), JobConfiguration.newBuilder((String)("MGR-" + groupName), (int)1).cron(this.props.getProperty("keepAliveCron")).build()));
        SCHEDULE_JOB_BOOTSTRAP_MAP.get(groupName).schedule();
    }

    public String getPrimaryDataSource() {
        return this.oldPrimaryDataSource;
    }

    public String getType() {
        return "MGR";
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }

    @Generated
    public void setProps(Properties props) {
        this.props = props;
    }

    static {
        SCHEDULE_JOB_BOOTSTRAP_MAP = new HashMap<String, ScheduleJobBootstrap>(16, 1.0f);
    }
}

