/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.encrypt.spring.namespace.parser;

import java.util.Collection;
import java.util.List;
import org.apache.shardingsphere.encrypt.algorithm.config.AlgorithmProvidedEncryptRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptColumnRuleConfiguration;
import org.apache.shardingsphere.encrypt.api.config.rule.EncryptTableRuleConfiguration;
import org.apache.shardingsphere.encrypt.spring.namespace.factorybean.EncryptAlgorithmFactoryBean;
import org.apache.shardingsphere.spring.namespace.registry.ShardingSphereAlgorithmBeanRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public final class EncryptRuleBeanDefinitionParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(AlgorithmProvidedEncryptRuleConfiguration.class);
        factory.addConstructorArgValue(EncryptRuleBeanDefinitionParser.parseEncryptTableRuleConfigurations(element));
        factory.addConstructorArgValue((Object)ShardingSphereAlgorithmBeanRegistry.getAlgorithmBeanReferences((ParserContext)parserContext, EncryptAlgorithmFactoryBean.class));
        factory.addConstructorArgValue((Object)Boolean.valueOf(element.getAttribute("query-with-cipher-column")));
        return factory.getBeanDefinition();
    }

    private static Collection<BeanDefinition> parseEncryptTableRuleConfigurations(Element element) {
        List encryptTableElements = DomUtils.getChildElementsByTagName((Element)element, (String)"table");
        ManagedList result = new ManagedList(encryptTableElements.size());
        for (Element each : encryptTableElements) {
            result.add(EncryptRuleBeanDefinitionParser.parseEncryptTableRuleConfiguration(each));
        }
        return result;
    }

    private static AbstractBeanDefinition parseEncryptTableRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptTableRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("name"));
        factory.addConstructorArgValue(EncryptRuleBeanDefinitionParser.parseEncryptColumnRuleConfigurations(element));
        return factory.getBeanDefinition();
    }

    private static Collection<BeanDefinition> parseEncryptColumnRuleConfigurations(Element element) {
        List encryptColumnElements = DomUtils.getChildElementsByTagName((Element)element, (String)"column");
        ManagedList result = new ManagedList(encryptColumnElements.size());
        for (Element each : encryptColumnElements) {
            result.add(EncryptRuleBeanDefinitionParser.parseEncryptColumnRuleConfiguration(each));
        }
        return result;
    }

    private static AbstractBeanDefinition parseEncryptColumnRuleConfiguration(Element element) {
        BeanDefinitionBuilder factory = BeanDefinitionBuilder.rootBeanDefinition(EncryptColumnRuleConfiguration.class);
        factory.addConstructorArgValue((Object)element.getAttribute("logic-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("cipher-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("assisted-query-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("plain-column"));
        factory.addConstructorArgValue((Object)element.getAttribute("encrypt-algorithm-ref"));
        return factory.getBeanDefinition();
    }
}

