/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.context;

import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.config.CalciteConnectionConfigImpl;
import org.apache.calcite.config.CalciteConnectionProperty;
import org.apache.calcite.config.Lex;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.parser.impl.SqlParserImpl;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorCatalogReader;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.shardingsphere.infra.database.type.DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.H2DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.MariaDBDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.MySQLDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.OracleDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.PostgreSQLDatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.SQL92DatabaseType;
import org.apache.shardingsphere.infra.database.type.dialect.SQLServerDatabaseType;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.optimize.context.OptimizeContext;
import org.apache.shardingsphere.infra.optimize.core.metadata.FederateSchemaMetadatas;
import org.apache.shardingsphere.infra.optimize.core.plan.PlannerInitializer;

public final class OptimizeContextFactory {
    private static final String LEX_CAMEL_NAME = CalciteConnectionProperty.LEX.camelName();
    private static final String CONFORMANCE_CAMEL_NAME = CalciteConnectionProperty.CONFORMANCE.camelName();
    private final Properties properties = new Properties();
    private final CalciteConnectionConfig connectionConfig;
    private final SqlParser.Config parserConfig;
    private final RelDataTypeFactory typeFactory;
    private final FederateSchemaMetadatas schemaMetadatas;
    private final RelOptCluster cluster;

    public OptimizeContextFactory(Map<String, ShardingSphereMetaData> metaDataMap) {
        DatabaseType databaseType = metaDataMap.isEmpty() ? null : metaDataMap.values().iterator().next().getResource().getDatabaseType();
        this.initProperties(databaseType);
        this.typeFactory = new JavaTypeFactoryImpl();
        this.cluster = this.newCluster();
        this.schemaMetadatas = new FederateSchemaMetadatas(metaDataMap);
        this.connectionConfig = new CalciteConnectionConfigImpl(this.properties);
        this.parserConfig = SqlParser.config().withLex(this.connectionConfig.lex()).withIdentifierMaxLength(128).withConformance(this.connectionConfig.conformance()).withParserFactory(SqlParserImpl.FACTORY);
    }

    private void initProperties(DatabaseType databaseType) {
        if (databaseType instanceof MySQLDatabaseType || databaseType == null) {
            this.properties.setProperty(LEX_CAMEL_NAME, Lex.MYSQL.name());
            this.properties.setProperty(CONFORMANCE_CAMEL_NAME, SqlConformanceEnum.MYSQL_5.name());
            return;
        }
        if (databaseType instanceof H2DatabaseType) {
            this.properties.setProperty(LEX_CAMEL_NAME, Lex.MYSQL.name());
            this.properties.setProperty(CONFORMANCE_CAMEL_NAME, SqlConformanceEnum.LENIENT.name());
            return;
        }
        if (databaseType instanceof MariaDBDatabaseType) {
            this.properties.setProperty(LEX_CAMEL_NAME, Lex.MYSQL.name());
            this.properties.setProperty(CONFORMANCE_CAMEL_NAME, SqlConformanceEnum.MYSQL_5.name());
            return;
        }
        if (databaseType instanceof OracleDatabaseType) {
            this.properties.setProperty(LEX_CAMEL_NAME, Lex.ORACLE.name());
            this.properties.setProperty(CONFORMANCE_CAMEL_NAME, SqlConformanceEnum.ORACLE_12.name());
            return;
        }
        if (databaseType instanceof PostgreSQLDatabaseType) {
            this.properties.setProperty(LEX_CAMEL_NAME, Lex.JAVA.name());
            this.properties.setProperty(CONFORMANCE_CAMEL_NAME, SqlConformanceEnum.BABEL.name());
            return;
        }
        if (databaseType instanceof SQL92DatabaseType) {
            this.properties.setProperty(LEX_CAMEL_NAME, Lex.MYSQL.name());
            this.properties.setProperty(CONFORMANCE_CAMEL_NAME, SqlConformanceEnum.STRICT_92.name());
            return;
        }
        if (databaseType instanceof SQLServerDatabaseType) {
            this.properties.setProperty(LEX_CAMEL_NAME, Lex.SQL_SERVER.name());
            this.properties.setProperty(CONFORMANCE_CAMEL_NAME, SqlConformanceEnum.SQL_SERVER_2008.name());
            return;
        }
        throw new ShardingSphereException("No matching DatabaseType found", new Object[0]);
    }

    private RelOptCluster newCluster() {
        VolcanoPlanner planner = new VolcanoPlanner();
        PlannerInitializer.init((RelOptPlanner)planner);
        return RelOptCluster.create((RelOptPlanner)planner, (RexBuilder)new RexBuilder(this.typeFactory));
    }

    public OptimizeContext create(String schemaName, Schema logicSchema) {
        CalciteCatalogReader catalogReader = this.createCalciteCatalogReader(schemaName, this.connectionConfig, this.typeFactory, logicSchema);
        SqlValidator validator = this.createSqlValidator(this.connectionConfig, this.typeFactory, catalogReader);
        SqlToRelConverter relConverter = this.createSqlToRelConverter(this.cluster, validator, catalogReader);
        return new OptimizeContext(this.properties, schemaName, logicSchema, this.parserConfig, validator, relConverter);
    }

    private CalciteCatalogReader createCalciteCatalogReader(String schemaName, CalciteConnectionConfig config, RelDataTypeFactory typeFactory, Schema logicSchema) {
        CalciteSchema rootSchema = CalciteSchema.createRootSchema((boolean)true);
        rootSchema.add(schemaName, logicSchema);
        return new CalciteCatalogReader(rootSchema, Collections.singletonList(schemaName), typeFactory, config);
    }

    private SqlValidator createSqlValidator(CalciteConnectionConfig config, RelDataTypeFactory typeFactory, CalciteCatalogReader catalogReader) {
        return SqlValidatorUtil.newValidator((SqlOperatorTable)SqlStdOperatorTable.instance(), (SqlValidatorCatalogReader)catalogReader, (RelDataTypeFactory)typeFactory, (SqlValidator.Config)SqlValidator.Config.DEFAULT.withLenientOperatorLookup(config.lenientOperatorLookup()).withSqlConformance(config.conformance()).withDefaultNullCollation(config.defaultNullCollation()).withIdentifierExpansion(true));
    }

    private SqlToRelConverter createSqlToRelConverter(RelOptCluster cluster, SqlValidator validator, CalciteCatalogReader catalogReader) {
        SqlToRelConverter.Config config = SqlToRelConverter.config().withTrimUnusedFields(true);
        RelOptTable.ViewExpander expander = (rowType, queryString, schemaPath, viewPath) -> null;
        return new SqlToRelConverter(expander, validator, (Prepare.CatalogReader)catalogReader, cluster, (SqlRexConvertletTable)StandardConvertletTable.INSTANCE, config);
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public FederateSchemaMetadatas getSchemaMetadatas() {
        return this.schemaMetadatas;
    }
}

