/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.optimize.core.metadata;

import java.sql.SQLException;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.collections4.map.LinkedMap;
import org.apache.shardingsphere.infra.exception.ShardingSphereException;
import org.apache.shardingsphere.infra.metadata.ShardingSphereMetaData;
import org.apache.shardingsphere.infra.optimize.core.metadata.FederateSchemaMetadata;

public final class FederateSchemaMetadatas {
    private final Map<String, FederateSchemaMetadata> schemas = new LinkedMap();

    public FederateSchemaMetadatas(Map<String, ShardingSphereMetaData> metaDataMap) {
        for (Map.Entry<String, ShardingSphereMetaData> each : metaDataMap.entrySet()) {
            try {
                this.schemas.put(each.getKey(), new FederateSchemaMetadata(each.getKey(), each.getValue()));
            }
            catch (SQLException ex) {
                throw new ShardingSphereException((Exception)ex);
            }
        }
    }

    public FederateSchemaMetadata getDefaultSchemaMetadata() {
        return this.schemas.get("logic_db");
    }

    public FederateSchemaMetadata getSchemaMetadataBySchemaName(String schemaName) {
        return this.schemas.get(schemaName);
    }

    @Generated
    public Map<String, FederateSchemaMetadata> getSchemas() {
        return this.schemas;
    }
}

