/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.util.Vector;
import scala.Tuple2;

public final class JavaKMeans {
    private static final Pattern SPACE = Pattern.compile(" ");

    static Vector parseVector(String line) {
        String[] splits = SPACE.split(line);
        double[] data = new double[splits.length];
        int i = 0;
        for (String s : splits) {
            data[i] = Double.parseDouble(s);
            ++i;
        }
        return new Vector(data);
    }

    static int closestPoint(Vector p, List<Vector> centers) {
        int bestIndex = 0;
        double closest = Double.POSITIVE_INFINITY;
        for (int i = 0; i < centers.size(); ++i) {
            double tempDist = p.squaredDist(centers.get(i));
            if (!(tempDist < closest)) continue;
            closest = tempDist;
            bestIndex = i;
        }
        return bestIndex;
    }

    static Vector average(List<Vector> ps) {
        int numVectors = ps.size();
        Vector out = new Vector(ps.get(0).elements());
        for (int i = 1; i < numVectors; ++i) {
            out.addInPlace(ps.get(i));
        }
        return out.divide((double)numVectors);
    }

    public static void main(String[] args) throws Exception {
        double tempDist;
        if (args.length < 4) {
            System.err.println("Usage: JavaKMeans <master> <file> <k> <convergeDist>");
            System.exit(1);
        }
        JavaSparkContext sc = new JavaSparkContext(args[0], "JavaKMeans", System.getenv("SPARK_HOME"), JavaSparkContext.jarOfClass(JavaKMeans.class));
        String path = args[1];
        int K = Integer.parseInt(args[2]);
        double convergeDist = Double.parseDouble(args[3]);
        JavaRDD data = sc.textFile(path).map((Function)new Function<String, Vector>(){

            public Vector call(String line) {
                return JavaKMeans.parseVector(line);
            }
        }).cache();
        final List centroids = data.takeSample(false, K, 42);
        do {
            JavaPairRDD closest = data.map((PairFunction)new PairFunction<Vector, Integer, Vector>(){

                public Tuple2<Integer, Vector> call(Vector vector) {
                    return new Tuple2((Object)JavaKMeans.closestPoint(vector, centroids), (Object)vector);
                }
            });
            JavaPairRDD pointsGroup = closest.groupByKey();
            Map newCentroids = pointsGroup.mapValues((Function)new Function<List<Vector>, Vector>(){

                public Vector call(List<Vector> ps) {
                    return JavaKMeans.average(ps);
                }
            }).collectAsMap();
            tempDist = 0.0;
            for (int i = 0; i < K; ++i) {
                tempDist += ((Vector)centroids.get(i)).squaredDist((Vector)newCentroids.get(i));
            }
            for (Map.Entry t : newCentroids.entrySet()) {
                centroids.set((Integer)t.getKey(), t.getValue());
            }
            System.out.println("Finished iteration (delta = " + tempDist + ")");
        } while (tempDist > convergeDist);
        System.out.println("Final centers:");
        for (Vector c : centroids) {
            System.out.println(c);
        }
        System.exit(0);
    }
}

