/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.ArrayList;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.Function2;

public final class JavaSparkPi {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Usage: JavaSparkPi <master> [slices]");
            System.exit(1);
        }
        JavaSparkContext jsc = new JavaSparkContext(args[0], "JavaSparkPi", System.getenv("SPARK_HOME"), JavaSparkContext.jarOfClass(JavaSparkPi.class));
        int slices = args.length == 2 ? Integer.parseInt(args[1]) : 2;
        int n = 100000 * slices;
        ArrayList<Integer> l = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            l.add(i);
        }
        JavaRDD dataSet = jsc.parallelize(l, slices);
        int count = (Integer)dataSet.map((Function)new Function<Integer, Integer>(){

            public Integer call(Integer integer) {
                double y;
                double x = Math.random() * 2.0 - 1.0;
                return x * x + (y = Math.random() * 2.0 - 1.0) * y < 1.0 ? 1 : 0;
            }
        }).reduce((Function2)new Function2<Integer, Integer, Integer>(){

            public Integer call(Integer integer, Integer integer2) {
                return integer + integer2;
            }
        });
        System.out.println("Pi is roughly " + 4.0 * (double)count / (double)n);
    }
}

