/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.Random;
import org.apache.spark.util.Vector;
import org.apache.spark.util.Vector$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class LocalKMeans$ {
    public static final LocalKMeans$ MODULE$;
    private final int N;
    private final int R;
    private final int D;
    private final int K;
    private final double convergeDist;
    private final Random rand;

    static {
        new LocalKMeans$();
    }

    public int N() {
        return this.N;
    }

    public int R() {
        return this.R;
    }

    public int D() {
        return this.D;
    }

    public int K() {
        return this.K;
    }

    public double convergeDist() {
        return this.convergeDist;
    }

    public Random rand() {
        return this.rand;
    }

    public Vector[] generateData() {
        return (Vector[])Array$.MODULE$.tabulate(this.N(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Vector apply(int i) {
                return LocalKMeans$.MODULE$.org$apache$spark$examples$LocalKMeans$$generatePoint$1(i);
            }
        }, ClassTag$.MODULE$.apply(Vector.class));
    }

    public int closestPoint(Vector p, HashMap<Object, Vector> centers) {
        boolean index = false;
        IntRef bestIndex = new IntRef(0);
        DoubleRef closest = new DoubleRef(Double.POSITIVE_INFINITY);
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), centers.size()).foreach$mVc$sp((Function1)new Serializable(p, centers, bestIndex, closest){
            public static final long serialVersionUID = 0L;
            private final Vector p$1;
            private final HashMap centers$1;
            private final IntRef bestIndex$1;
            private final DoubleRef closest$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Vector vCurr = (Vector)this.centers$1.get((Object)BoxesRunTime.boxToInteger((int)i)).get();
                double tempDist = this.p$1.squaredDist(vCurr);
                if (tempDist < this.closest$1.elem) {
                    this.closest$1.elem = tempDist;
                    this.bestIndex$1.elem = i;
                }
            }
            {
                this.p$1 = p$1;
                this.centers$1 = centers$1;
                this.bestIndex$1 = bestIndex$1;
                this.closest$1 = closest$1;
            }
        });
        return bestIndex.elem;
    }

    public void main(String[] args) {
        Vector[] data = this.generateData();
        HashSet points = new HashSet();
        ObjectRef kPoints = new ObjectRef((Object)new HashMap());
        DoubleRef tempDist = new DoubleRef(1.0);
        while (points.size() < this.K()) {
            points.add((Object)data[this.rand().nextInt(this.N())]);
        }
        Iterator iter = points.iterator();
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), points.size()).foreach((Function1)new Serializable(kPoints, iter){
            public static final long serialVersionUID = 0L;
            private final ObjectRef kPoints$1;
            private final Iterator iter$1;

            public final Option<Vector> apply(int i) {
                return ((HashMap)this.kPoints$1.elem).put((Object)BoxesRunTime.boxToInteger((int)i), this.iter$1.next());
            }
            {
                this.kPoints$1 = kPoints$1;
                this.iter$1 = iter$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Initial centers: ").append((Object)((HashMap)kPoints.elem)).toString());
        while (tempDist.elem > this.convergeDist()) {
            Tuple2[] closest = (Tuple2[])Predef$.MODULE$.refArrayOps((Object[])data).map((Function1)new Serializable(kPoints){
                public static final long serialVersionUID = 0L;
                private final ObjectRef kPoints$1;

                public final Tuple2<Object, Tuple2<Vector, Object>> apply(Vector p) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)LocalKMeans$.MODULE$.closestPoint(p, (HashMap<Object, Vector>)((HashMap)this.kPoints$1.elem))), (Object)new Tuple2((Object)p, (Object)BoxesRunTime.boxToInteger((int)1)));
                }
                {
                    this.kPoints$1 = kPoints$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
            Map mappings = Predef$.MODULE$.refArrayOps((Object[])closest).groupBy((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<Object, Tuple2<Vector, Object>> x) {
                    return x._1$mcI$sp();
                }
            });
            Map pointStats = (Map)mappings.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Tuple2<Vector, Object>> apply(Tuple2<Object, Tuple2<Object, Tuple2<Vector, Object>>[]> pair) {
                    return (Tuple2)Predef$.MODULE$.refArrayOps((Object[])pair._2()).reduceLeft((Function2)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<Object, Tuple2<Vector, Object>> apply(Tuple2<Object, Tuple2<Vector, Object>> x0$1, Tuple2<Object, Tuple2<Vector, Object>> x1$1) {
                            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
                            if (tuple2 != null) {
                                Tuple2 tuple22 = (Tuple2)tuple2._1();
                                Tuple2 tuple23 = (Tuple2)tuple2._2();
                                if (tuple22 != null) {
                                    int id1 = tuple22._1$mcI$sp();
                                    Tuple2 tuple24 = (Tuple2)tuple22._2();
                                    if (tuple24 != null) {
                                        Tuple2 tuple25;
                                        Vector x1 = (Vector)tuple24._1();
                                        int y1 = tuple24._2$mcI$sp();
                                        if (tuple23 != null && (tuple25 = (Tuple2)tuple23._2()) != null) {
                                            Vector x2 = (Vector)tuple25._1();
                                            int y2 = tuple25._2$mcI$sp();
                                            Tuple2 tuple26 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)id1), (Object)new Tuple2((Object)x1.$plus(x2), (Object)BoxesRunTime.boxToInteger((int)(y1 + y2))));
                                            return tuple26;
                                        }
                                    }
                                }
                            }
                            throw new MatchError((Object)tuple2);
                        }
                    });
                }
            }, Map$.MODULE$.canBuildFrom());
            Map newPoints = (Map)pointStats.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final Tuple2<Object, Vector> apply(Tuple2<Object, Tuple2<Vector, Object>> mapping) {
                    return new Tuple2((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp()), (Object)((Vector)((Tuple2)mapping._2())._1()).$div((double)((Tuple2)mapping._2())._2$mcI$sp()));
                }
            }, Map$.MODULE$.canBuildFrom());
            tempDist.elem = 0.0;
            newPoints.foreach((Function1)new Serializable(kPoints, tempDist){
                public static final long serialVersionUID = 0L;
                private final ObjectRef kPoints$1;
                private final DoubleRef tempDist$1;

                public final void apply(Tuple2<Object, Vector> mapping) {
                    this.tempDist$1.elem += ((Vector)((HashMap)this.kPoints$1.elem).get((Object)BoxesRunTime.boxToInteger((int)mapping._1$mcI$sp())).get()).squaredDist((Vector)mapping._2());
                }
                {
                    this.kPoints$1 = kPoints$1;
                    this.tempDist$1 = tempDist$1;
                }
            });
            newPoints.foreach((Function1)new Serializable(kPoints){
                public static final long serialVersionUID = 0L;
                private final ObjectRef kPoints$1;

                public final Option<Vector> apply(Tuple2<Object, Vector> newP) {
                    return ((HashMap)this.kPoints$1.elem).put((Object)BoxesRunTime.boxToInteger((int)newP._1$mcI$sp()), newP._2());
                }
                {
                    this.kPoints$1 = kPoints$1;
                }
            });
        }
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final centers: ").append((Object)((HashMap)kPoints.elem)).toString());
    }

    public final Vector org$apache$spark$examples$LocalKMeans$$generatePoint$1(int i) {
        return Vector$.MODULE$.apply(this.D(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x$1) {
                return this.apply$mcDI$sp(x$1);
            }

            public double apply$mcDI$sp(int x$1) {
                return LocalKMeans$.MODULE$.rand().nextDouble() * (double)LocalKMeans$.MODULE$.R();
            }
        });
    }

    private LocalKMeans$() {
        MODULE$ = this;
        this.N = 1000;
        this.R = 1000;
        this.D = 10;
        this.K = 10;
        this.convergeDist = 0.001;
        this.rand = new Random(42L);
    }
}

