/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples;

import java.util.Random;
import java.util.StringTokenizer;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.TextInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.deploy.SparkHadoopUtil$;
import org.apache.spark.examples.SparkHdfsLR;
import org.apache.spark.examples.SparkHdfsLR$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.scheduler.InputFormatInfo;
import org.apache.spark.scheduler.InputFormatInfo$;
import org.apache.spark.util.Vector;
import org.apache.spark.util.Vector$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class SparkHdfsLR$ {
    public static final SparkHdfsLR$ MODULE$;
    private final int D;
    private final Random rand;

    static {
        new SparkHdfsLR$();
    }

    public int D() {
        return this.D;
    }

    public Random rand() {
        return this.rand;
    }

    public SparkHdfsLR.DataPoint parsePoint(String line) {
        StringTokenizer tok = new StringTokenizer(line, " ");
        double y = new StringOps(Predef$.MODULE$.augmentString(tok.nextToken())).toDouble();
        double[] x = new double[this.D()];
        for (int i = 0; i < this.D(); ++i) {
            x[i] = new StringOps(Predef$.MODULE$.augmentString(tok.nextToken())).toDouble();
        }
        return new SparkHdfsLR.DataPoint(new Vector(x), y);
    }

    public void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: SparkHdfsLR <master> <file> <iters>");
            System.exit(1);
        }
        String inputPath = args[1];
        Configuration conf = SparkHadoopUtil$.MODULE$.get().newConfiguration();
        SparkContext sc = new SparkContext(args[0], "SparkHdfsLR", System.getenv("SPARK_HOME"), SparkContext$.MODULE$.jarOfClass(this.getClass()), (Map)Predef$.MODULE$.Map().apply((Seq)Nil$.MODULE$), (Map)InputFormatInfo$.MODULE$.computePreferredLocations((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new InputFormatInfo[]{new InputFormatInfo(conf, TextInputFormat.class, inputPath)}))));
        RDD lines = sc.textFile(inputPath, sc.textFile$default$2());
        RDD points = lines.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final SparkHdfsLR.DataPoint apply(String line) {
                return SparkHdfsLR$.MODULE$.parsePoint(line);
            }
        }, ClassTag$.MODULE$.apply(SparkHdfsLR.DataPoint.class)).cache();
        int ITERATIONS = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        ObjectRef w = new ObjectRef((Object)Vector$.MODULE$.apply(this.D(), (Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final double apply(int x$1) {
                return this.apply$mcDI$sp(x$1);
            }

            public double apply$mcDI$sp(int x$1) {
                return (double)2 * SparkHdfsLR$.MODULE$.rand().nextDouble() - 1.0;
            }
        }));
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Initial w: ").append((Object)((Vector)w.elem)).toString());
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), ITERATIONS).foreach$mVc$sp((Function1)new Serializable(points, w){
            public static final long serialVersionUID = 0L;
            private final RDD points$1;
            public final ObjectRef w$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"On iteration ").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                Vector gradient = (Vector)this.points$1.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.main.1 $outer;

                    public final Vector apply(SparkHdfsLR.DataPoint p) {
                        return Vector$.MODULE$.doubleToMultiplier((1.0 / (1.0 + package$.MODULE$.exp(-p.y() * ((Vector)this.$outer.w$1.elem).dot(p.x()))) - 1.0) * p.y()).$times(p.x());
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(Vector.class)).reduce((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(Vector x$2, Vector x$3) {
                        return x$2.$plus(x$3);
                    }
                });
                this.w$1.elem = ((Vector)this.w$1.elem).$minus(gradient);
            }
            {
                this.points$1 = points$1;
                this.w$1 = w$1;
            }
        });
        Predef$.MODULE$.println((Object)new StringBuilder().append((Object)"Final w: ").append((Object)((Vector)w.elem)).toString());
        System.exit(0);
    }

    private SparkHdfsLR$() {
        MODULE$ = this;
        this.D = 10;
        this.rand = new Random(42L);
    }
}

