/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.bagel;

import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.examples.bagel.WikipediaPageRankStandalone$;
import org.apache.spark.examples.bagel.WikipediaPageRankStandalone$$anonfun$pageRank$1$;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.xml.sax.SAXParseException;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.xml.Node;
import scala.xml.NodeSeq;
import scala.xml.NodeSeq$;
import scala.xml.XML$;

public final class WikipediaPageRankStandalone$ {
    public static final WikipediaPageRankStandalone$ MODULE$;

    static {
        new WikipediaPageRankStandalone$();
    }

    public void main(String[] args) {
        if (args.length < 5) {
            System.err.println("Usage: WikipediaPageRankStandalone <inputFile> <threshold> <numIterations> <host> <usePartitioner>");
            System.exit(-1);
        }
        SparkConf sparkConf = new SparkConf();
        sparkConf.set("spark.serializer", "spark.bagel.examples.WPRSerializer");
        String inputFile = args[0];
        double threshold = new StringOps(Predef$.MODULE$.augmentString(args[1])).toDouble();
        int numIterations = new StringOps(Predef$.MODULE$.augmentString(args[2])).toInt();
        String host = args[3];
        boolean usePartitioner = new StringOps(Predef$.MODULE$.augmentString(args[4])).toBoolean();
        sparkConf.setMaster(host).setAppName("WikipediaPageRankStandalone");
        SparkContext sc = new SparkContext(sparkConf, SparkContext$.MODULE$.$lessinit$greater$default$2());
        RDD input = sc.textFile(inputFile, sc.textFile$default$2());
        HashPartitioner partitioner = new HashPartitioner(sc.defaultParallelism());
        RDD links = usePartitioner ? SparkContext$.MODULE$.rddToPairRDDFunctions(input.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String[]> apply(String line) {
                return WikipediaPageRankStandalone$.MODULE$.parseArticle(line);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).partitionBy((Partitioner)partitioner).cache() : input.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<String, String[]> apply(String line) {
                return WikipediaPageRankStandalone$.MODULE$.parseArticle(line);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)).cache();
        long n = links.count();
        double defaultRank = 1.0 / (double)n;
        double a = 0.15;
        long startTime = System.currentTimeMillis();
        RDD<Tuple2<String, Object>> ranks = this.pageRank((RDD<Tuple2<String, String[]>>)links, numIterations, defaultRank, a, n, (Partitioner)partitioner, usePartitioner, sc.defaultParallelism());
        System.err.println(new StringBuilder().append((Object)"Articles with PageRank >= ").append((Object)BoxesRunTime.boxToDouble((double)threshold)).append((Object)":").toString());
        String top = Predef$.MODULE$.refArrayOps((Object[])ranks.filter((Function1)new Serializable(threshold){
            public static final long serialVersionUID = 0L;
            private final double threshold$1;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    double rank = tuple2._2$mcD$sp();
                    boolean bl = rank >= this.threshold$1;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
            {
                this.threshold$1 = threshold$1;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    String id = (String)tuple2._1();
                    double rank = tuple2._2$mcD$sp();
                    String string = new StringOps(Predef$.MODULE$.augmentString("%s\t%s\n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{id, BoxesRunTime.boxToDouble((double)rank)}));
                    return string;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(String.class)).collect()).mkString();
        Predef$.MODULE$.println((Object)top);
        double time = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Completed %d iterations in %f seconds: %f seconds per iteration")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numIterations), BoxesRunTime.boxToDouble((double)time), BoxesRunTime.boxToDouble((double)(time / (double)numIterations))})));
        System.exit(0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Tuple2<String, String[]> parseArticle(String line) {
        NodeSeq nodeSeq;
        Tuple2 tuple2;
        String[] fields = line.split("\t");
        Tuple2 tuple22 = new Tuple2((Object)fields[1], (Object)fields[3].replace("\\n", "\n"));
        if (tuple22 == null) throw new MatchError((Object)tuple22);
        String title = (String)tuple22._1();
        String body = (String)tuple22._2();
        Tuple2 tuple23 = tuple2 = new Tuple2((Object)title, (Object)body);
        String title2 = (String)tuple23._1();
        String body2 = (String)tuple23._2();
        String id = new String(title2);
        String string = body2;
        String string2 = "\\N";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            nodeSeq = NodeSeq$.MODULE$.Empty();
        } else {
            try {
                nodeSeq = XML$.MODULE$.loadString(body2).$bslash$bslash("link").$bslash("target");
            }
            catch (SAXParseException sAXParseException) {
                System.err.println(new StringBuilder().append((Object)"Article \"").append((Object)title2).append((Object)"\" has malformed XML in body:\n").append((Object)body2).toString());
                nodeSeq = NodeSeq$.MODULE$.Empty();
            }
        }
        NodeSeq links = nodeSeq;
        String[] outEdges = (String[])((TraversableOnce)links.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Node link) {
                return new String(link.text());
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(String.class));
        return new Tuple2((Object)id, (Object)outEdges);
    }

    public RDD<Tuple2<String, Object>> pageRank(RDD<Tuple2<String, String[]>> links, int numIterations, double defaultRank, double a, long n, Partitioner partitioner, boolean usePartitioner, int numPartitions) {
        ObjectRef ranks = new ObjectRef((Object)SparkContext$.MODULE$.rddToPairRDDFunctions(links, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).mapValues((Function1)new Serializable(defaultRank){
            public static final long serialVersionUID = 0L;
            private final double defaultRank$1;

            public final double apply(String[] edges) {
                return this.defaultRank$1;
            }
            {
                this.defaultRank$1 = defaultRank$1;
            }
        }));
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(1), numIterations).foreach$mVc$sp((Function1)new Serializable(links, defaultRank, a, n, partitioner, ranks){
            public static final long serialVersionUID = 0L;
            private final RDD links$1;
            public final double defaultRank$1;
            public final double a$1;
            public final long n$1;
            private final Partitioner partitioner$1;
            private final ObjectRef ranks$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RDD contribs = SparkContext$.MODULE$.rddToPairRDDFunctions(this.links$1, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))).groupWith((RDD)this.ranks$1.elem).flatMap((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.pageRank.1 $outer;

                    public final ArrayOps<Tuple2<String, Object>> apply(Tuple2<String, Tuple2<Seq<String[]>, Seq<Object>>> x0$3) {
                        Tuple2 tuple2;
                        Tuple2<String, Tuple2<Seq<String[]>, Seq<Object>>> tuple22 = x0$3;
                        if (tuple22 != null && (tuple2 = (Tuple2)tuple22._2()) != null) {
                            Seq linksWrapper = (Seq)tuple2._1();
                            Seq rankWrapper = (Seq)tuple2._2();
                            ArrayOps arrayOps = linksWrapper.length() > 0 ? (rankWrapper.length() > 0 ? Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])linksWrapper.apply(0)).map((Function1)new Serializable(this, linksWrapper, rankWrapper){
                                public static final long serialVersionUID = 0L;
                                private final Seq linksWrapper$1;
                                private final Seq rankWrapper$1;

                                public final Tuple2<String, Object> apply(String dest) {
                                    return new Tuple2((Object)dest, (Object)BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble((Object)this.rankWrapper$1.apply(0)) / (double)Predef$.MODULE$.refArrayOps((Object[])this.linksWrapper$1.apply(0)).size())));
                                }
                                {
                                    this.linksWrapper$1 = linksWrapper$1;
                                    this.rankWrapper$1 = rankWrapper$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))) : Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])linksWrapper.apply(0)).map((Function1)new Serializable(this, linksWrapper){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ anonfun$pageRank$1$$anonfun$10 $outer;
                                private final Seq linksWrapper$1;

                                public final Tuple2<String, Object> apply(String dest) {
                                    return new Tuple2((Object)dest, (Object)BoxesRunTime.boxToDouble((double)(this.$outer.org$apache$spark$examples$bagel$WikipediaPageRankStandalone$$anonfun$$anonfun$$$outer().defaultRank$1 / (double)Predef$.MODULE$.refArrayOps((Object[])this.linksWrapper$1.apply(0)).size())));
                                }
                                {
                                    if ($outer == null) {
                                        throw new NullPointerException();
                                    }
                                    this.$outer = $outer;
                                    this.linksWrapper$1 = linksWrapper$1;
                                }
                            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))) : Predef$.MODULE$.refArrayOps((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Tuple2.class)));
                            return arrayOps;
                        }
                        throw new MatchError(tuple22);
                    }

                    public /* synthetic */ anonfun.pageRank.1 org$apache$spark$examples$bagel$WikipediaPageRankStandalone$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, ClassTag$.MODULE$.apply(Tuple2.class));
                PairRDDFunctions qual$1 = SparkContext$.MODULE$.rddToPairRDDFunctions(contribs, ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Double());
                Serializable x$2 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x) {
                        return this.apply$mcDD$sp(x);
                    }

                    public double apply$mcDD$sp(double x) {
                        return x;
                    }
                };
                Serializable x$3 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x, double y) {
                        return this.apply$mcDDD$sp(x, y);
                    }

                    public double apply$mcDDD$sp(double x, double y) {
                        return x + y;
                    }
                };
                Serializable x$4 = new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(double x, double y) {
                        return this.apply$mcDDD$sp(x, y);
                    }

                    public double apply$mcDDD$sp(double x, double y) {
                        return x + y;
                    }
                };
                Partitioner x$5 = this.partitioner$1;
                boolean x$6 = qual$1.combineByKey$default$5();
                String x$7 = qual$1.combineByKey$default$6();
                this.ranks$1.elem = SparkContext$.MODULE$.rddToPairRDDFunctions(qual$1.combineByKey((Function1)x$2, (Function2)x$3, (Function2)x$4, x$5, x$6, x$7), ClassTag$.MODULE$.apply(String.class), ClassTag$.MODULE$.Double()).mapValues((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.pageRank.1 $outer;

                    public final double apply(double sum) {
                        return this.apply$mcDD$sp(sum);
                    }

                    public double apply$mcDD$sp(double sum) {
                        return this.$outer.a$1 / (double)this.$outer.n$1 + (1.0 - this.$outer.a$1) * sum;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.links$1 = links$1;
                this.defaultRank$1 = defaultRank$1;
                this.a$1 = a$1;
                this.n$1 = n$1;
                this.partitioner$1 = partitioner$1;
                this.ranks$1 = ranks$1;
            }
        });
        return (RDD)ranks.elem;
    }

    private WikipediaPageRankStandalone$() {
        MODULE$ = this;
    }
}

