/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.examples;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.clustering.KMeans;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.rdd.RDD;

public final class JavaKMeans {
    public static void main(String[] args) {
        if (args.length < 4) {
            System.err.println("Usage: JavaKMeans <master> <input_file> <k> <max_iterations> [<runs>]");
            System.exit(1);
        }
        String inputFile = args[1];
        int k = Integer.parseInt(args[2]);
        int iterations = Integer.parseInt(args[3]);
        int runs = 1;
        if (args.length >= 5) {
            runs = Integer.parseInt(args[4]);
        }
        JavaSparkContext sc = new JavaSparkContext(args[0], "JavaKMeans", System.getenv("SPARK_HOME"), JavaSparkContext.jarOfClass(JavaKMeans.class));
        JavaRDD lines = sc.textFile(args[1]);
        JavaRDD points = lines.map((Function)new ParsePoint());
        KMeansModel model = KMeans.train((RDD)points.rdd(), (int)k, (int)iterations, (int)runs);
        System.out.println("Cluster centers:");
        for (double[] center : model.clusterCenters()) {
            System.out.println(" " + Arrays.toString(center));
        }
        double cost = model.computeCost(points.rdd());
        System.out.println("Cost: " + cost);
        System.exit(0);
    }

    static class ParsePoint
    extends Function<String, double[]> {
        private static final Pattern SPACE = Pattern.compile(" ");

        ParsePoint() {
        }

        public double[] call(String line) {
            String[] tok = SPACE.split(line);
            double[] point = new double[tok.length];
            for (int i = 0; i < tok.length; ++i) {
                point[i] = Double.parseDouble(tok[i]);
            }
            return point;
        }
    }
}

