/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.examples;

import java.util.Arrays;
import java.util.regex.Pattern;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.mllib.classification.LogisticRegressionModel;
import org.apache.spark.mllib.classification.LogisticRegressionWithSGD;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.rdd.RDD;

public final class JavaLR {
    public static void printWeights(double[] a) {
        System.out.println(Arrays.toString(a));
    }

    public static void main(String[] args) {
        if (args.length != 4) {
            System.err.println("Usage: JavaLR <master> <input_dir> <step_size> <niters>");
            System.exit(1);
        }
        JavaSparkContext sc = new JavaSparkContext(args[0], "JavaLR", System.getenv("SPARK_HOME"), JavaSparkContext.jarOfClass(JavaLR.class));
        JavaRDD lines = sc.textFile(args[1]);
        JavaRDD points = lines.map((Function)new ParsePoint()).cache();
        double stepSize = Double.parseDouble(args[2]);
        int iterations = Integer.parseInt(args[3]);
        LogisticRegressionModel model = LogisticRegressionWithSGD.train((RDD)points.rdd(), (int)iterations, (double)stepSize);
        System.out.print("Final w: ");
        JavaLR.printWeights(model.weights());
        System.exit(0);
    }

    static class ParsePoint
    extends Function<String, LabeledPoint> {
        private static final Pattern COMMA = Pattern.compile(",");
        private static final Pattern SPACE = Pattern.compile(" ");

        ParsePoint() {
        }

        public LabeledPoint call(String line) {
            String[] parts = COMMA.split(line);
            double y = Double.parseDouble(parts[0]);
            String[] tok = SPACE.split(parts[1]);
            double[] x = new double[tok.length];
            for (int i = 0; i < tok.length; ++i) {
                x[i] = Double.parseDouble(tok[i]);
            }
            return new LabeledPoint(y, x);
        }
    }
}

