/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.streaming.examples;

import org.apache.spark.api.java.function.Function;
import org.apache.spark.streaming.Duration;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;
import org.apache.spark.streaming.examples.StreamingExamples;
import org.apache.spark.streaming.flume.FlumeUtils;

public final class JavaFlumeEventCount {
    private JavaFlumeEventCount() {
    }

    public static void main(String[] args) {
        if (args.length != 3) {
            System.err.println("Usage: JavaFlumeEventCount <master> <host> <port>");
            System.exit(1);
        }
        StreamingExamples.setStreamingLogLevels();
        String master = args[0];
        String host = args[1];
        int port = Integer.parseInt(args[2]);
        Duration batchInterval = new Duration(2000L);
        JavaStreamingContext ssc = new JavaStreamingContext(master, "FlumeEventCount", batchInterval, System.getenv("SPARK_HOME"), JavaStreamingContext.jarOfClass(JavaFlumeEventCount.class));
        JavaDStream flumeStream = FlumeUtils.createStream((JavaStreamingContext)ssc, (String)"localhost", (int)port);
        flumeStream.count();
        flumeStream.count().map((Function)new Function<Long, String>(){

            public String call(Long in) {
                return "Received " + in + " flume events.";
            }
        }).print();
        ssc.start();
        ssc.awaitTermination();
    }
}

