/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import breeze.storage.Zero;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.mllib.feature.IDFModel;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.DenseVector$;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.SparseVector$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple3;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\u0001\u0003\u00015\u00111!\u0013#G\u0015\t\u0019A!A\u0004gK\u0006$XO]3\u000b\u0005\u00151\u0011!B7mY&\u0014'BA\u0004\t\u0003\u0015\u0019\b/\u0019:l\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u0011U\u0001!Q1A\u0005\u0002Y\t!\"\\5o\t>\u001cgI]3r+\u00059\u0002CA\b\u0019\u0013\tI\u0002CA\u0002J]RD3\u0001F\u000e\"!\tar$D\u0001\u001e\u0015\tqb!\u0001\u0006b]:|G/\u0019;j_:L!\u0001I\u000f\u0003\u000bMKgnY3\"\u0003\t\nQ!\r\u00183]AB\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IaF\u0001\f[&tGi\\2Ge\u0016\f\b\u0005K\u0002$7\u0005BQa\n\u0001\u0005\u0002!\na\u0001P5oSRtDCA\u0015,!\tQ\u0003!D\u0001\u0003\u0011\u0015)b\u00051\u0001\u0018Q\rY3$\t\u0015\u0004Mm\t\u0003\"B\u0014\u0001\t\u0003yC#A\u0015)\u00079Z\u0012'I\u00013\u0003\u0015\td&\r\u00181\u0011\u0015!\u0004\u0001\"\u00016\u0003\r1\u0017\u000e\u001e\u000b\u0003me\u0002\"AK\u001c\n\u0005a\u0012!\u0001C%E\r6{G-\u001a7\t\u000bi\u001a\u0004\u0019A\u001e\u0002\u000f\u0011\fG/Y:fiB\u0019AhP!\u000e\u0003uR!A\u0010\u0004\u0002\u0007I$G-\u0003\u0002A{\t\u0019!\u000b\u0012#\u0011\u0005\t+U\"A\"\u000b\u0005\u0011#\u0011A\u00027j]\u0006dw-\u0003\u0002G\u0007\n1a+Z2u_JD3aM\u000e2\u0011\u0015!\u0004\u0001\"\u0001J)\t1$\nC\u0003;\u0011\u0002\u00071\nE\u0002M#\u0006k\u0011!\u0014\u0006\u0003\u001d>\u000bAA[1wC*\u0011\u0001KB\u0001\u0004CBL\u0017B\u0001*N\u0005\u001dQ\u0015M^1S\t\u0012C3\u0001S\u000e2Q\t\u0001Q\u000b\u0005\u0002\u001d-&\u0011q+\b\u0002\r\u000bb\u0004XM]5nK:$\u0018\r\u001c\u0015\u0004\u0001m\tt!\u0002.\u0003\u0011\u0013Y\u0016aA%E\rB\u0011!\u0006\u0018\u0004\u0006\u0003\tAI!X\n\u00039:AQa\n/\u0005\u0002}#\u0012a\u0017\u0004\u0005Cr\u0003!MA\u000eE_\u000e,X.\u001a8u\rJ,\u0017/^3oGf\fum\u001a:fO\u0006$xN]\n\u0004A:\u0019\u0007CA\be\u0013\t)\u0007C\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u0016A\n\u0015\r\u0011\"\u0001\u0017\u0011!!\u0003M!A!\u0002\u00139\u0002\"B\u0014a\t\u0003IGC\u00016m!\tY\u0007-D\u0001]\u0011\u0015)\u0002\u000e1\u0001\u0018\u0011\u001dq\u0007\r1A\u0005\n=\f\u0011!\\\u000b\u0002aB\u0011q\"]\u0005\u0003eB\u0011A\u0001T8oO\"9A\u000f\u0019a\u0001\n\u0013)\u0018!B7`I\u0015\fHC\u0001<z!\tyq/\u0003\u0002y!\t!QK\\5u\u0011\u001dQ8/!AA\u0002A\f1\u0001\u001f\u00132\u0011\u0019a\b\r)Q\u0005a\u0006\u0011Q\u000e\t\u0005\n}\u0002\u0004\r\u00111A\u0005\n}\f!\u0001\u001a4\u0016\u0005\u0005\u0005\u0001#BA\u0002\u0003\u0017\u0001XBAA\u0003\u0015\r!\u0015q\u0001\u0006\u0003\u0003\u0013\taA\u0019:fKj,\u0017\u0002BA\u0007\u0003\u000b\u00111\u0002R3og\u00164Vm\u0019;pe\"Y\u0011\u0011\u00031A\u0002\u0003\u0007I\u0011BA\n\u0003\u0019!gm\u0018\u0013fcR\u0019a/!\u0006\t\u0013i\fy!!AA\u0002\u0005\u0005\u0001\u0002CA\rA\u0002\u0006K!!\u0001\u0002\u0007\u00114\u0007\u0005\u0003\u0004(A\u0012\u0005\u0011Q\u0004\u000b\u0002U\"9\u0011\u0011\u00051\u0005\u0002\u0005\r\u0012aA1eIR!\u0011QEA\u0014\u001b\u0005\u0001\u0007bBA\u0015\u0003?\u0001\r!Q\u0001\u0004I>\u001c\u0007bBA\u0017A\u0012\u0005\u0011qF\u0001\u0006[\u0016\u0014x-\u001a\u000b\u0005\u0003K\t\t\u0004C\u0004\u00024\u0005-\u0002\u0019\u00016\u0002\u000b=$\b.\u001a:\t\u000f\u0005]\u0002\r\"\u0003\u0002:\u00059\u0011n]#naRLXCAA\u001e!\ry\u0011QH\u0005\u0004\u0003\u007f\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003\u0007\u0002G\u0011AA#\u0003\rIGM\u001a\u000b\u0002\u0003\u0002")
public class IDF {
    private final int minDocFreq;

    public int minDocFreq() {
        return this.minDocFreq;
    }

    public IDFModel fit(RDD<Vector> dataset) {
        DocumentFrequencyAggregator x$1 = new DocumentFrequencyAggregator(this.minDocFreq());
        Serializable x$2 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DocumentFrequencyAggregator apply(DocumentFrequencyAggregator df, Vector v) {
                return df.add(v);
            }
        };
        Serializable x$3 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final DocumentFrequencyAggregator apply(DocumentFrequencyAggregator df1, DocumentFrequencyAggregator df2) {
                return df1.merge(df2);
            }
        };
        int x$4 = dataset.treeAggregate$default$4((Object)x$1);
        Vector idf = ((DocumentFrequencyAggregator)dataset.treeAggregate((Object)x$1, (Function2)x$2, (Function2)x$3, x$4, ClassTag$.MODULE$.apply(DocumentFrequencyAggregator.class))).idf();
        return new IDFModel(idf);
    }

    public IDFModel fit(JavaRDD<Vector> dataset) {
        return this.fit((RDD<Vector>)dataset.rdd());
    }

    public IDF(int minDocFreq) {
        this.minDocFreq = minDocFreq;
    }

    public IDF() {
        this(0);
    }

    public static class DocumentFrequencyAggregator
    implements Serializable {
        private final int minDocFreq;
        private long m;
        private breeze.linalg.DenseVector<Object> df;

        public int minDocFreq() {
            return this.minDocFreq;
        }

        private long m() {
            return this.m;
        }

        private void m_$eq(long x$1) {
            this.m = x$1;
        }

        private breeze.linalg.DenseVector<Object> df() {
            return this.df;
        }

        private void df_$eq(breeze.linalg.DenseVector<Object> x$1) {
            this.df = x$1;
        }

        public DocumentFrequencyAggregator add(Vector doc) {
            Vector vector;
            block8: {
                block7: {
                    DenseVector denseVector;
                    Option<double[]> option;
                    block6: {
                        SparseVector sparseVector;
                        Option<Tuple3<Object, int[], double[]>> option2;
                        if (this.isEmpty()) {
                            this.df_$eq((breeze.linalg.DenseVector<Object>)breeze.linalg.DenseVector$.MODULE$.zeros$mJc$sp(doc.size(), ClassTag$.MODULE$.Long(), (Zero)Zero.LongZero$.MODULE$));
                        }
                        if (!((vector = doc) instanceof SparseVector) || (option2 = SparseVector$.MODULE$.unapply(sparseVector = (SparseVector)vector)).isEmpty()) break block6;
                        int[] indices = (int[])((Tuple3)option2.get())._2();
                        double[] values = (double[])((Tuple3)option2.get())._3();
                        int nnz = Predef$.MODULE$.intArrayOps(indices).size();
                        for (int k = 0; k < nnz; ++k) {
                            if (!(values[k] > 0.0)) continue;
                            breeze.linalg.DenseVector<Object> denseVector2 = this.df();
                            int n = indices[k];
                            denseVector2.update$mcJ$sp(n, denseVector2.apply$mcJ$sp(n) + 1L);
                        }
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block7;
                    }
                    if (!(vector instanceof DenseVector) || (option = DenseVector$.MODULE$.unapply(denseVector = (DenseVector)vector)).isEmpty()) break block8;
                    double[] values = (double[])option.get();
                    int n = Predef$.MODULE$.doubleArrayOps(values).size();
                    for (int j = 0; j < n; ++j) {
                        if (!(values[j] > 0.0)) continue;
                        breeze.linalg.DenseVector<Object> denseVector3 = this.df();
                        int n2 = j;
                        denseVector3.update$mcJ$sp(n2, denseVector3.apply$mcJ$sp(n2) + 1L);
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                this.m_$eq(this.m() + 1L);
                return this;
            }
            throw new UnsupportedOperationException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Only sparse and dense vectors are supported but got ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{vector.getClass()})));
        }

        public DocumentFrequencyAggregator merge(DocumentFrequencyAggregator other) {
            Object object;
            if (other.isEmpty()) {
                object = BoxedUnit.UNIT;
            } else {
                this.m_$eq(this.m() + other.m());
                if (this.df() == null) {
                    this.df_$eq((breeze.linalg.DenseVector<Object>)other.df().copy$mcJ$sp());
                    object = BoxedUnit.UNIT;
                } else {
                    object = this.df().$plus$eq(other.df(), breeze.linalg.DenseVector$.MODULE$.dv_dv_UpdateOp_Long_OpAdd());
                }
            }
            return this;
        }

        private boolean isEmpty() {
            return this.m() == 0L;
        }

        public Vector idf() {
            if (this.isEmpty()) {
                throw new IllegalStateException("Haven't seen any document yet.");
            }
            int n = this.df().length();
            double[] inv = new double[n];
            for (int j = 0; j < n; ++j) {
                if (this.df().apply$mcJ$sp(j) < (long)this.minDocFreq()) continue;
                inv[j] = package$.MODULE$.log(((double)this.m() + 1.0) / ((double)this.df().apply$mcJ$sp(j) + 1.0));
            }
            return Vectors$.MODULE$.dense(inv);
        }

        public DocumentFrequencyAggregator(int minDocFreq) {
            this.minDocFreq = minDocFreq;
            this.m = 0L;
        }

        public DocumentFrequencyAggregator() {
            this(0);
        }
    }
}

