/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.feature;

import com.github.fommil.netlib.BLAS;
import org.apache.spark.SparkContext;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.mllib.feature.Word2VecModel$;
import org.apache.spark.mllib.feature.Word2VecModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Saveable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.GenericTraversableTemplate;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\tUf\u0001B\u0001\u0003\u00015\u0011QbV8sIJ2VmY'pI\u0016d'BA\u0002\u0005\u0003\u001d1W-\u0019;ve\u0016T!!\u0002\u0004\u0002\u000b5dG.\u001b2\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001\u001dQ9\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0010+%\u0011a\u0003\u0005\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u00031mi\u0011!\u0007\u0006\u00035\u0011\tA!\u001e;jY&\u0011A$\u0007\u0002\t'\u00064X-\u00192mK\"Aa\u0004\u0001BC\u0002\u0013%q$A\u0005x_J$\u0017J\u001c3fqV\t\u0001\u0005\u0005\u0003\"I\u001dRcBA\b#\u0013\t\u0019\u0003#\u0001\u0004Qe\u0016$WMZ\u0005\u0003K\u0019\u00121!T1q\u0015\t\u0019\u0003\u0003\u0005\u0002\"Q%\u0011\u0011F\n\u0002\u0007'R\u0014\u0018N\\4\u0011\u0005=Y\u0013B\u0001\u0017\u0011\u0005\rIe\u000e\u001e\u0005\t]\u0001\u0011\t\u0011)A\u0005A\u0005Qqo\u001c:e\u0013:$W\r\u001f\u0011\t\u0011A\u0002!Q1A\u0005\nE\n1b^8sIZ+7\r^8sgV\t!\u0007E\u0002\u0010gUJ!\u0001\u000e\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=1\u0014BA\u001c\u0011\u0005\u00151En\\1u\u0011!I\u0004A!A!\u0002\u0013\u0011\u0014\u0001D<pe\u00124Vm\u0019;peN\u0004\u0003BB\u001e\u0001\t\u0003!A(\u0001\u0004=S:LGO\u0010\u000b\u0004{}\u0002\u0005C\u0001 \u0001\u001b\u0005\u0011\u0001\"\u0002\u0010;\u0001\u0004\u0001\u0003\"\u0002\u0019;\u0001\u0004\u0011\u0004b\u0002\"\u0001\u0005\u0004%IaQ\u0001\t]Vlwk\u001c:egV\t!\u0006\u0003\u0004F\u0001\u0001\u0006IAK\u0001\n]Vlwk\u001c:eg\u0002Bqa\u0012\u0001C\u0002\u0013%1)\u0001\u0006wK\u000e$xN]*ju\u0016Da!\u0013\u0001!\u0002\u0013Q\u0013a\u0003<fGR|'oU5{K\u0002Bqa\u0013\u0001C\u0002\u0013%A*\u0001\u0005x_J$G*[:u+\u0005i\u0005cA\b4O!1q\n\u0001Q\u0001\n5\u000b\u0011b^8sI2K7\u000f\u001e\u0011\t\u000fE\u0003!\u0019!C\u0005%\u0006aqo\u001c:e-\u0016\u001cgj\u001c:ngV\t1\u000bE\u0002\u0010gQ\u0003\"aD+\n\u0005Y\u0003\"A\u0002#pk\ndW\r\u0003\u0004Y\u0001\u0001\u0006IaU\u0001\u000eo>\u0014HMV3d\u001d>\u0014Xn\u001d\u0011\t\u000bm\u0002A\u0011\u0001.\u0015\u0005uZ\u0006\"\u0002/Z\u0001\u0004i\u0016!B7pI\u0016d\u0007\u0003B\u0011%OIB3!W0f!\t\u00017-D\u0001b\u0015\t\u0011g!\u0001\u0006b]:|G/\u0019;j_:L!\u0001Z1\u0003\u000bMKgnY3\"\u0003\u0019\fQ!\r\u00186]ABQ\u0001\u001b\u0001\u0005\n%\f\u0001cY8tS:,7+[7jY\u0006\u0014\u0018\u000e^=\u0015\u0007QSG\u000eC\u0003lO\u0002\u0007!'\u0001\u0002wc!)Qn\u001aa\u0001e\u0005\u0011aO\r\u0005\u0006_\u0002!\t\u0006]\u0001\u000eM>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8\u0016\u0003E\u0004\"A]<\u000e\u0003MT!\u0001^;\u0002\t1\fgn\u001a\u0006\u0002m\u0006!!.\u0019<b\u0013\tI3\u000fC\u0003z\u0001\u0011\u0005!0\u0001\u0003tCZ,G\u0003B>\u007f\u0003\u0013\u0001\"a\u0004?\n\u0005u\u0004\"\u0001B+oSRDaa =A\u0002\u0005\u0005\u0011AA:d!\u0011\t\u0019!!\u0002\u000e\u0003\u0019I1!a\u0002\u0007\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u0019\tY\u0001\u001fa\u0001O\u0005!\u0001/\u0019;iQ\u0011Ax,a\u0004\"\u0005\u0005E\u0011!B\u0019/i9\u0002\u0004bBA\u000b\u0001\u0011\u0005\u0011qC\u0001\niJ\fgn\u001d4pe6$B!!\u0007\u0002&A!\u00111DA\u0011\u001b\t\tiBC\u0002\u0002 \u0011\ta\u0001\\5oC2<\u0017\u0002BA\u0012\u0003;\u0011aAV3di>\u0014\bbBA\u0014\u0003'\u0001\raJ\u0001\u0005o>\u0014H\rK\u0003\u0002\u0014}\u000bY#\t\u0002\u0002.\u0005)\u0011GL\u0019/a!9\u0011\u0011\u0007\u0001\u0005\u0002\u0005M\u0012\u0001\u00044j]\u0012\u001c\u0016P\\8os6\u001cHCBA\u001b\u0003{\ty\u0004\u0005\u0003\u0010g\u0005]\u0002#B\b\u0002:\u001d\"\u0016bAA\u001e!\t1A+\u001e9mKJBq!a\n\u00020\u0001\u0007q\u0005C\u0004\u0002B\u0005=\u0002\u0019\u0001\u0016\u0002\u00079,X\u000eK\u0003\u00020}\u000bY\u0003C\u0004\u00022\u0001!\t!a\u0012\u0015\r\u0005U\u0012\u0011JA'\u0011!\tY%!\u0012A\u0002\u0005e\u0011A\u0002<fGR|'\u000fC\u0004\u0002B\u0005\u0015\u0003\u0019\u0001\u0016)\u000b\u0005\u0015s,a\u000b\t\u000f\u0005M\u0003\u0001\"\u0001\u0002V\u0005Qq-\u001a;WK\u000e$xN]:\u0016\u0003uCS!!\u0015`\u00033\n#!a\u0017\u0002\u000bEr#G\f\u0019)\t\u0001y\u00161\u0006\u0015\u0004\u0001\u0005\u0005\u0004c\u00011\u0002d%\u0019\u0011QM1\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u000f\u0005%$\u0001#\u0001\u0002l\u0005iqk\u001c:eeY+7-T8eK2\u00042APA7\r\u0019\t!\u0001#\u0001\u0002pM1\u0011Q\u000e\b\u0002rQ\u0001B\u0001GA:{%\u0019\u0011QO\r\u0003\r1{\u0017\rZ3s\u0011\u001dY\u0014Q\u000eC\u0001\u0003s\"\"!a\u001b\t\u0011\u0005u\u0014Q\u000eC\u0005\u0003\u007f\naBY;jY\u0012<vN\u001d3J]\u0012,\u0007\u0010F\u0002!\u0003\u0003Ca\u0001XA>\u0001\u0004i\u0006\u0002CAC\u0003[\"I!a\"\u0002!\t,\u0018\u000e\u001c3X_J$g+Z2u_J\u001cHc\u0001\u001a\u0002\n\"1A,a!A\u0002u;\u0001\"!$\u0002n!%\u0011qR\u0001\r'\u00064X\rT8bIZ\u000bt\f\r\t\u0005\u0003#\u000b\u0019*\u0004\u0002\u0002n\u0019A\u0011QSA7\u0011\u0013\t9J\u0001\u0007TCZ,Gj\\1e-Fz\u0006gE\u0002\u0002\u0014:AqaOAJ\t\u0003\tY\n\u0006\u0002\u0002\u0010\"I\u0011qTAJ\u0005\u0004%\t\u0001]\u0001\u0012M>\u0014X.\u0019;WKJ\u001c\u0018n\u001c8Wc}\u0003\u0004\u0002CAR\u0003'\u0003\u000b\u0011B9\u0002%\u0019|'/\\1u-\u0016\u00148/[8o-Fz\u0006\u0007\t\u0005\n\u0003O\u000b\u0019J1A\u0005\u0002A\fQb\u00197bgNt\u0015-\\3Wc}\u0003\u0004\u0002CAV\u0003'\u0003\u000b\u0011B9\u0002\u001d\rd\u0017m]:OC6,g+M01A\u00199\u0011qVAJ\u0001\u0006E&\u0001\u0002#bi\u0006\u001cb!!,\u000f\u0003g#\u0002cA\b\u00026&\u0019\u0011q\u0017\t\u0003\u000fA\u0013x\u000eZ;di\"Y\u0011qEAW\u0005+\u0007I\u0011AA^+\u00059\u0003BCA`\u0003[\u0013\t\u0012)A\u0005O\u0005)qo\u001c:eA!Q\u00111JAW\u0005+\u0007I\u0011A\u0019\t\u0015\u0005\u0015\u0017Q\u0016B\tB\u0003%!'A\u0004wK\u000e$xN\u001d\u0011\t\u000fm\ni\u000b\"\u0001\u0002JR1\u00111ZAh\u0003#\u0004B!!4\u0002.6\u0011\u00111\u0013\u0005\b\u0003O\t9\r1\u0001(\u0011\u001d\tY%a2A\u0002IB!\"!6\u0002.\u0006\u0005I\u0011AAl\u0003\u0011\u0019w\u000e]=\u0015\r\u0005-\u0017\u0011\\An\u0011%\t9#a5\u0011\u0002\u0003\u0007q\u0005C\u0005\u0002L\u0005M\u0007\u0013!a\u0001e!Q\u0011q\\AW#\u0003%\t!!9\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u001d\u0016\u0004O\u0005\u00158FAAt!\u0011\tI/!=\u000e\u0005\u0005-(\u0002BAw\u0003_\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0005\t\u0004\u0012\u0002BAz\u0003W\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011)\t90!,\u0012\u0002\u0013\u0005\u0011\u0011`\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\tYPK\u00023\u0003KD\u0011\"a@\u0002.\u0006\u0005I\u0011\t9\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011%\u0011\u0019!!,\u0002\u0002\u0013\u00051)\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010\u0003\u0006\u0003\b\u00055\u0016\u0011!C\u0001\u0005\u0013\ta\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003\f\tE\u0001cA\b\u0003\u000e%\u0019!q\u0002\t\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003\u0014\t\u0015\u0011\u0011!a\u0001U\u0005\u0019\u0001\u0010J\u0019\t\u0015\t]\u0011QVA\u0001\n\u0003\u0012I\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011Y\u0002\u0005\u0004\u0003\u001e\t\r\"1B\u0007\u0003\u0005?Q1A!\t\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005K\u0011yB\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011)\u0011I#!,\u0002\u0002\u0013\u0005!1F\u0001\tG\u0006tW)];bYR!!Q\u0006B\u001a!\ry!qF\u0005\u0004\u0005c\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005'\u00119#!AA\u0002\t-\u0001B\u0003B\u001c\u0003[\u000b\t\u0011\"\u0011\u0003:\u0005A\u0001.Y:i\u0007>$W\rF\u0001+\u0011)\u0011i$!,\u0002\u0002\u0013\u0005#qH\u0001\ti>\u001cFO]5oOR\t\u0011\u000f\u0003\u0006\u0003D\u00055\u0016\u0011!C!\u0005\u000b\na!Z9vC2\u001cH\u0003\u0002B\u0017\u0005\u000fB!Ba\u0005\u0003B\u0005\u0005\t\u0019\u0001B\u0006\u000f)\u0011Y%a%\u0002\u0002#\u0005!QJ\u0001\u0005\t\u0006$\u0018\r\u0005\u0003\u0002N\n=cACAX\u0003'\u000b\t\u0011#\u0001\u0003RM)!q\nB*)AA!Q\u000bB.OI\nY-\u0004\u0002\u0003X)\u0019!\u0011\f\t\u0002\u000fI,h\u000e^5nK&!!Q\fB,\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gN\r\u0005\bw\t=C\u0011\u0001B1)\t\u0011i\u0005\u0003\u0006\u0003>\t=\u0013\u0011!C#\u0005\u007fA!Ba\u001a\u0003P\u0005\u0005I\u0011\u0011B5\u0003\u0015\t\u0007\u000f\u001d7z)\u0019\tYMa\u001b\u0003n!9\u0011q\u0005B3\u0001\u00049\u0003bBA&\u0005K\u0002\rA\r\u0005\u000b\u0005c\u0012y%!A\u0005\u0002\nM\u0014aB;oCB\u0004H.\u001f\u000b\u0005\u0005k\u0012i\bE\u0003\u0010\u0005o\u0012Y(C\u0002\u0003zA\u0011aa\u00149uS>t\u0007#B\b\u0002:\u001d\u0012\u0004B\u0003B@\u0005_\n\t\u00111\u0001\u0002L\u0006\u0019\u0001\u0010\n\u0019\t\u0015\t\r%qJA\u0001\n\u0013\u0011))A\u0006sK\u0006$'+Z:pYZ,GC\u0001BD!\r\u0011(\u0011R\u0005\u0004\u0005\u0017\u001b(AB(cU\u0016\u001cG\u000f\u0003\u0005\u0003\u0010\u0006ME\u0011\u0001BI\u0003\u0011aw.\u00193\u0015\u000bu\u0012\u0019J!&\t\u000f}\u0014i\t1\u0001\u0002\u0002!9\u00111\u0002BG\u0001\u00049\u0003bB=\u0002\u0014\u0012\u0005!\u0011\u0014\u000b\bw\nm%Q\u0014BP\u0011\u001dy(q\u0013a\u0001\u0003\u0003Aq!a\u0003\u0003\u0018\u0002\u0007q\u0005\u0003\u0004]\u0005/\u0003\r!\u0018\u0005\t\u0005\u001f\u000bi\u0007\"\u0011\u0003$R)QH!*\u0003(\"9qP!)A\u0002\u0005\u0005\u0001bBA\u0006\u0005C\u0003\ra\n\u0015\u0006\u0005C{\u0016q\u0002\u0005\u000b\u0005\u0007\u000bi'!A\u0005\n\t\u0015\u0005\u0006BA7\u0003CBS!!\u001c`\u0003\u001fAC!a\u001a\u0002b!*\u0011qM0\u0002\u0010\u0001")
public class Word2VecModel
implements Serializable,
Saveable {
    private final Map<String, Object> wordIndex;
    private final float[] org$apache$spark$mllib$feature$Word2VecModel$$wordVectors;
    private final int numWords;
    private final int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    private final String[] wordList;
    private final double[] wordVecNorms;

    public static Word2VecModel load(SparkContext sparkContext, String string) {
        return Word2VecModel$.MODULE$.load(sparkContext, string);
    }

    private Map<String, Object> wordIndex() {
        return this.wordIndex;
    }

    public float[] org$apache$spark$mllib$feature$Word2VecModel$$wordVectors() {
        return this.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors;
    }

    private int numWords() {
        return this.numWords;
    }

    public int org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() {
        return this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize;
    }

    private String[] wordList() {
        return this.wordList;
    }

    private double[] wordVecNorms() {
        return this.wordVecNorms;
    }

    private double cosineSimilarity(float[] v1, float[] v2) {
        Predef$.MODULE$.require(v1.length == v2.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Vectors should have the same length";
            }
        });
        int n = v1.length;
        float norm1 = BLAS.getInstance().snrm2(n, v1, 1);
        float norm2 = BLAS.getInstance().snrm2(n, v2, 1);
        if (norm1 == 0.0f || norm2 == 0.0f) {
            return 0.0;
        }
        return BLAS.getInstance().sdot(n, v1, 1, v2, 1) / norm1 / norm2;
    }

    @Override
    public String formatVersion() {
        return "1.0";
    }

    @Override
    public void save(SparkContext sc, String path) {
        Word2VecModel$SaveLoadV1_0$.MODULE$.save(sc, path, this.getVectors());
    }

    public Vector transform(String word) {
        Option option = this.wordIndex().get((Object)word);
        if (option instanceof Some) {
            Some some = (Some)option;
            int ind = BoxesRunTime.unboxToInt((Object)some.x());
            float[] vec = (float[])Predef$.MODULE$.floatArrayOps(this.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors()).slice(ind * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), ind * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() + this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize());
            Vector vector = Vectors$.MODULE$.dense((double[])Predef$.MODULE$.floatArrayOps(vec).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(float x$7) {
                    return this.apply$mcDF$sp(x$7);
                }

                public double apply$mcDF$sp(float x$7) {
                    return x$7;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double())));
            return vector;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " not in vocabulary"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{word})));
        }
        throw new MatchError((Object)option);
    }

    public Tuple2<String, Object>[] findSynonyms(String word, int num) {
        Vector vector = this.transform(word);
        return this.findSynonyms(vector, num);
    }

    public Tuple2<String, Object>[] findSynonyms(Vector vector, int num) {
        Predef$.MODULE$.require(num > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Number of similar words should > 0";
            }
        });
        float[] fVector = (float[])Predef$.MODULE$.doubleArrayOps(vector.toArray()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply(double x$8) {
                return this.apply$mcFD$sp(x$8);
            }

            public float apply$mcFD$sp(double x$8) {
                return (float)x$8;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Float()));
        float[] cosineVec = (float[])Array$.MODULE$.fill(this.numWords(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final float apply() {
                return this.apply$mcF$sp();
            }

            public float apply$mcF$sp() {
                return 0.0f;
            }
        }, ClassTag$.MODULE$.Float());
        float alpha = 1.0f;
        float beta = 0.0f;
        BLAS.getInstance().sgemv("T", this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), this.numWords(), alpha, this.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors(), this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), fVector, 1, beta, cosineVec, 1);
        double[] cosVec = (double[])Predef$.MODULE$.floatArrayOps(cosineVec).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(float x$9) {
                return this.apply$mcDF$sp(x$9);
            }

            public double apply$mcDF$sp(float x$9) {
                return x$9;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
        for (int ind = 0; ind < this.numWords(); ++ind) {
            int n = ind;
            cosVec[n] = cosVec[n] / this.wordVecNorms()[ind];
        }
        return (Tuple2[])((TraversableOnce)((TraversableLike)((IterableLike)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])this.wordList()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(cosVec), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).toSeq().sortBy((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Tuple2<String, Object> x$10) {
                return -x$10._2$mcD$sp();
            }
        }, (Ordering)Ordering.Double$.MODULE$)).take(num + 1)).tail()).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public Map<String, float[]> getVectors() {
        return (Map)this.wordIndex().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Word2VecModel $outer;

            public final Tuple2<String, float[]> apply(Tuple2<String, Object> x0$4) {
                Tuple2<String, Object> tuple2 = x0$4;
                if (tuple2 != null) {
                    String word = (String)tuple2._1();
                    int ind = tuple2._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)word, Predef$.MODULE$.floatArrayOps(this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors()).slice(this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind, this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() * ind + this.$outer.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize()));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, Map$.MODULE$.canBuildFrom());
    }

    public Word2VecModel(Map<String, Object> wordIndex, float[] wordVectors) {
        this.wordIndex = wordIndex;
        this.org$apache$spark$mllib$feature$Word2VecModel$$wordVectors = wordVectors;
        this.numWords = wordIndex.size();
        this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize = wordVectors.length / this.numWords();
        Tuple2 tuple2 = ((GenericTraversableTemplate)wordIndex.toSeq().sortBy((Function1)new $anonfun$11(this), (Ordering)Ordering.Int$.MODULE$)).unzip((Function1)Predef$.MODULE$.conforms());
        if (tuple2 != null) {
            Seq wl;
            Seq seq;
            Seq wl2 = seq = (wl = (Seq)tuple2._1());
            this.wordList = (String[])wl2.toArray(ClassTag$.MODULE$.apply(String.class));
            double[] wordVecNorms = new double[this.numWords()];
            for (int i = 0; i < this.numWords(); ++i) {
                float[] vec = (float[])Predef$.MODULE$.floatArrayOps(wordVectors).slice(i * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), i * this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize() + this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize());
                wordVecNorms[i] = BLAS.getInstance().snrm2(this.org$apache$spark$mllib$feature$Word2VecModel$$vectorSize(), vec, 1);
            }
            this.wordVecNorms = wordVecNorms;
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Word2VecModel(Map<String, float[]> model) {
        this(Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordIndex(model), Word2VecModel$.MODULE$.org$apache$spark$mllib$feature$Word2VecModel$$buildWordVectors(model));
    }
}

