/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.regression;

import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.regression.IsotonicRegressionBase;
import org.apache.spark.ml.regression.IsotonicRegressionBase$;
import org.apache.spark.ml.util.SchemaUtils$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructType;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.reflect.ClassTag$;
import scala.reflect.api.JavaMirrors;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

public abstract class IsotonicRegressionBase$class {
    public static final boolean getIsotonic(IsotonicRegressionBase $this) {
        return BoxesRunTime.unboxToBoolean((Object)$this.$($this.isotonic()));
    }

    public static final int getFeatureIndex(IsotonicRegressionBase $this) {
        return BoxesRunTime.unboxToInt((Object)$this.$($this.featureIndex()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean hasWeightCol(IsotonicRegressionBase $this) {
        if (!$this.isDefined($this.weightCol())) return false;
        Object t = $this.$($this.weightCol());
        String string = "";
        if (t == null) {
            if (string == null) return false;
            return true;
        } else if (t.equals(string)) return false;
        return true;
    }

    public static RDD extractWeightedLabeledPoints(IsotonicRegressionBase $this, DataFrame dataset) {
        Column column;
        if (dataset.schema().apply($this.$($this.featuresCol())).dataType() instanceof VectorUDT) {
            int idx = BoxesRunTime.unboxToInt((Object)$this.$($this.featureIndex()));
            JavaUniverse $u = package$.MODULE$.universe();
            JavaMirrors.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(IsotonicRegressionBase.class.getClassLoader());
            public final class Org_apache_spark_ml_regression_IsotonicRegressionBase$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return ((Symbols.TypeSymbolApi)((Symbols.TypeSymbolApi)$m.staticClass("org.apache.spark.mllib.linalg.Vector")).asType()).toTypeConstructor();
                }

                public Org_apache_spark_ml_regression_IsotonicRegressionBase$$typecreator1$1(IsotonicRegressionBase $outer) {
                }
            }
            UserDefinedFunction extract2 = functions$.MODULE$.udf((Function1)new Serializable($this, idx){
                public static final long serialVersionUID = 0L;
                private final int idx$1;

                public final double apply(Vector v) {
                    return v.apply(this.idx$1);
                }
                {
                    this.idx$1 = idx$1;
                }
            }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_regression_IsotonicRegressionBase$$typecreator1$1($this)));
            column = extract2.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col($this.$($this.featuresCol()))}));
        } else {
            column = functions$.MODULE$.col($this.$($this.featuresCol()));
        }
        Column f = column;
        Column w2 = $this.hasWeightCol() ? functions$.MODULE$.col((String)$this.$($this.weightCol())) : functions$.MODULE$.lit((Object)BoxesRunTime.boxToDouble((double)1.0));
        return dataset.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col((String)$this.$($this.labelCol())), f, w2})).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Tuple3<Object, Object, Object> apply(Row x0$1) {
                Row row = x0$1;
                Some some = Row$.MODULE$.unapplySeq(row);
                if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(3) == 0) {
                    Object label = ((SeqLike)some.get()).apply(0);
                    Object feature = ((SeqLike)some.get()).apply(1);
                    Object weight = ((SeqLike)some.get()).apply(2);
                    if (label instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)label);
                        if (feature instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)feature);
                            if (weight instanceof Double) {
                                double d3 = BoxesRunTime.unboxToDouble((Object)weight);
                                Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToDouble((double)d), (Object)BoxesRunTime.boxToDouble((double)d2), (Object)BoxesRunTime.boxToDouble((double)d3));
                                return tuple3;
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }
        }, ClassTag$.MODULE$.apply(Tuple3.class));
    }

    public static StructType validateAndTransformSchema(IsotonicRegressionBase $this, StructType schema, boolean fitting) {
        DataType featuresType;
        if (fitting) {
            SchemaUtils$.MODULE$.checkColumnType(schema, (String)$this.$($this.labelCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
            if ($this.hasWeightCol()) {
                SchemaUtils$.MODULE$.checkColumnType(schema, (String)$this.$($this.weightCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.checkColumnType$default$4());
            } else {
                $this.logInfo((Function0)new Serializable($this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "The weight column is not defined. Treat all instance weights as 1.0.";
                    }
                });
            }
        }
        DataType dataType = featuresType = schema.apply($this.$($this.featuresCol())).dataType();
        DoubleType$ doubleType$ = DoubleType$.MODULE$;
        Predef$.MODULE$.require(!(dataType == null ? doubleType$ != null : !dataType.equals(doubleType$)) || featuresType instanceof VectorUDT);
        return SchemaUtils$.MODULE$.appendColumn(schema, (String)$this.$($this.predictionCol()), (DataType)DoubleType$.MODULE$, SchemaUtils$.MODULE$.appendColumn$default$4());
    }

    public static void $init$(IsotonicRegressionBase $this) {
        $this.org$apache$spark$ml$regression$IsotonicRegressionBase$_setter_$isotonic_$eq(new BooleanParam($this, "isotonic", "whether the output sequence should be isotonic/increasing (true) orantitonic/decreasing (false)"));
        $this.org$apache$spark$ml$regression$IsotonicRegressionBase$_setter_$featureIndex_$eq(new IntParam($this, "featureIndex", "The index of the feature if featuresCol is a vector column, no effect otherwise."));
        $this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{$this.isotonic().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true)), $this.featureIndex().$minus$greater(BoxesRunTime.boxToInteger((int)0))}));
    }
}

