/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.source.libsvm;

import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.VectorUDT;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SQLContext;
import org.apache.spark.sql.sources.BaseRelation;
import org.apache.spark.sql.sources.TableScan;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.slf4j.Logger;
import org.spark-project.guava.base.Objects;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001]4Q!\u0001\u0002\u0001\u00059\u0011a\u0002T5c'Zk%+\u001a7bi&|gN\u0003\u0002\u0004\t\u00051A.\u001b2tm6T!!\u0002\u0004\u0002\rM|WO]2f\u0015\t9\u0001\"\u0001\u0002nY*\u0011\u0011BC\u0001\u0006gB\f'o\u001b\u0006\u0003\u00171\ta!\u00199bG\",'\"A\u0007\u0002\u0007=\u0014xmE\u0003\u0001\u001f]Qb\u0004\u0005\u0002\u0011+5\t\u0011C\u0003\u0002\u0013'\u000591o\\;sG\u0016\u001c(B\u0001\u000b\t\u0003\r\u0019\u0018\u000f\\\u0005\u0003-E\u0011ABQ1tKJ+G.\u0019;j_:\u0004\"\u0001\u0005\r\n\u0005e\t\"!\u0003+bE2,7kY1o!\tYB$D\u0001\t\u0013\ti\u0002BA\u0004M_\u001e<\u0017N\\4\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\u0019M+'/[1mSj\f'\r\\3\t\u0011\u0015\u0002!Q1A\u0005\u0002\u001d\nA\u0001]1uQ\u000e\u0001Q#\u0001\u0015\u0011\u0005%bcBA\u0010+\u0013\tY\u0003%\u0001\u0004Qe\u0016$WMZ\u0005\u0003[9\u0012aa\u0015;sS:<'BA\u0016!\u0011!\u0001\u0004A!A!\u0002\u0013A\u0013!\u00029bi\"\u0004\u0003\u0002\u0003\u001a\u0001\u0005\u000b\u0007I\u0011A\u001a\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002iA\u0011q$N\u0005\u0003m\u0001\u00121!\u00138u\u0011!A\u0004A!A!\u0002\u0013!\u0014\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003\u0002\u0003\u001e\u0001\u0005\u000b\u0007I\u0011A\u0014\u0002\u0015Y,7\r^8s)f\u0004X\r\u0003\u0005=\u0001\t\u0005\t\u0015!\u0003)\u0003-1Xm\u0019;peRK\b/\u001a\u0011\t\u0011y\u0002!Q1A\u0005\u0002}\n!b]9m\u0007>tG/\u001a=u+\u0005\u0001\u0005CA!C\u001b\u0005\u0019\u0012BA\"\u0014\u0005)\u0019\u0016\u000bT\"p]R,\u0007\u0010\u001e\u0005\t\u000b\u0002\u0011\t\u0011)A\u0005\u0001\u0006Y1/\u001d7D_:$X\r\u001f;!Q\t!u\t\u0005\u0002 \u0011&\u0011\u0011\n\t\u0002\niJ\fgn]5f]RDQa\u0013\u0001\u0005\u00021\u000ba\u0001P5oSRtD\u0003B'R%N#\"A\u0014)\u0011\u0005=\u0003Q\"\u0001\u0002\t\u000byR\u0005\u0019\u0001!\t\u000b\u0015R\u0005\u0019\u0001\u0015\t\u000bIR\u0005\u0019\u0001\u001b\t\u000biR\u0005\u0019\u0001\u0015\t\u000bU\u0003A\u0011\t,\u0002\rM\u001c\u0007.Z7b+\u00059\u0006C\u0001-\\\u001b\u0005I&B\u0001.\u0014\u0003\u0015!\u0018\u0010]3t\u0013\ta\u0016L\u0001\u0006TiJ,8\r\u001e+za\u0016DQA\u0018\u0001\u0005B}\u000b\u0011BY;jY\u0012\u001c6-\u00198\u0015\u0003\u0001\u00042!\u00193g\u001b\u0005\u0011'BA2\t\u0003\r\u0011H\rZ\u0005\u0003K\n\u00141A\u0015#E!\t\tu-\u0003\u0002i'\t\u0019!k\\<\t\u000b)\u0004A\u0011I6\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012\u0001\u000e\u0005\u0006[\u0002!\tE\\\u0001\u0007KF,\u0018\r\\:\u0015\u0005=\u0014\bCA\u0010q\u0013\t\t\bEA\u0004C_>dW-\u00198\t\u000bMd\u0007\u0019\u0001;\u0002\u000b=$\b.\u001a:\u0011\u0005})\u0018B\u0001<!\u0005\r\te.\u001f")
public class LibSVMRelation
extends BaseRelation
implements TableScan,
Logging,
Serializable {
    private final String path;
    private final int numFeatures;
    private final String vectorType;
    private final transient SQLContext sqlContext;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public String path() {
        return this.path;
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    public String vectorType() {
        return this.vectorType;
    }

    public SQLContext sqlContext() {
        return this.sqlContext;
    }

    public StructType schema() {
        StructField structField = new StructField("label", (DataType)DoubleType$.MODULE$, false, StructField$.MODULE$.apply$default$4());
        StructField structField2 = new StructField("features", (DataType)new VectorUDT(), false, StructField$.MODULE$.apply$default$4());
        return StructType$.MODULE$.apply((Seq)Nil$.MODULE$.$colon$colon((Object)structField2).$colon$colon((Object)structField));
    }

    public RDD<Row> buildScan() {
        SparkContext sc = this.sqlContext().sparkContext();
        RDD<LabeledPoint> baseRdd = MLUtils$.MODULE$.loadLibSVMFile(sc, this.path(), this.numFeatures());
        String string = this.vectorType();
        String string2 = "sparse";
        boolean sparse2 = !(string != null ? !string.equals(string2) : string2 != null);
        return baseRdd.map((Function1)new Serializable(this, sparse2){
            public static final long serialVersionUID = 0L;
            private final boolean sparse$1;

            public final Row apply(LabeledPoint pt) {
                Vector features = this.sparse$1 ? pt.features().toSparse() : pt.features().toDense();
                return Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)pt.label()), features}));
            }
            {
                this.sparse$1 = sparse$1;
            }
        }, ClassTag$.MODULE$.apply(Row.class));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.path(), BoxesRunTime.boxToDouble((double)this.numFeatures()), this.vectorType()});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof LibSVMRelation)) return false;
        LibSVMRelation libSVMRelation = (LibSVMRelation)((Object)object);
        String string = this.path();
        String string2 = libSVMRelation.path();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.numFeatures() != libSVMRelation.numFeatures()) return false;
        String string3 = this.vectorType();
        String string4 = libSVMRelation.vectorType();
        if (string3 == null) {
            if (string4 == null) return true;
            return false;
        } else {
            if (!string3.equals(string4)) return false;
            return true;
        }
    }

    public LibSVMRelation(String path, int numFeatures, String vectorType, SQLContext sqlContext) {
        this.path = path;
        this.numFeatures = numFeatures;
        this.vectorType = vectorType;
        this.sqlContext = sqlContext;
        Logging.class.$init$((Logging)this);
    }
}

