/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import org.apache.spark.Accumulable;
import org.apache.spark.Accumulator;
import org.apache.spark.AccumulatorParam;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.mllib.clustering.KMeans$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$13$;
import org.apache.spark.mllib.clustering.KMeans$$anonfun$22$;
import org.apache.spark.mllib.clustering.KMeansModel;
import org.apache.spark.mllib.clustering.LocalKMeans$;
import org.apache.spark.mllib.clustering.VectorWithNorm;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.apache.spark.util.random.XORShiftRandom;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.immutable.ParSeq;
import scala.collection.parallel.immutable.ParSeq$;
import scala.math.Ordering;
import scala.math.Ordering$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\u0005h\u0001B\u0001\u0003\u00015\u0011aaS'fC:\u001c(BA\u0002\u0005\u0003)\u0019G.^:uKJLgn\u001a\u0006\u0003\u000b\u0019\tQ!\u001c7mS\nT!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001'\u0011\u0001a\u0002F\f\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mKB\u0011\u0001$G\u0007\u0002\r%\u0011!D\u0002\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!a\u0001\n\u0013i\u0012!A6\u0016\u0003y\u0001\"aD\u0010\n\u0005\u0001\u0002\"aA%oi\"A!\u0005\u0001BA\u0002\u0013%1%A\u0003l?\u0012*\u0017\u000f\u0006\u0002%OA\u0011q\"J\u0005\u0003MA\u0011A!\u00168ji\"9\u0001&IA\u0001\u0002\u0004q\u0012a\u0001=%c!A!\u0006\u0001B\u0001B\u0003&a$\u0001\u0002lA!AA\u0006\u0001BA\u0002\u0013%Q$A\u0007nCbLE/\u001a:bi&|gn\u001d\u0005\t]\u0001\u0011\t\u0019!C\u0005_\u0005\tR.\u0019=Ji\u0016\u0014\u0018\r^5p]N|F%Z9\u0015\u0005\u0011\u0002\u0004b\u0002\u0015.\u0003\u0003\u0005\rA\b\u0005\te\u0001\u0011\t\u0011)Q\u0005=\u0005qQ.\u0019=Ji\u0016\u0014\u0018\r^5p]N\u0004\u0003\u0002\u0003\u001b\u0001\u0005\u0003\u0007I\u0011B\u000f\u0002\tI,hn\u001d\u0005\tm\u0001\u0011\t\u0019!C\u0005o\u0005A!/\u001e8t?\u0012*\u0017\u000f\u0006\u0002%q!9\u0001&NA\u0001\u0002\u0004q\u0002\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0015\u0002\u0010\u0002\u000bI,hn\u001d\u0011\t\u0011q\u0002!\u00111A\u0005\nu\n!#\u001b8ji&\fG.\u001b>bi&|g.T8eKV\ta\b\u0005\u0002@\u0005:\u0011q\u0002Q\u0005\u0003\u0003B\ta\u0001\u0015:fI\u00164\u0017BA\"E\u0005\u0019\u0019FO]5oO*\u0011\u0011\t\u0005\u0005\t\r\u0002\u0011\t\u0019!C\u0005\u000f\u00061\u0012N\\5uS\u0006d\u0017N_1uS>tWj\u001c3f?\u0012*\u0017\u000f\u0006\u0002%\u0011\"9\u0001&RA\u0001\u0002\u0004q\u0004\u0002\u0003&\u0001\u0005\u0003\u0005\u000b\u0015\u0002 \u0002'%t\u0017\u000e^5bY&T\u0018\r^5p]6{G-\u001a\u0011\t\u00111\u0003!\u00111A\u0005\nu\t1#\u001b8ji&\fG.\u001b>bi&|gn\u0015;faND\u0001B\u0014\u0001\u0003\u0002\u0004%IaT\u0001\u0018S:LG/[1mSj\fG/[8o'R,\u0007o]0%KF$\"\u0001\n)\t\u000f!j\u0015\u0011!a\u0001=!A!\u000b\u0001B\u0001B\u0003&a$\u0001\u000bj]&$\u0018.\u00197ju\u0006$\u0018n\u001c8Ti\u0016\u00048\u000f\t\u0005\t)\u0002\u0011\t\u0019!C\u0005+\u00069Q\r]:jY>tW#\u0001,\u0011\u0005=9\u0016B\u0001-\u0011\u0005\u0019!u.\u001e2mK\"A!\f\u0001BA\u0002\u0013%1,A\u0006faNLGn\u001c8`I\u0015\fHC\u0001\u0013]\u0011\u001dA\u0013,!AA\u0002YC\u0001B\u0018\u0001\u0003\u0002\u0003\u0006KAV\u0001\tKB\u001c\u0018\u000e\\8oA!A\u0001\r\u0001BA\u0002\u0013%\u0011-\u0001\u0003tK\u0016$W#\u00012\u0011\u0005=\u0019\u0017B\u00013\u0011\u0005\u0011auN\\4\t\u0011\u0019\u0004!\u00111A\u0005\n\u001d\f\u0001b]3fI~#S-\u001d\u000b\u0003I!Dq\u0001K3\u0002\u0002\u0003\u0007!\r\u0003\u0005k\u0001\t\u0005\t\u0015)\u0003c\u0003\u0015\u0019X-\u001a3!\u0011\u0015a\u0007\u0001\"\u0003n\u0003\u0019a\u0014N\\5u}QAa\u000e]9sgR,h\u000f\u0005\u0002p\u00015\t!\u0001C\u0003\u001dW\u0002\u0007a\u0004C\u0003-W\u0002\u0007a\u0004C\u00035W\u0002\u0007a\u0004C\u0003=W\u0002\u0007a\bC\u0003MW\u0002\u0007a\u0004C\u0003UW\u0002\u0007a\u000bC\u0003aW\u0002\u0007!\rC\u0003m\u0001\u0011\u0005\u0001\u0010F\u0001oQ\u00119(0!\u0001\u0011\u0005mtX\"\u0001?\u000b\u0005u4\u0011AC1o]>$\u0018\r^5p]&\u0011q\u0010 \u0002\u0006'&t7-Z\u0011\u0003\u0003\u0007\tQ\u0001\r\u00189]ABa!a\u0002\u0001\t\u0003i\u0012\u0001B4fi.CS!!\u0002{\u0003\u0017\t#!!\u0004\u0002\u000bErCG\f\u0019\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005!1/\u001a;L)\u0011\t)\"a\u0006\u000e\u0003\u0001Aa\u0001HA\b\u0001\u0004q\u0002&BA\bu\u0006\u0005\u0001BBA\u000f\u0001\u0011\u0005Q$\u0001\thKRl\u0015\r_%uKJ\fG/[8og\"*\u00111\u0004>\u0002\f!9\u00111\u0005\u0001\u0005\u0002\u0005\u0015\u0012\u0001E:fi6\u000b\u00070\u0013;fe\u0006$\u0018n\u001c8t)\u0011\t)\"a\n\t\r1\n\t\u00031\u0001\u001fQ\u0015\t\tC_A\u0001\u0011\u0019\ti\u0003\u0001C\u0001{\u0005)r-\u001a;J]&$\u0018.\u00197ju\u0006$\u0018n\u001c8N_\u0012,\u0007&BA\u0016u\u0006-\u0001bBA\u001a\u0001\u0011\u0005\u0011QG\u0001\u0016g\u0016$\u0018J\\5uS\u0006d\u0017N_1uS>tWj\u001c3f)\u0011\t)\"a\u000e\t\rq\n\t\u00041\u0001?Q\u0015\t\tD_A\u0001\u0011\u0019\ti\u0004\u0001C\u0001;\u00059q-\u001a;Sk:\u001c\b\u0006CA\u001e\u0003\u0003\n9%a\u0013\u0011\u0007=\t\u0019%C\u0002\u0002FA\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\t\tI%\u0001%TkB\u0004xN\u001d;!M>\u0014\bE];og\u0002J7\u000f\t3faJ,7-\u0019;fI:\u0002C\u000b[5tAA\f'/Y7!o&dG\u000e\t5bm\u0016\u0004cn\u001c\u0011fM\u001a,7\r\u001e\u0011j]\u0002\ndf\u000e\u00181]\u0005\u0012\u0011QJ\u0001\u0006c92d\u0006\r\u0015\u0006\u0003wQ\u00181\u0002\u0005\b\u0003'\u0002A\u0011AA+\u0003\u001d\u0019X\r\u001e*v]N$B!!\u0006\u0002X!1A'!\u0015A\u0002yA\u0003\"!\u0015\u0002B\u0005\u001d\u00131\n\u0015\u0006\u0003#R\u0018\u0011\u0001\u0005\u0007\u0003?\u0002A\u0011A\u000f\u0002-\u001d,G/\u00138ji&\fG.\u001b>bi&|gn\u0015;faNDS!!\u0018{\u0003\u0017Aq!!\u001a\u0001\t\u0003\t9'\u0001\ftKRLe.\u001b;jC2L'0\u0019;j_:\u001cF/\u001a9t)\u0011\t)\"!\u001b\t\r1\u000b\u0019\u00071\u0001\u001fQ\u0015\t\u0019G_A\u0001\u0011\u0019\ty\u0007\u0001C\u0001+\u0006Qq-\u001a;FaNLGn\u001c8)\u000b\u00055$0a\u0003\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x\u0005Q1/\u001a;FaNLGn\u001c8\u0015\t\u0005U\u0011\u0011\u0010\u0005\u0007)\u0006M\u0004\u0019\u0001,)\u000b\u0005M$0!\u0001\t\r\u0005}\u0004\u0001\"\u0001b\u0003\u001d9W\r^*fK\u0012DS!! {\u0003\u0017Aq!!\"\u0001\t\u0003\t9)A\u0004tKR\u001cV-\u001a3\u0015\t\u0005U\u0011\u0011\u0012\u0005\u0007A\u0006\r\u0005\u0019\u00012)\u000b\u0005\r%0a\u0003\t\u0013\u0005=\u0005\u00011A\u0005\n\u0005E\u0015\u0001D5oSRL\u0017\r\\'pI\u0016dWCAAJ!\u0015y\u0011QSAM\u0013\r\t9\n\u0005\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007=\fY*C\u0002\u0002\u001e\n\u00111bS'fC:\u001cXj\u001c3fY\"I\u0011\u0011\u0015\u0001A\u0002\u0013%\u00111U\u0001\u0011S:LG/[1m\u001b>$W\r\\0%KF$2\u0001JAS\u0011%A\u0013qTA\u0001\u0002\u0004\t\u0019\n\u0003\u0005\u0002*\u0002\u0001\u000b\u0015BAJ\u00035Ig.\u001b;jC2lu\u000eZ3mA!9\u0011Q\u0016\u0001\u0005\u0002\u0005=\u0016aD:fi&s\u0017\u000e^5bY6{G-\u001a7\u0015\t\u0005U\u0011\u0011\u0017\u0005\t\u0003g\u000bY\u000b1\u0001\u0002\u001a\u0006)Qn\u001c3fY\"*\u00111\u0016>\u0002\f!9\u0011\u0011\u0018\u0001\u0005\u0002\u0005m\u0016a\u0001:v]R!\u0011\u0011TA_\u0011!\ty,a.A\u0002\u0005\u0005\u0017\u0001\u00023bi\u0006\u0004b!a1\u0002J\u00065WBAAc\u0015\r\t9MB\u0001\u0004e\u0012$\u0017\u0002BAf\u0003\u000b\u00141A\u0015#E!\u0011\ty-!6\u000e\u0005\u0005E'bAAj\t\u00051A.\u001b8bY\u001eLA!a6\u0002R\n1a+Z2u_JDS!a.{\u0003\u0003Aq!!8\u0001\t\u0013\ty.\u0001\u0007sk:\fEnZ8sSRDW\u000e\u0006\u0003\u0002\u001a\u0006\u0005\b\u0002CA`\u00037\u0004\r!a9\u0011\r\u0005\r\u0017\u0011ZAs!\ry\u0017q]\u0005\u0004\u0003S\u0014!A\u0004,fGR|'oV5uQ:{'/\u001c\u0005\b\u0003[\u0004A\u0011BAx\u0003)Ig.\u001b;SC:$w.\u001c\u000b\u0005\u0003c\fI\u0010E\u0003\u0010\u0003g\f90C\u0002\u0002vB\u0011Q!\u0011:sCf\u0004RaDAz\u0003KD\u0001\"a0\u0002l\u0002\u0007\u00111\u001d\u0005\b\u0003{\u0004A\u0011BA\u0000\u0003IIg.\u001b;L\u001b\u0016\fgn\u001d)be\u0006dG.\u001a7\u0015\t\u0005E(\u0011\u0001\u0005\t\u0003\u007f\u000bY\u00101\u0001\u0002d\"\"\u0001A_A\u0001\u000f\u001d\u00119A\u0001E\u0001\u0005\u0013\taaS'fC:\u001c\bcA8\u0003\f\u00191\u0011A\u0001E\u0001\u0005\u001b\u0019BAa\u0003\u000f)!9ANa\u0003\u0005\u0002\tEAC\u0001B\u0005\u0011)\u0011)Ba\u0003C\u0002\u0013\u0005!qC\u0001\u0007%\u0006sEiT'\u0016\u0005\te\u0001\u0003\u0002B\u000e\u0005Ki!A!\b\u000b\t\t}!\u0011E\u0001\u0005Y\u0006twM\u0003\u0002\u0003$\u0005!!.\u0019<b\u0013\r\u0019%Q\u0004\u0015\u0006\u0005'Q\u0018\u0011\u0001\u0005\n\u0005W\u0011Y\u0001)A\u0005\u00053\tqAU!O\t>k\u0005\u0005K\u0003\u0003*i\f\t\u0001\u0003\u0006\u00032\t-!\u0019!C\u0001\u0005/\t\u0001cS0N\u000b\u0006s5k\u0018)B%\u0006cE*\u0012')\u000b\t=\"0!\u0001\t\u0013\t]\"1\u0002Q\u0001\n\te\u0011!E&`\u001b\u0016\u000bejU0Q\u0003J\u000bE\nT#MA!*!Q\u0007>\u0002\u0002!A!Q\bB\u0006\t\u0003\u0011y$A\u0003ue\u0006Lg\u000e\u0006\b\u0002\u001a\n\u0005#1\tB#\u0005\u000f\u0012IEa\u0013\t\u0011\u0005}&1\ba\u0001\u0003\u0003Da\u0001\bB\u001e\u0001\u0004q\u0002B\u0002\u0017\u0003<\u0001\u0007a\u0004\u0003\u00045\u0005w\u0001\rA\b\u0005\u0007y\tm\u0002\u0019\u0001 \t\r\u0001\u0014Y\u00041\u0001cQ\u0015\u0011YD\u001fB(C\t\u0011\t&A\u00032]Mr\u0003\u0007\u0003\u0005\u0003>\t-A\u0011\u0001B+)1\tIJa\u0016\u0003Z\tm#Q\fB0\u0011!\tyLa\u0015A\u0002\u0005\u0005\u0007B\u0002\u000f\u0003T\u0001\u0007a\u0004\u0003\u0004-\u0005'\u0002\rA\b\u0005\u0007i\tM\u0003\u0019\u0001\u0010\t\rq\u0012\u0019\u00061\u0001?Q\u0015\u0011\u0019F_A\u0001\u0011!\u0011iDa\u0003\u0005\u0002\t\u0015D\u0003CAM\u0005O\u0012IGa\u001b\t\u0011\u0005}&1\ra\u0001\u0003\u0003Da\u0001\bB2\u0001\u0004q\u0002B\u0002\u0017\u0003d\u0001\u0007a\u0004K\u0003\u0003di\f\t\u0001\u0003\u0005\u0003>\t-A\u0011\u0001B9))\tIJa\u001d\u0003v\t]$\u0011\u0010\u0005\t\u0003\u007f\u0013y\u00071\u0001\u0002B\"1ADa\u001cA\u0002yAa\u0001\fB8\u0001\u0004q\u0002B\u0002\u001b\u0003p\u0001\u0007a\u0004K\u0003\u0003pi\f\t\u0001C\u0005\u0003\u0000\t-A\u0011\u0001\u0003\u0003\u0002\u0006Ya-\u001b8e\u00072|7/Z:u)\u0019\u0011\u0019I!#\u0003&B)qB!\"\u001f-&\u0019!q\u0011\t\u0003\rQ+\b\u000f\\33\u0011!\u0011YI! A\u0002\t5\u0015aB2f]R,'o\u001d\t\u0007\u0005\u001f\u0013y*!:\u000f\t\tE%1\u0014\b\u0005\u0005'\u0013I*\u0004\u0002\u0003\u0016*\u0019!q\u0013\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012b\u0001BO!\u00059\u0001/Y2lC\u001e,\u0017\u0002\u0002BQ\u0005G\u0013q\u0002\u0016:bm\u0016\u00148/\u00192mK>s7-\u001a\u0006\u0004\u0005;\u0003\u0002\u0002\u0003BT\u0005{\u0002\r!!:\u0002\u000bA|\u0017N\u001c;\t\u0013\t-&1\u0002C\u0001\t\t5\u0016!\u00039pS:$8i\\:u)\u00151&q\u0016BY\u0011!\u0011YI!+A\u0002\t5\u0005\u0002\u0003BT\u0005S\u0003\r!!:\t\u0013\tU&1\u0002C\u0001\u0005\t]\u0016a\u00054bgR\u001c\u0016/^1sK\u0012$\u0015n\u001d;b]\u000e,G#\u0002,\u0003:\nu\u0006\u0002\u0003B^\u0005g\u0003\r!!:\u0002\u0005Y\f\u0004\u0002\u0003B`\u0005g\u0003\r!!:\u0002\u0005Y\u0014\u0004\"\u0003Bb\u0005\u0017!\tA\u0002Bc\u0003A1\u0018\r\\5eCR,\u0017J\\5u\u001b>$W\r\u0006\u0003\u0003H\n5\u0007cA\b\u0003J&\u0019!1\u001a\t\u0003\u000f\t{w\u000e\\3b]\"9!q\u001aBa\u0001\u0004q\u0014\u0001C5oSRlu\u000eZ3\t\u0015\tM'1BA\u0001\n\u0013\u0011).A\u0006sK\u0006$'+Z:pYZ,GC\u0001Bl!\u0011\u0011YB!7\n\t\tm'Q\u0004\u0002\u0007\u001f\nTWm\u0019;)\u000b\t-!0!\u0001)\u000b\t\u0015!0!\u0001")
public class KMeans
implements Serializable,
Logging {
    private int org$apache$spark$mllib$clustering$KMeans$$k;
    private int org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    private int org$apache$spark$mllib$clustering$KMeans$$runs;
    private String org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    private int initializationSteps;
    private double org$apache$spark$mllib$clustering$KMeans$$epsilon;
    private long seed;
    private Option<KMeansModel> initialModel;
    private transient Logger org$apache$spark$Logging$$log_;

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2) {
        return KMeans$.MODULE$.train(rDD, n, n2);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string);
    }

    public static KMeansModel train(RDD<Vector> rDD, int n, int n2, int n3, String string, long l) {
        return KMeans$.MODULE$.train(rDD, n, n2, n3, string, l);
    }

    public static String K_MEANS_PARALLEL() {
        return KMeans$.MODULE$.K_MEANS_PARALLEL();
    }

    public static String RANDOM() {
        return KMeans$.MODULE$.RANDOM();
    }

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int org$apache$spark$mllib$clustering$KMeans$$k() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$k_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$maxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = x$1;
    }

    public int org$apache$spark$mllib$clustering$KMeans$$runs() {
        return this.org$apache$spark$mllib$clustering$KMeans$$runs;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$runs_$eq(int x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$runs = x$1;
    }

    public String org$apache$spark$mllib$clustering$KMeans$$initializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(String x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = x$1;
    }

    private int initializationSteps() {
        return this.initializationSteps;
    }

    private void initializationSteps_$eq(int x$1) {
        this.initializationSteps = x$1;
    }

    public double org$apache$spark$mllib$clustering$KMeans$$epsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon;
    }

    private void org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(double x$1) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = x$1;
    }

    private long seed() {
        return this.seed;
    }

    private void seed_$eq(long x$1) {
        this.seed = x$1;
    }

    public int getK() {
        return this.org$apache$spark$mllib$clustering$KMeans$$k();
    }

    public KMeans setK(int k) {
        this.org$apache$spark$mllib$clustering$KMeans$$k_$eq(k);
        return this;
    }

    public int getMaxIterations() {
        return this.org$apache$spark$mllib$clustering$KMeans$$maxIterations();
    }

    public KMeans setMaxIterations(int maxIterations) {
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations_$eq(maxIterations);
        return this;
    }

    public String getInitializationMode() {
        return this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
    }

    public KMeans setInitializationMode(String initializationMode) {
        KMeans$.MODULE$.validateInitMode(initializationMode);
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode_$eq(initializationMode);
        return this;
    }

    public int getRuns() {
        return this.org$apache$spark$mllib$clustering$KMeans$$runs();
    }

    public KMeans setRuns(int runs) {
        if (runs <= 0) {
            throw new IllegalArgumentException("Number of runs must be positive");
        }
        this.org$apache$spark$mllib$clustering$KMeans$$runs_$eq(runs);
        return this;
    }

    public int getInitializationSteps() {
        return this.initializationSteps();
    }

    public KMeans setInitializationSteps(int initializationSteps) {
        if (initializationSteps <= 0) {
            throw new IllegalArgumentException("Number of initialization steps must be positive");
        }
        this.initializationSteps_$eq(initializationSteps);
        return this;
    }

    public double getEpsilon() {
        return this.org$apache$spark$mllib$clustering$KMeans$$epsilon();
    }

    public KMeans setEpsilon(double epsilon) {
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon_$eq(epsilon);
        return this;
    }

    public long getSeed() {
        return this.seed();
    }

    public KMeans setSeed(long seed) {
        this.seed_$eq(seed);
        return this;
    }

    private Option<KMeansModel> initialModel() {
        return this.initialModel;
    }

    private void initialModel_$eq(Option<KMeansModel> x$1) {
        this.initialModel = x$1;
    }

    public KMeans setInitialModel(KMeansModel model) {
        Predef$.MODULE$.require(model.k() == this.org$apache$spark$mllib$clustering$KMeans$$k(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "mismatched cluster count";
            }
        });
        this.initialModel_$eq((Option<KMeansModel>)new Some((Object)model));
        return this;
    }

    public KMeansModel run(RDD<Vector> data) {
        StorageLevel storageLevel = data.getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data is not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        RDD norms = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(Vector x$1) {
                return Vectors$.MODULE$.norm(x$1, 2.0);
            }
        }, ClassTag$.MODULE$.Double());
        norms.persist();
        RDD zippedData = data.zip(norms, ClassTag$.MODULE$.Double()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final VectorWithNorm apply(Tuple2<Vector, Object> x0$1) {
                Tuple2<Vector, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    Vector v = (Vector)tuple2._1();
                    double norm2 = tuple2._2$mcD$sp();
                    VectorWithNorm vectorWithNorm = new VectorWithNorm(v, norm2);
                    return vectorWithNorm;
                }
                throw new MatchError(tuple2);
            }
        }, ClassTag$.MODULE$.apply(VectorWithNorm.class));
        KMeansModel model = this.runAlgorithm((RDD<VectorWithNorm>)zippedData);
        norms.unpersist(norms.unpersist$default$1());
        StorageLevel storageLevel3 = data.getStorageLevel();
        StorageLevel storageLevel4 = StorageLevel$.MODULE$.NONE();
        if (!(storageLevel3 != null ? !storageLevel3.equals(storageLevel4) : storageLevel4 != null)) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "The input data was not directly cached, which may hurt performance if its parent RDDs are also uncached.";
                }
            });
        }
        return model;
    }

    private KMeansModel runAlgorithm(RDD<VectorWithNorm> data) {
        Option<KMeansModel> option;
        block12: {
            VectorWithNorm[][] vectorWithNormArray;
            int numRuns;
            long initStartTime;
            SparkContext sc;
            block11: {
                block10: {
                    int n;
                    sc = data.sparkContext();
                    initStartTime = System.nanoTime();
                    if (this.initialModel().nonEmpty()) {
                        if (this.org$apache$spark$mllib$clustering$KMeans$$runs() > 1) {
                            this.logWarning((Function0<String>)new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply() {
                                    return "Ignoring runs; one run is allowed when initialModel is given.";
                                }
                            });
                        }
                        n = 1;
                    } else {
                        n = this.org$apache$spark$mllib$clustering$KMeans$$runs();
                    }
                    numRuns = n;
                    option = this.initialModel();
                    if (!(option instanceof Some)) break block10;
                    Some some = (Some)option;
                    KMeansModel kMeansCenters = (KMeansModel)some.x();
                    vectorWithNormArray = (VectorWithNorm[][])((Object[])new VectorWithNorm[][]{(VectorWithNorm[])Predef$.MODULE$.refArrayOps((Object[])kMeansCenters.clusterCenters()).map((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final VectorWithNorm apply(Vector s) {
                            return new VectorWithNorm(s);
                        }
                    }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(VectorWithNorm.class)))});
                    break block11;
                }
                None$ none$ = None$.MODULE$;
                Option<KMeansModel> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block12;
                String string = this.org$apache$spark$mllib$clustering$KMeans$$initializationMode();
                String string2 = KMeans$.MODULE$.RANDOM();
                vectorWithNormArray = !(string != null ? !string.equals(string2) : string2 != null) ? this.initRandom(data) : this.initKMeansParallel(data);
            }
            VectorWithNorm[][] centers = vectorWithNormArray;
            double initTimeInSeconds = (double)(System.nanoTime() - initStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, initTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final double initTimeInSeconds$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialization with ", " took "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.org$apache$spark$mllib$clustering$KMeans$$initializationMode()}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.initTimeInSeconds$1)}))).append((Object)" seconds.").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.initTimeInSeconds$1 = initTimeInSeconds$1;
                }
            });
            boolean[] active = (boolean[])Array$.MODULE$.fill(numRuns, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return true;
                }
            }, ClassTag$.MODULE$.Boolean());
            double[] costs = (double[])Array$.MODULE$.fill(numRuns, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply() {
                    return this.apply$mcD$sp();
                }

                public double apply$mcD$sp() {
                    return 0.0;
                }
            }, ClassTag$.MODULE$.Double());
            ArrayBuffer activeRuns = (ArrayBuffer)new ArrayBuffer().$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numRuns));
            IntRef iteration = new IntRef(0);
            long iterationStartTime = System.nanoTime();
            while (iteration.elem < this.org$apache$spark$mllib$clustering$KMeans$$maxIterations() && !activeRuns.isEmpty()) {
                VectorWithNorm[][] activeCenters = (VectorWithNorm[][])((TraversableOnce)activeRuns.map((Function1)new Serializable(this, centers){
                    public static final long serialVersionUID = 0L;
                    private final VectorWithNorm[][] centers$1;

                    public final VectorWithNorm[] apply(int r) {
                        return this.centers$1[r];
                    }
                    {
                        this.centers$1 = centers$1;
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
                ArrayBuffer costAccums = (ArrayBuffer)activeRuns.map((Function1)new Serializable(this, sc){
                    public static final long serialVersionUID = 0L;
                    private final SparkContext sc$1;

                    public final Accumulator<Object> apply(int x$2) {
                        return this.sc$1.accumulator((Object)BoxesRunTime.boxToDouble((double)0.0), (AccumulatorParam)AccumulatorParam.DoubleAccumulatorParam$.MODULE$);
                    }
                    {
                        this.sc$1 = sc$1;
                    }
                }, ArrayBuffer$.MODULE$.canBuildFrom());
                Broadcast bcActiveCenters = sc.broadcast((Object)activeCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class))));
                Map totalContribs = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.mapPartitions((Function1)new Serializable(this, costAccums, bcActiveCenters){
                    public static final long serialVersionUID = 0L;
                    public final ArrayBuffer costAccums$1;
                    private final Broadcast bcActiveCenters$1;

                    public final Iterator<Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>>> apply(Iterator<VectorWithNorm> points) {
                        VectorWithNorm[][] thisActiveCenters = (VectorWithNorm[][])this.bcActiveCenters$1.value();
                        int runs = thisActiveCenters.length;
                        int k = thisActiveCenters[0].length;
                        int dims = thisActiveCenters[0][0].vector().size();
                        Vector[][] sums = (Vector[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this, dims){
                            public static final long serialVersionUID = 0L;
                            private final int dims$1;

                            public final Vector apply() {
                                return Vectors$.MODULE$.zeros(this.dims$1);
                            }
                            {
                                this.dims$1 = dims$1;
                            }
                        }, ClassTag$.MODULE$.apply(Vector.class));
                        long[][] counts = (long[][])Array$.MODULE$.fill(runs, k, (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final long apply() {
                                return this.apply$mcJ$sp();
                            }

                            public long apply$mcJ$sp() {
                                return 0L;
                            }
                        }, ClassTag$.MODULE$.Long());
                        points.foreach((Function1)new Serializable(this, thisActiveCenters, runs, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$13 $outer;
                            public final VectorWithNorm[][] thisActiveCenters$1;
                            private final int runs$1;
                            public final Vector[][] sums$1;
                            public final long[][] counts$1;

                            public final void apply(VectorWithNorm point) {
                                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.runs$1).foreach$mVc$sp((Function1)new Serializable(this, point){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$13$$anonfun$apply$4 $outer;
                                    private final VectorWithNorm point$1;

                                    public final void apply(int i) {
                                        this.apply$mcVI$sp(i);
                                    }

                                    public void apply$mcVI$sp(int i) {
                                        Tuple2<Object, Object> tuple2 = KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)Predef$.MODULE$.refArrayOps((Object[])this.$outer.thisActiveCenters$1[i]), this.point$1);
                                        if (tuple2 != null) {
                                            Tuple2.mcID.sp sp2;
                                            int bestCenter = tuple2._1$mcI$sp();
                                            double cost = tuple2._2$mcD$sp();
                                            Tuple2.mcID.sp sp3 = sp2 = new Tuple2.mcID.sp(bestCenter, cost);
                                            int bestCenter2 = sp3._1$mcI$sp();
                                            double cost2 = sp3._2$mcD$sp();
                                            ((Accumulable)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().costAccums$1.apply(i)).$plus$eq((Object)BoxesRunTime.boxToDouble((double)cost2));
                                            Vector sum = this.$outer.sums$1[i][bestCenter2];
                                            BLAS$.MODULE$.axpy(1.0, this.point$1.vector(), sum);
                                            long[] lArray = this.$outer.counts$1[i];
                                            lArray[bestCenter2] = lArray[bestCenter2] + 1L;
                                            return;
                                        }
                                        throw new MatchError(tuple2);
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.point$1 = point$1;
                                    }
                                });
                            }

                            public /* synthetic */ $anonfun$13 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                                return this.$outer;
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.thisActiveCenters$1 = thisActiveCenters$1;
                                this.runs$1 = runs$1;
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        });
                        IndexedSeq contribs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), runs).flatMap((Function1)new Serializable(this, k, sums, counts){
                            public static final long serialVersionUID = 0L;
                            private final int k$1;
                            public final Vector[][] sums$1;
                            public final long[][] counts$1;

                            public final IndexedSeq<Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>>> apply(int i) {
                                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.k$1).map((Function1)new Serializable(this, i){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$13$$anonfun$15 $outer;
                                    private final int i$1;

                                    public final Tuple2<Tuple2<Object, Object>, Tuple2<Vector, Object>> apply(int j) {
                                        return new Tuple2((Object)new Tuple2.mcII.sp(this.i$1, j), (Object)new Tuple2((Object)this.$outer.sums$1[this.i$1][j], (Object)BoxesRunTime.boxToLong((long)this.$outer.counts$1[this.i$1][j])));
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.i$1 = i$1;
                                    }
                                }, IndexedSeq$.MODULE$.canBuildFrom());
                            }
                            {
                                this.k$1 = k$1;
                                this.sums$1 = sums$1;
                                this.counts$1 = counts$1;
                            }
                        }, IndexedSeq$.MODULE$.canBuildFrom());
                        return contribs.iterator();
                    }
                    {
                        this.costAccums$1 = costAccums$1;
                        this.bcActiveCenters$1 = bcActiveCenters$1;
                    }
                }, data.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;

                    public final Tuple2<Vector, Object> apply(Tuple2<Vector, Object> x, Tuple2<Vector, Object> y) {
                        return this.$outer.org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(x, y);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.apply(Tuple2.class), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
                bcActiveCenters.unpersist(false);
                ((TraversableLike)activeRuns.zipWithIndex(ArrayBuffer$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                        Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                }).foreach((Function1)new Serializable(this, centers, active, costs, iteration, costAccums, totalContribs){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;
                    private final VectorWithNorm[][] centers$1;
                    private final boolean[] active$1;
                    private final double[] costs$1;
                    public final IntRef iteration$1;
                    private final ArrayBuffer costAccums$1;
                    private final Map totalContribs$1;

                    public final void apply(Tuple2<Object, Object> x$5) {
                        Tuple2<Object, Object> tuple2 = x$5;
                        if (tuple2 != null) {
                            int run2 = tuple2._1$mcI$sp();
                            int i = tuple2._2$mcI$sp();
                            boolean changed = false;
                            for (int j = 0; j < this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(); ++j) {
                                Tuple2 tuple22 = (Tuple2)this.totalContribs$1.apply((Object)new Tuple2.mcII.sp(i, j));
                                if (tuple22 != null) {
                                    Tuple2 tuple23;
                                    Vector sum = (Vector)tuple22._1();
                                    long count = tuple22._2$mcJ$sp();
                                    Tuple2 tuple24 = tuple23 = new Tuple2((Object)sum, (Object)BoxesRunTime.boxToLong((long)count));
                                    Vector sum2 = (Vector)tuple24._1();
                                    long count2 = tuple24._2$mcJ$sp();
                                    if (count2 == 0L) continue;
                                    BLAS$.MODULE$.scal(1.0 / (double)count2, sum2);
                                    VectorWithNorm newCenter = new VectorWithNorm(sum2);
                                    if (KMeans$.MODULE$.fastSquaredDistance(newCenter, this.centers$1[run2][j]) > this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon() * this.$outer.org$apache$spark$mllib$clustering$KMeans$$epsilon()) {
                                        changed = true;
                                    }
                                    this.centers$1[run2][j] = newCenter;
                                    continue;
                                }
                                throw new MatchError((Object)tuple22);
                            }
                            if (!changed) {
                                this.active$1[run2] = false;
                                this.$outer.logInfo((Function0<String>)new Serializable(this, run2){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$runAlgorithm$4 $outer;
                                    private final int run$1;

                                    public final String apply() {
                                        return new StringBuilder().append((Object)"Run ").append((Object)BoxesRunTime.boxToInteger((int)this.run$1)).append((Object)" finished in ").append((Object)BoxesRunTime.boxToInteger((int)(this.$outer.iteration$1.elem + 1))).append((Object)" iterations").toString();
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.run$1 = run$1;
                                    }
                                });
                            }
                            this.costs$1[run2] = BoxesRunTime.unboxToDouble((Object)((Accumulable)this.costAccums$1.apply(i)).value());
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.centers$1 = centers$1;
                        this.active$1 = active$1;
                        this.costs$1 = costs$1;
                        this.iteration$1 = iteration$1;
                        this.costAccums$1 = costAccums$1;
                        this.totalContribs$1 = totalContribs$1;
                    }
                });
                activeRuns = (ArrayBuffer)activeRuns.filter((Function1)new Serializable(this, active){
                    public static final long serialVersionUID = 0L;
                    private final boolean[] active$1;

                    public final boolean apply(int x$6) {
                        return this.apply$mcZI$sp(x$6);
                    }

                    public boolean apply$mcZI$sp(int x$6) {
                        return this.active$1[x$6];
                    }
                    {
                        this.active$1 = active$1;
                    }
                });
                ++iteration.elem;
            }
            double iterationTimeInSeconds = (double)(System.nanoTime() - iterationStartTime) / 1.0E9;
            this.logInfo((Function0<String>)new Serializable(this, iterationTimeInSeconds){
                public static final long serialVersionUID = 0L;
                private final double iterationTimeInSeconds$1;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Iterations took "})).s((Seq)Nil$.MODULE$)).append((Object)new StringOps(Predef$.MODULE$.augmentString("%.3f")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.iterationTimeInSeconds$1)}))).append((Object)" seconds.").toString();
                }
                {
                    this.iterationTimeInSeconds$1 = iterationTimeInSeconds$1;
                }
            });
            if (iteration.elem == this.org$apache$spark$mllib$clustering$KMeans$$maxIterations()) {
                this.logInfo((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ KMeans $outer;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans reached the max number of iterations: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.org$apache$spark$mllib$clustering$KMeans$$maxIterations())}));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            } else {
                this.logInfo((Function0<String>)new Serializable(this, iteration){
                    public static final long serialVersionUID = 0L;
                    private final IntRef iteration$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"KMeans converged in ", " iterations."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.iteration$1.elem)}));
                    }
                    {
                        this.iteration$1 = iteration$1;
                    }
                });
            }
            Tuple2 tuple2 = (Tuple2)Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(costs).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).min(Ordering$.MODULE$.Tuple2((Ordering)Ordering.Double$.MODULE$, (Ordering)Ordering.Int$.MODULE$));
            if (tuple2 != null) {
                Tuple2.mcDI.sp sp2;
                double minCost = tuple2._1$mcD$sp();
                int bestRun = tuple2._2$mcI$sp();
                Tuple2.mcDI.sp sp3 = sp2 = new Tuple2.mcDI.sp(minCost, bestRun);
                double minCost2 = sp3._1$mcD$sp();
                int bestRun2 = sp3._2$mcI$sp();
                this.logInfo((Function0<String>)new Serializable(this, minCost2){
                    public static final long serialVersionUID = 0L;
                    private final double minCost$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The cost for the best run is ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.minCost$1)}));
                    }
                    {
                        this.minCost$1 = minCost$1;
                    }
                });
                return new KMeansModel((Vector[])Predef$.MODULE$.refArrayOps((Object[])centers[bestRun2]).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Vector apply(VectorWithNorm x$8) {
                        return x$8.vector();
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vector.class))));
            }
            throw new MatchError((Object)tuple2);
        }
        throw new MatchError(option);
    }

    private VectorWithNorm[][] initRandom(RDD<VectorWithNorm> data) {
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs() * this.org$apache$spark$mllib$clustering$KMeans$$k(), (long)new XORShiftRandom(this.seed()).nextInt())).toSeq();
        return (VectorWithNorm[][])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final Seq sample$1;

            public final VectorWithNorm[] apply(int r) {
                return (VectorWithNorm[])((TraversableOnce)((TraversableLike)this.sample$1.slice(r * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), (r + 1) * this.$outer.org$apache$spark$mllib$clustering$KMeans$$k())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final VectorWithNorm apply(VectorWithNorm v) {
                        return new VectorWithNorm(Vectors$.MODULE$.dense(v.vector().toArray()), v.norm());
                    }
                }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.sample$1 = sample$1;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
    }

    private VectorWithNorm[][] initKMeansParallel(RDD<VectorWithNorm> data) {
        ArrayBuffer[] centers = (ArrayBuffer[])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final ArrayBuffer<VectorWithNorm> apply(int r) {
                return (ArrayBuffer)ArrayBuffer$.MODULE$.empty();
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        RDD costs = data.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;

            public final double[] apply(VectorWithNorm x$9) {
                return (double[])Array$.MODULE$.fill(this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return Double.POSITIVE_INFINITY;
                    }
                }, ClassTag$.MODULE$.Double());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        int seed = new XORShiftRandom(this.seed()).nextInt();
        Seq sample = Predef$.MODULE$.refArrayOps((Object[])data.takeSample(true, this.org$apache$spark$mllib$clustering$KMeans$$runs(), (long)seed)).toSeq();
        ArrayBuffer[] newCenters = (ArrayBuffer[])Array$.MODULE$.tabulate(this.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, sample){
            public static final long serialVersionUID = 0L;
            private final Seq sample$2;

            public final ArrayBuffer<VectorWithNorm> apply(int r) {
                return (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new VectorWithNorm[]{((VectorWithNorm)this.sample$2.apply(r)).toDense()}));
            }
            {
                this.sample$2 = sample$2;
            }
        }, ClassTag$.MODULE$.apply(ArrayBuffer.class));
        IntRef step = new IntRef(0);
        while (step.elem < this.initializationSteps()) {
            Broadcast bcNewCenters = data.context().broadcast((Object)newCenters, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ArrayBuffer.class)));
            RDD preCosts = costs;
            costs = data.zip(preCosts, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).map((Function1)new Serializable(this, bcNewCenters){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                public final Broadcast bcNewCenters$1;

                public final double[] apply(Tuple2<VectorWithNorm, double[]> x0$2) {
                    Tuple2<VectorWithNorm, double[]> tuple2 = x0$2;
                    if (tuple2 != null) {
                        VectorWithNorm point = (VectorWithNorm)tuple2._1();
                        double[] cost = (double[])tuple2._2();
                        double[] dArray = (double[])Array$.MODULE$.tabulate(this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, point, cost){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$initKMeansParallel$1 $outer;
                            private final VectorWithNorm point$3;
                            private final double[] cost$1;

                            public final double apply(int r) {
                                return this.apply$mcDI$sp(r);
                            }

                            public double apply$mcDI$sp(int r) {
                                return scala.math.package$.MODULE$.min(KMeans$.MODULE$.pointCost((TraversableOnce<VectorWithNorm>)((ArrayBuffer[])this.$outer.bcNewCenters$1.value())[r], this.point$3), this.cost$1[r]);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.point$3 = point$3;
                                this.cost$1 = cost$1;
                            }
                        }, ClassTag$.MODULE$.Double());
                        return dArray;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.bcNewCenters$1 = bcNewCenters$1;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE))).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK());
            double[] sumCosts = (double[])costs.aggregate((Object)new double[this.org$apache$spark$mllib$clustering$KMeans$$runs()], (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final double[] apply(double[] s, double[] v) {
                    for (int r = 0; r < this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(); ++r) {
                        int n = r;
                        s[n] = s[n] + v[r];
                    }
                    return s;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, (Function2)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;

                public final double[] apply(double[] s0, double[] s1) {
                    for (int r = 0; r < this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(); ++r) {
                        int n = r;
                        s0[n] = s0[n] + s1[r];
                    }
                    return s0;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            bcNewCenters.unpersist(false);
            preCosts.unpersist(false);
            RDD qual$1 = data.zip(costs, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
            Serializable x$13 = new Serializable(this, seed, step, sumCosts){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ KMeans $outer;
                private final int seed$1;
                private final IntRef step$1;
                public final double[] sumCosts$1;

                public final Iterator<Tuple2<VectorWithNorm, IndexedSeq<Object>>> apply(int index2, Iterator<Tuple2<VectorWithNorm, double[]>> pointsWithCosts) {
                    XORShiftRandom rand2 = new XORShiftRandom((long)(this.seed$1 ^ this.step$1.elem << 16 ^ index2));
                    return pointsWithCosts.flatMap((Function1)new Serializable(this, rand2){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$22 $outer;
                        public final XORShiftRandom rand$1;

                        public final Iterable<Tuple2<VectorWithNorm, IndexedSeq<Object>>> apply(Tuple2<VectorWithNorm, double[]> x0$3) {
                            Tuple2<VectorWithNorm, double[]> tuple2 = x0$3;
                            if (tuple2 != null) {
                                VectorWithNorm p = (VectorWithNorm)tuple2._1();
                                double[] c = (double[])tuple2._2();
                                IndexedSeq rs = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$runs()).filter((Function1)new Serializable(this, c){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ $anonfun$22$$anonfun$apply$8 $outer;
                                    private final double[] c$1;

                                    public final boolean apply(int r) {
                                        return this.apply$mcZI$sp(r);
                                    }

                                    public boolean apply$mcZI$sp(int r) {
                                        return this.$outer.rand$1.nextDouble() < 2.0 * this.c$1[r] * (double)this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer().org$apache$spark$mllib$clustering$KMeans$$k() / this.$outer.org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer().sumCosts$1[r];
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.c$1 = c$1;
                                    }
                                });
                                Iterable iterable = rs.length() > 0 ? Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)p, (Object)rs))) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
                                return iterable;
                            }
                            throw new MatchError(tuple2);
                        }

                        public /* synthetic */ $anonfun$22 org$apache$spark$mllib$clustering$KMeans$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.rand$1 = rand$1;
                        }
                    });
                }

                public /* synthetic */ KMeans org$apache$spark$mllib$clustering$KMeans$$anonfun$$$outer() {
                    return this.$outer;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.seed$1 = seed$1;
                    this.step$1 = step$1;
                    this.sumCosts$1 = sumCosts$1;
                }
            };
            boolean x$14 = qual$1.mapPartitionsWithIndex$default$2();
            Tuple2[] chosen = (Tuple2[])qual$1.mapPartitionsWithIndex((Function2)x$13, x$14, ClassTag$.MODULE$.apply(Tuple2.class)).collect();
            this.mergeNewCenters$1(centers, newCenters);
            Predef$.MODULE$.refArrayOps((Object[])chosen).foreach((Function1)new Serializable(this, newCenters){
                public static final long serialVersionUID = 0L;
                public final ArrayBuffer[] newCenters$1;

                public final void apply(Tuple2<VectorWithNorm, IndexedSeq<Object>> x0$4) {
                    Tuple2<VectorWithNorm, IndexedSeq<Object>> tuple2 = x0$4;
                    if (tuple2 != null) {
                        VectorWithNorm p = (VectorWithNorm)tuple2._1();
                        IndexedSeq rs = (IndexedSeq)tuple2._2();
                        rs.foreach((Function1)new Serializable(this, p){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$initKMeansParallel$2 $outer;
                            private final VectorWithNorm p$1;

                            public final ArrayBuffer<VectorWithNorm> apply(int x$10) {
                                return this.$outer.newCenters$1[x$10].$plus$eq((Object)this.p$1.toDense());
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.p$1 = p$1;
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.newCenters$1 = newCenters$1;
                }
            });
            ++step.elem;
        }
        this.mergeNewCenters$1(centers, newCenters);
        costs.unpersist(false);
        Broadcast bcCenters = data.context().broadcast((Object)centers, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(ArrayBuffer.class)));
        Map weightMap = RDD$.MODULE$.rddToPairRDDFunctions(RDD$.MODULE$.rddToPairRDDFunctions(data.flatMap((Function1)new Serializable(this, bcCenters){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            public final Broadcast bcCenters$1;

            public final Iterator<Tuple2<Tuple2<Object, Object>, Object>> apply(VectorWithNorm p) {
                return package$.MODULE$.Iterator().tabulate(this.$outer.org$apache$spark$mllib$clustering$KMeans$$runs(), (Function1)new Serializable(this, p){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$23 $outer;
                    private final VectorWithNorm p$2;

                    public final Tuple2<Tuple2<Object, Object>, Object> apply(int r) {
                        return new Tuple2((Object)new Tuple2.mcII.sp(r, KMeans$.MODULE$.findClosest((TraversableOnce<VectorWithNorm>)((ArrayBuffer[])this.$outer.bcCenters$1.value())[r], this.p$2)._1$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)1.0));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.p$2 = p$2;
                    }
                });
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.bcCenters$1 = bcCenters$1;
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).reduceByKey((Function2)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply(double x$11, double x$12) {
                return this.apply$mcDDD$sp(x$11, x$12);
            }

            public double apply$mcDDD$sp(double x$11, double x$12) {
                return x$11 + x$12;
            }
        }), ClassTag$.MODULE$.apply(Tuple2.class), ClassTag$.MODULE$.Double(), Ordering$.MODULE$.Tuple2((Ordering)Ordering.Int$.MODULE$, (Ordering)Ordering.Int$.MODULE$)).collectAsMap();
        bcCenters.unpersist(false);
        ParSeq finalCenters = (ParSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.org$apache$spark$mllib$clustering$KMeans$$runs()).par().map((Function1)new Serializable(this, centers, weightMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ KMeans $outer;
            private final ArrayBuffer[] centers$2;
            public final Map weightMap$1;

            public final VectorWithNorm[] apply(int r) {
                VectorWithNorm[] myCenters = (VectorWithNorm[])this.centers$2[r].toArray(ClassTag$.MODULE$.apply(VectorWithNorm.class));
                double[] myWeights = (double[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), myCenters.length).map((Function1)new Serializable(this, r){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$24 $outer;
                    private final int r$1;

                    public final double apply(int i) {
                        return this.apply$mcDI$sp(i);
                    }

                    public double apply$mcDI$sp(int i) {
                        return BoxesRunTime.unboxToDouble((Object)this.$outer.weightMap$1.getOrElse((Object)new Tuple2.mcII.sp(this.r$1, i), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final double apply() {
                                return this.apply$mcD$sp();
                            }

                            public double apply$mcD$sp() {
                                return 0.0;
                            }
                        }));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.r$1 = r$1;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Double());
                return LocalKMeans$.MODULE$.kMeansPlusPlus(r, myCenters, myWeights, this.$outer.org$apache$spark$mllib$clustering$KMeans$$k(), 30);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.centers$2 = centers$2;
                this.weightMap$1 = weightMap$1;
            }
        }, (CanBuildFrom)ParSeq$.MODULE$.canBuildFrom());
        return (VectorWithNorm[][])finalCenters.toArray(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(VectorWithNorm.class)));
    }

    public final Tuple2 org$apache$spark$mllib$clustering$KMeans$$mergeContribs$1(Tuple2 x, Tuple2 y) {
        BLAS$.MODULE$.axpy(1.0, (Vector)x._1(), (Vector)y._1());
        return new Tuple2(y._1(), (Object)BoxesRunTime.boxToLong((long)(x._2$mcJ$sp() + y._2$mcJ$sp())));
    }

    private final void mergeNewCenters$1(ArrayBuffer[] centers$2, ArrayBuffer[] newCenters$1) {
        for (int r = 0; r < this.org$apache$spark$mllib$clustering$KMeans$$runs(); ++r) {
            centers$2[r].$plus$plus$eq((TraversableOnce)newCenters$1[r]);
            newCenters$1[r].clear();
        }
    }

    private KMeans(int k, int maxIterations, int runs, String initializationMode, int initializationSteps, double epsilon, long seed) {
        this.org$apache$spark$mllib$clustering$KMeans$$k = k;
        this.org$apache$spark$mllib$clustering$KMeans$$maxIterations = maxIterations;
        this.org$apache$spark$mllib$clustering$KMeans$$runs = runs;
        this.org$apache$spark$mllib$clustering$KMeans$$initializationMode = initializationMode;
        this.initializationSteps = initializationSteps;
        this.org$apache$spark$mllib$clustering$KMeans$$epsilon = epsilon;
        this.seed = seed;
        Logging.class.$init$((Logging)this);
        this.initialModel = None$.MODULE$;
    }

    public KMeans() {
        this(2, 20, 1, KMeans$.MODULE$.K_MEANS_PARALLEL(), 5, 1.0E-4, Utils$.MODULE$.random().nextLong());
    }
}

