/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.impl;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.Logging;
import org.apache.spark.SparkContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005maAB\u0001\u0003\u0003\u0003!AB\u0001\u000bQKJLw\u000eZ5d\u0007\",7m\u001b9pS:$XM\u001d\u0006\u0003\u0007\u0011\tA![7qY*\u0011QAB\u0001\u0006[2d\u0017N\u0019\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sOV\u0011Q\u0002M\n\u0004\u00019!\u0002CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0005\u0002\u0016-5\ta!\u0003\u0002\u0018\r\t9Aj\\4hS:<\u0007\u0002C\r\u0001\u0005\u000b\u0007I\u0011A\u000e\u0002%\rDWmY6q_&tG/\u00138uKJ4\u0018\r\\\u0002\u0001+\u0005a\u0002CA\b\u001e\u0013\tq\u0002CA\u0002J]RD\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\u0014G\",7m\u001b9pS:$\u0018J\u001c;feZ\fG\u000e\t\u0005\tE\u0001\u0011)\u0019!C\u0001G\u0005\u00111oY\u000b\u0002IA\u0011Q#J\u0005\u0003M\u0019\u0011Ab\u00159be.\u001cuN\u001c;fqRD\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0004g\u000e\u0004\u0003\"\u0002\u0016\u0001\t\u0003Y\u0013A\u0002\u001fj]&$h\bF\u0002-si\u00022!\f\u0001/\u001b\u0005\u0011\u0001CA\u00181\u0019\u0001!Q!\r\u0001C\u0002I\u0012\u0011\u0001V\t\u0003gY\u0002\"a\u0004\u001b\n\u0005U\u0002\"a\u0002(pi\"Lgn\u001a\t\u0003\u001f]J!\u0001\u000f\t\u0003\u0007\u0005s\u0017\u0010C\u0003\u001aS\u0001\u0007A\u0004C\u0003#S\u0001\u0007A\u0005C\u0004=\u0001\t\u0007I\u0011B\u001f\u0002\u001f\rDWmY6q_&tG/U;fk\u0016,\u0012A\u0010\t\u0004\u007f\u0011sS\"\u0001!\u000b\u0005\u0005\u0013\u0015aB7vi\u0006\u0014G.\u001a\u0006\u0003\u0007B\t!bY8mY\u0016\u001cG/[8o\u0013\t)\u0005IA\u0003Rk\u0016,X\r\u0003\u0004H\u0001\u0001\u0006IAP\u0001\u0011G\",7m\u001b9pS:$\u0018+^3vK\u0002Bq!\u0013\u0001C\u0002\u0013%Q(\u0001\bqKJ\u001c\u0018n\u001d;fIF+X-^3\t\r-\u0003\u0001\u0015!\u0003?\u0003=\u0001XM]:jgR,G-U;fk\u0016\u0004\u0003bB'\u0001\u0001\u0004%IaG\u0001\fkB$\u0017\r^3D_VtG\u000fC\u0004P\u0001\u0001\u0007I\u0011\u0002)\u0002\u001fU\u0004H-\u0019;f\u0007>,h\u000e^0%KF$\"!\u0015+\u0011\u0005=\u0011\u0016BA*\u0011\u0005\u0011)f.\u001b;\t\u000fUs\u0015\u0011!a\u00019\u0005\u0019\u0001\u0010J\u0019\t\r]\u0003\u0001\u0015)\u0003\u001d\u00031)\b\u000fZ1uK\u000e{WO\u001c;!\u0011\u0015I\u0006\u0001\"\u0001[\u0003\u0019)\b\u000fZ1uKR\u0011\u0011k\u0017\u0005\u00069b\u0003\rAL\u0001\b]\u0016<H)\u0019;b\u0011\u0015q\u0006A\"\u0005`\u0003)\u0019\u0007.Z2la>Lg\u000e\u001e\u000b\u0003#\u0002DQ!Y/A\u00029\nA\u0001Z1uC\")1\r\u0001D\tI\u0006q\u0011n]\"iK\u000e\\\u0007o\\5oi\u0016$GCA3i!\tya-\u0003\u0002h!\t9!i\\8mK\u0006t\u0007\"B1c\u0001\u0004q\u0003\"\u00026\u0001\r#Y\u0017a\u00029feNL7\u000f\u001e\u000b\u0003#2DQ!Y5A\u00029BQA\u001c\u0001\u0007\u0012=\f\u0011\"\u001e8qKJ\u001c\u0018n\u001d;\u0015\u0005E\u0003\b\"B1n\u0001\u0004q\u0003\"\u0002:\u0001\r#\u0019\u0018AE4fi\u000eCWmY6q_&tGOR5mKN$2\u0001^A\b!\u0011)X0!\u0001\u000f\u0005Y\\hBA<{\u001b\u0005A(BA=\u001b\u0003\u0019a$o\\8u}%\t\u0011#\u0003\u0002}!\u00059\u0001/Y2lC\u001e,\u0017B\u0001@\u0000\u0005!IE/\u001a:bE2,'B\u0001?\u0011!\u0011\t\u0019!!\u0003\u000f\u0007=\t)!C\u0002\u0002\bA\ta\u0001\u0015:fI\u00164\u0017\u0002BA\u0006\u0003\u001b\u0011aa\u0015;sS:<'bAA\u0004!!)\u0011-\u001da\u0001]!9\u00111\u0003\u0001\u0005\u0002\u0005U\u0011\u0001\u00063fY\u0016$X-\u00117m\u0007\",7m\u001b9pS:$8\u000fF\u0001R\u0011\u001d\tI\u0002\u0001C\u0005\u0003+\tAC]3n_Z,7\t[3dWB|\u0017N\u001c;GS2,\u0007")
public abstract class PeriodicCheckpointer<T>
implements Logging {
    private final int checkpointInterval;
    private final SparkContext sc;
    private final Queue<T> checkpointQueue;
    private final Queue<T> persistedQueue;
    private int updateCount;
    private transient Logger org$apache$spark$Logging$$log_;

    public Logger org$apache$spark$Logging$$log_() {
        return this.org$apache$spark$Logging$$log_;
    }

    public void org$apache$spark$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public int checkpointInterval() {
        return this.checkpointInterval;
    }

    public SparkContext sc() {
        return this.sc;
    }

    private Queue<T> checkpointQueue() {
        return this.checkpointQueue;
    }

    private Queue<T> persistedQueue() {
        return this.persistedQueue;
    }

    private int updateCount() {
        return this.updateCount;
    }

    private void updateCount_$eq(int x$1) {
        this.updateCount = x$1;
    }

    public void update(T newData) {
        this.persist(newData);
        this.persistedQueue().enqueue((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newData}));
        while (this.persistedQueue().size() > 3) {
            Object dataToUnpersist = this.persistedQueue().dequeue();
            this.unpersist(dataToUnpersist);
        }
        this.updateCount_$eq(this.updateCount() + 1);
        if (this.checkpointInterval() != -1 && this.updateCount() % this.checkpointInterval() == 0 && this.sc().getCheckpointDir().nonEmpty()) {
            this.checkpoint(newData);
            this.checkpointQueue().enqueue((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{newData}));
            boolean canDelete = true;
            while (this.checkpointQueue().size() > 1 && canDelete) {
                if (this.isCheckpointed(this.checkpointQueue().head())) {
                    this.removeCheckpointFile();
                    continue;
                }
                canDelete = false;
            }
        }
    }

    public abstract void checkpoint(T var1);

    public abstract boolean isCheckpointed(T var1);

    public abstract void persist(T var1);

    public abstract void unpersist(T var1);

    public abstract Iterable<String> getCheckpointFiles(T var1);

    public void deleteAllCheckpoints() {
        while (this.checkpointQueue().nonEmpty()) {
            this.removeCheckpointFile();
        }
    }

    private void removeCheckpointFile() {
        Object old = this.checkpointQueue().dequeue();
        FileSystem fs = FileSystem.get((Configuration)this.sc().hadoopConfiguration());
        this.getCheckpointFiles(old).foreach((Function1)new Serializable(this, fs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ PeriodicCheckpointer $outer;
            private final FileSystem fs$1;

            public final Object apply(String checkpointFile) {
                Boolean bl;
                try {
                    bl = BoxesRunTime.boxToBoolean((boolean)this.fs$1.delete(new Path(checkpointFile), true));
                }
                catch (Exception exception) {
                    this.$outer.logWarning((Function0<String>)new Serializable(this, checkpointFile){
                        public static final long serialVersionUID = 0L;
                        private final String checkpointFile$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"PeriodicCheckpointer could not remove old checkpoint file: ").append((Object)this.checkpointFile$1).toString();
                        }
                        {
                            this.checkpointFile$1 = checkpointFile$1;
                        }
                    });
                    bl = BoxedUnit.UNIT;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.fs$1 = fs$1;
            }
        });
    }

    public PeriodicCheckpointer(int checkpointInterval, SparkContext sc) {
        this.checkpointInterval = checkpointInterval;
        this.sc = sc;
        Logging.class.$init$((Logging)this);
        this.checkpointQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.persistedQueue = (Queue)Queue$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.updateCount = 0;
    }
}

