/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.Field;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.BinaryLogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.LogisticCostFun;
import org.apache.spark.ml.classification.LogisticRegressionModel;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.MultiClassSummarizer;
import org.apache.spark.ml.classification.ProbabilisticClassifier;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.regression.LabeledPoint;
import org.apache.spark.mllib.stat.MultivariateOnlineSummarizer;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005]a\u0001B\u0001\u0003\u00015\u0011!\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]*\u00111\u0001B\u0001\u000fG2\f7o]5gS\u000e\fG/[8o\u0015\t)a!\u0001\u0002nY*\u0011q\u0001C\u0001\u0006gB\f'o\u001b\u0006\u0003\u0013)\ta!\u00199bG\",'\"A\u0006\u0002\u0007=\u0014xm\u0001\u0001\u0014\t\u0001qa$\t\t\u0006\u001fA\u0011\"dG\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\u0018!J|'-\u00192jY&\u001cH/[2DY\u0006\u001c8/\u001b4jKJ\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\r1Lg.\u00197h\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t1a+Z2u_J\u0004\"a\u0004\u0001\u0011\u0005=a\u0012BA\u000f\u0003\u0005]aunZ5ti&\u001c'+Z4sKN\u001c\u0018n\u001c8N_\u0012,G\u000e\u0005\u0002\u0010?%\u0011\u0001E\u0001\u0002\u0019\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000eU1sC6\u001c\bC\u0001\u0012$\u001b\u00051\u0011B\u0001\u0013\u0007\u0005\u001daunZ4j]\u001eD\u0001B\n\u0001\u0003\u0006\u0004%\teJ\u0001\u0004k&$W#\u0001\u0015\u0011\u0005%zcB\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z\u0013A\u0002)sK\u0012,g-\u0003\u00021c\t11\u000b\u001e:j]\u001eT!AL\u0016\t\u0011M\u0002!\u0011!Q\u0001\n!\nA!^5eA!)Q\u0007\u0001C\u0001m\u00051A(\u001b8jiz\"\"AG\u001c\t\u000b\u0019\"\u0004\u0019\u0001\u0015\t\u000bU\u0002A\u0011A\u001d\u0015\u0003iAQa\u000f\u0001\u0005\u0002q\n1b]3u%\u0016<\u0007+\u0019:b[R\u0011QHP\u0007\u0002\u0001!)qH\u000fa\u0001\u0001\u0006)a/\u00197vKB\u0011!&Q\u0005\u0003\u0005.\u0012a\u0001R8vE2,\u0007\"\u0002#\u0001\t\u0003)\u0015AE:fi\u0016c\u0017m\u001d;jG:+G\u000fU1sC6$\"!\u0010$\t\u000b}\u001a\u0005\u0019\u0001!\t\u000b!\u0003A\u0011A%\u0002\u0015M,G/T1y\u0013R,'\u000f\u0006\u0002>\u0015\")qh\u0012a\u0001\u0017B\u0011!\u0006T\u0005\u0003\u001b.\u00121!\u00138u\u0011\u0015y\u0005\u0001\"\u0001Q\u0003\u0019\u0019X\r\u001e+pYR\u0011Q(\u0015\u0005\u0006\u007f9\u0003\r\u0001\u0011\u0005\u0006'\u0002!\t\u0001V\u0001\u0010g\u0016$h)\u001b;J]R,'oY3qiR\u0011Q(\u0016\u0005\u0006\u007fI\u0003\rA\u0016\t\u0003U]K!\u0001W\u0016\u0003\u000f\t{w\u000e\\3b]\")!\f\u0001C\u00017\u0006\u00112/\u001a;Ti\u0006tG-\u0019:eSj\fG/[8o)\tiD\fC\u0003@3\u0002\u0007a\u000bC\u0003_\u0001\u0011\u0005s,\u0001\u0007tKR$\u0006N]3tQ>dG\r\u0006\u0002>A\")q(\u0018a\u0001\u0001\")!\r\u0001C!G\u0006aq-\u001a;UQJ,7\u000f[8mIV\t\u0001\tC\u0003f\u0001\u0011\u0005c-A\u0007tKR$\u0006N]3tQ>dGm\u001d\u000b\u0003{\u001dDQa\u00103A\u0002!\u00042AK5A\u0013\tQ7FA\u0003BeJ\f\u0017\u0010C\u0003m\u0001\u0011\u0005S.A\u0007hKR$\u0006N]3tQ>dGm]\u000b\u0002Q\")q\u000e\u0001C)a\u0006)AO]1j]R\u00111$\u001d\u0005\u0006e:\u0004\ra]\u0001\bI\u0006$\u0018m]3u!\t!x/D\u0001v\u0015\t1h!A\u0002tc2L!\u0001_;\u0003\u0013\u0011\u000bG/\u0019$sC6,\u0007\"\u0002>\u0001\t\u0003Z\u0018\u0001B2paf$\"A\u0007?\t\u000buL\b\u0019\u0001@\u0002\u000b\u0015DHO]1\u0011\u0007}\f)!\u0004\u0002\u0002\u0002)\u0019\u00111\u0001\u0003\u0002\u000bA\f'/Y7\n\t\u0005\u001d\u0011\u0011\u0001\u0002\t!\u0006\u0014\u0018-\\'ba\"\u001a\u0001!a\u0003\u0011\t\u00055\u00111C\u0007\u0003\u0003\u001fQ1!!\u0005\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tyA\u0001\u0007FqB,'/[7f]R\fG\u000e")
public class LogisticRegression
extends ProbabilisticClassifier<Vector, LogisticRegression, LogisticRegressionModel>
implements LogisticRegressionParams {
    private final String uid;
    private final DoubleParam threshold;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public void validateParams() {
        LogisticRegressionParams$class.validateParams(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LogisticRegression setRegParam(double value) {
        return (LogisticRegression)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setElasticNetParam(double value) {
        return (LogisticRegression)this.set(this.elasticNetParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setMaxIter(int value) {
        return (LogisticRegression)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LogisticRegression setTol(double value) {
        return (LogisticRegression)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LogisticRegression setFitIntercept(boolean value) {
        return (LogisticRegression)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LogisticRegression setStandardization(boolean value) {
        return (LogisticRegression)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    @Override
    public LogisticRegression setThreshold(double value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    @Override
    public LogisticRegression setThresholds(double[] value) {
        return (LogisticRegression)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    @Override
    public LogisticRegressionModel train(DataFrame dataset) {
        RDD instances = this.extractLabeledPoints(dataset).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<Object, Vector> apply(LabeledPoint x0$1) {
                LabeledPoint labeledPoint = x0$1;
                if (labeledPoint != null) {
                    double label = labeledPoint.label();
                    Vector features = labeledPoint.features();
                    double d = label;
                    if (features != null) {
                        Vector vector = features;
                        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToDouble((double)d), (Object)vector);
                        return tuple2;
                    }
                }
                throw new MatchError((Object)labeledPoint);
            }
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        StorageLevel storageLevel = dataset.rdd().getStorageLevel();
        StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
        boolean handlePersistence = !(storageLevel != null ? !storageLevel.equals(storageLevel2) : storageLevel2 != null);
        Object object = handlePersistence ? instances.persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()) : BoxedUnit.UNIT;
        Tuple2 x$4 = new Tuple2((Object)new MultivariateOnlineSummarizer(), (Object)new MultiClassSummarizer());
        Serializable x$5 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c, Tuple2<Object, Vector> v) {
                Tuple2 tuple2 = new Tuple2(c, v);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple22._1();
                        MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple22._2();
                        if (summarizer != null) {
                            MultivariateOnlineSummarizer multivariateOnlineSummarizer = summarizer;
                            if (labelSummarizer != null) {
                                MultiClassSummarizer multiClassSummarizer = labelSummarizer;
                                if (tuple23 != null) {
                                    double label = tuple23._1$mcD$sp();
                                    Vector features = (Vector)tuple23._2();
                                    double d = label;
                                    if (features != null) {
                                        Vector vector = features;
                                        Tuple2 tuple24 = new Tuple2((Object)multivariateOnlineSummarizer.add(vector), (Object)multiClassSummarizer.add(d));
                                        return tuple24;
                                    }
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        };
        Serializable x$6 = new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> apply(Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c1, Tuple2<MultivariateOnlineSummarizer, MultiClassSummarizer> c2) {
                Tuple2 tuple2 = new Tuple2(c1, c2);
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    Tuple2 tuple23 = (Tuple2)tuple2._2();
                    if (tuple22 != null) {
                        MultivariateOnlineSummarizer summarizer1 = (MultivariateOnlineSummarizer)tuple22._1();
                        MultiClassSummarizer classSummarizer1 = (MultiClassSummarizer)tuple22._2();
                        if (summarizer1 != null) {
                            MultivariateOnlineSummarizer multivariateOnlineSummarizer = summarizer1;
                            if (classSummarizer1 != null) {
                                MultiClassSummarizer multiClassSummarizer = classSummarizer1;
                                if (tuple23 != null) {
                                    MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
                                    MultiClassSummarizer classSummarizer2 = (MultiClassSummarizer)tuple23._2();
                                    if (summarizer2 != null) {
                                        MultivariateOnlineSummarizer multivariateOnlineSummarizer2 = summarizer2;
                                        if (classSummarizer2 != null) {
                                            MultiClassSummarizer multiClassSummarizer2 = classSummarizer2;
                                            Tuple2 tuple24 = new Tuple2((Object)multivariateOnlineSummarizer.merge(multivariateOnlineSummarizer2), (Object)multiClassSummarizer.merge(multiClassSummarizer2));
                                            return tuple24;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
                throw new MatchError((Object)tuple2);
            }
        };
        int x$7 = instances.treeAggregate$default$4((Object)x$4);
        Tuple2 tuple2 = (Tuple2)instances.treeAggregate((Object)x$4, (Function2)x$5, (Function2)x$6, x$7, ClassTag$.MODULE$.apply(Tuple2.class));
        if (tuple2 != null) {
            Tuple3 tuple3;
            Tuple2 tuple22;
            MultivariateOnlineSummarizer summarizer = (MultivariateOnlineSummarizer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            MultivariateOnlineSummarizer summarizer2 = (MultivariateOnlineSummarizer)tuple23._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple23._2();
            long[] histogram2 = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numClasses = histogram2.length;
            int numFeatures = summarizer2.mean().size();
            if (numInvalid != 0L) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in {0 to ", " "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(numClasses - 1))}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)numInvalid)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$1;

                    public final String apply() {
                        return this.msg$1;
                    }
                    {
                        this.msg$1 = msg$1;
                    }
                });
                throw new SparkException(msg);
            }
            if (numClasses > 2) {
                String msg = new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Currently, LogisticRegression with ElasticNet in ML package only supports "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"binary classification. Found ", " in the input dataset."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)numClasses)}))).toString();
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$2;

                    public final String apply() {
                        return this.msg$2;
                    }
                    {
                        this.msg$2 = msg$2;
                    }
                });
                throw new SparkException(msg);
            }
            double[] featuresMean = summarizer2.mean().toArray();
            double[] featuresStd = (double[])Predef$.MODULE$.doubleArrayOps(summarizer2.variance().toArray()).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(double x) {
                    return this.apply$mcDD$sp(x);
                }

                public double apply$mcDD$sp(double x) {
                    return package$.MODULE$.sqrt(x);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            double regParamL1 = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            double regParamL2 = (1.0 - BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam()))) * BoxesRunTime.unboxToDouble((Object)this.$(this.regParam()));
            LogisticCostFun costFun = new LogisticCostFun((RDD<Tuple2<Object, Vector>>)instances, numClasses, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())), featuresStd, featuresMean, regParamL2);
            LBFGS optimizer = BoxesRunTime.unboxToDouble((Object)this.$(this.elasticNetParam())) == 0.0 || BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) == 0.0 ? new LBFGS(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableInnerProductModule)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double())) : new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, this.regParamL1Fun$1(numFeatures, featuresStd, regParamL1), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space((Field)Field.fieldDouble$.MODULE$, ClassTag$.MODULE$.Double()));
            Vector initialWeightsWithIntercept = Vectors$.MODULE$.zeros(BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures);
            if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
                initialWeightsWithIntercept.toArray()[numFeatures] = package$.MODULE$.log((double)histogram2[1] / (double)histogram2[0]);
            }
            Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction((DiffFunction)costFun, DenseVector$.MODULE$.canCopyDenseVector(ClassTag$.MODULE$.Double())), (Object)initialWeightsWithIntercept.toBreeze().toDenseVector$mcD$sp(ClassTag$.MODULE$.Double()));
            ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Double());
            FirstOrderMinimizer.State state = null;
            while (states.hasNext()) {
                state = (FirstOrderMinimizer.State)states.next();
                arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
            }
            if (state == null) {
                String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " failed."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{optimizer.getClass().getName()}));
                this.logError((Function0<String>)new Serializable(this, msg){
                    public static final long serialVersionUID = 0L;
                    private final String msg$3;

                    public final String apply() {
                        return this.msg$3;
                    }
                    {
                        this.msg$3 = msg$3;
                    }
                });
                throw new SparkException(msg);
            }
            double[] rawWeights = (double[])((DenseVector)state.x()).toArray$mcD$sp(ClassTag$.MODULE$.Double()).clone();
            for (int i = 0; i < numFeatures; ++i) {
                int n = i;
                rawWeights[n] = rawWeights[n] * (featuresStd[i] != 0.0 ? 1.0 / featuresStd[i] : 0.0);
            }
            Tuple3 tuple32 = tuple3 = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? new Tuple3((Object)Vectors$.MODULE$.dense((double[])Predef$.MODULE$.doubleArrayOps(rawWeights).dropRight(1)).compressed(), Predef$.MODULE$.doubleArrayOps(rawWeights).last(), arrayBuilder.result()) : new Tuple3((Object)Vectors$.MODULE$.dense(rawWeights).compressed(), (Object)BoxesRunTime.boxToDouble((double)0.0), arrayBuilder.result());
            if (tuple3 != null) {
                Tuple3 tuple33;
                Vector weights2 = (Vector)tuple3._1();
                double intercept2 = BoxesRunTime.unboxToDouble((Object)tuple3._2());
                double[] objectiveHistory = (double[])tuple3._3();
                Tuple3 tuple34 = tuple33 = new Tuple3((Object)weights2, (Object)BoxesRunTime.boxToDouble((double)intercept2), (Object)objectiveHistory);
                Vector weights3 = (Vector)tuple34._1();
                double intercept3 = BoxesRunTime.unboxToDouble((Object)tuple34._2());
                double[] objectiveHistory2 = (double[])tuple34._3();
                Object object2 = handlePersistence ? instances.unpersist(instances.unpersist$default$1()) : BoxedUnit.UNIT;
                LogisticRegressionModel model = this.copyValues(new LogisticRegressionModel(this.uid(), weights3, intercept3), this.copyValues$default$2());
                BinaryLogisticRegressionTrainingSummary logRegSummary = new BinaryLogisticRegressionTrainingSummary(model.transform(dataset), this.$(this.probabilityCol()), this.$(this.labelCol()), objectiveHistory2);
                return model.setSummary(logRegSummary);
            }
            throw new MatchError((Object)tuple3);
        }
        throw new MatchError((Object)tuple2);
    }

    @Override
    public LogisticRegression copy(ParamMap extra) {
        return (LogisticRegression)this.defaultCopy(extra);
    }

    private final Function1 regParamL1Fun$1(int numFeatures$1, double[] featuresStd$1, double regParamL1$1) {
        return new Serializable(this, numFeatures$1, featuresStd$1, regParamL1$1){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegression $outer;
            private final int numFeatures$1;
            private final double[] featuresStd$1;
            private final double regParamL1$1;

            public final double apply(int index) {
                return this.apply$mcDI$sp(index);
            }

            public double apply$mcDI$sp(int index) {
                return index == this.numFeatures$1 ? 0.0 : (BoxesRunTime.unboxToBoolean((Object)this.$outer.$(this.$outer.standardization())) ? this.regParamL1$1 : (this.featuresStd$1[index] != 0.0 ? this.regParamL1$1 / this.featuresStd$1[index] : 0.0));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.numFeatures$1 = numFeatures$1;
                this.featuresStd$1 = featuresStd$1;
                this.regParamL1$1 = regParamL1$1;
            }
        };
    }

    public LogisticRegression(String uid) {
        this.uid = uid;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasThreshold$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.regParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.elasticNetParam().$minus$greater(BoxesRunTime.boxToDouble((double)0.0))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.maxIter().$minus$greater(BoxesRunTime.boxToInteger((int)100))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.tol().$minus$greater(BoxesRunTime.boxToDouble((double)1.0E-6))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.fitIntercept().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.standardization().$minus$greater(BoxesRunTime.boxToBoolean((boolean)true))}));
    }

    public LogisticRegression() {
        this(Identifiable$.MODULE$.randomUID("logreg"));
    }
}

