/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.BinaryLogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionParams;
import org.apache.spark.ml.classification.LogisticRegressionParams$class;
import org.apache.spark.ml.classification.LogisticRegressionSummary;
import org.apache.spark.ml.classification.LogisticRegressionTrainingSummary;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasElasticNetParam$class;
import org.apache.spark.ml.param.shared.HasFitIntercept$class;
import org.apache.spark.ml.param.shared.HasMaxIter$class;
import org.apache.spark.ml.param.shared.HasRegParam$class;
import org.apache.spark.ml.param.shared.HasStandardization$class;
import org.apache.spark.ml.param.shared.HasThreshold$class;
import org.apache.spark.ml.param.shared.HasTol$class;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.DataFrame;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005md\u0001B\u0001\u0003\u00015\u0011q\u0003T8hSN$\u0018n\u0019*fOJ,7o]5p]6{G-\u001a7\u000b\u0005\r!\u0011AD2mCN\u001c\u0018NZ5dCRLwN\u001c\u0006\u0003\u000b\u0019\t!!\u001c7\u000b\u0005\u001dA\u0011!B:qCJ\\'BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001aE\u0002\u0001\u001dm\u0001Ba\u0004\t\u001355\t!!\u0003\u0002\u0012\u0005\t\u0001\u0003K]8cC\nLG.[:uS\u000e\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m!\t\u0019\u0002$D\u0001\u0015\u0015\t)b#\u0001\u0004mS:\fGn\u001a\u0006\u0003/\u0019\tQ!\u001c7mS\nL!!\u0007\u000b\u0003\rY+7\r^8s!\ty\u0001\u0001\u0005\u0002\u00109%\u0011QD\u0001\u0002\u0019\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000eU1sC6\u001c\b\u0002C\u0010\u0001\u0005\u000b\u0007I\u0011\t\u0011\u0002\u0007ULG-F\u0001\"!\t\u0011\u0003F\u0004\u0002$M5\tAEC\u0001&\u0003\u0015\u00198-\u00197b\u0013\t9C%\u0001\u0004Qe\u0016$WMZ\u0005\u0003S)\u0012aa\u0015;sS:<'BA\u0014%\u0011!a\u0003A!A!\u0002\u0013\t\u0013\u0001B;jI\u0002B\u0001B\f\u0001\u0003\u0006\u0004%\taL\u0001\bo\u0016Lw\r\u001b;t+\u0005\u0011\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0011],\u0017n\u001a5ug\u0002B\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001N\u0001\nS:$XM]2faR,\u0012!\u000e\t\u0003GYJ!a\u000e\u0013\u0003\r\u0011{WO\u00197f\u0011!I\u0004A!A!\u0002\u0013)\u0014AC5oi\u0016\u00148-\u001a9uA!11\b\u0001C\u0001\tq\na\u0001P5oSRtD\u0003\u0002\u000e>}}BQa\b\u001eA\u0002\u0005BQA\f\u001eA\u0002IAQa\r\u001eA\u0002UBQ!\u0011\u0001\u0005B\t\u000bAb]3u)\"\u0014Xm\u001d5pY\u0012$\"a\u0011#\u000e\u0003\u0001AQ!\u0012!A\u0002U\nQA^1mk\u0016DQa\u0012\u0001\u0005BQ\nAbZ3u)\"\u0014Xm\u001d5pY\u0012DQ!\u0013\u0001\u0005B)\u000bQb]3u)\"\u0014Xm\u001d5pY\u0012\u001cHCA\"L\u0011\u0015)\u0005\n1\u0001M!\r\u0019S*N\u0005\u0003\u001d\u0012\u0012Q!\u0011:sCfDQ\u0001\u0015\u0001\u0005BE\u000bQbZ3u)\"\u0014Xm\u001d5pY\u0012\u001cX#\u0001'\t\u000fM\u0003!\u0019!C\u0005)\u00061Q.\u0019:hS:,\u0012!\u0016\t\u0005GY\u0013R'\u0003\u0002XI\tIa)\u001e8di&|g.\r\u0005\u00073\u0002\u0001\u000b\u0011B+\u0002\u000f5\f'oZ5oA!91\f\u0001b\u0001\n\u0013!\u0016!B:d_J,\u0007BB/\u0001A\u0003%Q+\u0001\u0004tG>\u0014X\r\t\u0005\b?\u0002\u0011\r\u0011\"\u0011a\u0003)qW/\\\"mCN\u001cXm]\u000b\u0002CB\u00111EY\u0005\u0003G\u0012\u00121!\u00138u\u0011\u0019)\u0007\u0001)A\u0005C\u0006Ya.^7DY\u0006\u001c8/Z:!\u0011\u001d9\u0007\u00011A\u0005\n!\fq\u0002\u001e:bS:LgnZ*v[6\f'/_\u000b\u0002SB\u00191E\u001b7\n\u0005-$#AB(qi&|g\u000e\u0005\u0002\u0010[&\u0011aN\u0001\u0002\"\u0019><\u0017n\u001d;jGJ+wM]3tg&|g\u000e\u0016:bS:LgnZ*v[6\f'/\u001f\u0005\ba\u0002\u0001\r\u0011\"\u0003r\u0003M!(/Y5oS:<7+^7nCJLx\fJ3r)\t\u0011X\u000f\u0005\u0002$g&\u0011A\u000f\n\u0002\u0005+:LG\u000fC\u0004w_\u0006\u0005\t\u0019A5\u0002\u0007a$\u0013\u0007\u0003\u0004y\u0001\u0001\u0006K![\u0001\u0011iJ\f\u0017N\\5oON+X.\\1ss\u0002BQA\u001f\u0001\u0005\u0002m\fqa];n[\u0006\u0014\u00180F\u0001m\u0011\u0019i\b\u0001\"\u0001\u0003}\u0006Q1/\u001a;Tk6l\u0017M]=\u0015\u0005\r{\b\"\u0002>}\u0001\u0004a\u0007bBA\u0002\u0001\u0011\u0005\u0011QA\u0001\u000bQ\u0006\u001c8+^7nCJLXCAA\u0004!\r\u0019\u0013\u0011B\u0005\u0004\u0003\u0017!#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003\u001f\u0001A\u0011\u0001\u0002\u0002\u0012\u0005AQM^1mk\u0006$X\r\u0006\u0003\u0002\u0014\u0005e\u0001cA\b\u0002\u0016%\u0019\u0011q\u0003\u0002\u000331{w-[:uS\u000e\u0014Vm\u001a:fgNLwN\\*v[6\f'/\u001f\u0005\t\u00037\ti\u00011\u0001\u0002\u001e\u00059A-\u0019;bg\u0016$\b\u0003BA\u0010\u0003Ki!!!\t\u000b\u0007\u0005\rb!A\u0002tc2LA!a\n\u0002\"\tIA)\u0019;b\rJ\fW.\u001a\u0005\b\u0003W\u0001A\u0011KA\u0017\u0003\u001d\u0001(/\u001a3jGR$2!NA\u0018\u0011\u001d\t\t$!\u000bA\u0002I\t\u0001BZ3biV\u0014Xm\u001d\u0005\b\u0003k\u0001A\u0011KA\u001c\u0003Y\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,Gc\u0001\n\u0002:!9\u00111HA\u001a\u0001\u0004\u0011\u0012!\u0004:boB\u0013X\rZ5di&|g\u000eC\u0004\u0002@\u0001!\t&!\u0011\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000fF\u0002\u0013\u0003\u0007Bq!!\r\u0002>\u0001\u0007!\u0003C\u0004\u0002H\u0001!\t%!\u0013\u0002\t\r|\u0007/\u001f\u000b\u00045\u0005-\u0003\u0002CA'\u0003\u000b\u0002\r!a\u0014\u0002\u000b\u0015DHO]1\u0011\t\u0005E\u0013qK\u0007\u0003\u0003'R1!!\u0016\u0005\u0003\u0015\u0001\u0018M]1n\u0013\u0011\tI&a\u0015\u0003\u0011A\u000b'/Y7NCBDq!!\u0018\u0001\t#\ny&\u0001\bsC^\u0014\u0004O]3eS\u000e$\u0018n\u001c8\u0015\u0007U\n\t\u0007C\u0004\u0002<\u0005m\u0003\u0019\u0001\n\t\u000f\u0005\u0015\u0004\u0001\"\u0015\u0002h\u00051\u0002O]8cC\nLG.\u001b;zeA\u0014X\rZ5di&|g\u000eF\u00026\u0003SBq!a\u001b\u0002d\u0001\u0007!#A\u0006qe>\u0014\u0017MY5mSRL\bf\u0001\u0001\u0002pA!\u0011\u0011OA<\u001b\t\t\u0019HC\u0002\u0002v\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\tI(a\u001d\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197")
public class LogisticRegressionModel
extends ProbabilisticClassificationModel<Vector, LogisticRegressionModel>
implements LogisticRegressionParams {
    private final String uid;
    private final Vector weights;
    private final double intercept;
    private final Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    private final Function1<Vector, Object> score;
    private final int numClasses;
    private Option<LogisticRegressionTrainingSummary> trainingSummary;
    private final DoubleParam threshold;
    private final BooleanParam standardization;
    private final DoubleParam tol;
    private final BooleanParam fitIntercept;
    private final IntParam maxIter;
    private final DoubleParam elasticNetParam;
    private final DoubleParam regParam;

    @Override
    public void checkThresholdConsistency() {
        LogisticRegressionParams$class.checkThresholdConsistency(this);
    }

    @Override
    public void validateParams() {
        LogisticRegressionParams$class.validateParams(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization$class.getStandardization(this);
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final double getTol() {
        return HasTol$class.getTol(this);
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept$class.getFitIntercept(this);
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter$class.getMaxIter(this);
    }

    @Override
    public final DoubleParam elasticNetParam() {
        return this.elasticNetParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasElasticNetParam$_setter_$elasticNetParam_$eq(DoubleParam x$1) {
        this.elasticNetParam = x$1;
    }

    @Override
    public final double getElasticNetParam() {
        return HasElasticNetParam$class.getElasticNetParam(this);
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public final double getRegParam() {
        return HasRegParam$class.getRegParam(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector weights() {
        return this.weights;
    }

    public double intercept() {
        return this.intercept;
    }

    @Override
    public LogisticRegressionModel setThreshold(double value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThreshold(this, value);
    }

    @Override
    public double getThreshold() {
        return LogisticRegressionParams$class.getThreshold(this);
    }

    @Override
    public LogisticRegressionModel setThresholds(double[] value) {
        return (LogisticRegressionModel)LogisticRegressionParams$class.setThresholds(this, value);
    }

    @Override
    public double[] getThresholds() {
        return LogisticRegressionParams$class.getThresholds(this);
    }

    public Function1<Vector, Object> org$apache$spark$ml$classification$LogisticRegressionModel$$margin() {
        return this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin;
    }

    private Function1<Vector, Object> score() {
        return this.score;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    private Option<LogisticRegressionTrainingSummary> trainingSummary() {
        return this.trainingSummary;
    }

    private void trainingSummary_$eq(Option<LogisticRegressionTrainingSummary> x$1) {
        this.trainingSummary = x$1;
    }

    public LogisticRegressionTrainingSummary summary() {
        Option<LogisticRegressionTrainingSummary> option = this.trainingSummary();
        if (option instanceof Some) {
            LogisticRegressionTrainingSummary summ;
            Some some = (Some)option;
            LogisticRegressionTrainingSummary logisticRegressionTrainingSummary = summ = (LogisticRegressionTrainingSummary)some.x();
            return logisticRegressionTrainingSummary;
        }
        if (None$.MODULE$.equals(option)) {
            throw new SparkException("No training summary available for this LogisticRegressionModel", (Throwable)new NullPointerException());
        }
        throw new MatchError(option);
    }

    public LogisticRegressionModel setSummary(LogisticRegressionTrainingSummary summary) {
        this.trainingSummary_$eq((Option<LogisticRegressionTrainingSummary>)new Some((Object)summary));
        return this;
    }

    public boolean hasSummary() {
        return this.trainingSummary().isDefined();
    }

    public LogisticRegressionSummary evaluate(DataFrame dataset) {
        return new BinaryLogisticRegressionSummary(this.transform(dataset), this.$(this.probabilityCol()), this.$(this.labelCol()));
    }

    @Override
    public double predict(Vector features) {
        return BoxesRunTime.unboxToDouble((Object)this.score().apply((Object)features)) > this.getThreshold() ? 1.0 : 0.0;
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            for (int i = 0; i < size; ++i) {
                denseVector.values()[i] = 1.0 / (1.0 + package$.MODULE$.exp(-denseVector.values()[i]));
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in LogisticRegressionModel: raw2probabilitiesInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public Vector predictRaw(Vector features) {
        double m = BoxesRunTime.unboxToDouble((Object)this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
        return Vectors$.MODULE$.dense(-m, (Seq<Object>)Predef$.MODULE$.wrapDoubleArray(new double[]{m}));
    }

    @Override
    public LogisticRegressionModel copy(ParamMap extra) {
        return (LogisticRegressionModel)((Model)this.copyValues(new LogisticRegressionModel(this.uid(), this.weights(), this.intercept()), extra)).setParent(this.parent());
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        double t = this.getThreshold();
        double rawThreshold = t == 0.0 ? Double.NEGATIVE_INFINITY : (t == 1.0 ? Double.POSITIVE_INFINITY : package$.MODULE$.log(t / (1.0 - t)));
        return rawPrediction.apply(1) > rawThreshold ? 1.0 : 0.0;
    }

    @Override
    public double probability2prediction(Vector probability) {
        return probability.apply(1) > this.getThreshold() ? 1.0 : 0.0;
    }

    public LogisticRegressionModel(String uid, Vector weights2, double intercept2) {
        this.uid = uid;
        this.weights = weights2;
        this.intercept = intercept2;
        HasRegParam$class.$init$(this);
        HasElasticNetParam$class.$init$(this);
        HasMaxIter$class.$init$(this);
        HasFitIntercept$class.$init$(this);
        HasTol$class.$init$(this);
        HasStandardization$class.$init$(this);
        HasThreshold$class.$init$(this);
        LogisticRegressionParams$class.$init$(this);
        this.org$apache$spark$ml$classification$LogisticRegressionModel$$margin = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final double apply(Vector features) {
                return BLAS$.MODULE$.dot(features, this.$outer.weights()) + this.$outer.intercept();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.score = new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogisticRegressionModel $outer;

            public final double apply(Vector features) {
                double m = BoxesRunTime.unboxToDouble((Object)this.$outer.org$apache$spark$ml$classification$LogisticRegressionModel$$margin().apply((Object)features));
                return 1.0 / (1.0 + package$.MODULE$.exp(-m));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.numClasses = 2;
        this.trainingSummary = None$.MODULE$;
    }
}

