/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.SparkException;
import org.apache.spark.annotation.Experimental;
import org.apache.spark.ml.classification.NaiveBayes;
import org.apache.spark.ml.classification.NaiveBayesModel$;
import org.apache.spark.ml.classification.NaiveBayesParams;
import org.apache.spark.ml.classification.NaiveBayesParams$class;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.mllib.classification.NaiveBayes$;
import org.apache.spark.mllib.linalg.BLAS$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Matrix;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u0005uc\u0001B\u0001\u0003\u00015\u0011qBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\u0006\u0003\u0007\u0011\tab\u00197bgNLg-[2bi&|gN\u0003\u0002\u0006\r\u0005\u0011Q\u000e\u001c\u0006\u0003\u000f!\tQa\u001d9be.T!!\u0003\u0006\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Y\u0011aA8sO\u000e\u00011c\u0001\u0001\u000f7A!q\u0002\u0005\n\u001b\u001b\u0005\u0011\u0011BA\t\u0003\u0005\u0001\u0002&o\u001c2bE&d\u0017n\u001d;jG\u000ec\u0017m]:jM&\u001c\u0017\r^5p]6{G-\u001a7\u0011\u0005MAR\"\u0001\u000b\u000b\u0005U1\u0012A\u00027j]\u0006dwM\u0003\u0002\u0018\r\u0005)Q\u000e\u001c7jE&\u0011\u0011\u0004\u0006\u0002\u0007-\u0016\u001cGo\u001c:\u0011\u0005=\u0001\u0001CA\b\u001d\u0013\ti\"A\u0001\tOC&4XMQ1zKN\u0004\u0016M]1ng\"Aq\u0004\u0001BC\u0002\u0013\u0005\u0003%A\u0002vS\u0012,\u0012!\t\t\u0003E!r!a\t\u0014\u000e\u0003\u0011R\u0011!J\u0001\u0006g\u000e\fG.Y\u0005\u0003O\u0011\na\u0001\u0015:fI\u00164\u0017BA\u0015+\u0005\u0019\u0019FO]5oO*\u0011q\u0005\n\u0005\tY\u0001\u0011\t\u0011)A\u0005C\u0005!Q/\u001b3!\u0011!q\u0003A!b\u0001\n\u0003y\u0013A\u00019j+\u0005\u0011\u0002\u0002C\u0019\u0001\u0005\u0003\u0005\u000b\u0011\u0002\n\u0002\u0007AL\u0007\u0005\u0003\u00054\u0001\t\u0015\r\u0011\"\u00015\u0003\u0015!\b.\u001a;b+\u0005)\u0004CA\n7\u0013\t9DC\u0001\u0004NCR\u0014\u0018\u000e\u001f\u0005\ts\u0001\u0011\t\u0011)A\u0005k\u00051A\u000f[3uC\u0002Baa\u000f\u0001\u0005\u0002\u0011a\u0014A\u0002\u001fj]&$h\b\u0006\u0003\u001b{yz\u0004\"B\u0010;\u0001\u0004\t\u0003\"\u0002\u0018;\u0001\u0004\u0011\u0002\"B\u001a;\u0001\u0004)\u0004BC!\u0001!\u0003E9\u0019)C\u0005\u0005\u0006\u0019\u0001\u0010J\u0019\u0016\u0003\r\u0003Ba\t#G\u0013&\u0011Q\t\n\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0007\r:U'\u0003\u0002II\t1q\n\u001d;j_:\u00042aI$K!\t\u00192*\u0003\u0002M)\tYA)\u001a8tKZ+7\r^8s\u0011!q\u0005\u0001#A!B\u0013\u0019\u0015\u0001\u0002=%c\u0001B\u0001\u0002\u0015\u0001\t\u0006\u0004%I!U\u0001\u0013i\",G/Y'j]V\u001ch*Z4UQ\u0016$\u0018-F\u0001G\u0011!\u0019\u0006\u0001#A!B\u00131\u0015a\u0005;iKR\fW*\u001b8vg:+w\r\u00165fi\u0006\u0004\u0003\u0002C+\u0001\u0011\u000b\u0007I\u0011\u0002,\u0002\u00179,w\r\u00165fi\u0006\u001cV/\\\u000b\u0002\u0013\"A\u0001\f\u0001E\u0001B\u0003&\u0011*\u0001\u0007oK\u001e$\u0006.\u001a;b'Vl\u0007\u0005C\u0004[\u0001\t\u0007I\u0011I.\u0002\u00159,Xn\u00117bgN,7/F\u0001]!\t\u0019S,\u0003\u0002_I\t\u0019\u0011J\u001c;\t\r\u0001\u0004\u0001\u0015!\u0003]\u0003-qW/\\\"mCN\u001cXm\u001d\u0011\t\u000b\t\u0004A\u0011B2\u0002-5,H\u000e^5o_6L\u0017\r\\\"bY\u000e,H.\u0019;j_:$\"A\u00133\t\u000b\u0015\f\u0007\u0019\u0001\n\u0002\u0011\u0019,\u0017\r^;sKNDQa\u001a\u0001\u0005\n!\fACY3s]>,H\u000e\\5DC2\u001cW\u000f\\1uS>tGC\u0001&j\u0011\u0015)g\r1\u0001\u0013\u0011\u0015Y\u0007\u0001\"\u0015m\u0003)\u0001(/\u001a3jGR\u0014\u0016m\u001e\u000b\u0003%5DQ!\u001a6A\u0002IAQa\u001c\u0001\u0005RA\faC]1xeA\u0014xNY1cS2LG/_%o!2\f7-\u001a\u000b\u0003%EDQA\u001d8A\u0002I\tQB]1x!J,G-[2uS>t\u0007\"\u0002;\u0001\t\u0003*\u0018\u0001B2paf$\"A\u0007<\t\u000b]\u001c\b\u0019\u0001=\u0002\u000b\u0015DHO]1\u0011\u0005edX\"\u0001>\u000b\u0005m$\u0011!\u00029be\u0006l\u0017BA?{\u0005!\u0001\u0016M]1n\u001b\u0006\u0004\bBB@\u0001\t\u0003\n\t!\u0001\u0005u_N#(/\u001b8h)\u0005\t\u0003f\u0001\u0001\u0002\u0006A!\u0011qAA\u0007\u001b\t\tIAC\u0002\u0002\f\u0019\t!\"\u00198o_R\fG/[8o\u0013\u0011\ty!!\u0003\u0003\u0019\u0015C\b/\u001a:j[\u0016tG/\u00197\b\u0011\u0005M!\u0001#\u0001\u0005\u0003+\tqBT1jm\u0016\u0014\u0015-_3t\u001b>$W\r\u001c\t\u0004\u001f\u0005]aaB\u0001\u0003\u0011\u0003!\u0011\u0011D\n\u0007\u0003/\tY\"!\t\u0011\u0007\r\ni\"C\u0002\u0002 \u0011\u0012a!\u00118z%\u00164\u0007cA\u0012\u0002$%\u0019\u0011Q\u0005\u0013\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000fm\n9\u0002\"\u0001\u0002*Q\u0011\u0011Q\u0003\u0005\t\u0003[\t9\u0002\"\u0001\u00020\u00059aM]8n\u001f2$G#\u0002\u000e\u00022\u0005u\u0002\u0002CA\u001a\u0003W\u0001\r!!\u000e\u0002\u0011=dG-T8eK2\u0004B!a\u000e\u0002<5\u0011\u0011\u0011\b\u0006\u0003\u0007YI1!AA\u001d\u0011!\ty$a\u000bA\u0002\u0005\u0005\u0013A\u00029be\u0016tG\u000fE\u0002\u0010\u0003\u0007J1!!\u0012\u0003\u0005)q\u0015-\u001b<f\u0005\u0006LXm\u001d\u0005\u000b\u0003\u0013\n9\"!A\u0005\n\u0005-\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!!\u0014\u0011\t\u0005=\u0013\u0011L\u0007\u0003\u0003#RA!a\u0015\u0002V\u0005!A.\u00198h\u0015\t\t9&\u0001\u0003kCZ\f\u0017\u0002BA.\u0003#\u0012aa\u00142kK\u000e$\b")
public class NaiveBayesModel
extends ProbabilisticClassificationModel<Vector, NaiveBayesModel>
implements NaiveBayesParams {
    private final String uid;
    private final Vector pi;
    private final Matrix theta;
    private Tuple2<Option<Matrix>, Option<DenseVector>> x$1;
    private Option<Matrix> thetaMinusNegTheta;
    private Option<DenseVector> negThetaSum;
    private final int numClasses;
    private final DoubleParam smoothing;
    private final Param<String> modelType;
    private volatile byte bitmap$0;

    public static NaiveBayesModel fromOld(org.apache.spark.mllib.classification.NaiveBayesModel naiveBayesModel, NaiveBayes naiveBayes) {
        return NaiveBayesModel$.MODULE$.fromOld(naiveBayesModel, naiveBayes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple2 x$1$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                Tuple2 tuple2;
                Tuple2 tuple22;
                String string = this.$(this.modelType());
                String string2 = NaiveBayes$.MODULE$.Multinomial();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    tuple22 = new Tuple2((Object)None$.MODULE$, (Object)None$.MODULE$);
                } else {
                    String string4 = NaiveBayes$.MODULE$.Bernoulli();
                    String string5 = string;
                    if (string4 != null ? !string4.equals(string5) : string5 != null) throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.modelType())})));
                    Matrix negTheta = this.theta().map((Function1<Object, Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(double value) {
                            return this.apply$mcDD$sp(value);
                        }

                        public double apply$mcDD$sp(double value) {
                            return package$.MODULE$.log(1.0 - package$.MODULE$.exp(value));
                        }
                    });
                    DenseVector ones2 = new DenseVector((double[])Array$.MODULE$.fill(this.theta().numCols(), (Function0)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply() {
                            return this.apply$mcD$sp();
                        }

                        public double apply$mcD$sp() {
                            return 1.0;
                        }
                    }, ClassTag$.MODULE$.Double()));
                    Matrix thetaMinusNegTheta = this.theta().map((Function1<Object, Object>)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final double apply(double value) {
                            return this.apply$mcDD$sp(value);
                        }

                        public double apply$mcDD$sp(double value) {
                            return value - package$.MODULE$.log(1.0 - package$.MODULE$.exp(value));
                        }
                    });
                    tuple22 = new Tuple2((Object)Option$.MODULE$.apply((Object)thetaMinusNegTheta), (Object)Option$.MODULE$.apply((Object)negTheta.multiply(ones2)));
                }
                Tuple2 tuple23 = tuple22;
                if (tuple23 == null) throw new MatchError((Object)tuple23);
                Option thetaMinusNegTheta = (Option)tuple23._1();
                Option negThetaSum = (Option)tuple23._2();
                this.x$1 = tuple2 = new Tuple2((Object)thetaMinusNegTheta, (Object)negThetaSum);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.x$1;
        }
    }

    private Option thetaMinusNegTheta$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.thetaMinusNegTheta = (Option)this.x$1()._1();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.thetaMinusNegTheta;
        }
    }

    private Option negThetaSum$lzycompute() {
        NaiveBayesModel naiveBayesModel = this;
        synchronized (naiveBayesModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.negThetaSum = (Option)this.x$1()._2();
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.negThetaSum;
        }
    }

    @Override
    public final DoubleParam smoothing() {
        return this.smoothing;
    }

    @Override
    public final Param<String> modelType() {
        return this.modelType;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$smoothing_$eq(DoubleParam x$1) {
        this.smoothing = x$1;
    }

    @Override
    public final void org$apache$spark$ml$classification$NaiveBayesParams$_setter_$modelType_$eq(Param x$1) {
        this.modelType = x$1;
    }

    @Override
    public final double getSmoothing() {
        return NaiveBayesParams$class.getSmoothing(this);
    }

    @Override
    public final String getModelType() {
        return NaiveBayesParams$class.getModelType(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public Vector pi() {
        return this.pi;
    }

    public Matrix theta() {
        return this.theta;
    }

    private /* synthetic */ Tuple2 x$1() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.x$1$lzycompute() : this.x$1;
    }

    private Option<Matrix> thetaMinusNegTheta() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.thetaMinusNegTheta$lzycompute() : this.thetaMinusNegTheta;
    }

    private Option<DenseVector> negThetaSum() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.negThetaSum$lzycompute() : this.negThetaSum;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector multinomialCalculation(Vector features) {
        void var2_2;
        DenseVector prob2 = this.theta().multiply(features);
        BLAS$.MODULE$.axpy(1.0, this.pi(), (Vector)prob2);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private DenseVector bernoulliCalculation(Vector features) {
        void var2_2;
        features.foreachActive((Function2<Object, Object, BoxedUnit>)new Serializable(this, features){
            public static final long serialVersionUID = 0L;
            private final Vector features$1;

            public final void apply(int x$2, double value) {
                this.apply$mcVID$sp(x$2, value);
            }

            public void apply$mcVID$sp(int x$2, double value) {
                if (value != 0.0 && value != 1.0) {
                    throw new SparkException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Bernoulli naive Bayes requires 0 or 1 feature values but found ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.features$1})));
                }
            }
            {
                this.features$1 = features$1;
            }
        });
        DenseVector prob2 = ((Matrix)this.thetaMinusNegTheta().get()).multiply(features);
        BLAS$.MODULE$.axpy(1.0, this.pi(), (Vector)prob2);
        BLAS$.MODULE$.axpy(1.0, (Vector)this.negThetaSum().get(), (Vector)prob2);
        return var2_2;
    }

    @Override
    public Vector predictRaw(Vector features) {
        block4: {
            DenseVector denseVector;
            block3: {
                String string;
                block2: {
                    string = this.$(this.modelType());
                    String string2 = NaiveBayes$.MODULE$.Multinomial();
                    String string3 = string;
                    if (string2 != null ? !string2.equals(string3) : string3 != null) break block2;
                    denseVector = this.multinomialCalculation(features);
                    break block3;
                }
                String string4 = NaiveBayes$.MODULE$.Bernoulli();
                String string5 = string;
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block4;
                denseVector = this.bernoulliCalculation(features);
            }
            return denseVector;
        }
        throw new UnknownError(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Invalid modelType: ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$(this.modelType())})));
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            int i;
            DenseVector denseVector = (DenseVector)vector;
            int size = denseVector.size();
            double maxLog = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(denseVector.values()).max((Ordering)Ordering.Double$.MODULE$));
            for (i = 0; i < size; ++i) {
                denseVector.values()[i] = package$.MODULE$.exp(denseVector.values()[i] - maxLog);
            }
            double probSum = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(denseVector.values()).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
            for (i = 0; i < size; ++i) {
                denseVector.values()[i] = denseVector.values()[i] / probSum;
            }
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in NaiveBayesModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public NaiveBayesModel copy(ParamMap extra) {
        return (NaiveBayesModel)this.copyValues(new NaiveBayesModel(this.uid(), this.pi(), this.theta()).setParent(this.parent()), extra);
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"NaiveBayesModel with ", " classes"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.pi().size())}));
    }

    public NaiveBayesModel(String uid, Vector pi, Matrix theta) {
        this.uid = uid;
        this.pi = pi;
        this.theta = theta;
        NaiveBayesParams$class.$init$(this);
        this.numClasses = pi.size();
    }
}

