/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.DeveloperApi;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.ClassifierParams$class;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams;
import org.apache.spark.ml.classification.ProbabilisticClassifierParams$class;
import org.apache.spark.ml.param.DoubleArrayParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.shared.HasProbabilityCol$class;
import org.apache.spark.ml.param.shared.HasThresholds$class;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@DeveloperApi
@ScalaSignature(bytes="\u0006\u0001\u00055b!B\u0001\u0003\u0003\u0003i!\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2T!a\u0001\u0003\u0002\u001d\rd\u0017m]:jM&\u001c\u0017\r^5p]*\u0011QAB\u0001\u0003[2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011AB1qC\u000eDWMC\u0001\f\u0003\ry'oZ\u0002\u0001+\rqQCI\n\u0004\u0001=1\u0003\u0003\u0002\t\u0012'\u0005j\u0011AA\u0005\u0003%\t\u00111c\u00117bgNLg-[2bi&|g.T8eK2\u0004\"\u0001F\u000b\r\u0001\u0011)a\u0003\u0001b\u0001/\taa)Z1ukJ,7\u000fV=qKF\u0011\u0001D\b\t\u00033qi\u0011A\u0007\u0006\u00027\u0005)1oY1mC&\u0011QD\u0007\u0002\b\u001d>$\b.\u001b8h!\tIr$\u0003\u0002!5\t\u0019\u0011I\\=\u0011\u0005Q\u0011C!B\u0012\u0001\u0005\u0004!#!A'\u0012\u0005a)\u0003\u0003\u0002\t\u0001'\u0005\u0002\"\u0001E\u0014\n\u0005!\u0012!!\b)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[3s!\u0006\u0014\u0018-\\:\t\u000b)\u0002A\u0011A\u0016\u0002\rqJg.\u001b;?)\u0005)\u0003\"B\u0017\u0001\t\u0003q\u0013!E:fiB\u0013xNY1cS2LG/_\"pYR\u0011\u0011e\f\u0005\u0006a1\u0002\r!M\u0001\u0006m\u0006dW/\u001a\t\u0003eUr!!G\u001a\n\u0005QR\u0012A\u0002)sK\u0012,g-\u0003\u00027o\t11\u000b\u001e:j]\u001eT!\u0001\u000e\u000e\t\u000be\u0002A\u0011\u0001\u001e\u0002\u001bM,G\u000f\u00165sKNDw\u000e\u001c3t)\t\t3\bC\u00031q\u0001\u0007A\bE\u0002\u001a{}J!A\u0010\u000e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005e\u0001\u0015BA!\u001b\u0005\u0019!u.\u001e2mK\")1\t\u0001C!\t\u0006IAO]1og\u001a|'/\u001c\u000b\u0003\u000b.\u0003\"AR%\u000e\u0003\u001dS!\u0001\u0013\u0004\u0002\u0007M\fH.\u0003\u0002K\u000f\nIA)\u0019;b\rJ\fW.\u001a\u0005\u0006\u0019\n\u0003\r!R\u0001\bI\u0006$\u0018m]3u\u0011\u0015q\u0005A\"\u0005P\u0003Y\u0011\u0018m\u001e\u001aqe>\u0014\u0017MY5mSRL\u0018J\u001c)mC\u000e,GC\u0001)Y!\t\tf+D\u0001S\u0015\t\u0019F+\u0001\u0004mS:\fGn\u001a\u0006\u0003+\u001a\tQ!\u001c7mS\nL!a\u0016*\u0003\rY+7\r^8s\u0011\u0015IV\n1\u0001Q\u00035\u0011\u0018m\u001e)sK\u0012L7\r^5p]\")1\f\u0001C\t9\u0006y!/Y<3aJ|'-\u00192jY&$\u0018\u0010\u0006\u0002Q;\")\u0011L\u0017a\u0001!\")q\f\u0001C)A\u0006q!/Y<3aJ,G-[2uS>tGCA b\u0011\u0015If\f1\u0001Q\u0011\u0015\u0019\u0007\u0001\"\u0005e\u0003I\u0001(/\u001a3jGR\u0004&o\u001c2bE&d\u0017\u000e^=\u0015\u0005A+\u0007\"\u00024c\u0001\u0004\u0019\u0012\u0001\u00034fCR,(/Z:\t\u000b!\u0004A\u0011C5\u0002-A\u0014xNY1cS2LG/\u001f\u001aqe\u0016$\u0017n\u0019;j_:$\"a\u00106\t\u000b-<\u0007\u0019\u0001)\u0002\u0017A\u0014xNY1cS2LG/\u001f\u0015\u0003\u00015\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\u0004\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002s_\naA)\u001a<fY>\u0004XM]!qS\u001e1AO\u0001E\u0001\tU\f\u0001\u0005\u0015:pE\u0006\u0014\u0017\u000e\\5ti&\u001c7\t\\1tg&4\u0017nY1uS>tWj\u001c3fYB\u0011\u0001C\u001e\u0004\u0007\u0003\tA\t\u0001B<\u0014\u0007YD8\u0010\u0005\u0002\u001as&\u0011!P\u0007\u0002\u0007\u0003:L(+\u001a4\u0011\u0005ea\u0018BA?\u001b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015Qc\u000f\"\u0001\u0000)\u0005)\bbBA\u0002m\u0012\u0005\u0011QA\u0001 ]>\u0014X.\u00197ju\u0016$v\u000e\u0015:pE\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\u0018J\u001c)mC\u000e,G\u0003BA\u0004\u0003\u001b\u00012!GA\u0005\u0013\r\tYA\u0007\u0002\u0005+:LG\u000f\u0003\u0005\u0002\u0010\u0005\u0005\u0001\u0019AA\t\u0003\u00051\bcA)\u0002\u0014%\u0019\u0011Q\u0003*\u0003\u0017\u0011+gn]3WK\u000e$xN\u001d\u0005\n\u000331\u0018\u0011!C\u0005\u00037\t1B]3bIJ+7o\u001c7wKR\u0011\u0011Q\u0004\t\u0005\u0003?\tI#\u0004\u0002\u0002\")!\u00111EA\u0013\u0003\u0011a\u0017M\\4\u000b\u0005\u0005\u001d\u0012\u0001\u00026bm\u0006LA!a\u000b\u0002\"\t1qJ\u00196fGR\u0004")
public abstract class ProbabilisticClassificationModel<FeaturesType, M extends ProbabilisticClassificationModel<FeaturesType, M>>
extends ClassificationModel<FeaturesType, M>
implements ProbabilisticClassifierParams {
    private final DoubleArrayParam thresholds;
    private final Param<String> probabilityCol;

    public static void normalizeToProbabilitiesInPlace(DenseVector denseVector) {
        ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
    }

    @Override
    public /* synthetic */ StructType org$apache$spark$ml$classification$ProbabilisticClassifierParams$$super$validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public StructType validateAndTransformSchema(StructType schema, boolean fitting, DataType featuresDataType) {
        return ProbabilisticClassifierParams$class.validateAndTransformSchema(this, schema, fitting, featuresDataType);
    }

    @Override
    public final DoubleArrayParam thresholds() {
        return this.thresholds;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasThresholds$_setter_$thresholds_$eq(DoubleArrayParam x$1) {
        this.thresholds = x$1;
    }

    @Override
    public double[] getThresholds() {
        return HasThresholds$class.getThresholds(this);
    }

    @Override
    public final Param<String> probabilityCol() {
        return this.probabilityCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasProbabilityCol$_setter_$probabilityCol_$eq(Param x$1) {
        this.probabilityCol = x$1;
    }

    @Override
    public final String getProbabilityCol() {
        return HasProbabilityCol$class.getProbabilityCol(this);
    }

    public M setProbabilityCol(String value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.probabilityCol(), value));
    }

    public M setThresholds(double[] value) {
        return (M)((ProbabilisticClassificationModel)this.set(this.thresholds(), value));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataFrame transform(DataFrame dataset) {
        void var2_2;
        this.transformSchema(dataset.schema(), true);
        if (this.isDefined(this.thresholds())) {
            Predef$.MODULE$.require(this.$(this.thresholds()).length == this.numClasses(), (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)this.$outer.getClass().getSimpleName()).append((Object)".transform() called with non-matching numClasses and thresholds.length.").append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" numClasses=", ", but thresholds has length ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.$outer.numClasses()), BoxesRunTime.boxToInteger((int)this.$outer.$(this.$outer.thresholds()).length)}))).toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        DataFrame outputData = dataset;
        int numColsOutput = 0;
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
            JavaUniverse $u = package$.MODULE$.universe();
            JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
            public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1
            extends TypeCreator {
                public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                    Universe $u = $m$untyped.universe();
                    Mirror<U> $m = $m$untyped;
                    return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                }

                public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                }
            }
            UserDefinedFunction predictRawUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final Vector apply(Object features) {
                    return this.$outer.predictRaw(features);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator1$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
            outputData = outputData.withColumn(this.getRawPredictionCol(), predictRawUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.getFeaturesCol())})));
            ++numColsOutput;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
            Column column;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                JavaUniverse $u2 = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final Vector apply(Vector rawPrediction) {
                        return this.$outer.raw2probability(rawPrediction);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator2$1(this)), ((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator3$1(this))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
            } else {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                UserDefinedFunction probabilityUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final Vector apply(Object features) {
                        return this.$outer.predictProbability(features);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator4$1(this)), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                column = probabilityUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column probUDF = column;
            outputData = outputData.withColumn(this.$(this.probabilityCol()), probUDF);
            ++numColsOutput;
        }
        if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.predictionCol()))).nonEmpty()) {
            Column column;
            if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.rawPredictionCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final double apply(Vector rawPrediction) {
                        return this.$outer.raw2prediction(rawPrediction);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator5$1(this))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.rawPredictionCol()))}));
            } else if (new StringOps(Predef$.MODULE$.augmentString(this.$(this.probabilityCol()))).nonEmpty()) {
                JavaUniverse $u = package$.MODULE$.universe();
                JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(ProbabilisticClassificationModel.class.getClassLoader());
                public final class Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1
                extends TypeCreator {
                    public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                        Universe $u = $m$untyped.universe();
                        Mirror<U> $m = $m$untyped;
                        return $m.staticClass("org.apache.spark.mllib.linalg.Vector").asType().toTypeConstructor();
                    }

                    public Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(ProbabilisticClassificationModel<FeaturesType, M> $outer) {
                    }
                }
                column = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final double apply(Vector probability) {
                        return this.$outer.probability2prediction(probability);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_ml_classification_ProbabilisticClassificationModel$$typecreator6$1(this))).apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.probabilityCol()))}));
            } else {
                UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ ProbabilisticClassificationModel $outer;

                    public final double apply(Object features) {
                        return this.$outer.predict(features);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
                column = predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))}));
            }
            Column predUDF = column;
            outputData = outputData.withColumn(this.$(this.predictionCol()), predUDF);
            ++numColsOutput;
        }
        if (numColsOutput == 0) {
            this.logWarning((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ ProbabilisticClassificationModel $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ": ProbabilisticClassificationModel.transform() was called as NOOP"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.uid()}))).append((Object)" since no output columns were set.").toString();
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
        }
        return var2_2;
    }

    public abstract Vector raw2probabilityInPlace(Vector var1);

    public Vector raw2probability(Vector rawPrediction) {
        Vector probs = rawPrediction.copy();
        return this.raw2probabilityInPlace(probs);
    }

    @Override
    public double raw2prediction(Vector rawPrediction) {
        return this.isDefined(this.thresholds()) ? this.probability2prediction(this.raw2probability(rawPrediction)) : (double)rawPrediction.argmax();
    }

    public Vector predictProbability(FeaturesType features) {
        Vector rawPreds = this.predictRaw(features);
        return this.raw2probabilityInPlace(rawPreds);
    }

    public double probability2prediction(Vector probability) {
        double d;
        if (this.isDefined(this.thresholds())) {
            double[] thresholds2 = this.getThresholds();
            double[] scaledProbability = (double[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.doubleArrayOps(probability.toArray()).zip((GenIterable)Predef$.MODULE$.wrapDoubleArray(thresholds2), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final double apply(Tuple2<Object, Object> x0$1) {
                    Tuple2<Object, Object> tuple2 = x0$1;
                    if (tuple2 != null) {
                        double p = tuple2._1$mcD$sp();
                        double t = tuple2._2$mcD$sp();
                        double d = t == 0.0 ? Double.POSITIVE_INFINITY : p / t;
                        return d;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()));
            d = Vectors$.MODULE$.dense(scaledProbability).argmax();
        } else {
            d = probability.argmax();
        }
        return d;
    }

    public ProbabilisticClassificationModel() {
        HasProbabilityCol$class.$init$(this);
        HasThresholds$class.$init$(this);
        ProbabilisticClassifierParams$class.$init$(this);
    }
}

