/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import org.apache.spark.annotation.Experimental;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.ml.Model;
import org.apache.spark.ml.classification.ClassificationModel;
import org.apache.spark.ml.classification.DecisionTreeClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel;
import org.apache.spark.ml.classification.ProbabilisticClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassificationModel$;
import org.apache.spark.ml.classification.RandomForestClassifier;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.tree.DecisionTreeModel;
import org.apache.spark.ml.tree.TreeEnsembleModel;
import org.apache.spark.ml.tree.TreeEnsembleModel$class;
import org.apache.spark.ml.tree.impl.RandomForest$;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.mllib.linalg.DenseVector;
import org.apache.spark.mllib.linalg.SparseVector;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.tree.configuration.Algo$;
import org.apache.spark.mllib.tree.model.RandomForestModel;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrame;
import org.apache.spark.sql.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.math.Numeric;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.TypeTags;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;

@Experimental
@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0001\u0003\u00055\u0011qDU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aL7-\u0019;j_:lu\u000eZ3m\u0015\t\u0019A!\u0001\bdY\u0006\u001c8/\u001b4jG\u0006$\u0018n\u001c8\u000b\u0005\u00151\u0011AA7m\u0015\t9\u0001\"A\u0003ta\u0006\u00148N\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\n\u0005\u00019Y\u0012\u0005\u0005\u0003\u0010!IQR\"\u0001\u0002\n\u0005E\u0011!\u0001\t)s_\n\f'-\u001b7jgRL7m\u00117bgNLg-[2bi&|g.T8eK2\u0004\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\r1Lg.\u00197h\u0015\t9b!A\u0003nY2L'-\u0003\u0002\u001a)\t1a+Z2u_J\u0004\"a\u0004\u0001\u0011\u0005qyR\"A\u000f\u000b\u0005y!\u0011\u0001\u0002;sK\u0016L!\u0001I\u000f\u0003#Q\u0013X-Z#og\u0016l'\r\\3N_\u0012,G\u000e\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005)\u0001\t\u0015\r\u0011\"\u0011*\u0003\r)\u0018\u000eZ\u000b\u0002UA\u00111F\f\b\u0003E1J!!L\u0012\u0002\rA\u0013X\rZ3g\u0013\ty\u0003G\u0001\u0004TiJLgn\u001a\u0006\u0003[\rB\u0001B\r\u0001\u0003\u0002\u0003\u0006IAK\u0001\u0005k&$\u0007\u0005\u0003\u00055\u0001\t\u0015\r\u0011\"\u00036\u0003\u0019yFO]3fgV\ta\u0007E\u0002#oeJ!\u0001O\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005=Q\u0014BA\u001e\u0003\u0005}!UmY5tS>tGK]3f\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\u0005\t{\u0001\u0011\t\u0011)A\u0005m\u00059q\f\u001e:fKN\u0004\u0003\u0002C \u0001\u0005\u000b\u0007I\u0011\u0001!\u0002\u00179,XNR3biV\u0014Xm]\u000b\u0002\u0003B\u0011!EQ\u0005\u0003\u0007\u000e\u00121!\u00138u\u0011!)\u0005A!A!\u0002\u0013\t\u0015\u0001\u00048v[\u001a+\u0017\r^;sKN\u0004\u0003\u0002C$\u0001\u0005\u000b\u0007I\u0011\t!\u0002\u00159,Xn\u00117bgN,7\u000f\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003B\u0003-qW/\\\"mCN\u001cXm\u001d\u0011\t\r-\u0003A\u0011\u0001\u0003M\u0003\u0019a\u0014N\\5u}Q)!$\u0014(P!\")\u0001F\u0013a\u0001U!)AG\u0013a\u0001m!)qH\u0013a\u0001\u0003\")qI\u0013a\u0001\u0003\"11\n\u0001C\u0001\tI#BAG*V-\")A+\u0015a\u0001m\u0005)AO]3fg\")q(\u0015a\u0001\u0003\")q)\u0015a\u0001\u0003\")A\u000b\u0001C!1V\t\u0011\fE\u0002#oi\u0003\"\u0001H.\n\u0005qk\"!\u0005#fG&\u001c\u0018n\u001c8Ue\u0016,Wj\u001c3fY\"Aa\f\u0001EC\u0002\u0013%q,\u0001\u0007`iJ,WmV3jO\"$8/F\u0001a!\r\u0011s'\u0019\t\u0003E\tL!aY\u0012\u0003\r\u0011{WO\u00197f\u0011!)\u0007\u0001#A!B\u0013\u0001\u0017!D0ue\u0016,w+Z5hQR\u001c\b\u0005C\u0003h\u0001\u0011\u0005s,A\u0006ue\u0016,w+Z5hQR\u001c\b\"B5\u0001\t#R\u0017!\u0004;sC:\u001chm\u001c:n\u00136\u0004H\u000e\u0006\u0002lcB\u0011An\\\u0007\u0002[*\u0011aNB\u0001\u0004gFd\u0017B\u00019n\u0005%!\u0015\r^1Ge\u0006lW\rC\u0003sQ\u0002\u00071.A\u0004eCR\f7/\u001a;\t\u000bQ\u0004A\u0011K;\u0002\u0015A\u0014X\rZ5diJ\u000bw\u000f\u0006\u0002\u0013m\")qo\u001da\u0001%\u0005Aa-Z1ukJ,7\u000fC\u0003z\u0001\u0011E#0\u0001\fsC^\u0014\u0004O]8cC\nLG.\u001b;z\u0013:\u0004F.Y2f)\t\u00112\u0010C\u0003}q\u0002\u0007!#A\u0007sC^\u0004&/\u001a3jGRLwN\u001c\u0005\u0006}\u0002!\te`\u0001\u0005G>\u0004\u0018\u0010F\u0002\u001b\u0003\u0003Aq!a\u0001~\u0001\u0004\t)!A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\b\u00055QBAA\u0005\u0015\r\tY\u0001B\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003\u001f\tIA\u0001\u0005QCJ\fW.T1q\u0011\u001d\t\u0019\u0002\u0001C!\u0003+\t\u0001\u0002^8TiJLgn\u001a\u000b\u0002U!Q\u0011\u0011\u0004\u0001\t\u0006\u0004%\t!a\u0007\u0002%\u0019,\u0017\r^;sK&k\u0007o\u001c:uC:\u001cWm]\u000b\u0002%!I\u0011q\u0004\u0001\t\u0002\u0003\u0006KAE\u0001\u0014M\u0016\fG/\u001e:f\u00136\u0004xN\u001d;b]\u000e,7\u000f\t\u0005\t\u0003G\u0001A\u0011\u0001\u0003\u0002&\u0005)Ao\\(mIV\u0011\u0011q\u0005\t\u0005\u0003S\t\t$\u0004\u0002\u0002,)!\u0011QFA\u0018\u0003\u0015iw\u000eZ3m\u0015\tqb#\u0003\u0003\u00024\u0005-\"!\u0005*b]\u0012|WNR8sKN$Xj\u001c3fY\"\u001a\u0001!a\u000e\u0011\t\u0005e\u0012qH\u0007\u0003\u0003wQ1!!\u0010\u0007\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003\u0003\nYD\u0001\u0007FqB,'/[7f]R\fGn\u0002\u0005\u0002F\tA\t\u0001BA$\u0003}\u0011\u0016M\u001c3p[\u001a{'/Z:u\u00072\f7o]5gS\u000e\fG/[8o\u001b>$W\r\u001c\t\u0004\u001f\u0005%caB\u0001\u0003\u0011\u0003!\u00111J\n\u0006\u0003\u0013\ni%\t\t\u0004E\u0005=\u0013bAA)G\t1\u0011I\\=SK\u001aDqaSA%\t\u0003\t)\u0006\u0006\u0002\u0002H!A\u0011\u0011LA%\t\u0003\tY&A\u0004ge>lw\n\u001c3\u0015\u0013i\ti&!\u0019\u0002l\u0005U\u0004\u0002CA0\u0003/\u0002\r!a\n\u0002\u0011=dG-T8eK2D\u0001\"a\u0019\u0002X\u0001\u0007\u0011QM\u0001\u0007a\u0006\u0014XM\u001c;\u0011\u0007=\t9'C\u0002\u0002j\t\u0011aCU1oI>lgi\u001c:fgR\u001cE.Y:tS\u001aLWM\u001d\u0005\t\u0003[\n9\u00061\u0001\u0002p\u0005\u00192-\u0019;fO>\u0014\u0018nY1m\r\u0016\fG/\u001e:fgB)1&!\u001dB\u0003&\u0019\u00111\u000f\u0019\u0003\u00075\u000b\u0007\u000f\u0003\u0004H\u0003/\u0002\r!\u0011\u0005\u000b\u0003s\nI%!A\u0005\n\u0005m\u0014a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006!A.\u00198h\u0015\t\t9)\u0001\u0003kCZ\f\u0017\u0002BAF\u0003\u0003\u0013aa\u00142kK\u000e$\b")
public final class RandomForestClassificationModel
extends ProbabilisticClassificationModel<Vector, RandomForestClassificationModel>
implements TreeEnsembleModel {
    private final String uid;
    private final DecisionTreeClassificationModel[] _trees;
    private final int numFeatures;
    private final int numClasses;
    private double[] _treeWeights;
    private Vector featureImportances;
    private final int numTrees;
    private final int totalNumNodes;
    private volatile byte bitmap$0;

    public static RandomForestClassificationModel fromOld(RandomForestModel randomForestModel, RandomForestClassifier randomForestClassifier, Map<Object, Object> map, int n) {
        return RandomForestClassificationModel$.MODULE$.fromOld(randomForestModel, randomForestClassifier, map, n);
    }

    private double[] _treeWeights$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this._treeWeights = (double[])Array$.MODULE$.fill(this.numTrees(), (Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply() {
                        return this.apply$mcD$sp();
                    }

                    public double apply$mcD$sp() {
                        return 1.0;
                    }
                }, ClassTag$.MODULE$.Double());
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this._treeWeights;
        }
    }

    private Vector featureImportances$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.featureImportances = RandomForest$.MODULE$.featureImportances(this.trees(), this.numFeatures());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.featureImportances;
        }
    }

    @Override
    public int numTrees() {
        return this.numTrees;
    }

    private int totalNumNodes$lzycompute() {
        RandomForestClassificationModel randomForestClassificationModel = this;
        synchronized (randomForestClassificationModel) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.totalNumNodes = TreeEnsembleModel$class.totalNumNodes(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
            return this.totalNumNodes;
        }
    }

    @Override
    public int totalNumNodes() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.totalNumNodes$lzycompute() : this.totalNumNodes;
    }

    @Override
    public void org$apache$spark$ml$tree$TreeEnsembleModel$_setter_$numTrees_$eq(int x$1) {
        this.numTrees = x$1;
    }

    @Override
    public Vector javaTreeWeights() {
        return TreeEnsembleModel$class.javaTreeWeights(this);
    }

    @Override
    public String toDebugString() {
        return TreeEnsembleModel$class.toDebugString(this);
    }

    @Override
    public String uid() {
        return this.uid;
    }

    private DecisionTreeClassificationModel[] _trees() {
        return this._trees;
    }

    public int numFeatures() {
        return this.numFeatures;
    }

    @Override
    public int numClasses() {
        return this.numClasses;
    }

    @Override
    public DecisionTreeModel[] trees() {
        return this._trees();
    }

    private double[] _treeWeights() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this._treeWeights$lzycompute() : this._treeWeights;
    }

    @Override
    public double[] treeWeights() {
        return this._treeWeights();
    }

    @Override
    public DataFrame transformImpl(DataFrame dataset) {
        Broadcast bcastModel = dataset.sqlContext().sparkContext().broadcast((Object)this, ClassTag$.MODULE$.apply(RandomForestClassificationModel.class));
        UserDefinedFunction predictUDF = functions$.MODULE$.udf((Function1)new Serializable(this, bcastModel){
            public static final long serialVersionUID = 0L;
            private final Broadcast bcastModel$1;

            public final double apply(Object features) {
                return ((ClassificationModel)this.bcastModel$1.value()).predict((Vector)features);
            }
            {
                this.bcastModel$1 = bcastModel$1;
            }
        }, ((TypeTags)package$.MODULE$.universe()).TypeTag().Double(), ((TypeTags)package$.MODULE$.universe()).TypeTag().Any());
        return dataset.withColumn(this.$(this.predictionCol()), predictUDF.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(this.$(this.featuresCol()))})));
    }

    @Override
    public Vector predictRaw(Vector features) {
        double[] votes = (double[])Array$.MODULE$.fill(this.numClasses(), (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final double apply() {
                return this.apply$mcD$sp();
            }

            public double apply$mcD$sp() {
                return 0.0;
            }
        }, ClassTag$.MODULE$.Double());
        Predef$.MODULE$.refArrayOps((Object[])this._trees()).view().foreach((Function1)new Serializable(this, features, votes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RandomForestClassificationModel $outer;
            private final Vector features$1;
            private final double[] votes$1;

            public final void apply(DecisionTreeClassificationModel tree) {
                double[] classCounts = tree.rootNode().predictImpl(this.features$1).impurityStats().stats();
                double total = BoxesRunTime.unboxToDouble((Object)Predef$.MODULE$.doubleArrayOps(classCounts).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
                if (total != 0.0) {
                    for (int i = 0; i < this.$outer.numClasses(); ++i) {
                        int n = i;
                        this.votes$1[n] = this.votes$1[n] + classCounts[i] / total;
                    }
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.features$1 = features$1;
                this.votes$1 = votes$1;
            }
        });
        return Vectors$.MODULE$.dense(votes);
    }

    @Override
    public Vector raw2probabilityInPlace(Vector rawPrediction) {
        Vector vector = rawPrediction;
        if (vector instanceof DenseVector) {
            DenseVector denseVector = (DenseVector)vector;
            ProbabilisticClassificationModel$.MODULE$.normalizeToProbabilitiesInPlace(denseVector);
            DenseVector denseVector2 = denseVector;
            return denseVector2;
        }
        if (vector instanceof SparseVector) {
            throw new RuntimeException("Unexpected error in RandomForestClassificationModel: raw2probabilityInPlace encountered SparseVector");
        }
        throw new MatchError((Object)vector);
    }

    @Override
    public RandomForestClassificationModel copy(ParamMap extra) {
        return (RandomForestClassificationModel)((Model)this.copyValues(new RandomForestClassificationModel(this.uid(), this._trees(), this.numFeatures(), this.numClasses()), extra)).setParent(this.parent());
    }

    @Override
    public String toString() {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"RandomForestClassificationModel with ", " trees"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.numTrees())}));
    }

    public Vector featureImportances() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.featureImportances$lzycompute() : this.featureImportances;
    }

    public RandomForestModel toOld() {
        return new RandomForestModel(Algo$.MODULE$.Classification(), (org.apache.spark.mllib.tree.model.DecisionTreeModel[])Predef$.MODULE$.refArrayOps((Object[])this._trees()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final org.apache.spark.mllib.tree.model.DecisionTreeModel apply(DecisionTreeClassificationModel x$2) {
                return x$2.toOld();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(org.apache.spark.mllib.tree.model.DecisionTreeModel.class))));
    }

    public RandomForestClassificationModel(String uid, DecisionTreeClassificationModel[] _trees, int numFeatures, int numClasses) {
        this.uid = uid;
        this._trees = _trees;
        this.numFeatures = numFeatures;
        this.numClasses = numClasses;
        TreeEnsembleModel$class.$init$(this);
        Predef$.MODULE$.require(this.numTrees() > 0, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "RandomForestClassificationModel requires at least 1 tree.";
            }
        });
    }

    public RandomForestClassificationModel(DecisionTreeClassificationModel[] trees, int numFeatures, int numClasses) {
        this(Identifiable$.MODULE$.randomUID("rfc"), trees, numFeatures, numClasses);
    }
}

